function  [imC] = cropImage(im, cropBox, val)
  % [imC] = cropImage(im, cropBox, [val])
  % imC = im(cropBox(1,2):cropBox(2,2), cropBox(1,1):cropBox(2,1));
  % Crop the image to the crop box.  Return an image of the size
  % dictated by cropBox.  It may be padded with values 128 or val
  % Here cropBox = [xMin, yMin; xMax, yMax];
    

  if nargin < 3
    val = 128;
  end
  
  % Compute the size of the cropped image.
  sizeIm = size(im);
  if length(size(im)) == 3
    imDim = size(im,3);
  else
    imDim = 1;
  end
  sizeImC = cropBox(2,:) - cropBox(1,:) + 1;
  sizeImC = [sizeImC(2) sizeImC(1)];
  if imDim > 1
    sizeImC(3) = imDim;
  end
  imC = val*ones(sizeImC, class(im));
  
  % Intersect the cropBox with the image.
  cropBoxTrim = max( cropBox, 1);
  cropBoxTrim(1,:) = min( [cropBoxTrim(1,:); sizeIm(2) sizeIm(1)], [], 1);
  cropBoxTrim(2,:) = min( [cropBoxTrim(2,:); sizeIm(2) sizeIm(1)], [], 1);
  sizeImCT = cropBoxTrim(2,:) - cropBoxTrim(1,:) + 1;
  sizeImCT = [sizeImCT(2) sizeImCT(1)];

  % Copy the image data to the trimmed crop box with the cropped image.
  corner = (cropBox(1,:)-cropBoxTrim(1,:));
  if corner(1) <= sizeImC(2) & corner(2) <= sizeImC(1)
    shft = max(-corner, 0);
    if imDim == 1
      imC((shft(2)+(1:sizeImCT(1))), (shft(1)+(1:sizeImCT(2)))) = ...
          im(cropBoxTrim(1,2):cropBoxTrim(2,2), ...
             cropBoxTrim(1,1):cropBoxTrim(2,1));
    else
      for k = 1:imDim
        imC((shft(2)+(1:sizeImCT(1))), (shft(1)+(1:sizeImCT(2))), k) = ...
            im(cropBoxTrim(1,2):cropBoxTrim(2,2), ...
               cropBoxTrim(1,1):cropBoxTrim(2,1), k);
      end
    end
  end
