function [x0, r, w, maxW] = fitCircleRobust(pts, initx0, initr, normals, ...
                                            sigmaErr)
%
% function [x0, r, w, maxW] = fitCircleRobust(pts, initx0, initr,
%                                  normals, sigmaErr)
%
%  minimize sum_i  w_i [u_i^T (x_i-x_0) - r)]^2 
%  w.r.t. x_0 and r.
% Input:
%  pts: an Nx2 matrix containing 2D x_i, i=1...N
%  initx0: 2-vector initial guess for centre
%  initr: initial guess for radius 
%  normals: an Nx2 matrix of corresponding 2D edge normal directions nrml_i  
%  sigmaErr is the stdev of the measurement error
% Output
%  x0 - 2x1 fitted circle's center position
%  r  - fitted circle's radius
%  w  - double N x 1 matrix of 0/1 weights for edgels.
  
x0 = initx0(:)';  % Make it a row vector.

% FINISH THIS CODE