function [labelIm, thetaCenters] = labelDir(dirIm, nTheta, wrapOrient)
  % [labelIm, thetaCenters] = labelDir(dirIm, nTheta, wrapOrient)
  % Compute the bin label, 1..nTheta, for the orientation image dirIm,
  % with direction values in [-1, 1] (the orientation is pi*dirIm).
  % We use nTheta>0 evenly spaced labels 1, 2, ... , nTheta.
  % If wrapOrient> 0 we consider orientations mod pi.
  % Output:
  %  labelIm is the same size as dirIm
  %  thetaCenters are the centers of the orientation bins, in radians
  
    
  nTheta = round(nTheta);
  if nTheta <= 0
    error(sprintf(...
      'Number of desired orientation bins must be positive: nTheta = %d', ...
        nTheta));;
  end
  
  nBin = nTheta;
  if wrapOrient > 0
    nBin = 2*nBin;
  end
  
  % dirIm in range [-1 1], which corresponds to -pi, to pi
  labelIm = ceil((dirIm+1.0)*(nBin/2.0));
  labelIm = max(labelIm,1);
  labelIm = min(labelIm,nBin);
  % Compute centers of each label bin
  thetaCenters = pi*(-1 + (2/nBin) * (0.5 + (0:(nBin-1))));
  
  if wrapOrient > 0
    idx = (labelIm >= nTheta+1);
    labelIm(idx) = labelIm(idx) - nTheta;
    thetaCenters = thetaCenters(1:nTheta);
  end
  
  
  return;