function [p] = cropBox2BoxPoly(cB)
  % boxPoly = cropBox2BoxPoly(cropBox)
  %
  % Given a crop box:  [xmin, ymin; xmax ymax]
  % Return a 2 x 5 array of points forming
  % the polygonal boundary of the crop box.
    
  p = zeros(2,5);
  p(:,[1 3 5]) = cB([1 2 1], :)';
  p(:,2) = [cB(1,1); cB(2,2)];
  p(:,4) = [cB(2,1); cB(1, 2)];
  
  return