function []=plotHoGCells(fig, centerPts, paramsHoG, penColour, lineWidth, im)
%% [] = plotHoGCells(fig, centerPts, params, penColour, lineWidth, im)
%% Draw pattern of HoG cells in figure with handle fig, 
%% described by paramsHoG, and centered on pixels 
%%   centerPts = [x(1) x(2) ... x(n); y(1) y(2) ... y(n)];
%% OPTIONAL: 
%%   penColour = [r g b] (default [1 0 0] (red))
%%   lineWidth = default 1
%%   im   Clear figure, draw image in figure
  
  if nargin == 6
    figure(fig); close; figure(fig);
    %% Display image
    sz = size(im);
    image(im);
    if (size(sz,2) == 2)
      colormap(gray(256)); 
    end
    axis equal;
  else
    figure(fig);
  end
  if nargin < 5
    lineWidth = 1;
  end
  if nargin < 4
    penColour = [1 0 0];
  end
  
  % HoG cells are centered on vertices, width and length sx sy
  figure(fig); hold on;
  for kPt = 1:size(centerPts,2)
    center = centerPts(:,kPt)';
    for k = 1:length(paramsHoG.cellBox)
      cellBox = paramsHoG.cellBox(k).bbox;
      cellPoly = [cellBox(1,:) ; cellBox(1,1) cellBox(2,2); ...
                  cellBox(2,:); cellBox(2,1) cellBox(1,2);  ...
                  cellBox(1,:)]';
      cellPoly = cellPoly + repmat(center(:), 1, 5);
      drawPolys(figure(fig), cellPoly, penColour, lineWidth);
    end
  end
  