function v = getVertexGrid(nRow, nCol)
  % v = getVertexGrid(nRow, nCol)
  % Generate a grid of sample points, 
  % with unit spacing in x and y, and
  % with mean [0,0].  The neighbours
  % are given by the 4-neighbourhood.
    
  v = emptyVertex;
  [x,y] = meshgrid(1:nCol, 1:nRow);
  x = x(:);
  y = y(:);
  x0 = (nCol+1)/2;
  y0 = (nRow+1)/2;
  for k = 1:length(x)
      v(k).xy = [x(k), y(k)] - [x0, y0];
      % Set 4-neighbours
      if (x(k) > 1)
          v(k).nhbr = [v(k).nhbr, k - nRow];
      end
      if (y(k) > 1)
          v(k).nhbr = [v(k).nhbr, k - 1];
      end
      if (y(k) < nRow)
          v(k).nhbr = [v(k).nhbr, k + 1];
      end
      if (x(k) < nCol)
          v(k).nhbr = [v(k).nhbr, k + nRow];
      end
  end

  return
  
  for k = 1:length(v)
    fprintf(2, '%d: %f %f\n', k, v(k).xy(1:2));
    fprintf(2, ' %d', v(k).nhbr);
    fprintf(2, '\n');
  end
    
   
  
  