
function [z, hogScore, thetaCorner] = findCornerPoints(z, hog, thetaHoG,...
                                                  paramsScore)
% [idz, hogScore, thetaCorner] = findCornerPoints(z, hog, thetaHoG,...
%                                                 paramsScore)
% Input:
%  2 x P array of image sample points z (in pixels)
%  nTheta x P array of HoG responses (nTheta = paramsHoG.nTheta)
%  thetaHoG a 1 x nTheta  array providing the gradient orientation for 
%     the center of each HoG bin (in radians).
%  paramsScore  the structure of params used to form score for each
%               HoG response.
% Output
%  z -  1xQ matrix submatrix of the original z, consisting
%       of the columns of z that (possibly) obtained a score > 0.
%       Other columns of z are guaranteed to have a score of zero.
%  hogScore - a 1 x Q) vector (doubles) storing the score
%        for the points z(:, idz).  This score should be non-negative
%        and increase for points for which you are more confident
%        that they correspond to a checkerboard corner point.
%  thetaCorner - a 2 x Q matrix storing the two distinct
%         (mod pi) thetas for the gradients at the possible checkerboard
%         corner points z(:, idz).
%        

  nBin = size(hog,1);
  z = [];
  hogScore = [];
  thetaCorner = [];

  return;
  
