%%% CSC 420 Assignment 1, Handout/Solution code

% See the words "MODIFY THIS" below, which indicate where
% you need to modify this code (just two lines). 
% You main task is to complete the M-file findCornerPts.m 
% that is called below.

clear all;


% Need to change the following root directory for A1 
% to be the corresponding directory on your machine (or on CDF).
% MODIFY THIS if necessary
csc420Root = '../';

% Set paths to include the M-files we use 
if ~exist('upConv', 'file')
  % upConv.m is in the iseToolbox
  % Set the path to include both the ise and utvis toolboxes
  % See ../README.txt
  run('../pathReset');
end
if ~exist('gaussFilt', 'file')
  addpath([csc420Root 'util/']);
end
if ~exist('setHoGParams', 'file')
  addpath([csc420Root 'util/HoG/']);
end

% Set constants for test image data (don't change)
imRootDir = [csc420Root 'data/'];
imRootName = 'calibTest';
imExt = '.jpg';
frames = 1:15; 
imFrameNumPad = 2;


% Constants for the HoG response (leave these parameters as is)
HoGversion = 1;  % 1 HoG cell centered on 0, 0
szCell = 8;      % szCell x szCell (pixels) cell
stepHoG = 2;     % stride for sampling hog, every stepHoG pixels
                 % in both x and y.
paramsHoG = setHoGParams(szCell, HoGversion);  % Build the params struct
paramsHoG.nTheta = 24;  % Reset the number of orientations to nTheta bins.

% Constants for gradient response  (leave these parameters as is)
paramsGrad.useGauss = true;  % Use clipped Gaussian (and deriv.) filters
paramsGrad.sigma = 1.0;      % Scale, sigma, for clipped Gaussian
% Don't supersample the image before computing derivatives.
paramsGrad.superSample = 1;  

% Use the structure paramsScore for parameters of your 
% HoG scoring function (can change this structure to be as you like)
% MODIFY THIS
paramsScore.thetaConstant1 = 0;

SELECT_PT = true;
% When this flag is true, the HoG at only one moused-in point
% is displayed.  Use this to help decide on how to detect corner
% points and test your scoring method.
% You should set this to false once you have a scoring method implemented.

% Loop over test images
for kFrm = frames
  
  % Construct full path for test image
  imName = [imRootName num2strPad(kFrm, imFrameNumPad)];
  fName = [imRootDir imName imExt];
  
  % Read test image, convert to monochrome if necessary.
  im = double(imread(fName));
  if length(size(im)) == 3
    im = sum(im, 3)/size(im,3);
  end
  szIm = size(im);
  
  % Display test image
  figure(1); clf; 
  colormap(gray(256));
  image(im); axis equal; axis off; 
  title(imName);
  
  % Get strength of gradient image nrmGradIm, and direction dirGradIm.
  % Display gradient direction image in figure(2)
  [nrmGradIm, dirGradIm] = getGradNrmDir(im, paramsGrad, figure(2));
  
  % Display strentght gradient information
  figure(4); clf;
  idx = nrmGradIm >= paramsHoG.minAmp;
  tmp = nrmGradIm;
  tmp(~idx) = 0;
  showIm(min(tmp,paramsHoG.maxAmp) - ~idx);
  pause(0.1);
  
  if SELECT_PT
    % Hand select points in image, compute and display HoG
    figure(1);
    fprintf('Click the mouse on a point in image 1.\n');
    pt = round(ginput(1));
    if size(pt,1) > 0
      % Ensure pt is within the image bounds
      pt = max(pt, 1); pt = min(pt, [szIm(2), szIm(1)]);
      z = pt';
      figure(1); hold on; plot(pt(1), pt(2), '*r');
    else
      error('No point was moused in.  Don''t hit enter.\n');
    end
  else
    % Get grid of HoG sample points, spaced by stepHoG in x and y
    [x,y] = meshgrid(1:stepHoG:szIm(2), 1:stepHoG:szIm(1));
    % Form sample points into a 2 x P matrix z.
    z = [x(:) y(:)]';
  end
  
  % Compute the HoG responses at each z
  [hog, thetaHoG] = getAlignedHoG(z, nrmGradIm, dirGradIm, ...
                                     paramsGrad.superSample, paramsHoG);
  % The result is a paramsHoG.nTheta x P matrix.
  % If this step or your later steps cause a memory exception 
  % then loop over smaller batches of z-points and process 
  % each batch separately.
  
  if SELECT_PT
    % Plot first HoG response
    figure(100); clf;
    plot(thetaHoG, hog(:, 1), '-+b');
    ax = axis;
    axis([-pi, pi, 0, ax(4)]);
    xlabel('Theta (in radians)');
    ylabel('Sum of gradient strengths');
    title('HoG Response');
  end
  
  % You need to supply this function. See the function comments in 
  % the handout code for its specification.
  [z, hogScore, thetaCorner] = findCornerPts(z, hog, thetaHoG,...
                                             paramsScore);
  
  % Plot information about the possible checkerboard corners
  % that were detected
  if size(z, 2) > 0  
    
    %% Plot responses as an image
    % First stuff the responses into a response image.
    respIm = zeros(size(im));
    ind = sub2ind(size(im), z(2,:), z(1,:));
    respIm(ind(:)) = hogScore;
    % Display the response image.
    % Only every stepHoG pixel can be nonzero in this image.
    figure(5); clf;
    showIm(respIm);
    
    % Threshold for detection can be adjusted here
    thresDisplay = 0.5;
    idDetect = hogScore > thresDisplay;

    figure(1); hold on;
    for jpt = find(idDetect)
      for jt = 1:2
        theta = thetaCorner(jt, jpt);
        ct = cos(theta);
        st = sin(theta);
        plot(z(1,jpt) - szCell*st*[-1, 1], ...
             z(2,jpt) + szCell*ct*[-1, 1], '-y');
      end
    end
    figure(1);
    plot(z(1,idDetect), z(2,idDetect), '+r');
    
    if false & kFrm < 4  
      % Print a jpeg image of the result w/o title
      axh = get(figure(1), 'CurrentAxes');
      set(get(axh, 'Title'), 'Visible', 'off');
      print(figure(1), '-djpeg99', [imName 'CornerPoints']);
      set(get(axh, 'Title'), 'Visible', 'on');
    end  
    
    title([imName ': Candidate corner locations (+r)']);
    pause(0.1);

    % Link the axes fo the four response images (they are the same size)
    % This allows you to use the zoom and pan tools on any one
    % image, and the axes of the other images are set to match.
    ax = [];
    for kFig = [1, 2, 4, 5];
      ax(end+1) = get(figure(kFig), 'CurrentAxes');
    end 
    linkaxes(ax);
     
    if SELECT_PT
      % Show the two detected orientations on HoG histogram
      figure(100); hold on;
      ax = axis;
      plot(thetaCorner(1,1)*[1,1], ax(3:4), '-r'); 
      plot(thetaCorner(2,1)*[1,1], ax(3:4), '-g'); 
    end
    
  else % size(z,2) == 0
    
    fprintf(['No possible checkerboard corner points detected\n'...
             'All scores are equal to zero.\n']);
    
    % Link the axes fo the three response images (they are the same size)
    % This allows you to use the zoom and pan tools on any one
    % image, and the axes of the other images are set to match.
    ax = [];
    for kFig = [1, 2, 4];
      ax(end+1) = get(figure(kFig), 'CurrentAxes');
    end
    linkaxes(ax);
  
  end % scoring HoG's
  
  fprintf('Separate the figures on your screen.\n');
  fprintf('Press any key to continue...');
  pause;
  fprintf('\n');
  
end % over test images