/**
 *  Demonstrate list searching and sorting algorithms. */
public class ListUtil {
  
  /** For conditional compilation of debug information. */
  public static final boolean DEBUG = true;
    
  /** For debug output, set this flag to true. */
  public static boolean BINARY_SEARCH_CHATTY;

  /** Search an array of comparable objects which is sorted
    *  in increasing order for a given item.  If the item is
    *  found in the array, return the index of the item.  
    *  Requires: list and item are not null.     
    *  @param list the array of comparable items.
    *  @param item the target to be searched for. 
    *  @returns index >= 0 if the item was found to match
    *           the one at list[index], or index < 0 if the 
    *           item was not found, but belongs at location
    *           -(index+1) in the list[] array. */
  public static int binarySearch(Comparable[] list, 
                                 Comparable item) {
    int first = 0;
    int last = list.length;
    if (last == 0) {
      // Empty list
      return -1;  // -(first + 1)
    }
    int count = 0; // Keep track of the number of comparisons
    int res;
    // Loop invariant:  If the item is in the list then
    // it must have index j s.t. first <= j < last
    while (last > first + 1) {
      int m = first + (last - first)/2;
      if (DEBUG) 
        assert ( first < m && m < last ): "Middle equals first or last";
      res = list[m].compareTo(item);
      if (DEBUG) 
        count++;
      if (res <= 0)
        first = m;
      else
        last = m;
    }
    res = list[first].compareTo(item);
    if (DEBUG) {
      count++;
      if (BINARY_SEARCH_CHATTY) {
        System.out.println("Used " + count +
                           " comparisons in a list of length " +
                           list.length);
        int logFormula = 
          ((int) Math.ceil(Math.log(list.length)/Math.log(2.0))) + 1;
        System.out.println("ceil(log2(" + list.length +
                           ")) + 1 = " + logFormula);
      }
    }
    if (res == 0)
      return first;
    if (res > 0)
      return -(first+1);  // item should go in location first
    return -(first+2);    // item should go in location first+1
  }
}
