import junit.framework.TestCase;
import java.util.Random;

/**
 * A JUnit test case class for binary search.
 */
public class BinarySearchTest extends TestCase {
  /** Random number seed. */
  static long seed;

  /** Random number generator. */
  static Random random = new Random();

  /** Items to be searched. */
  private Comparable list[];

  /** Generate a random 9 digit seed, and print it so that
   *  the example can be rerun exactly. */
  public void setSeed() {
    seed = (System.currentTimeMillis()) % 1000000000;
    System.out.println("Random seed: " + seed);
  }

  /** Sets up a sorted list of distinct Integers of
   *  length n. */
  public void buildListNoDup(int n) {
    int maxSpacing = 50;
    list = new Integer[n];
    // Reset the random number generator.
    random.setSeed(seed);
    
    int prev = 0;
    for (int k = 0; k < n; k++) {
      list[k] = prev + random.nextInt(maxSpacing) + 1;
      prev = (Integer) list[k];
    }
  }
  
  /** Test the search when item is found. */
  public void testSimple() {
    setSeed();
    int len = 20 + random.nextInt(10000);  // Should be bigger than 10
    
    ListUtil.BINARY_SEARCH_CHATTY = true;
    buildListNoDup(len);

    int index = ListUtil.binarySearch(list,
                   new Integer((Integer) list[10]));
    assertEquals("Found item at: ", 10, index);

    index = ListUtil.binarySearch(list,
                new Integer((Integer) list[0]));
    assertEquals("Found item at: ", 0, index);

    index = ListUtil.binarySearch(list, 
                new Integer((Integer) list[len-1]));
    assertEquals("Found item at: ", len-1, index);
    
  }
  
  /** Test the search when item is found. */
  public void testNotFound() {
    setSeed();
    int len = 20 + random.nextInt(1000); 
    
    ListUtil.BINARY_SEARCH_CHATTY = true;
    buildListNoDup(len);
    
    boolean found = false;
    for (int k = 10; k < len & !found; k++) {
      int kPrev = (Integer) list[k-1];
      int kTarget = (Integer) list[k];
      if (kPrev + 1 < kTarget) {
        found = true;
        int index = ListUtil.binarySearch(list,
                      new Integer(kPrev+1));
        assertEquals("Search returns: ", 
                     -(k+1), index);
      }
    }

    int kPrev = (Integer) list[0];
    int index = ListUtil.binarySearch(list,
              new Integer(kPrev - 1));
    assertEquals("Search returns: ", -1, index);

    int kTarget = (Integer) list[len-1];
    index = ListUtil.binarySearch(list, 
              new Integer(kTarget+1));
    assertEquals("Search returns: ", -(len+1), index);
    
  }
}
