// Author: Arnold Rosenbloom Lecturer U of T Mississauga
import java.util.*;
public class Subject {
	private Vector observers=new Vector();

	public Subject(){
		attachObserver(GraphicObserver.observer);
	}

	protected void attachObserver(Observer o){ 
		observers.add(o); 
		o.attachSubject(this); 
	}
	protected void detachObserver(Observer o){ 
		observers.remove(o); 
		o.detachSubject(this);
	}
	protected void notifyObserver(){ 
		Enumeration e = observers.elements();
		while(e.hasMoreElements()) {
			Observer o=(Observer)e.nextElement();
			o.update();
		}
	}
}
