#ifndef __CLOUD_UTILS_H__
#define __CLOUD_UTILS_H__

#include <unistd.h>
#include <stdint.h>

/*
 * Send x > 0 bytes through an open socket descriptor sd
 * from a buffer buf (buf is assumed to have length >= x).
 * Returns x if successful, otherwise, returns the error
 * on a failed send (0 for socket closed or -1 for other
 * send error).
 */
int write_x_bytes(int, unsigned int, uint8_t*);

/*
 * Reads x > 0 bytes from an open socket descriptor sd
 * into a buffer buf (buf is assumed to have length >= x).
 * Returns x if successful, otherwise, returns the error
 * on a failed read (0 for socket closed or -1 for other
 * read error).
 */
int read_x_bytes(int, unsigned int, uint8_t*);

#endif
