#include "cloud_utils.h"

int write_x_bytes(int sd, unsigned int x, uint8_t* buf)
{
  int wc = 0, total = 0;
  while (x - total > 0) {
    wc = write(sd, buf+total, x-total);
    if (wc <= 0)
      return wc;
    total += wc;
  }
  return total;
}

int read_x_bytes(int sd, unsigned int x, uint8_t* buf)
{
  int rc = 0, total = 0;
  while (x - total > 0) {
    rc = read(sd, buf+total, x-total);
    if (rc <= 0)
      return rc;
    total += rc;
  }
  return total;
}


