
#ifndef CLOUD_PROTOCOL_H
#define CLOUD_PROTOCOL_H

#define SERVER_PORT 9955

#include <cstdint>

/*
	cloud packets consists of:
	-cloud_hdr
	-cloud_fname chars listing filename
	-cloud_datalen bytes of data
*/
struct cloud_hdr {
	uint8_t cloud_reqtype;
	uint8_t cloud_userid;

	uint16_t cloud_fnamelen; //in bytes
	uint32_t cloud_datalen; //in bytes

	uint64_t cloud_oldcrc;
	uint64_t cloud_newcrc;
} __attribute__ ((packed));
typedef struct cloud_hdr cloud_hdr_t;


enum cloud_reqtype {
	req_update = 0x0001, 		//send updated patch data for destination to update to

	req_updatefull = 0x0002, 	//send updated full file for destination to update to (oldcrc unused)

	req_reqfull = 0x0003, 		//request a newest complete file (oldcrc, newcrc, datalen unusued)

	req_reqpatch = 0x0004,		//reqests a patch to get from oldcrc to newest vertsion (newcrc, datalen unused)

	req_checkall = 0x0005, 		//check if a list of files with crc's are all up to date.
								//sender should expect req_update's for each too old file and
								//req_reqpatch's or req_reqfull's for each newer file.

								//the data will consist of multiple (one for each file):
								// uint16_t len, uint64_t crc, char* name
								//with no padding, where len tells you the length of name.

	req_uptodate = 0x0006,		//acknowledges a file is up to date (oldcrc, datalen unused)
								//might not be necessary

	req_delete = 0x0007,		//tell destination to delete a file (oldcrc, newcrc, datalen unused)

	req_notify = 0x0008			//all zero notify header, used when:
								//	-finished replying to checkall
};




#endif
