import java.util.NoSuchElementException;

public class LinkedRing {
  private ListNode prev;
  private int size;
  public LinkedRing() {}
  
  public Object current() {
    if (size == 0) 
      throw new NoSuchElementException("Ring is empty");
    return prev.link.value;
  }
  
  public int size() { return size; }
  public void roll() { if (prev != null) prev = prev.link; }
  public String toString() {
    StringBuffer sb = new StringBuffer("[");
    if (size > 0) {
      ListNode n;
      for (n = prev.link; n != prev; n = n.link) {
        sb = sb.append(" [ "+ n.value + " ]");
      }
      sb = sb.append(" [ "+ n.value + " ]");
    }
    sb = sb.append(" ]");
    return sb.toString();
  }
  
  public void insert(Object o) {
    ListNode tmp = new ListNode(o);
    if (size == 0) {
      // Create a list of length 1.
      prev = tmp;
      prev.link = prev;
      size = 1;
      return;
    }
    tmp.link = prev.link;
    prev.link = tmp;
    ++size;
  }
  
  public Object remove() {
    if (size == 0) {
      throw new NoSuchElementException("Ring is empty.");
    }
    Object o;
    if (size == 1) {
      o = prev.value;
      prev = null;
      size = 0;
    } else { //size > 1
      o = prev.link.value;
      prev.link = prev.link.link;
      --size;
    }
    return o;
  }
 }
