/**
 * A Queue with fixed capacity.
 * Operations are constant-time except for
 * construction which is O(capacity) and
 * dequeue which is O(size()).
 */
public class ArrayQueue implements Queue {

    /** The number of elements in me. */
    protected int size;

    /** contents[0 .. size-1] contains my elements. */
    protected Object[] contents;

    /* Representation invariant:
         size >= 0.
         If size is 0, I am empty.
         If size > 0:
           contents[0] is the head
           contents[size-1] is the tail
           contents[0 .. size-1] contains the
              Objects in the order they were inserted. 
    */

    /** 
     * Construct an ArrayQueue with capacity for n elements. 
     * Requires: n > 0.
     * @param n the maximum capacity of the queue. 
     */
    public ArrayQueue(int n) {
        contents = new Object[n];
    }

    /** Append o to me.
     *  Requires: queue is not already full.
     *  @param o the element to be inserted at the end.
     */
    public void enqueue(Object o) {
        contents[size++] = o;
    }

    /** Remove and return my front element.
      * Runs in time O(size()).
      * Requires: size() != 0. 
      * @return the front element of the queue.
      */
    public Object dequeue() {
        Object head = contents[0];

        // Move all the other elements up one spot.
        for (int i = 0; i < size - 1; ++i) {
            contents[i] = contents[i + 1];
        }
        
        --size;
        return head;
    }

    /** Return my front element.
      * Requires: size() != 0. 
      * @return the front element of the queue.
      */
    public Object head() {
        return contents[0];
    }
 
    /** Returns the queue size.
     *  @return the number of elements in the queue.
     */
    public int size() {
        return size;
    }

    /** Returns the maximum number of elements this
     *  queue can contain.
     *  @return the capacity of the queue.
     */
    public int capacity() {
        return contents.length;
    }

} // End of ArrayQueue.
