/*

PreQuel. Copyright Horst Samulowitz and Jessica Davies and Fahiem Bacchus 2006

 A QBF preprocessor based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
Jessica Davies and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Jessica Davies and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to implied warranties of merchantability and fitness for a particular purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Davies:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Jessica Davies and Fahiem Bacchus },
	year    = { 2006 },
	title   = { A QBF preprocessor employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <time.h>
#include "2clsEq.h"
#include "utilities.h"

#ifdef WIN32
#include <windows.h>
#else /* WIN32 */
#include <sys/times.h>					// Linux, Solaris, HPUX, etc.
#include <unistd.h>					// Linux, Solaris
//#include <sys/time.h>					// BSD
//#include <sys/resource.h>				// BSD
//#include <sys/param.h>				// BSD
//#include <sys/sysctl.h>				// BSD
#endif /* WIN32 */

bool bNT;						/* this is Windows NT */
Contradiction CONTRADICTION;

// fatal error; print a message taking printf style arguments; then exits(1)
#ifdef WIN32
void __cdecl panic(char *fs, ...) {
#else
void panic(char *fs, ...) {
#endif
  va_list args;
  va_start(args, fs);
  printf("FATAL ERROR: ");
  vprintf(fs, args);
  fflush(stdout);
  printf("\n");
  exit(1);
}

bool member(int l, int* array, int len) {
  //return true if l is in array of size len.
  for(int i=0;i<len;i++)
    if(l==array[i])
      return true;
  return false;
}

#ifdef WIN32
static double GetWinRunTime(void);

/* Detect platform */
void DetectPlatform() {
  OSVERSIONINFO osvi;
  osvi.dwOSVersionInfoSize=sizeof(OSVERSIONINFO);
  GetVersionEx(&osvi);
  if(osvi.dwPlatformId==VER_PLATFORM_WIN32_NT)
    bNT=true;
  else
    bNT=false;
}
#endif /* WIN32 */

/* GetInternalRunTime

   Description:
   Get the time in seconds since an OS specific epoch.
   If possible, we provide accounted time.
   Notes:
   On non-Windows systems, the default time calculation assumes a Linux, Solaris
   or HPUX system.  Commented out code is also provided for BSD, and if all
   else fails, there is a call to the ANSI clock routine.
*/

double GetInternalRunTime(void) {
  double df;
#ifndef WIN32
  // Linux, Solaris, HPUX, etc.
  struct tms usage;
  // BSD
  //struct rusage usage;
#endif /* win32 */
#ifdef WIN32
  df=GetWinRunTime();
  //return(clock()/(CLOCKS_PER_SEC*1.0));
#else /* WIN32 */

  // times() returns accounted time on Linux, Solaris, HPUX etc.
  // on most systems, CLK_TCK is defined as 100, meaning that
  // the time wraps in either 250 or 500 days on a 32 bit processor.

  times(&usage);
  df=((double)usage.tms_utime+(double)usage.tms_stime)/100;
  // Changed Horst: Removed: CLK_TCK; Replaced by 100

  //	// getrusage() returns accounted time (among other things) on BSD
  //
  //	getrusage(RUSAGE_SELF,&usage);
  //	df=(double)usage.ru_utime.tv_sec+usage.ru_utime.tv_usec/1000000.0+
  //		(double)usage.ru_stime.tv_sec+usage.ru_stime.tv_usec/1000000.0;
  //
  //	// the ANSI clock() routine causes trouble on many systems since
  //	// CLOCKS_PER_SEC may be defined as 1000000, causing the time to wrap
  //	// in either 35 or 70 minutes on a 32 bit processor.
  //
  //	df=(double)clock()/CLOCKS_PER_SEC;
#endif /* WIN32 */
  return df;
}

#ifdef WIN32
/* GetWinRunTime

   Description:
   Get the current system time in seconds, as a double precision number.
   For Windows 95/98, this routine reports the elapsed time, using
   QueryPerformanceCounter and QueryPerformanceFrequency to attain a
   precision of better than 1 microsecond.
   For Windows NT, this routine reports the accounted CPU time using
   GetProcessTimes.
   Notes:
   Windows 95/98 reports a clock frequency of 1193180 Hz on a PC.  The actual
   frequency is more likely 1193046.471111 Hz, which causes a 32 bit counter
   to overflow exactly once an hour... but we take their word for it anyways.
   We assume that the clock frequency is under 4294967296 Hz, so we can
   ignore the upper longword of the frequency.
*/

static double GetWinRunTime(void)
{
  double dfTime;
  if(bNT)
	{
	  FILETIME ftTemp;
	  FILETIME ftKernal;
	  FILETIME ftUser;

	  GetProcessTimes(GetCurrentProcess(),&ftTemp,&ftTemp,&ftKernal,&ftUser);
	  dfTime=(*(__int64 *)&ftKernal+*(__int64 *)&ftUser)/10000000.0;
	}
  else								/* Windows 95/98 */
	{
	  unsigned int n[2];
	  static double k0,k1;

	  if(!k0)
		{
		  if(!QueryPerformanceFrequency((LARGE_INTEGER *)n))
			return 0.0;
		  k0=n[0];
		  k1=4294967296.0/k0;
		}
	  QueryPerformanceCounter((LARGE_INTEGER *)n);
	  dfTime=n[1]*k1+n[0]/k0;
	}
  return dfTime;
}
#endif /* WIN32 */



