/*

PreQuel. Copyright Horst Samulowitz and Jessica Davies and Fahiem Bacchus 2006

 A QBF preprocessor based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
Jessica Davies and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Jessica Davies and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to implied warranties of merchantability and fitness for a particular purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Davies:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Jessica Davies and Fahiem Bacchus },
	year    = { 2006 },
	title   = { A QBF preprocessor employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/
//
// FILE: uplit.cpp
//

// OVERVIEW:
//
// This file contains the longer functions required to perform unit
// propagation simultaneously on the binary and nary theory.  The
// shorter functions are inlined and found at the end of 
// preprocessor.h.

#include "preprocessor.h"

// This flag is used for debugging when you want to print out the 
// literals that were unit propagated to trace the progress of
// hyper-resolution.
extern bool inHypRes;

// This unit set holds the literals to be unit propagated.  
UniqueSet * UPstack;

// The functions are define below.
void UnitPropLit(int L);
void changeNaryToBcls(preNcls * Cls, int clsIndex);

// Pushes L onto the UPstack.
void pushUPstack(int L) {
  //Jessica: cannot set the value of a universal
  if (!isLitExistential(L)) {
    setContradiction();
    printf("c CONTRADICTION found(4)!\n");
    return;
  }
  switch(getVal(L)) {
  case F:
    setContradiction();
    //printf("c %d set to true and false.\n", IntLitToExt(L));
    printf("c CONTRADICTION found(1)!\n");
    break;
  case T:
    break;
  case U:
    if(UPstack->member(negate(L))) {
      setContradiction();
      //printf("c %d set to true and false.\n", IntLitToExt(L));
      printf("c CONTRADICTION found(2)!\n");
    }
    else if(!UPstack->member(L)) {
      UPstack->pushnew(L);
    }
    break;
  default:
    printf("ERROR: Illegal value for tval for literal %d.\n",
	   IntLitToExt(L));
    break;    
  }
}

// Performs unit propagation on L, adding new unit clauses to
// the stack. 
void UnitPropLit(int L) {
  int i, j, k;
  preLit * Lit = intToPreLit(L);
  preLit * notLit = intToPreLit(negate(L));
  preLit * otherLit;
  preLit * negOtherLit;
  preNcls * Cls;

  // Check if the literal has already been set.
  if(Lit->val == T)
    return;

  else if(Lit->val == F) {
    setContradiction();
    printf("c CONTRADICTION found(3)!\n");
    return;
  }
  
#ifdef _DEBUG
  printf("* Unit propagating %d through clauses.\n", IntLitToExt(L));
#endif // _DEBUG

#ifdef _STATS
  //temp
  // This is where unit propagated lits are printed out for debugging
  // hyper-resolution.
  //if(inHypRes)
  //printf("* Unit propagating %d through clauses.\n", IntLitToExt(L));

  numValuedLits += 2;
#endif // _STATS

  // If the value of the literal was unknown, then set it true and set any
  // nary clauses that it appears in to inactive.  Also, remove the clause
  // from the LitNcls lists of all the other literals in the clause.
  // Finally, add any literals implied by this literal to the UPstack.
  Lit->val = T;
  for(i = 0; i < Lit->numNcls; i++) {

#ifdef _STATS
    //temp-new
    //// Add one to the number of satisfied clauses if this clause was not
    //// already inactive.
    //if(getActive(Lit->LitNcls[i]) == true) {
    numSatCls++;
    numSatNaryCls++;
    //}
#endif // _STATS

    setActive(Lit->LitNcls[i], false);
    
    // Go through the other literals in this newly inactive clause and remove 
    // the clause from their LitNcls list of nary clauses that they are in.
    for(j = 0; j < getCurLen(Lit->LitNcls[i]); j++) {
      if(getLitsElem(Lit->LitNcls[i], j) != L) {
	otherLit = intToPreLit(getLitsElem(Lit->LitNcls[i], j));
	
	for(k = 0; k < otherLit->numNcls; k++) {
	  if(otherLit->LitNcls[k] == Lit->LitNcls[i]) {
	    otherLit->LitNcls[k] = otherLit->LitNcls[--otherLit->numNcls];
	    break;
	  }
	}
      }
    }
  }

  // Add literals implied by this literal to the UPstack.
  for(i = 0; i < Lit->numBcls; i++) {
    pushUPstack(Lit->LitBcls[i]);
    if(CONTRADICTION.val)
      return;

#ifdef _DEBUG
    printf("Implication %d->%d satisfied.\n", IntLitToExt(L),
	   IntLitToExt(Lit->LitBcls[i]));
#endif // _DEBUG

#ifdef _STATS
    numSatCls++;
    numSatBcls++;
#endif // _STATS
  }

  // Now set its negation to false and remove its negation from any nary
  // clauses and implications (binary clauses) that it appears in.
  notLit->val = F;

  // First, remove the negation from the nary clauses.
  for(i = 0; i < notLit->numNcls; i++) {
    int clsIndex = notLit->LitNcls[i];
    Cls = intToPreNcls(clsIndex);

    //temp-new
    //if(Cls->active) {

    // If the clauses is active, find the literal's negation and replace it with
    // the last literal in the clause and shorten the clause length.
    for(j = 0; j < Cls->curLen; j++) {
      if(Cls->lits[j] == negate(L)) {
	Cls->lits[j] = Cls->lits[--Cls->curLen];
	
#ifdef _DEBUG
	printf("Removing %d from clause %d.\n", IntLitToExt(negate(L)),
	       notLit->LitNcls[i]);
#endif // _DEBUG

	break;
      }
    }

    //Jessica: perform universal reduction
    // But must be careful if we are in runHypRes() ???
#ifndef _NO_UR
    if(universalReduction(Cls, clsIndex))
      return;
#endif

    // If the clauses has become binary, run the function changeNaryToBcls
    // to set it to inactive and add it to the binary clause stack.
    if(Cls->curLen == 2)
      changeNaryToBcls(Cls, notLit->LitNcls[i]);

    //temp-new
    //}

  }

  // Now, remove implications involving the literals negation from the other
  // literals.
  for(i = 0; i < notLit->numBcls; i++) {
    negOtherLit = intToPreLit(negate(notLit->LitBcls[i]));
    if(negOtherLit->val == U) {
      for(j = 0; j < negOtherLit->numBcls; j++) {
	if(negOtherLit->LitBcls[j] == L) {

	  // BUCKET STUFF
	  //deleteBclsFromTable(negOtherLit->num, L);
	  // END BUCKET STUFF

	  negOtherLit->LitBcls[j] = negOtherLit->LitBcls[--negOtherLit->numBcls];

#ifdef _DEBUG
	  printf("Removed %d from bcls of %d.\n", IntLitToExt(L),
		 IntLitToExt(negOtherLit->num));
#endif // _DEBUG

	  break;
	}
      }
    }

#ifdef _STATS
    if(negOtherLit->val == U) {
      numSatCls++;
      numSatBcls++;

#ifdef _DEBUG
      printf("Implication %d->%d satisfied.\n", notLit->num, notLit->LitBcls[i]);
#endif // _DEBUG

    }
#endif // _STATS

  }
}

// This function takes an nary clause that is left with two literals and
// converts it to a binary clause.  This function is similar to 
// convertNaryToBcls except it is used with the UPstack instead of the 
// naryUPstack and bclsUPstack.  Since only one literal is being unit
// propagated at one time in this version, new binary clauses can be
// immediately added to the implication lists of the literals instead
// of putting them on the stack and later evaluating whether they are
// still valid binary clauses.  The clause is also removed from the 
// remaining two literals' lists of nary clauses.
void changeNaryToBcls(preNcls * Cls, int clsIndex) {
  int i;
  int L1 = Cls->lits[0];
  int L2 = Cls->lits[1];

#ifdef _STATS
  // Increment the number of nary clauses converted to binary.
  numReducedNary++;

  // Increment the number of binary clauses added to the theory.
  numAddBcls++;
#endif // _STATS

  Cls->active = false;

  // Add binary clauses to implication lists.
  if(addBcls(negate(L1), L2)) {
    addBcls(negate(L2), L1);

#ifdef _DEBUG      
    printf("New BCLS is: %d v %d.\n", IntLitToExt(L1), IntLitToExt(L2));
#endif // _DEBUG

  }

#ifdef _STATS
  // If the binary clause could not be added, it is redundant and hence 
  // satisfied.
  else {
    numSatCls++;
    numSatBcls++;
  }
#endif // _STATS

  // Now, remove the clause's index from the list of nary clause indexes 
  // for the two remaining literals.
  preLit * Lit = intToPreLit(L1);
  for(i = 0; i < Lit->numNcls; i++) {
    if(Lit->LitNcls[i] == clsIndex) {
      Lit->LitNcls[i] = Lit->LitNcls[--Lit->numNcls];
      break;
    }
  }
  Lit = intToPreLit(L2);
  for(i = 0; i < Lit->numNcls; i++) {
    if(Lit->LitNcls[i] == clsIndex) {
      Lit->LitNcls[i] = Lit->LitNcls[--Lit->numNcls];
      break;
    }
  } 
}
