/*

PreQuel. Copyright Horst Samulowitz and Jessica Davies and Fahiem Bacchus 2006

 A QBF preprocessor based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
Jessica Davies and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Jessica Davies and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to implied warranties of merchantability and fitness for a particular purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Davies:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Jessica Davies and Fahiem Bacchus },
	year    = { 2006 },
	title   = { A QBF preprocessor employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/

#ifndef __uniqueset_H
#define __uniqueset_H
#include <stdio.h>
#include "2clsEq.h"

/**************************************************************
 Utility constant time (albeit space intensive)
 set of integers.
*************************************************************/

class UniqueSet {
  bool *marks; //set of marks to keep set unique
  int capacity;
public:
  int size;    //size of set;
  int *set;    //set of integers
  UniqueSet(int maxsize) {
	capacity=maxsize;
	set = new int[capacity];
	size = 0;
	marks = new bool[capacity];
	for(int i=0; i<capacity; i++)
	  marks[i]=false;

	if(!set||!marks)
	  panic("Memory Allocation Failure #28\n");


  }
  ~UniqueSet() {
	delete[] set;
	delete[] marks;
  }

  void inline pushnew(int e) {
#ifdef _PARANOIA
	if(e<0||e>=capacity)
	  panic("pushnew in Uniqueset has run out of room!\n");
#endif // _PARANOIA
	if(!marks[e]) {
	  set[size++]=e;
	  marks[e]=true;
	}
  }

  void inline empty() {
	for(int i=0; i<size; i++)
	  marks[set[i]]=false;
	size=0;
  }

  bool inline member(int e) {
#ifdef _PARANOIA
	if(e<0||e>=capacity)
	  panic("member in Uniqueset queiried with out of scope argument!\n");
#endif // _PARANOIA
	return(marks[e]);
  }

  int inline pop() {
#ifdef _PARANOIA
	if(size==0)
	  panic("pop in Uniqueset called on empty set!\n");
#endif // _PARANOIA
	marks[set[--size]]=false;
	return(set[size]);
  }

  bool inline isEmpty() {
	return(size==0);
  }

  void inline printLitset() {
	int i;
	printf("uniqueset: size=%d, [", size);
	for(i=0; i<size; i++)
	  printf("%d,",to_ff(set[i]));
	printf("]/[");
	for(i=0; i<capacity; i++)
	  if(marks[i])
		printf("%d,",to_ff(i));
	printf("]");
  }
  void inline printset() {
	int i;
	printf("uniqueset: size=%d, [", size);
	for(i=0; i<size; i++)
	  printf("%d,",set[i]);
	printf("]/[");
	for(i=0; i<capacity; i++)
	  if(marks[i])
		printf("%d,",i);
	printf("]");
  }

};

class MultiSet {
  //class for constant time allocation of a set.
  //we keep track of the number of times an element enters the set.
  //and we also track the elements of the set for clean up time
  //order of the size of the set.
  int capacity;
public:
  int size;    //size of set;
  int *entrycount; //index each member.
  int *set;    //the elements in the set.

  MultiSet(int maxsize) {
	capacity=maxsize;
	entrycount = new int[capacity];
	set = new int[capacity];
	if(!entrycount||!set)
	  panic("Memory Allocation Failure #29\n");

	size = 0;
	for(int i=0; i<capacity; i++)
	  entrycount[i]=0;

  }
  ~MultiSet() {
	delete[] entrycount;
	delete[] set;
  }

  int inline add(int e) {
#ifdef _PARANOIA
	if(e<0||e>=capacity)
	  panic("push in MultiSet is out of bounds.!\n");
#endif // _PARANOIA
	if(entrycount[e]==0) {
	  set[size++]=e;
	}
	entrycount[e] +=1;
	return(entrycount[e]);
  }

  void inline empty() {
	for(int i=0; i<size; i++)
	  entrycount[set[i]]=0;
	size=0;
  }

  int inline membercount(int e) {
#ifdef _PARANOIA
	if(e<0||e>=capacity)
	  panic("member in Multiset queiried with out of scope argument!\n");
#endif // _PARANOIA
	return(entrycount[e]);
  }

  bool inline isEmpty() {
	return(size==0);
  }

  void inline printset() {
	int i;
	printf("Multiset: size=%d, [", size);
	for(i=0; i<size; i++)
	  printf("%d (#%d),",to_ff(set[i]), entrycount[set[i]]);
	printf("]/[");
	for(i=0; i<capacity; i++)
	  if(entrycount[i]!=0)
		printf("%d (#%d),",to_ff(i), entrycount[i]);
	printf("]");
  }
};


#endif /* __uniqueset_H */


