/*

PreQuel. Copyright Horst Samulowitz and Jessica Davies and Fahiem Bacchus 2006

 A QBF preprocessor based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
Jessica Davies and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Jessica Davies and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to implied warranties of merchantability and fitness for a particular purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Davies:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Jessica Davies and Fahiem Bacchus },
	year    = { 2006 },
	title   = { A QBF preprocessor employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/

//
// FILE: subsume.cpp
//

// OVERVIEW:
//
// This file contains function for preforming simple subsumption and Krom 
// subsumption.  Simple subsumption eliminates clauses such as (a v b v c v d)
// when a binary clause (a v b) is present in the theory.  Krom subsumption
// takes an nary clause such as (-a v b v c v d) and a binary clause such
// as (a v b) and produces the clause (b v c v d) and subsumes the original
// nary clause.
/*
#include "preprocessor.h"

#ifdef _STATS
int numSimpSubCls = 0;
int numKromSubCls = 0;
double simple_start_time;
double simple_time;
double krom_start_time;
double krom_time;
#endif _STATS

extern bool foundNewBcls;

// Used by Krom subsumption to convert nary clauses reduced to two literals
// to implications.  The function definition is found in uplit.cpp.
void changeNaryToBcls(preNcls * Cls, int clsIndex);

void simpleSubsump() {
  int i, j, k, m, n, lit;
  bool subsumed;

#ifdef _STATS
  simple_start_time = GetInternalRunTime();
#endif _STATS

  for(i = 0; i < NUMNCLS; i++) {
    if(getActive(i)) {
      subsumed = false;
      for(j = 0; !subsumed && (j < getCurLen(i)); j++) {
	for(k = (j + 1); !subsumed && (k < getCurLen(i)); k++) {
	  if(findBclsTable(negate(getLitsElem(i, j)), getLitsElem(i, k))) {
	    subsumed = true;
	    setActive(i, false);

	    //temp
	    printf("Clause: ( ");
	    for(m = 0; m < getCurLen(i); m++)
	      printf("%d ", IntLitToExt(getLitsElem(i, m)));
	    printf(") subsumed by (%d %d)\n", IntLitToExt(getLitsElem(i, j)),
		   IntLitToExt(getLitsElem(i, k)));

	    // Remove this clause's index from the LitNcls list of the literals
	    // in it.
	    for(m = 0; m < getCurLen(i); m++) {
	      lit = getLitsElem(i, m);
	      for(n = 0; n < getNumNcls(lit); n++) {
		if(getLitNclsElem(lit, n) == i) {
		  setLitNclsElem(lit, n,  getLitNclsElem(lit, getNumNcls(lit) - 1));
		  setNumNcls(lit, getNumNcls(lit) - 1);
		  break;
		}
	      }
	    }

#ifdef _STATS
	    numSimpSubCls++;
	    numSatCls++;
	    numSatNaryCls++;
#endif _STATS

	  }
	}
      }
    }
  }

#ifdef _STATS
  simple_time = GetInternalRunTime() - simple_start_time;
  printf("Simple subsumption subsumed %d nary clauses.\n", numSimpSubCls);
  printf("Simple subsumption took %.3f seconds.\n", simple_time);
#endif _STATS

}


void kromSubsump() {
  int i, j, k, m, n, lit;
  bool subsumed;

#ifdef _STATS
  krom_start_time = GetInternalRunTime();
#endif _STATS

  for(i = 0; i < NUMNCLS; i++) {
    if(getActive(i)) {
      subsumed = false;
      for(j = 0; !subsumed && (j < getCurLen(i)); j++) {
	for(k = (j + 1); !subsumed && (k < getCurLen(i)); k++) {
	  if(findBclsTable(getLitsElem(i, j), getLitsElem(i, k))) {
	    subsumed = true;

	    //temp
	    printf("Clause: ( ");
	    for(n = 0; n < getCurLen(i); n++)
	      printf("%d ", IntLitToExt(getLitsElem(i, n)));
	    printf(") Krom subsumed by (%d %d)\n", IntLitToExt(negate(getLitsElem(i, j))),
		   IntLitToExt(getLitsElem(i, k)));

#ifdef _STATS
	    numKromSubCls++;
#endif _STATS

	    lit = getLitsElem(i, j);
	    setLitsElem(i, j, getLitsElem(i, getCurLen(i) - 1));
	    setCurLen(i, getCurLen(i) - 1);
	    
	    // Remove this clause index from the LitNcls index list of j.
	    for(m = 0; m < getNumNcls(lit); m++) {
	      if(getLitNclsElem(lit, m) == i) {
		setNumNcls(lit, getNumNcls(lit) - 1);
		setLitNclsElem(lit, m, getLitNclsElem(lit, getNumNcls(lit)));
		break;
	      }
	    }

	    // Check if clause has become binary and convert it to an implication
	    // if it has.
	    if(getCurLen(i) == 2) {
	      foundNewBcls = true;
	      changeNaryToBcls(intToPreNcls(i), i);
	    }
	    //return;
	  }
	  else if(findBclsTable(negate(getLitsElem(i, j)), negate(getLitsElem(i, k)))) {
	    subsumed = true;

	    //temp
	    printf("Clause: ( ");
	    for(n = 0; n < getCurLen(i); n++)
	      printf("%d ", IntLitToExt(getLitsElem(i, n)));
	    printf(") Krom subsumed by (%d %d)\n", IntLitToExt(negate(getLitsElem(i, j))),
		   IntLitToExt(getLitsElem(i, k)));

#ifdef _STATS
	    numKromSubCls++;
#endif _STATS

	    lit = getLitsElem(i, k);
	    setLitsElem(i, k, getLitsElem(i, getCurLen(i) - 1));
	    setCurLen(i, getCurLen(i) - 1);
	    
	    // Remove this clause index from the LitNcls index list of k.
	    for(m = 0; m < getNumNcls(lit); m++) {
	      if(getLitNclsElem(lit, m) == i) {
		setNumNcls(lit, getNumNcls(lit) - 1);
		setLitNclsElem(lit, m, getLitNclsElem(lit, getNumNcls(lit)));
		break;
	      }
	    }

	    // Check if clause has become binary and convert it to an implication
	    // if it has.
	    if(getCurLen(i) == 2) {
	      foundNewBcls = true;
	      changeNaryToBcls(intToPreNcls(i), i);
	    }
    
	    //return;
	  }
	}
      }
      // If the clause was subsumed (shortened), there is a chance that another
      // Krom subsumption could be performed.  So, i is set back one to rerun 
      // Krom subsumption until no subsumptions are found.
      if(subsumed)
	i--;
    }
  }

#ifdef _STATS
  krom_time = GetInternalRunTime() - krom_start_time;
  printf("Krom subsumption subsumed %d nary clauses.\n", numKromSubCls);
  printf("Krom subsumption took %.3f seconds.\n", krom_time);
#endif _STATS

}

*/
