/*

PreQuel. Copyright Horst Samulowitz and Jessica Davies and Fahiem Bacchus 2006

 A QBF preprocessor based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
Jessica Davies and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Jessica Davies and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to implied warranties of merchantability and fitness for a particular purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Davies:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Jessica Davies and Fahiem Bacchus },
	year    = { 2006 },
	title   = { A QBF preprocessor employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/

/*Readproblem. Read a QDIMACS standard CNF File.*/
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "2clsEq.h"
#include "uniqueset.h"
#include "utilities.h"

bool *renum_varused;
int  *renum_varnum;
int  *orig_varnum;

const int MAXWORD=256;

int NVARS, NCLAUSES, NLITS, LITSINCLAUSES, NACTIVELITS;
CLAUSELIST *lenNclauses[CLSGROUPS];

// Horst: Add Prefix Level Information when reading file
bool *bArrExistential;
int  *nArrPrefixLevel;
// END

// Horst
int NMAXPREFIXLEVEL;


bool readProblem(char *input_file) {
  FILE* fp;
  char ch;
  int lit, clslen;
  CLAUSELIST *clsptr;
  int maxclause[MAXCLAUSELEN];
  int i,j;
  char word[MAXWORD];

  for(i=0;i<CLSGROUPS;i++) {
    lenNclauses[i]=NULL;
  }

  if(!(fp = fopen(input_file, "r"))) return false;

  //find the parameter line. A line starting with 'p'
  while(fscanf(fp,"%c",&ch) && ch!='p')
    while(fscanf(fp,"%c",&ch) && ch!='\n')
      ;

  if(!fscanf(fp, "%s%d%d", word, &NVARS, &NCLAUSES)) {
    printf("Problems finding parameter line in input %s", input_file);
    return false;
  }
  if(NVARS < 0 || NCLAUSES < 0) {
    printf("Illegal parameters specified, #vars = %d, #clauses = %d!\n",
		   NVARS, NCLAUSES);
    return false;
  }

  // ***************************************************************************
  // Horst: READ PREFIX
  // ***************************************************************************
  fpos_t fFilePos;
  fgetpos(fp,&fFilePos);
  fscanf(fp,"%c",&ch);
  while(ch!='e' && ch!='a' && ch!='-' && ch!='0' && ch!='1' && ch!='2' && ch!='3' && ch!='4' && ch!='5' && ch!='6'&& ch!='7' && ch!='8' && ch!='9'  )
  {
    fgetpos(fp,&fFilePos);
    fscanf(fp,"%c",&ch);
    //printf(" Value %c", ch);
  }
  
  fsetpos(fp,&fFilePos);
  //printf(" Value %c", ch);
  int  nPrefixLevel = 0;
  bool bExistential;
  bArrExistential = new bool[NVARS * 2];
  nArrPrefixLevel = new int[NVARS * 2];
  int nVar;

  if((ch!='e') && (ch!='a'))
  {
    for(int c1 = 0; c1 < 2*NVARS; c1++) {
     bArrExistential[c1] = true;
      nArrPrefixLevel[c1] = 0;
    }
   
  }
  else 
  {
  while(fscanf(fp,"%c",&ch))
  {
  // printf(" Value %c", ch);
   if((ch!='e') && (ch!='a'))
   {
     break;
   }

   if(ch=='e')
    bExistential = true;
   else
    bExistential = false;

   while(fscanf(fp,"%d",&nVar) && nVar!=0)
   {
     //printf(" \n Reading %d ", nVar);
     if(nVar > 0)
     {
       //printf(" \n Variable %d Internal %d Number of total Vars: %d", nVar, to_internal(nVar), NVARS);
      
      bArrExistential[to_internal(nVar)] = bExistential;
      nArrPrefixLevel[to_internal(nVar)] = nPrefixLevel; 
      bArrExistential[to_internal(-nVar)] = bExistential;
      nArrPrefixLevel[to_internal(-nVar)] = nPrefixLevel;
      //printf(" Setting: %d %d %d ", to_internal(nVar), nPrefixLevel, bExistential);
      //printf(" Setting: %d %d %d ", to_internal(-nVar), nPrefixLevel, bExistential);
     }
     else
      break;
     //*/
   }
   fgetpos(fp,&fFilePos);
   fscanf(fp,"%d",&nVar);
   ++nPrefixLevel;
  }
  }
  fsetpos(fp,&fFilePos);

  // Set Max Prefix Level
  NMAXPREFIXLEVEL = nPrefixLevel;

  // ***************************************************************************
  // END: Read PREFIX
  // ***************************************************************************



  int retval;
  for(i=0;i<NCLAUSES;i++) {
    clslen=0;
    while((retval=fscanf(fp, "%d", &lit))&&lit) {
      if(abs(lit) < 1 || abs(lit) > NVARS) {
		printf("Read illegal literal %d in file, #vars = %d!\n",
			   lit, NVARS);
		return false;
      }
      maxclause[clslen++]=to_internal(lit);
    }
    if(retval==EOF) {
      NCLAUSES=i;
      break;
    }

    //test for various reductions.
    if(clslen==0) {
      setContradiction();
      return true;
    }
	//
	int *cls = new int[clslen];
	if(!cls)
	  panic("Memory Allocation Failure #21\n");
	int reallen=0;
	bool tautology=false;
	for(j=0;j<clslen;j++) {
	  if(member(maxclause[j],cls,reallen))
	    //printf("R");
	    continue;
	  else if(member(negate(maxclause[j]),cls,reallen)) {
	    //printf("\n --> TAUTOLOGY ");
	    //assert(false);
            tautology=true;
	    break;
	  }
	  else
	    cls[reallen++]=maxclause[j];
	}
//Jessica
#ifndef _NO_UR
        //********************************************************************************
        // Horst: Universal Reduction
        //********************************************************************************
        if(!tautology) {
          int nMaxExistentialPrefixLevel = 0;
          int nMaxUniversalPrefixLevel = -1;
          //int nLiteral;
          for(j=0;j<clslen;j++) {
            //printf("Literal %d PrefixLevel %d Existential? %d", maxclause[j], nArrPrefixLevel[maxclause[j]], bArrExistential[maxclause[j]]);
            // Existential
            if(bArrExistential[maxclause[j]])
            {
              if(nArrPrefixLevel[maxclause[j]] > nMaxExistentialPrefixLevel)
              {
                nMaxExistentialPrefixLevel = nArrPrefixLevel[maxclause[j]];
              }
            }
            else { // Universal
              if(nArrPrefixLevel[maxclause[j]] > nMaxUniversalPrefixLevel)
              {
                //printf(" HERE %d ", bArrExistential[maxclause[j]]);
                nMaxUniversalPrefixLevel = nArrPrefixLevel[maxclause[j]];
              }
            }
         }
          //printf(" MaxUniversal %d MaxExistential %d", nMaxUniversalPrefixLevel, nMaxExistentialPrefixLevel);
          if(nMaxUniversalPrefixLevel > nMaxExistentialPrefixLevel)
          {
            //assert(false);
            // Find the new length 
            reallen = clslen;
            for(j=0;j<clslen;j++) {
              if(nArrPrefixLevel[maxclause[j]] > nMaxExistentialPrefixLevel)
                reallen--;

	      //printf("\n Cut tailing Universals: * %d %d %d", nMaxUniversalPrefixLevel, nMaxExistentialPrefixLevel, reallen); 
            }
            if(reallen==0) {
              printf("\n Empty Clause detected when reading file! \n");
              //assert(false);
              return false;
            }
            // get rid of old clause
            delete [] cls;
            cls = new int[reallen];
            int pos = 0;
            for(j=0;j<clslen;j++) {
              if(nArrPrefixLevel[maxclause[j]] <= nMaxExistentialPrefixLevel)
              {
                cls[pos++]=maxclause[j];
                printf(" Rem %d", maxclause[j]);
              }
            }
            assert(pos == reallen);
            clslen=reallen;
          }
        }
        //printf("\n");

        //********************************************************************************
        // END: Universal Reduction
        //********************************************************************************
#endif // _NO_UR

	if(!tautology) {
	  int clsgrp = (reallen<CLSGROUPS)?reallen:CLSGROUPS-1;
	  clsptr = lenNclauses[clsgrp];
	  lenNclauses[clsgrp] = new CLAUSELIST;
	  if(!lenNclauses[clsgrp])
	    panic("Memory Allocation Failure #22\n");
	  lenNclauses[clsgrp]->cls = cls;
	  lenNclauses[clsgrp]->clslen=reallen;
	  lenNclauses[clsgrp]->active=true;
	  lenNclauses[clsgrp]->pnext=clsptr;
	}
  }

  int bcls=0;
  for(clsptr=lenNclauses[2];clsptr;clsptr=clsptr->pnext)
    bcls++;

  printf("c Inital problem has %d variables, %d nary clauses (%d binary clauses), %d Quantifier Alternations.\n",
		 NVARS,NCLAUSES-bcls,bcls, getMaxPrefixLevel());

  int Tlen=0;
  int Acls=0;

  for(i=3;i<CLSGROUPS;i++) {
    for(clsptr=lenNclauses[i];clsptr;clsptr=clsptr->pnext)
      if(clsptr->active) {
		Acls++;
		Tlen+=clsptr->clslen;
      }
  }

  //@JON My additions
  extern int NUMNCLS;
  NUMNCLS = Acls;
  //@JON End of my addtions

  printf("c Num non-binary clauses %d, Average non-binary clause length %2.3f\n",Acls, (Acls>0? (Tlen*1.0)/Acls:0));

  //renumber the literals.
  renum_varused = new bool[NVARS];
  renum_varnum = new int[NVARS];
  orig_varnum = new int[NVARS];

  // Horst: Duplicates of PrefixLevel/Type Arrays
  int *renum_nArrPrefixLevel = new int[2 * NVARS];
  bool *renum_bArrExistential = new bool[2 * NVARS];
  // END


  if(!renum_varused || !renum_varnum || !orig_varnum)
	panic("Memory Allocation Failure #23\n");
  for(i=0;i<NVARS;i++) {
    renum_varnum[i]=i;
	orig_varnum[i]=i;
    renum_varused[i]=false;
    // Horst: Generate a copy
    renum_bArrExistential[to_literal(i, true)] = bArrExistential[to_literal(i, true)];
    renum_nArrPrefixLevel[to_literal(i, true)] = nArrPrefixLevel[to_literal(i, true)];
    renum_bArrExistential[to_literal(i, false)] = bArrExistential[to_literal(i, false)];
    renum_nArrPrefixLevel[to_literal(i, false)] = nArrPrefixLevel[to_literal(i, false)];
    // End
  }

  //mark the used vars
  for(i=0;i<CLSGROUPS;i++)
    for(clsptr=lenNclauses[i];clsptr;clsptr=clsptr->pnext)
      for(j=0;j<clsptr->clslen;j++)
		renum_varused[variable_of(clsptr->cls[j])]=true;

  //number them
  j=0;
  for(i=0;i<NVARS;i++) {
	renum_varnum[i]=j;
        //printf("\n Variable used: %d %d %d" ,i , renum_varused[i], nArrPrefixLevel[to_literal(i, false)]);
	if(renum_varused[i]) {
	  orig_varnum[j]=i;
          // Horst: Update Values from Copy
          bArrExistential[to_literal(j, true)] = renum_bArrExistential[to_literal(i, true)];
          nArrPrefixLevel[to_literal(j, true)] = renum_nArrPrefixLevel[to_literal(i, true)];
          bArrExistential[to_literal(j, false)] = renum_bArrExistential[to_literal(i, false)];
          nArrPrefixLevel[to_literal(j, false)] = renum_nArrPrefixLevel[to_literal(i, false)];
          // Test
	  //          printf("\n XXXXXXXrenum Literal: %d (PL: %d ) to %d (PL: %d )", i, nArrPrefixLevel[to_literal(i, false)], j, nArrPrefixLevel[to_literal(j, false)]);
          // END
	  j++;
	}
  }

  if(j!=NVARS) {
    //printf("\n Write File! ");
    //FILE* fpnew;
    //fpnew=fopen("renumbered.cnf", "w");
    //print map
    //fprintf(fpnew,"c\n");
    //for(i=0;i<NVARS;i++)
    //if(renum_varused[i])
    // 	fprintf(fpnew,"cV%d==>%d\n", i+1, renum_varnum[i]+1);



    NVARS=j;
    //now renumber the clauses
    for(i=0;i<CLSGROUPS;i++)
      for(clsptr=lenNclauses[i];clsptr;clsptr=clsptr->pnext)
		for(j=0;j<clsptr->clslen;j++)
		  clsptr->cls[j]=to_literal(renum_varnum[variable_of(clsptr->cls[j])],
									truth_of(clsptr->cls[j]));

    //now print them out.
    // h
    //fprintf(fpnew,"c NEW theory.\n");
    //fprintf(fpnew,"p cnf %d %d \n", NVARS,  NCLAUSES);
    //printPrefix(fpnew, renum_litnum);  
    //for(i=0;i<CLSGROUPS;i++)
    // for(clsptr=lenNclauses[i];clsptr;clsptr=clsptr->pnext) {
    //	for(j=0;j<clsptr->clslen;j++)
    //	  fprintf(fpnew,"%d ",to_ff(clsptr->cls[j]));
    //	fprintf(fpnew,"0\n");
    // }
    //fclose(fpnew);
  }
  else
    printf("c Theory has no gaps\n");

  delete[] renum_varused;
  delete[] renum_varnum;

  NLITS=NVARS*2;
  return true;
}


