/*

PreQuel. Copyright Horst Samulowitz and Jessica Davies and Fahiem Bacchus 2006

 A QBF preprocessor based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
Jessica Davies and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Jessica Davies and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to implied warranties of merchantability and fitness for a particular purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Davies:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Jessica Davies and Fahiem Bacchus },
	year    = { 2006 },
	title   = { A QBF preprocessor employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "2clsEq.h"
#include "preprocessor.h"
#include "utilities.h"

char * filename;
char * outfile = NULL;

void gatherStats();

void usage() {
  printf("QBF Preprocessor. Developed and written by Horst Samulowitz and Jessica Davies and Fahiem Bacchus, University of Toronto\n");
  printf("Usage: preQuel [input qdimacs filename] \n");
  printf("       -> output is written to new file \n");
  exit(1);
}

#ifdef WIN32
int __cdecl main(int argc, char *argv[]) {
#else
int main(int argc, char *argv[]) {
#endif
  if(argc == 1)
    usage();

  // Set default verbosity level to zero (silent).
  int level = 0;

  // Look for parameters.
  for(int i = 1; i < argc; i++) {
      // Check if the user provides a verbosity
    if(argv[i][0] == '-' && argv[i][1] == 'v') {
      i++;
      if((sscanf(argv[i], "%d", &level) != 1)
	 && (level >= 0) && (level <= 3))
	usage();
    }
    // Check if user provided name for the output cnf.
    else if(argv[i][0] == '-' && argv[i][1] == 'o') {
      i++;
      outfile = argv[i];
    }
    // Otherwise, assume the argument is the input filename.
    else
      filename=argv[i];
    }

#ifdef WIN32
  DetectPlatform();
#endif /* WIN32 */

  CONTRADICTION.val=false;
  // Horst: Changed to read QBF Problems
  if(!readProblem(filename)) {
      printf("c Problem reading CNF file.\n");
      exit(1);
  }

  start_time = GetInternalRunTime();

  if(strchr(filename,'/'))
    filename=strrchr(filename, '/')+1;
  else if(strchr(filename,'\\'))
    filename=strrchr(filename, '\\')+1;
  preprocessor();

  // This function's work is now performed in the beginning of cnfoutput().
  //gatherStats();
  if(!CONTRADICTION.val)
    {
      //cnfoutput();
     cnfoutputOrigTheory();
    }

    //temp
  //fprintReducedTheory();
 

  end_time = GetInternalRunTime();

  printSummary();
  recordSummary();

  return(0);
}
