/*

PreQuel. Copyright Horst Samulowitz and Jessica Davies and Fahiem Bacchus 2006

 A QBF preprocessor based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
Jessica Davies and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Jessica Davies and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to implied warranties of merchantability and fitness for a particular purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Davies:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Jessica Davies and Fahiem Bacchus },
	year    = { 2006 },
	title   = { A QBF preprocessor employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/
//
// FILE: hypres.cpp
//

// OVERVIEW:
//
// This file contains the 3 major functions used to perform hyper-
// resolution and a number of support functions.  The basic procedure
// is the same as outline in the e-mail you set.  HypRes is the main
// function that is recursively called.  HypResDFS is called on 
// literals that have already been visited.  Finally, runHypRes 
// does all the required initialization, runs HypRes on all
// unvisited literals without antecedant literals, and prints out
// statistics about HypRes's performance.

// This new version of HypRes includes the following features:
//    1. UniqueSetArray and NewImplicantListArray to reduce
//       the number of memory allocations and deallocations.
//    2. Black-Grey-White labelling technique to deal with
//       cycles in the depth-first searches.
//    3. Better usage of UniqueSets, through accessing internal
//       arrays directly for iterations.
//    4. When literals are temporarily unit propagated to find
//       their hyper-resolvants, this version uses a stack to
//       keep track of changes made to the theory.  During the 
//       temporary unit propagation, the changes that must be 
//       tracked include assigning literals a value, setting 
//       clauses inactive, and decrementing the length of clauses.
//    5. This version uses the 'onStack' variable of the preLits
//       class to prevent literals from being pushed on the 
//       UnitPropStack more than once.  This prevents stack overflow.
//    6. A implication graph hashtable has been added to speed
//       up searching for the existence of a binary clause.  So far
//       it actually slows things down.


#include "preprocessor.h"

// This variable enables hypres debug information to be output to 

// This variable enables code to do error checking on the hyper-resolution
// procedure.
//#define _HR_DEBUG

// This variable enables code to print out the recursive path taken by
// HypRes and what happened along the way.
//#define _HR_TRACE

// This variable enables code to time various parts of the hyper-resolution
// procedure to determine what is causing a slowdown.
//#define _HR_STATS

// The UnitPropStack contains a stack of the literals that need to be
// unit propagated as a result setting a literal and all its implied
// children to true.  It is used in the section of HypRes that temporarily 
// sets the current literal true to find the hyper-resolvants.  A different
// stack, the UPstack is used to store literals that have been forced true
// and will actually be set permanently true in the theory.
int * UnitPropStack;
int topUnitPropStack;

// The number of binary clauses found in this round of HypRes.
int numNewBclsFound;

// Set true if a new binary clause is generated.  Used with foundNewForced
// to determine when to stop running cycles of HypRes.
bool foundNewBcls;
// Set true if a literals was forced true during this run of HypRes.
bool foundNewForced;

#ifdef _HR_STATS
// Counts the number of times the HypRes function is called.
int HRcounter;
#endif // _HR_STATS

#ifdef _HR_TRACE
// File for outputing trace printout and error checking.
FILE * fp;
char HRfilename[] = "hypres00.out";
#endif // _HR_TRACE

//REMOVE
//UniqueSet * printSet;
//UniqueSet * storageSet;
//bool returnForBcls;
//REMOVE

// UniqueSetArray is used to recycle ChildUPImplicants to 
// avoid excessive calls to new and delete, thus saving time.
UniqueSet ** UniqueSetArray;
int USArraySize;

// The NewImplicantListArray is used to recycle NewImplicantLists to 
// avoid excessive calls to new and delete, thus saving time.
int ** NewImplicantListArray;
int NILArraySize;

// The following variables are used in a experimental method of reducing
// the copy time during the phase when implicants are temporarily set true
// to determine a literal's hyper-resolvents.  The lists contain the set of
// clauses/literals that have been accessed during the current invocation of
// HypRes.  This way, when the accessed fields of the clauses/literals are
// reset, only those actually accessed can be reset instead of blindly
// reseting all clauses and literals.
int * AccessedNclsList;
int sizeAccessedNclsList;
int * AccessedLitsList;
int sizeAccessedLitsList;

// The following list is used with recursive printing and checking
// functions that traverse the implication graphs of the literals.
// The InComponent field of literals is used to mark visited literals
// during the depth-first searches that occur during printing.  The 
// list that follows keeps track of visited literals so that the
// InComponent variable can be reset for its next use.
int * InComponentSetList;
int sizeInComponentSetList;

// The following variables are for having multiple output files as
// required when running of trace of HypRes because of the huge
// volume of output.  It tracks the number of overall times HypRes
// has been executed and switches files after a set number.
int iteration = 0;

// These variables are used to record information of how long various parts
// of the HypRes function take to execute.
#ifdef _HR_STATS
double total_start_time;
double total_time;
double rv_start_time;
double rv_time;
double hrdfs_start_time;
double hrdfs_time;
double copy_start_time;
double copy_time;
double up1_start_time;
double up1_time;
double up2_start_time;
double up2_time;
double fix_start_time;
double fix_time;
double checkimp_start_time;
double checkimp_time;
int checkimpcount;
double prop_start_time;
double prop_time;
#endif // _HR_STATS

#ifdef _HR_DEBUG
// The following variables are used to keep track of memory usage.
// The first keeps track of the number of dynamically allocated
// UniqueSets
int UniqueSetCount = 0;
// The second keeps track of the number of NewImplicantList 
// integers arrays allocated.
int IntArrayCount = 0;
#endif // _HR_DEBUG

// $$$ NEW $$$

UndoNode * UndoStack;
int topUndoStack;
int sizeUndoStack;
void UndoChanges();

// $$$ END NEW $$$

// This function puts lit on the stack of literals to be unit propagated 
// and sets all nary clauses containing lit to inactive.
bool pushUnitPropStack(int lit);

// resetAccessed() is used in the experimental method of reducing copy time.
// It sets the accessed field of the clauses and literals used by HypRes
// back to false.
void resetAccessed();

// This function prints all literals implied by lit.
void printClosure(int lit);

// Prints lit's UPImplicants
void printUPImplicants(int lit, UniqueSet * UPImplicants);

//REMOVE
//BGW
// The function were used to prevent cycles in the graph from causing
// wrongful deletions.
//bool checkForImplicant(int cur_lit, int target, int root);
//bool checkForImplicant2(int target, int root);
//REMOVE

// Functions used with the UniqueSet array.
void initUniqueSetArray();
UniqueSet * getUniqueSet();
void returnUniqueSet();
void cleanupUniqueSetArray();

// Functions used with the NewImplicantList array.
void initNewImplicantListArray();
int * getNewImplicantList();
void returnNewImplicantList();
void cleanupNewImplicantListArray();


// TEMP SUBSUME
//void simpleSubsump();
//void kromSubsump();
// TEMP SUBSUME

// This function performs a depth-first search on a literal's implication
// graph and adds all literals found to UPImplicants.  It is used to find
// the UPImplicants of a literal that has previously been visited by 
// HypRes.
void HypResDFS(int lit, UniqueSet * UPImplicants) {
  int i;

#ifdef _HR_TRACE
  fprintf(fp, "    + HypResDFS visited %d.\n", IntLitToExt(lit)); 
#endif // _HR_TRACE

#ifdef _HR_DEBUG
	  
  if(UPImplicants->member(lit)) {    
    printf("ERROR: HypResDFS visited literal %d, already a member",
	    IntLitToExt(lit));
    printf(" of UPImplicants.\n");
    return;
  }
#endif // _HR_DEBUG

  UPImplicants->pushnew(lit);

  //BGW
  for(i = 0; i < getNumBcls(lit); i++) {
    if(!UPImplicants->member(getLitBclsElem(lit, i))
       && (getState(getLitBclsElem(lit, i)) != GREY))
      HypResDFS(getLitBclsElem(lit, i), UPImplicants);
  } 
}

#ifdef _UR_IN_HYPRES
//Jessica: reduce the length of the clause by universal reduction.  
void UnivReduc_Undo(int clsIndex, int rootPrefixLevel) {
  preNcls *Cls = intToPreNcls(clsIndex);

  // In this case, the clause might not contain any existentials
  int nMaxExistentialPrefixLevel = -1;
  int nMaxUniversalPrefixLevel = -1;
  // This length is the temporary shorter length due to hypres 
  int reallen = getCurLen(clsIndex);
  int j; 

  // We want to look through the entire clause
  for(j=0;j<getHR_curLen(clsIndex);j++) {
    if(getVal(Cls->lits[j])!=U)
      continue;

    // Existential
    if(isLitExistential(Cls->lits[j]))
    {
      if(getLitPrefixLevel(Cls->lits[j]) > nMaxExistentialPrefixLevel)
      {
        nMaxExistentialPrefixLevel = getLitPrefixLevel(Cls->lits[j]);
      }
    }
    else // Universal
    {
      if(getLitPrefixLevel(Cls->lits[j]) > nMaxUniversalPrefixLevel)
      {
        nMaxUniversalPrefixLevel = getLitPrefixLevel(Cls->lits[j]);
      }
    }
  }
  // Check if there are some universals which are trailing both the
  // existentials in the clause AND the root
  if((nMaxUniversalPrefixLevel > nMaxExistentialPrefixLevel) && 
     (nMaxUniversalPrefixLevel >= rootPrefixLevel))
  {
    // Find the new length 
    for(j=0;j<getHR_curLen(clsIndex);j++) {
      if(getVal(Cls->lits[j])==U) {
// Jessica: Oct. 26, 2005: I found that the following line was the cause
// of the satisfiability of s27_d2_s.qdimacs being switched.  This happens
// because the following line considers that an existential at the same
// level as the root should get removed from the clause due to universal
// reduction.  Obviously, existentials should not be removed by UR!!!!
// We want to remove the *universals* which are simultaneously:
// 1. trailing the existentials in the clause
// 2. trailing the root
#if 0
        if(getLitPrefixLevel(Cls->lits[j]) >= rootPrefixLevel)
            reallen--;
#else
        if(!isLitExistential(Cls->lits[j])) {
          int litPrefixLevel = getLitPrefixLevel(Cls->lits[j]);
          if(litPrefixLevel > nMaxExistentialPrefixLevel && 
             // the = in >= means that if the root is a universal, the
             // universals at the same level as it are removed
             litPrefixLevel >= rootPrefixLevel) {
            reallen--;
          } 
        }
#endif
      }
    }
  }

  // Call DecrCurLen_Undo the corresponding number of times
  int numToDecr = Cls->curLen - reallen;
  for(j=0;j<numToDecr;j++) {
    DecrCurLen_Undo(clsIndex);
  }
}
#endif

// This is the main function of the hyper-resolution procedure.  It 
// recursively determines the hyper-resolvents the literal it is 
// called on and the literal's implicants.  HypRes returns true,
// if it performed hyper-resolution on L without finding a
// contradiction implying that not-L is forced and false
// if the contradtion was found.
bool HypRes(preLit * L, UniqueSet * UPImplicants) {
  int i, j, k, numL, negL, lit, negLit, impl, neg, clsIndex;

  // This list holds all the newly found implicants of the literal L.  
  // These implicants are discovered by the unit propagation phase of 
  // hyper-resolution and are record in a list so that HypRes can
  // be run on them and the transitive closure can be removed.
  int sizeNewImplicantList;
  int * NewImplicantList;

  // A UniqueSet to hold the implicants of the literals children.
  UniqueSet * ChildUPImplicants;

//Jessica
#if 0
  printf("HypRes enter\n");
#endif

#ifdef _HR_STATS
  HRcounter++;
#endif // _HR_STATS

  iteration++;

#ifdef _HR_DEBUG
  //if((iteration % 500) == 499) {
  //printf("-- %d UniqueSets Allocated --\n", UniqueSetCount);
  //printf("-- %d Integer Arrays Allocated --\n", IntArrayCount);
  //}
#endif // _HR_DEBUG

#ifdef _HR_TRACE
  // This stuff changes the output file every certain number of HypRes
  // calls.
  if((iteration % 5000) == 4999) {
  //if((iteration % 10000) == 9999) {
    fclose(fp);
    if(HRfilename[7] == '9') {
      HRfilename[7] = '0';
      HRfilename[6]++;
    }
    else
      HRfilename[7]++;

    printf("Changing to filename \"%s\".\n", HRfilename);
    if((fp = fopen(HRfilename, "w")) == NULL)
      printf("ERROR: Failed to open %s.\n", HRfilename);
  }
#endif // _HR_TRACE    

  numL = getNum(L);
  negL = negate(numL);

#ifdef _HR_TRACE
  fprintf(fp, "Beginning HypRes on %d.\n", IntLitToExt(numL));
  printClosure(numL);
#endif // _HR_TRACE

#ifdef _HR_DEBUG
  if(!UPImplicants->isEmpty())
    printf("ERROR: UPImplicants not empty when HypResDFS was called on %d.\n",
	   IntLitToExt(numL));
#endif // _HR_DEBUG

  //BGW
  //if(getVisited(L)) {

  // If the state of L is BLACK, it has already been visited, so HypResDFS
  // should be run on it.
  if(getState(L) == BLACK) {

#ifdef _HR_STATS
    rv_start_time = GetInternalRunTime();
#endif // _HR_STATS

#ifdef _HR_TRACE
    fprintf(fp, "  %d already visited.  Running HypResDFS.\n", IntLitToExt(numL));
#endif // _HR_TRACE

    HypResDFS(numL, UPImplicants);

#ifdef _HR_TRACE
    fprintf(fp, "Finished HypRes on %d.\n", IntLitToExt(numL));
    printUPImplicants(numL, UPImplicants);
#endif // _HR_TRACE

#ifdef _HR_STATS
    rv_time += (GetInternalRunTime() - rv_start_time);
#endif // _HR_STATS
//Jessica
#if 0
  printf("HypRes exit\n");
#endif
    return(true);
  }
  //BGW
  //else {

  // If the state of L is WHITE, the is the first time that it has been 
  // visited.  The implication graphs of its children should be recursively
  // updated first.
  else if(getState(L) == WHITE) {

#ifdef _HR_TRACE
    fprintf(fp, "  %d visited for first time.\n", IntLitToExt(numL));
#endif // _HR_TRACE

    //BGW
    //setVisited(L, true);
    setState(numL, GREY);

    UPImplicants->pushnew(numL);

    if(getNumBcls(L) > 0) {

#ifdef _HR_STATS
      hrdfs_start_time = GetInternalRunTime();
#endif // _HR_STATS

      //REMOVE
      //ChildUPImplicants = new UniqueSet(NLITS);
      ChildUPImplicants = getUniqueSet();

#ifdef _HR_DEBUG
      UniqueSetCount++;
#endif // _HR_DEBUG

      for(i = 0; i < getNumBcls(L); i++) {

	impl = getLitBclsElem(L, i);

	// If impl is already a member of UPImplicants then impl can be removed 
	// from L's binary clause list.  To maintain the symmetry of the 
	// implications, when L->impl is removed, -impl->-L must also be removed.

	//BGW
	//if(UPImplicants->member(impl) && checkForImplicant2(impl, numL)) {
	if(UPImplicants->member(impl)) {

	  //REMOVE
#ifdef _HR_TRACE
	  //fprintf(fp, "  $ Found %d already in UPImplicants of %d.  Skipping\n",
	  //IntLitToExt(impl), IntLitToExt(numL));
#endif // _HR_TRACE     
	  //*
	  //REMOVE
	  
#ifdef _HR_TRACE
	  fprintf(fp, "  $ Found %d already in UPImplicants of %d.  Deleting.\n",
		 IntLitToExt(impl), IntLitToExt(numL));
#endif // _HR_TRACE

	  // BUCKET STUFF
	  //deleteBclsFromTable(numL, impl);
	  // END BUCKET STUFF

	  // Remove L->impl
	  setNumBcls(L, getNumBcls(L) - 1);
	  setLitBclsElem(L, i, getLitBclsElem(L, getNumBcls(L)));

	  // Remove -impl->-L
	  // First find -L in the LitBcls list of literal -impl (neg).
	  neg = negate(impl);

	  for(j = 0; j < getNumBcls(neg); j++) {
	    if(getLitBclsElem(neg, j) == negL) {

	      // BUCKET STUFF
	      //deleteBclsFromTable(neg, negL);
	      // END BUCKET STUFF
#ifdef _DEBUG // Jessica
              printf("Removing implication %d->%d\n", IntLitToExt(neg), 
                      IntLitToExt(getLitBclsElem(neg, j)));
#endif
	      setNumBcls(neg, getNumBcls(neg) - 1);
	      setLitBclsElem(neg, j, getLitBclsElem(neg, getNumBcls(neg)));
	      break;
	    }
	      
#ifdef _HR_DEBUG
	    // Make sure that the implications -i->-L was actually found.
	    if(j == (getNumBcls(neg) - 1)) { 
	      printf("ERROR: Could not find implication %d->%d!.1\n",
		     IntLitToExt(neg), IntLitToExt(negL));
	      printf("Implications of %d are:", IntLitToExt(neg));
	      for(k = 0; k < getNumBcls(neg); k++)
		printf(" %d", IntLitToExt(getLitBclsElem(neg, k)));
	      printf("\n");
	    }
#endif // _HR_DEBUG

	  }
	  
	  // Do not increment i on this iteration because the implication
	  // at this spot in L's list of implications was just replaced
	  // with a new one.
	  i--;

#ifdef _STATS
	  numSatCls++;
	  numSatBcls++;
#endif // _STATS

	  //REMOVE
	  //*/

	}

	// If impl is not already a member, recursively compute impl implicants
	// and then add them to L's UPImplicant list.

	//BGW
	//else {
	else if(getState(impl) != GREY) {

#ifdef _HR_TRACE
	  fprintf(fp, "    Looking at child %d of %d.\n", IntLitToExt(getLitBclsElem(L, i)),
		  IntLitToExt(numL));
#endif // _HR_TRACE

#ifdef _HR_STATS
	  hrdfs_time += (GetInternalRunTime() - hrdfs_start_time);
#endif // _HR_STATS

	  if(!HypRes(intToPreLit(getLitBclsElem(L, i)), ChildUPImplicants)) {
	    pushUPstack(negL);

	    //REMOVE
	    //delete ChildUPImplicants;
	    //ChildUPImplicants = NULL;
	    returnUniqueSet();

#ifdef _HR_DEBUG
	    UniqueSetCount--;
#endif // _HR_DEBUG
//Jessica
#if 0
  printf("HypRes exit\n");
#endif
	    return(false);
	  }	

#ifdef _HR_STATS
	  hrdfs_start_time = GetInternalRunTime();
#endif // _HR_STATS

	  // Add the child's implicants to those of L.
	  while(!ChildUPImplicants->isEmpty()) {
	    impl = ChildUPImplicants->pop();

	    // If L implies a literal and its negation then we have found that
	    // not-L is forced.
	    if(UPImplicants->member(negate(impl))) {
	      pushUPstack(negL);

#ifdef _HR_TRACE
	      fprintf(fp, " <> Contradiction found: %d implies %d and %d (1).\n",
		     IntLitToExt(numL), IntLitToExt(impl),
		     IntLitToExt(negate(impl)));
#endif // _HR_TRACE

	      //REMOVE
	      //delete ChildUPImplicants;
	      //ChildUPImplicants = NULL;
	      returnUniqueSet();
     
#ifdef _HR_DEBUG
	      UniqueSetCount--;
#endif // _HR_DEBUG

#ifdef _HR_STATS
	      hrdfs_time += (GetInternalRunTime() - hrdfs_start_time);
#endif // _HR_STATS
//Jessica
#if 0
  printf("HypRes exit\n");
#endif
	      return(false);
	    }
	    else
	      UPImplicants->pushnew(impl);
	  }
	}
      }

      //REMOVE
      //delete ChildUPImplicants;
      //ChildUPImplicants = NULL;
      returnUniqueSet();

#ifdef _HR_DEBUG
      UniqueSetCount--;
#endif // _HR_DEBUG

#ifdef _HR_STATS
      hrdfs_time += (GetInternalRunTime() - hrdfs_start_time);
      up1_start_time = GetInternalRunTime();
#endif // _HR_STATS

      // UNIT PROPAGATION OF L: PHASE 1

      // Set the top of the stack to -1;
      topUnitPropStack = -1;

#ifdef _HR_TRACE
      fprintf(fp, ": Set %d to true and perform UP.\n", IntLitToExt(numL));
      printUPImplicants(numL, UPImplicants);
#endif // _HR_TRACE

      // Begin unit propagation of L to determine further implicants of L.
      // Go through all literals implied by L, the UPImplicant set, and 
      // set them all true.  Then set all nary clauses containing these
      // literals to inactive.

      // Because the unit propagtion process requires us to change the
      // values of literals, the length of clauses, and the activity of
      // clauses, special temporary variables are used.  The variables 
      // have HR_ prefixes, such as HR_active.  If the first time the
      // variables are accessed during HypRes, it is with a get function,
      // such as getHR_val(), these functions will copy the correct value
      // from the corresponding permanent variable, in this case, "val".
      // The accessed flag of the literal or clause involved is then
      // set to true, so no copying is needed next time it is accessed.
      // If the first access to a literal or clause is a set, no copying
      // is needed but the accessed variable of the literal or clause is
      // still set true.  Accessed literals and clausess are also put in
      // a list.  When this HypRes call exits, the list is used to reset
      // the accessed variables of all literals and clauses involved in
      // the unit propagation.  This is performed in the resetAccessed()
      // function.

      for(i = 0; i < UPImplicants->size; i++) {
	impl = UPImplicants->set[i];

	//REMOVE
	//while(!UPImplicants->isEmpty()) {
	//impl = UPImplicants->pop();
	//storageSet->pushnew(impl);
	//REMOVE

#ifdef _HR_DEBUG
	//if(getHR_val(impl) == U) {
	if(getVal(impl) == U) {
#endif // _HR_DEBUG	  

        // Set tval of impl to T
	//setHR_val(impl, T);
	setVal_Undo(impl, T);

	// Set all nary clauses containing impl to inactive.
        for(j = 0; j < getNumNcls(impl); j++)
	  //setHR_active(getLitNclsElem(impl, j), false);
	  setInActive_Undo(getLitNclsElem(impl, j));

#ifdef _HR_DEBUG
	}
	//else if(getHR_val(impl) == F)
	else if(getVal(impl) == F)
	  printf("ERROR: Tried to set previously false literal %d to true.\n",
		 IntLitToExt(impl));
	else
	  printf("ERROR: Tried to set literal %d to true again.\n",
		 IntLitToExt(impl));
#endif // _HR_DEBUG

      }
      

      // Go through the UPImplicants of L again, this time setting the 
      // negation of each implicant to false.  Decrement all nary
      // clauses containing these negations.  If any clause gets to a
      // length of 1, add the remaining literal of undefined value to
      // a stack of literals to be unit propagated in the second phase.
      // If any clause gets to length 0, it is a contradiction which 
      // means the negation of L must be forced in the theory.  Exit,
      // HypRes and force L to be false.
      for(i = 0; i < UPImplicants->size; i++) {

	//REMOVE
	//while(!storageSet->isEmpty()) {
	//impl = storageSet->pop();
	//UPImplicants->pushnew(impl);	
	//neg = negate(impl);
	//REMOVE

	neg = negate(UPImplicants->set[i]);

#ifdef _HR_DEBUG
	//if(getHR_val(neg) == U) {
	if(getVal(neg) == U) {
#endif // _HR_DEBUG

	//setHR_val(neg, F);
	setVal_Undo(neg, F);

	// Decrement the length of all active clauses containing the neg.
	for(j = 0; j < getNumNcls(neg); j++) {
	  clsIndex = getLitNclsElem(neg, j);
	  //if(getHR_active(clsIndex)) {
	  if(getActive(clsIndex)) {
	    //setHR_curLen(clsIndex, getHR_curLen(clsIndex) - 1);
//Jessica
#ifdef _DEBUG
            if (IntLitToExt(numL) == 9) {
              printf("hello 2\n");
            }
#endif
	    DecrCurLen_Undo(clsIndex);

#ifdef _UR_IN_HYPRES
            //Jessica: make any further length reductions due to universal
            // reduction 
#ifndef _NO_UR
#ifdef _UR_DEBUG
            int temp = getCurLen(clsIndex);
#endif
            assert(getVal(neg)!=U);
            UnivReduc_Undo(clsIndex, getLitPrefixLevel(L));
#ifdef _UR_DEBUG
            if(getCurLen(clsIndex) < temp)
              printf("HypRes(): universal reduction reduced clause length\n");
#endif        
#endif //_NO_UR   
#endif //_UR_IN_HYPRES 

	    // If the nary clause has become a unit clause, find the 
	    // remaining literal and push it onto the UnitPropStack.
	    //if(getHR_curLen(clsIndex) == 1) {
	    if(getCurLen(clsIndex) == 1) {

#ifdef _HR_DEBUG 
	      int count = 0;
#endif // _HR_DEBUG


	      //for(k = 0; k < getCurLen(clsIndex); k++) {
	      for(k = 0; k < getHR_curLen(clsIndex); k++) {
		//if(getHR_val(getLitsElem(clsIndex, k)) == U) {
		if(getVal(getLitsElem(clsIndex, k)) == U) {
		  if(!pushUnitPropStack(getLitsElem(clsIndex, k))) {
		    UndoChanges();

		    pushUPstack(negL);

#ifdef _HR_TRACE
		    fprintf(fp, " <> Contradiction found: %d implies %d and %d (2).\n",
			   IntLitToExt(numL), IntLitToExt(getLitsElem(clsIndex, k)),
			   IntLitToExt(negate(getLitsElem(clsIndex, k))));
#endif // _HR_TRACE

		    //resetAccessed();

#ifdef _HR_STATS
		    up1_time += (GetInternalRunTime() - up1_start_time);
#endif // _HR_STATS
//Jessica
#if 0
  printf("HypRes exit\n");
#endif
		    return(false);
		  }

#ifdef _HR_DEBUG 
		  count++;
		  if(count > 1) {
		    int w;

		    // Check for case where multiple copies of the literal exist in the clause
		    // because of the use of HR_curLen which gives too large a value for
		    // the length.  This is a shady patch up job.
		    bool okay = true;
		    for(w = 0; w < k; w++) {
		      if((getVal(getLitsElem(clsIndex, w)) == U) &&
			 (getLitsElem(clsIndex, w) != getLitsElem(clsIndex, k)))
			okay = false;
		    }
		    if(!okay) {
		      printf("ERROR: Count on lits with val U greater than 1 (a)!\n");
		      //temp-new
		      printf("The clause is:\n");
		      for(w = 0; w < getHR_curLen(clsIndex); w++)
		      //for(int w = 0; w < getCurLen(clsIndex); w++)
			printf("%d (%d) ", IntLitToExt(getLitsElem(clsIndex, w)),
				getVal(getLitsElem(clsIndex, w)));
		      printf("\n");
		    }
		  }
		  continue;
#endif // _HR_DEBUG
		  break;
		}
	      }

#ifdef _HR_DEBUG
	      if(count == 0)
		printf("ERROR: Could not find an active literal in this clause! (a)\n");
#endif // _HR_DEBUG
	    }

	    // If the length of a clause has become zero, the clause is empty.
	    // This means that forcing L to be true causes a contradiction and
	    // thus -L can be unit propagated.
	    //else if(getHR_curLen(clsIndex) == 0) {
	    else if(getCurLen(clsIndex) == 0) {
	      UndoChanges();

	      pushUPstack(negL);

#ifdef _HR_TRACE
	      fprintf(fp, " <> Contradiction found: Clause %d",
		     IntLitToExt(getLitsElem(clsIndex, 0)));
	      for(int w = 1; w < getHR_curLen(clsIndex); w++)
		//for(int w = 1; w < getCurLen(clsIndex); w++)
		fprintf(fp, " v %d", IntLitToExt(getLitsElem(clsIndex, w)));
	      fprintf(fp, "\nbecame an empty clause.\n");
#endif // _HR_TRACE

	      //resetAccessed();

#ifdef _HR_STATS
	      up1_time += (GetInternalRunTime() - up1_start_time);
#endif // _HR_STATS
//Jessica
#if 0
  printf("HypRes exit\n");
#endif
	      return(false);
	    }
	  }
	}
	
#ifdef _HR_DEBUG
	}
     	//else if(getHR_val(neg) == T)
	else if(getVal(neg) == T)
	  printf("ERROR: Tried to set previously true literal %d to false.\n",
		 IntLitToExt(neg));
	else
	  printf("ERROR: Tried to set literal %d to false again.\n",
		 IntLitToExt(neg)); 
#endif // _HR_DEBUG

      }

#ifdef _HR_STATS
      up1_time += (GetInternalRunTime() - up1_start_time);
      up2_start_time = GetInternalRunTime();
#endif // _HR_STATS

      // UNIT PROPAGATION OF L: PHASE 2

      // If we made it here, no clause was made empty by setting L and
      // its initial implicants to true.  Now unit propagate all new
      // unit clauses made true by setting L and its initial implicants
      // true.  Also, add these unit clauses to UPImplicants and add 
      // them to the set of children of L (ie. the LitBcls list of
      // implications of L).  To do this, go through the literals in
      // the UnitPropStack and force them to be true.  Add any new
      // unit clauses to the stack and continue until the stack is
      // empty.

      // Set the size of the list of L's new implicants to zero.
      sizeNewImplicantList = 0;

      // Initialize the list of new implicants of L.
      NewImplicantList = getNewImplicantList();

#ifdef _HR_DEBUG
      IntArrayCount++;
#endif // _HR_DEBUG

      while(topUnitPropStack > -1) {
	lit = UnitPropStack[topUnitPropStack--];

#ifdef _HR_TRACE
	fprintf(fp, "Unit propagating %d, a new implicant of %d.\n", IntLitToExt(lit),
	       IntLitToExt(numL));
#endif // _HR_TRACE

	//switch(getHR_val(lit)) {
	switch(getVal(lit)) {
	case F:
	  // If the literal was already set to false, there is a contradiction
	  // and -L can be unit propagated.
	  UndoChanges();

	  pushUPstack(negL);

#ifdef _HR_TRACE
	  fprintf(fp, " <> Contradiction found: %d implies %d and %d (3).\n",
		 IntLitToExt(numL), IntLitToExt(lit),
		 IntLitToExt(negate(lit)));
#endif // _HR_TRACE

	  //resetAccessed();
	  returnNewImplicantList();

#ifdef _HR_DEBUG
	  IntArrayCount--;
#endif // _HR_DEBUG

#ifdef _HR_STATS
	  up2_time += (GetInternalRunTime() - up2_start_time);
#endif // _HR_STATS
//Jessica
#if 0
  printf("HypRes exit\n");
#endif
	  return(false);
	case T:
	  break;
	case U:
	  //setHR_val(lit, T);
	  setVal_Undo(lit, T);
	  negLit = negate(lit);
	  //setHR_val(negLit, F);
	  setVal_Undo(negLit, F);
//Jessica
#if 1          
//#ifdef _HR_DEBUG
	  if(UPImplicants->member(lit))
	    printf("ERROR: Literal %d was already a member of UPImplicants!\n",
		   IntLitToExt(lit));
#endif // _HR_DEBUG

	  // Add lit to implicants of L
	  UPImplicants->pushnew(lit);

	  // Add lit to the list of new implicants of L.
	  NewImplicantList[sizeNewImplicantList++] = lit;
	  
	  // Add binary clause (-L v lit) or equivalently, L->lit and
	  // -lit->-L to theory.
#ifdef _DEBUG //Jessica
          if(IntLitToExt(numL) == 164 && IntLitToExt(lit) == 231) {
            printf("hello\n");
          }
#endif
	  if(addBcls(numL, lit)) {
	    addBcls(negate(lit), negL);

#ifdef _DEBUG //Jessica
          printf("    & Added %d->%d and %d->%d to theory.\n",
		   IntLitToExt(numL), IntLitToExt(lit),
		   IntLitToExt(negate(lit)), IntLitToExt(negL));
#endif

#ifdef _HR_TRACE
	    fprintf(fp, "    & Added %d->%d and %d->%d to theory.\n",
		   IntLitToExt(numL), IntLitToExt(lit),
		   IntLitToExt(negate(lit)), IntLitToExt(negL));
#endif // _HR_TRACE

#ifdef _STATS
	    numAddBcls++;
#endif // _STATS

	    foundNewBcls = true;
	    numNewBclsFound++;
	  }

#ifdef _HR_DEBUG
	  // It is no longer always an error if a binary clause already exists in 
	  // the theory.  This is because, using the Black-Grey-White scheme, not 
	  // all implicants of a literal will be put in its UPImplicants list.
	  // Specifically, GREY literals won't be there.  If they are found to
	  // be implied by L during unit propagation, HypRes will try to add them
	  // and find them already there.  But, I don't think this can happen with
	  // WHITE or BLACK implicants.
	  else if(getState(lit) != GREY)
	    printf("ERROR: Binary clause (%d v %d) existed in theory already!\n",
		    IntLitToExt(negL), IntLitToExt(lit));
#endif // _HR_DEBUG

	  // Add literals implied by lit (from binary clauses of the 
	  // form (-lit v a)) to the UnitPropStack.
	  for(i = 0; i < getNumBcls(lit); i++) {
	    if(!pushUnitPropStack(getLitBclsElem(lit, i))) {
	      UndoChanges();

	      pushUPstack(negL);

#ifdef _HR_TRACE
	      fprintf(fp, " <> Contradiction found: %d implies %d and %d (4).\n",
		     IntLitToExt(numL), IntLitToExt(getLitBclsElem(lit, i)),
		     IntLitToExt(negate(getLitBclsElem(lit, i))));
#endif // _HR_TRACE

	      //resetAccessed();
	      returnNewImplicantList();
	  
#ifdef _HR_DEBUG
	      IntArrayCount--;
#endif // _HR_DEBUG

#ifdef _HR_STATS
	      up2_time += (GetInternalRunTime() - up2_start_time);
#endif // _HR_STATS
//Jessica
#if 0
  printf("HypRes exit\n");
#endif
	      return(false);
	    }
	  }

	  // Decrement the length of all active clauses containing the 
	  // negation of lit.
	  for(i = 0; i < getNumNcls(negLit); i++) {

	    clsIndex = getLitNclsElem(negLit, i);
	    //if(getHR_active(clsIndex)) {
	    if(getActive(clsIndex)) {
	      //setHR_curLen(clsIndex, getHR_curLen(clsIndex) - 1);
	      DecrCurLen_Undo(clsIndex);

#ifdef _UR_IN_HYPRES
              //Jessica
#ifndef _NO_UR
#ifdef _UR_DEBUG
              int temp = getCurLen(clsIndex);
#endif
              assert(getVal(negLit)!=U);
              UnivReduc_Undo(clsIndex, getLitPrefixLevel(L));
#ifdef _UR_DEBUG
              if(getCurLen(clsIndex) < temp)
                printf("HypRes(): universal reduction reduced clause length 2\n");
#endif
#endif //_NO_UR
#endif //_UR_IN_HYPRES

	      // If the nary clause has become a unit clause, find the 
	      // remaining literal and push it onto the UnitPropStack.
	      //if(getHR_curLen(clsIndex) == 1) {
	      if(getCurLen(clsIndex) == 1) {

#ifdef _HR_DEBUG 
		int count = 0;
#endif // _HR_DEBUG
                
		//for(j = 0; j < getCurLen(clsIndex); j++) {
		for(j = 0; j < getHR_curLen(clsIndex); j++) {
		  //if(getHR_val(getLitsElem(clsIndex, j)) == U) {
		  if(getVal(getLitsElem(clsIndex, j)) == U) { 
		    if(!pushUnitPropStack(getLitsElem(clsIndex, j))) {
		      UndoChanges();

		      pushUPstack(negL);

#ifdef _HR_TRACE
		      fprintf(fp, " <> Contradiction found: %d implies %d and %d (5).\n",
			     IntLitToExt(numL), IntLitToExt(getLitsElem(clsIndex, j)),
			     IntLitToExt(negate(getLitsElem(clsIndex, j))));
#endif // _HR_TRACE

		      //resetAccessed();
		      returnNewImplicantList();
		      
#ifdef _HR_DEBUG
		      IntArrayCount--;
#endif // _HR_DEBUG      

#ifdef _HR_STATS		      
		      up2_time += (GetInternalRunTime() - up2_start_time);
#endif // _HR_STATS

		      return(false);
//Jessica
#if 0
  printf("HypRes exit\n");
#endif
		    }

#ifdef _HR_DEBUG 
		    count++;
		    if(count > 1) {
		      int w;

		      // Check for case where multiple copies of the literal exist in the clause
		      // because of the use of HR_curLen which gives too large a value for
		      // the length.  This is a shady patch up job.
		      bool okay = true;
		      for(w = 0; w < j; w++) {
			if((getVal(getLitsElem(clsIndex, w)) == U) &&
			   (getLitsElem(clsIndex, w) != getLitsElem(clsIndex, j)))
			  okay = false;
		      }
		      if(!okay) {
			printf("ERROR: Count on lits with tval U greater than 1 (b)!\n");
		      
			//temp-new
			printf("The clause is: ");
			for(w = 0; w < getHR_curLen(clsIndex); w++)
			//for(int w = 0; w < getCurLen(clsIndex); w++)
			  printf("%d (%d) ", IntLitToExt(getLitsElem(clsIndex, w)),
				  getVal(getLitsElem(clsIndex, w)));
			printf("\n");
		      }
		    }
		    continue;
#endif // _HR_DEBUG
		    break;
		  }
		}

#ifdef _HR_DEBUG
		if(count == 0)
		  printf("ERROR: Could not find an active literal in this clause! (b)\n");
#endif // _HR_DEBUG
	      }
	    }
	  }
	  break;
	default:
	  printf("ERROR: Illegal value for tval of literal %d in UnitPropStack.\n",
		 IntLitToExt(lit));
	  break;    
	}
      }

      //resetAccessed();
      UndoChanges();

#ifdef _HR_STATS
      up2_time += (GetInternalRunTime() - up2_start_time);
      fix_start_time = GetInternalRunTime();
#endif // _HR_STATS

      //REMOVE
      //temp
      //ChildUPImplicants = new UniqueSet(NLITS);
      ChildUPImplicants = getUniqueSet();

#ifdef _HR_DEBUG
      UniqueSetCount++;
#endif // _HR_DEBUG

      // At this stage L has all hyper-resolvants as implicants in its 
      // implication graph.  However, some of these new children might not have 
      // their own implication graph set properly.  Furthermore, L might have too
      // many children.  That is, the previous stage would have added all transitive
      // closures as children.  We want to delete some of these children.  Fix these
      // two things now.
      for(i = 0; i < sizeNewImplicantList; i++) {
	impl = NewImplicantList[i];

	if(impl == numL)
	  printf("ERROR?:  impl = numL (%d).\n", IntLitToExt(numL));

	// If impl equals negative one that means it has been previously deleted
	// from the list.
	//if(impl != -1) {

	  //BGW
	// The grey part may be wrong?
	if((impl != -1) && (getState(impl) != GREY)) {


#ifdef _HR_TRACE
	  fprintf(fp, "    Look at NEW child %d of %d.\n", IntLitToExt(impl),
		 IntLitToExt(numL));
#endif // _HR_TRACE

#ifdef _HR_STATS
	  fix_time += (GetInternalRunTime() - fix_start_time);
#endif // _HR_STATS

#ifdef _HR_DEBUG
	  if(!ChildUPImplicants->isEmpty())
	    printf("ERROR: ChildUPImplicants was not empty as expected!\n");
	  bool value =
#endif // _HR_DEBUG

	  HypRes(intToPreLit(impl), ChildUPImplicants);

#ifdef _HR_STATS
	  fix_start_time = GetInternalRunTime();
#endif // _HR_STATS

#ifdef _HR_DEBUG
	  // Value should alway be true, otherwise the previous step would have
	  // already returned false.
	  if(!value) {
	    printf("ERROR: HypRes() returned false on %d but should be true!\n",
		   IntLitToExt(impl));
	  } 
#endif // _HR_DEBUG

	  for(j = 0; j < sizeNewImplicantList; j++) {
	    int impl2 = NewImplicantList[j];
	     
	    // Check that impl2 wasn't already deleted and that i and j are not
	    // the same element in the list.
	    if((impl2 != -1) && (j != i)) {

#ifdef _HR_DEBUG
	      // Check that there are no duplicate entries in the new implicant
	      // list.
	      if(impl2 == impl)
		printf("ERROR: Duplicate literal %d in NewImplicantList[]!\n",
		       IntLitToExt(impl2));
#endif // _HR_DEBUG

	      // Remove the transistive closure from the implicants of L: 
	      // Delete impl2 from L's LitBcls implication list if it is
	      // already reachable from impl's implication graph.  Also,
	      // remove impl2 from the NewImplicantList[].
	      // ** TEMPORARY ** It may turn out that impl2 = L.  This 
	      // occurs if L->a->L.  In this case we shouldn't try to
	      // delete L->impl2, so we will skip this case.

	      //REMOVE
	      // ** TEMPORARY 2 ** There is also the case where impl = a,
	      // impl2 = b, and L->a->L->b.  In this case, impl2 (b) will be 
	      // a member of ChildUPImplicants (the implicants of a).  
	      // However, if L->impl2 is deleted, then b will be removed
	      // wrongly from L's graph.  checkForImplicant looks at this
	      // case and returns false if it is found, that is it returns
	      // false if impl->impl2 only because impl->L->impl2.
	      //REMOVE

	      //REMOVE
	      //#ifdef _HR_STATS
	      //checkimp_start_time = GetInternalRunTime();
	      //#endif // _HR_STATS

	      //BGW
	      //if(ChildUPImplicants->member(impl2) && (impl2 != numL)
	      // && (checkForImplicant(impl, impl2, numL))) {
	      if(ChildUPImplicants->member(impl2) && (impl2 != numL)) {

		//REMOVE
		//#ifdef _HR_STATS
		//checkimpcount++;
		//checkimp_time += (GetInternalRunTime() - checkimp_start_time);
		//#endif // _HR_STATS

		//REMOVE
		//temp
#ifdef _HR_TRACE
		//fprintf(fp, "  $ Found %d already in %d's graph.  Skipping.\n",
		//IntLitToExt(impl2), IntLitToExt(numL));
#endif // _HR_TRACE
		//*
		//REMOVE

#ifdef _HR_TRACE
		fprintf(fp, "  $ Found %d already in %d's graph.  Deleting %d->%d.\n",
		       IntLitToExt(impl2), IntLitToExt(impl), IntLitToExt(numL),
		       IntLitToExt(impl2));
#endif // _HR_TRACE

		// Remove L->impl2
		// First find impl2 in the LitBcls list of literal L.
		for(k = 0; k < getNumBcls(L); k++) {
		  if(getLitBclsElem(L, k) == impl2) {

		    // BUCKET STUFF
		    //deleteBclsFromTable(numL, impl2);
		    // END BUCKET STUFF

		    setNumBcls(L, getNumBcls(L) - 1);
		    setLitBclsElem(L, k, getLitBclsElem(L, getNumBcls(L)));
		    break;
		  }
	      
#ifdef _HR_DEBUG
		  // Make sure that the implications L->impl2 was actually found.
		  if(k == (getNumBcls(L) - 1)) {
		    printf("ERROR: Could not find implication %d->%d!.2\n",
			   IntLitToExt(numL), IntLitToExt(impl2));
		    printf("Implications of %d are:", IntLitToExt(numL));
		    for(int m = 0; m < getNumBcls(numL); m++)
		      printf(" %d", IntLitToExt(getLitBclsElem(numL, m)));
		    printf("\n");
		  }
#endif // _HR_DEBUG
		}

		// Now Remove -impl2->-L
		// First find -L in the LitBcls list of literal -impl2.
		neg = negate(impl2);

		for(k = 0; k < getNumBcls(neg); k++) {
		  if(getLitBclsElem(neg, k) == negL) {

		    // BUCKET STUFF
		    //deleteBclsFromTable(neg, negL);
		    // END BUCKET STUFF

		    setNumBcls(neg, getNumBcls(neg) - 1);
		    setLitBclsElem(neg, k, getLitBclsElem(neg, getNumBcls(neg)));
		    break;
		  }
	      
#ifdef _HR_DEBUG
		  // Make sure that the implications -impl2->-L was actually found.
		  if(k == (getNumBcls(neg) - 1)) {
		    printf("ERROR: Could not find implication %d->%d!.3\n",
			   IntLitToExt(neg), IntLitToExt(negL));
		    printf("Implications of %d are:", IntLitToExt(neg));
		    for(int m = 0; m < getNumBcls(neg); m++)
		      printf(" %d", IntLitToExt(getLitBclsElem(neg, m)));
		    printf("\n");
		  }
#endif // _HR_DEBUG

		}

		// Remove impl2 from the NewImplicantList[].
		NewImplicantList[j] = -1;

#ifdef _STATS
		numSatCls++;
		numSatBcls++;
#endif // _STATS

		//REMOVE
                //temp
		//*/

	      }

	      //REMOVE
	      //#ifdef _HR_STATS
	      //else
	      //checkimp_time += (GetInternalRunTime() - checkimp_start_time);
	      //#endif // _HR_STATS

	    }
	  }
	  // Empty the ChildUPImplicants to prepare for their next use.
	  ChildUPImplicants->empty();
	}
      }

      returnNewImplicantList();

#ifdef _HR_DEBUG
      IntArrayCount--;
#endif // _HR_DEBUG

      //REMOVE
      //delete ChildUPImplicants;
      //ChildUPImplicants = NULL;
      returnUniqueSet();
 
#ifdef _HR_DEBUG  
      UniqueSetCount--;
#endif // _HR_DEBUG

#ifdef _HR_STATS
      fix_time += (GetInternalRunTime() - fix_start_time);
#endif // _HR_STATS

    }
    
    //BGW
    setState(numL, BLACK);

#ifdef _HR_TRACE
    fprintf(fp, "Finished HypRes on %d.\n", IntLitToExt(numL));
    printUPImplicants(numL, UPImplicants);
    printClosure(numL);
#endif // _HR_TRACE
//Jessica
#if 0
  printf("HypRes exit\n");
#endif
    return(true);
  }

  // This point should not be reached.
  //BGW
  else {
    printf("ERROR: HypRes got called on %d, a grey literal!\n",
	   IntLitToExt(numL));
//Jessica
#if 0
  printf("HypRes exit\n");
#endif
    return(true);
  }
//Jessica
#if 0
  printf("HypRes exit\n");
#endif
}

// The runHypRes function performs the initializtion for hyper-resolution.
// It then runs HypRes on all literals without antecedant implications.
// Then, it prints some statistics and free memory.
void runHypRes() {

  int i, visCount = 0;

#ifdef _HR_TRACE
  if((fp = fopen(HRfilename, "a")) == NULL)
    printf("ERROR: Failed to open %s.\n", HRfilename);
  fprintf(fp, "Entering runHypRes()\n");
#endif // _HR_TRACE

//Jessica
#ifdef _DEBUG
  printf("runHypRes() enter\n");
#endif

  // Set foundNewBcls to false.  This flag indicated if Hyper-resolution
  // found any new binary clauses on this pass.
  foundNewBcls = false;
  numNewBclsFound = 0;
  // Set foundNewForced to false.  This flag indicated if Hyper-resolution
  // found any literals that caused a contradiction when set true.  This 
  // forced Hyper-resolution to set them to false.
  foundNewForced = false;
  int numNewUPFound = 0;

  // TEMP SUBSUME
  //printf("Performing Simple Subsumption.\n");
  //simpleSubsump();
  //printf("Performing Krom Subsumption.\n");
  //kromSubsump();
  // TEMP SUBSUME

#ifdef _HR_STATS
  HRcounter = 0;
  total_time = 0.0;
  rv_time = 0.0;
  hrdfs_time = 0.0;
  copy_time = 0.0;
  up1_time = 0.0;
  up2_time = 0.0;
  fix_time = 0.0;
  checkimp_time = 0.0;
  checkimpcount = 0;
  prop_time = 0.0;

  total_start_time = GetInternalRunTime();
#endif // _HR_STATS

  // Set up expermental variables.
  AccessedNclsList = new int[NUMNCLS];
  sizeAccessedNclsList = 0;
  AccessedLitsList = new int[NLITS];
  sizeAccessedLitsList = 0;

  // Set up marked list for recursive searches.
  InComponentSetList = new int[NLITS];

  if(!AccessedNclsList || !AccessedLitsList || !InComponentSetList)
    panic("Memory Allocation Failure #20P\n"); 


  //REMOVE
  // Set up UniqueSet for printing
  //printSet = new UniqueSet(NLITS);

  // Set all nary clause accessed variables to false.
  for(i = 0; i < NUMNCLS; i++)
    setNclsAccessedFalse(i);

  for(i = 0; i < NLITS; i++) {
    // Set all literal  accessed variables to false.
    setLitAccessedFalse(i);
    // Set all literal visited states to white.
    setState(i, WHITE);
    // Set all InComponent variables to false.
    setInComponent(i, false);

    //temp-new
    // Set all OnStack variables to false.  OnStack is used to indicate
    // whether a literal is on the UnitPropStack already to avoid having
    // duplicate entries on the stack.
    setOnStack(i, false);
  }

  // Initialize the set of implicants for HypRes calls.
  UniqueSet * UPImplicants = new UniqueSet(NLITS);

  if(!UPImplicants)
    panic("Memory Allocation Failure #21P\n"); 

  //REMOVE
  // This UniqueSet is used for temporary storage during the HypRes 
  // function.  It holds the implicants from UPImplicants after they
  // are popped off the UPImplicants set.  Afterwards, this temporary
  // set can be used to restore the original contents of UPImplicants.
  //storageSet = new UniqueSet(NLITS);

  // Initialize the UniqueSet array used by the HypRes function for
  // reuse of ChildUPImplicants.
  initUniqueSetArray();

  // Initialize the NewImplicantList array used by the HypRes function for
  // reuse of NewImplicantLists.
  initNewImplicantListArray();

  // $$$ NEW $$$

  sizeUndoStack = 20 * NLITS;
  UndoStack = new UndoNode[sizeUndoStack];
  if(!UndoStack)
    panic("Memory Allocation Failure #22P\n");
  topUndoStack = -1;

  // Set up HR_curLen to hold the actual value of curLen for the sake of 
  // searching through nary clauses to find the last remaining active
  // literal.
  for(i = 0; i < NUMNCLS; i++)
    setHR_curLen(i, getCurLen(i));

  // $$$ END NEW $$$

  //BGW
  //REMOVE
  //for(i = 0; i < NLITS; i++)
  //setVisited(i, false);

  for(i = 0; i < NLITS; i++) {
    //BGW
    //if(active(i) && !getVisited(i) && (getNumBcls(negate(i)) == 0)) {
    //Jessica: should we also check that the root is existential?
    if(active(i) && (getState(i) == WHITE) && (getNumBcls(negate(i)) == 0)) {

#ifdef _HR_TRACE
      fprintf(fp, "->Starting recursive HypRes from %d.\n", IntLitToExt(i));
#endif // _HR_TRACE

      visCount++;
      if(!HypRes(intToPreLit(i), UPImplicants)) {

#ifdef _HR_STATS
	prop_start_time = GetInternalRunTime(); 
#endif // _HR_STATS

	//REMOVE
	//if(!returnForBcls) {
	numNewUPFound++;
	foundNewForced = true;

#ifdef _HR_TRACE
	fprintf(fp, "! Unit propagating %d caused contradiction, forcing this literal.\n",
	       IntLitToExt(i));
#endif // _HR_TRACE

        //Jessica
        assert(topUndoStack == -1);
	propagateUPstack();
	if(haveContradiction()) {
//Jessica
#ifdef _DEBUG
          printf("runHypRes() exit 2\n");
#endif
	  return;
        }

	// $$$ NEW $$$

	// Set up HR_curLen to hold the actual value of curLen for the sake of 
	// searching through nary clauses to find the last remaining active
	// literal.
	//for(j = 0; j < NUMNCLS; j++)
	//setHR_curLen(j, getCurLen(j));

	// $$$ END NEW $$$

	//REMOVE
	//}
	//else {
	//fprintf(fp, "@ New bcls found.  Restarting HypRes.\n");
	//returnForBcls = false;
	//}

	//fprintf(fp, "Starting from zero again.\n");
	//i = 0;
	//fprintf(fp, "\n Starting from back again.\n");
	//i = NLITS - 1;
	//for(j = 0; j < NLITS; j++)
	//setVisited(j, false);
	//REMOVE

#ifdef _HR_STATS
	prop_time += (GetInternalRunTime() - prop_start_time);
#endif // _HR_STATS

      }
      UPImplicants->empty();
    }
  }

#ifdef _HR_STATS
  total_time = GetInternalRunTime() - total_start_time;
  printf("s HypRes took a total of %.3f seconds.\n", total_time);
  printf("s %.3f seconds were spent revisiting literals.\n", rv_time);
  printf("s %.3f seconds were spent recursively searching children.\n",
	 hrdfs_time);
  printf("s %.3f seconds were spent copying literal fields.\n",
	 copy_time);
  printf("s %.3f seconds were spent doing initial unit propagation.\n",
	 up1_time);
  printf("s %.3f seconds were spent during the full UP.\n", up2_time);
  printf("s %.3f seconds were spent fixing up the implications.\n",
	 fix_time);
  printf("s %.3f seconds were spent in internal fix loop.\n", checkimp_time); 
  printf("s %.3f seconds were spent propagating forced literals.\n",
	 prop_time);
  printf("c checkimpcount is %d.\n", checkimpcount);
  printf("c HRcounter is %d.\n", HRcounter);
#endif // _HR_STATS

#ifdef _DETAILS
  printf("c HypRes for loop visited %d literals.\n", visCount);
  printf("c HypRes found %d new binary clauses.\n", numNewBclsFound);
  printf("c HypRes ran %d unit propagations.\n\n", numNewUPFound);
#endif // _DETAILS

  // Clean up UniqueSet array.
  cleanupUniqueSetArray();

  // Clean up NewImplicantList array.
  cleanupNewImplicantListArray();

  delete [] UndoStack;
  delete UPImplicants;
  UPImplicants = NULL;

  //REMOVE
  //delete storageSet;
  //storageSet = NULL;
  //delete printSet;
  //printSet = NULL;
  //REMOVE

  delete [] InComponentSetList;

  // Delete expermental variables;
  delete [] AccessedNclsList;
  delete [] AccessedLitsList;

#ifdef _HR_TRACE
  fprintf(fp, "Exiting runHypRes()\n");
  fclose(fp);
#endif // _HR_TRACE

//Jessica
#ifdef _DEBUG
  printf("runHypRes() exit\n");
#endif
}

// This function puts lit on the stack of literals to be unit propagated 
// and sets all nary clauses containing lit to inactive.
bool pushUnitPropStack(int lit) {
#if 0 //we can temporarily UP universals
  //Jessica
  if(!isLitExistential(lit)) {
#ifdef _UR_DEBUG
    printf("pushUnitPropStack(): %d is universal\n", IntLitToExt(lit));
#endif
    return(false);
  }
#endif

  //temp-new
  if(getOnStack(lit)) {

#ifdef _HR_TRACE
    fprintf(fp, "      Literal %d was already pushed on the stack.\n", 
	    IntLitToExt(lit));
#endif // _HR_TRACE

    return(true);
  }
  
  //switch(getHR_val(lit)) {
  switch(getVal(lit)) {
  case F:
    // If the literal was already set to false, there is a contradiction
    // and -L can be unit propagated.    
    return(false);
  case T:
    // Nothing to do since the literal has already been processed.
    break;
  case U:

#ifdef _HR_DEBUG
    if(topUnitPropStack >= NLITS-1) {
      bool * mark = new bool[NLITS];
      int j;
      printf("ERROR: UnitPropStack overflow!\n");
      for(j = 0; j < NLITS; j++)
	mark[j] = false;
      for(j = 0; j <= topUnitPropStack; j++) {
	if((UnitPropStack[j] < 0) || (UnitPropStack[j] >= NLITS))
	  printf("Element of UnitPropStack is out of bounds!\n");
	else if(mark[UnitPropStack[j]] == true)
	  printf("Duplicate %d found.\n", IntLitToExt(UnitPropStack[j]));
	else
	  mark[UnitPropStack[j]] = true;
      }
      exit(1);
    }
#endif // _HR_DEBUG

    UnitPropStack[++topUnitPropStack] = lit;
    //temp-new
    setOnStack_Undo(lit);

    // Set all nary clauses containing lit to inactive.
    for(int i = 0; i < getNumNcls(lit); i++)
      //setHR_active(getLitNclsElem(lit, i), false);
      setInActive_Undo(getLitNclsElem(lit, i));
    break;
  default:
    printf("ERROR: Illegal value for tval for literal %d.\n",
	   IntLitToExt(lit));
    break;    
  }
  return(true);
}

// Reset accessed sets to false all the accessed variables of literals and
// clauses  used during the temporary unit propagation of HypRes.
void resetAccessed() {
  int i;

  for(i = 0; i < sizeAccessedNclsList; i++)
    setNclsAccessedFalse(AccessedNclsList[i]);
  sizeAccessedNclsList = 0;
  for(i = 0; i < sizeAccessedLitsList; i++)
    setLitAccessedFalse(AccessedLitsList[i]);
  sizeAccessedLitsList = 0;
}

// Sets the inComponent variable of all literals in the InComponentList
// back to false.
void resetInComponent() {
  int i;

  for(i = 0; i < sizeInComponentSetList; i++)
    setInComponent(InComponentSetList[i], false);
}

#ifdef _HR_TRACE
// Recursively prints the transitive closure of the implication graph
// for literal, lit.
void printClosureHelper(int lit) {
  int i;

  setInComponent(lit, true);
  InComponentSetList[sizeInComponentSetList++] = lit;
  fprintf(fp, "%d ", IntLitToExt(lit));

  for(i = 0; i < getNumBcls(lit); i++) {
    if(!getInComponent(getLitBclsElem(lit, i)))
      printClosureHelper(getLitBclsElem(lit, i));
  }
}

// Calls printClosureHelper to recursively print the transitive closure
// of the implication graph for literal, lit.
void printClosure(int lit) {

  sizeInComponentSetList = 0;

  fprintf(fp, "The following literals are implied by %d:\n",
	 IntLitToExt(lit));
  
  printClosureHelper(lit);
  fprintf(fp, "\n");
  resetInComponent();
}

// Prints the literals in lit's UPImplicants list.
void printUPImplicants(int lit, UniqueSet * UPImplicants) {
  int i;

  fprintf(fp, "The UPImplicants of %d are:\n", IntLitToExt(lit));

  for(i = 0; i < UPImplicants->size; i++) {
    fprintf(fp, "%d ", IntLitToExt(UPImplicants->set[i]));
  }
  fprintf(fp, "\n");
}
#endif // _HR_TRACE


//REMOVE
bool checkForImplicantHelper(int cur_lit, int target, int root) {
  int i, child;

  setInComponent(cur_lit, true);
  InComponentSetList[sizeInComponentSetList++] = cur_lit;

  for(i = 0; i < getNumBcls(cur_lit); i++) {
    child = getLitBclsElem(cur_lit, i);
    if(child == target) {
      resetInComponent();
      return(true);
    }
    else if(!getInComponent(child) && (child != root)) {
      if(checkForImplicantHelper(child, target, root))
	return(true);
    }
  }
  return(false);
}

bool checkForImplicant(int cur_lit, int target, int root) {

  sizeInComponentSetList = 0;
  if(checkForImplicantHelper(cur_lit, target, root))
    return(true);
  else {
    resetInComponent();
    return(false);
  }
}

bool checkForImplicant2(int target, int root) {
  int i, child;
  sizeInComponentSetList = 0;

  for(i = 0; i < getNumBcls(root); i++) {
    child = getLitBclsElem(root, i);
    if(child == root)
      printf("ERROR: %d implies itself!\n", IntLitToExt(child));
    else if(child != target) {
      if(checkForImplicantHelper(child, target, root))
	return(true);
    }  
  }
  resetInComponent();
  return(false);
}
//REMOVE

// Initializes the UniqueSetArray used to decrease the number of
// memory allocations and deallocations by reusing UniqueSets.
void initUniqueSetArray() {
  int i;

  USArraySize = 0;
  
  UniqueSetArray = new (UniqueSet *) [NLITS];

  if(!UniqueSetArray)
    panic("Memory Allocation Failure #23P\n"); 

  for(i = 0; i < NLITS; i++)
    UniqueSetArray[i] = NULL;

}

// Returns a free UniqueSet.
UniqueSet * getUniqueSet() {
  if(UniqueSetArray[USArraySize] == NULL) {
    UniqueSetArray[USArraySize] = new UniqueSet(NLITS);
    if(!UniqueSetArray[USArraySize])
      panic("Memory Allocation Failure #24P\n");
  }
  return(UniqueSetArray[USArraySize++]);
}

// Reclaims the last UniqueSet given out.
inline void returnUniqueSet() {
  UniqueSetArray[--USArraySize]->empty();
}

// Deallocates all the UniqueSets.
void cleanupUniqueSetArray() {
  int i = 0;
  while(UniqueSetArray[i] != NULL)
    delete UniqueSetArray[i++];

  delete [] UniqueSetArray;
}

// Initializes the NewImplicantListArray used to decrease the number
// of memory allocations and deallocations by reusing int arrays.
void initNewImplicantListArray() {
  int i;

  NILArraySize = 0;
  
  NewImplicantListArray = new (int *) [NVARS + 1];

  if(!NewImplicantListArray)
    panic("Memory Allocation Failure #25P\n"); 

  for(i = 0; i < (NVARS + 1); i++)
    NewImplicantListArray[i] = NULL;

}

// Returns a free int array.
int * getNewImplicantList() {
  if(NewImplicantListArray[NILArraySize] == NULL) {
    NewImplicantListArray[NILArraySize] = new int[NLITS];
    if(!NewImplicantListArray[NILArraySize])
      panic("Memory Allocation Failure #26P\n"); 
  }
  return(NewImplicantListArray[NILArraySize++]);
}

// Reclaims the last int array given out.
inline void returnNewImplicantList() {
  NILArraySize--;
}

// Deallocates all the int arrays.
void cleanupNewImplicantListArray() {
  int i = 0;
  while(NewImplicantListArray[i] != NULL)
    delete [] NewImplicantListArray[i++];

  delete [] NewImplicantListArray;
}

// $$$ NEW $$$

void UndoChanges() {
  while(topUndoStack > -1) {
    if(UndoStack[topUndoStack].type == SETUNDEF) {
      setVal(UndoStack[topUndoStack--].index, U);
    }
    else if(UndoStack[topUndoStack].type == INCRLEN) {
      IncrCurLen(UndoStack[topUndoStack--].index);
    }
    else if(UndoStack[topUndoStack].type == SETACTIVE) {
      setActive(UndoStack[topUndoStack--].index, true);
    }
    //temp-new
    else
      setOnStack(UndoStack[topUndoStack--].index, false);
  }
}

// $$$ END NEW $$$
