/*

PreQuel. Copyright Horst Samulowitz and Jessica Davies and Fahiem Bacchus 2006

 A QBF preprocessor based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
Jessica Davies and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Jessica Davies and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to implied warranties of merchantability and fitness for a particular purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Davies:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Jessica Davies and Fahiem Bacchus },
	year    = { 2006 },
	title   = { A QBF preprocessor employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/

//
// FILE: cnfoutput.cpp
//

// OVERVIEW:
//
// This file contains code that prints to a file, the reduced cnf formula
// generated by the  preprocessor. This file is in cnf format and the
// comments at the top contain a mapping from the original input file's
// numbering of literals to the new file's number of its reduced set of
// literals and back.


#include "preprocessor.h"
#include <string.h>
#include <vector>
#include <algorithm>

using namespace std;

extern char * filename;
extern char * outfile;

int NEW_NVARS = 0;
int NEW_NLITS = 0;
int NEW_NUMCLS = 0;
int NEW_NUMBCLS = 0;
int NEW_NUMNCLS = 0;
bool * var_assign;


// Horst: Print Quantifier Prefix, use array renumbered Literals
void printPrefix(FILE* fp, int * renum_litnum) {
  int i;
  // get max prefix level
  int nMaxPrefixLevel = getMaxPrefixLevel();
  bool bFirst, bAtLeastOne;

  bool *bArrAlreadyAddedToPrefix = new bool[NLITS];

  // Renumbering the Literals might cause mapping of several literals on one literal
  // therefore we store if a literal has been added to the prefix already
  for(int c=0; c<NLITS; c++)
   bArrAlreadyAddedToPrefix[c] = false;
  
  bool bFirstLine = true;
  //bool bMissed = false;
  int  nLastLit = 2;

  for(int h=0; h<nMaxPrefixLevel; h++)
  {
    i = 0;
    bFirst = true;
    bAtLeastOne = false;
    while(i<NLITS)
    {     
     if((renum_litnum[i] != -1) && (getLitPrefixLevel(i) == h) && (active(i)) && (!bArrAlreadyAddedToPrefix[renum_litnum[i]]))
     {
      bArrAlreadyAddedToPrefix[renum_litnum[i]] = true;
      if(bFirst)
      {
	//if(!bMissed)
	//{
	//if(!bFirstLine)
	// {           
	//fprintf(fp, "0\n"); 
	   // }
	//else
        //bFirstLine = false;
       //} 
       if(isLitExistential(i))
	 {
          if(nLastLit != 0)
	    {
             if(!bFirstLine)
              fprintf(fp, "0\n");  
             fprintf(fp, "e ");
	    }
          nLastLit = 0;
         }
       else
	 {
          if(nLastLit != 1)
	  {
           if(!bFirstLine)
            fprintf(fp, "0\n"); 
           fprintf(fp, "a ");
	  }
          nLastLit = 1;
	 }
       bFirst = false;
         
      }
      fprintf(fp, "%d ", variable_of(renum_litnum[i]) + 1);
      bAtLeastOne = true;
      bFirstLine = false;
     }
     //if(!bAtLeastOne)
     //  {
     //    bMissed = true;
         //fprintf(fp, "%d ",bMissed);
     //  }
     //else 
     //  bMissed = false;
     i++;
     i++;
    }
    
  }
  if(!bFirstLine)
   fprintf(fp, "0\n"); 
}



void cnfoutputOrigTheory() {
  
  int  * renum_lits;
  bool * lits_found;
  int i,n;

  lits_found = new bool[NLITS];

  for(i = 0; i < NLITS; i++)
    lits_found[i] = false;

  renum_lits = new int[NLITS];

  // Open File
  FILE * fp;
  outfile = new char[256];
  outfile[0] = '\0';
  //strcpy(outfile,"preprocessed.qdimacs");
  strncat(outfile, filename, (strrchr(filename, '.') - filename));
  strcat(outfile, "_outOrig.qdimacs");
  // End Open File

   printf("\nc Outputting reduced theory to file %s.\n", outfile);

  if((fp = fopen(outfile, "w")) == NULL)
   printf("ERROR: Failed to open %s.\n", outfile);
  
  // Produce the remaining original theory
  vector<int> vecLiterals;
  vector<int> vecTheory;

  long nNumberOfRemainingClauses = 0;
  // Go to the list of original clauses
  CLAUSELIST * clsptr;
  for(i = 2; i < CLSGROUPS; i++) {
    for(clsptr = lenNclauses[i]; clsptr; clsptr = clsptr->pnext) {
      if(clsptr->active) {
	 vecLiterals.clear();
         bool bClauseTrue = false;
         bool bTautology  = false;         
         for(n=0; n < clsptr->clslen; n++)
	   {
            int literal = clsptr->cls[n]; 
            bool bSkip  = false;
            // This is because of the strange handling of equivalent literals
            do {
             if(getVal(literal) == T)
               bClauseTrue = true;
             else if(getVal(literal) == F)
               bSkip = true;
             else 
              literal = getEquivLit(literal);
	    } while((!bClauseTrue) && (!bSkip) && (literal != getEquivLit(literal)));
            
            if((!bClauseTrue) && (!bSkip)) {
	     if(getVal(literal) == T) {
              bClauseTrue = true;
	      }
	     else if(getVal(literal) == F) {
	      bSkip = true;
	     }	    
            }
            if(bSkip)
	    {
	      // Skip
              //printf(" Skip: %d", to_ff(getEquivLitCorrectly(clsptr->cls[n])));
	    }
            else
             vecLiterals.push_back(literal);            
	    
	    //printf("%d [%d %d %c] ", to_ff(getEquivLitCorrectly(clsptr->cls[n])), to_ff(clsptr->cls[n]), isLitExistential(getEquivLitCorrectly(clsptr->cls[n])),
	    //	   (getVal(getEquivLitCorrectly(clsptr->cls[n]) == T) ? 'T' : 'F'));
            }
	 //printf("\nClause True ?: %d \n",bClauseTrue); 
        // If the clause is not true we output its literals
        if(!bClauseTrue)
	  {
            unsigned int k,l;
	    // Remove Duplicates
            sort( vecLiterals.begin(), vecLiterals.end() );
            vecLiterals.erase( unique( vecLiterals.begin(), vecLiterals.end() ), vecLiterals.end() ); 
            assert(vecLiterals.size()>0);
	    //printf("After duplicates\n");
            //for(k = 0; k < vecLiterals.size(); k++)
	    //  printf("  %d [%d %c] ", to_ff(vecLiterals[k]), isLitExistential(vecLiterals[k]),
  	    //	   (getVal(vecLiterals[k]) == T) ? 'T' : 'F');

  	    //printf("\n");
            // Check for tautologieses

            for(k = 0; k < vecLiterals.size(); k++)
	     {
              for(l = k + 1; l < vecLiterals.size(); l++)
		{
                 if(to_ff(vecLiterals[k]) == -(to_ff(vecLiterals[l])))
                   bTautology = true;
		}
             }
            // If not a tautology output the clause!
            if(!bTautology)
	    {
             for(k = 0; k < vecLiterals.size(); k++)
	     {
	       //printf(" Adding Literal %d", to_ff(vecLiterals[k]));  
	       lits_found[vecLiterals[k]] = true;
	       if(vecLiterals[k] % 2 == 0)
	      {
                 lits_found[vecLiterals[k] + 1] = true;
                 assert(abs(to_ff(vecLiterals[k] + 1)) == abs(to_ff(vecLiterals[k])));
	      }
              else
	      {   
                 lits_found[vecLiterals[k] - 1] = true; 
                 assert(abs(to_ff(vecLiterals[k] - 1)) == abs(to_ff(vecLiterals[k])));
	      }
              vecTheory.push_back(to_ff(vecLiterals[k]));
	     }
             // Add separating 0
             vecTheory.push_back(0);
             // Increase number of clauses
             nNumberOfRemainingClauses++; 
             //for(k = 0; k < vecLiterals.size(); k++)
	       //printf("  %d [%d %c] ", to_ff(vecLiterals[k]), isLitExistential(vecLiterals[k]),
	       //	   (getVal(vecLiterals[k]) == T) ? 'T' : 'F');
	       //printf("\n");	     
	    }
	    //else
	    //printf("Tautology\n");
          }
      }
    }
  }
 NEW_NLITS = 0; 
 // Count number of active literals
 for(i = 0; i < NLITS; i++)
   {
     if(lits_found[i])
     {
       renum_lits[i] = NEW_NLITS;
       NEW_NLITS++;
     }
     else
       renum_lits[i] = -1;
   }
 
 NEW_NUMCLS = nNumberOfRemainingClauses;


 // Now print out the new cnf file.
 fprintf(fp, "p cnf %d %d\n", NEW_NLITS/2, NEW_NUMCLS);

 // Horst: Print Quantifier Prefix
 printPrefix(fp, renum_lits);

 // Output theory
 unsigned m;
 for(m = 0; m < vecTheory.size(); m++)
 {
  if(vecTheory[m] != 0)
    {
     fprintf(fp, "%d ", to_ff(renum_lits[to_internal(vecTheory[m])]));
     //printf(" Literal: %d Val: %c ",to_ff(renum_lits[to_internal(vecTheory[m])]), (getVal(to_internal(vecTheory[m])) == T) ? 'T' : 'F'); 
    }
  if(vecTheory[m] == 0)  
  {
   fprintf(fp, "0\n");
   //printf("\n");
  }
 }
 // End
 fclose(fp);
}



void cnfoutput() {
  int i, j;

  int * renum_lits;
  bool * vars_found;
  FILE * fp;

  if(outfile == NULL) {
    outfile = new char[256];
    outfile[0] = '\0';
// Jessica
#if 0
#ifdef _UR_IN_HYPRES
    strcat(outfile, "Bench01_Pre_b/");
#else
    strcat(outfile, "Bench01_Pre_a/");
#endif
#endif
    strncat(outfile, filename, (strrchr(filename, '.') - filename));
    strcat(outfile, "_out.qdimacs");
  }

  //printf("\nc Outputting reduced theory to file %s.\n", outfile);

  if((fp = fopen(outfile, "w")) == NULL)
    printf("ERROR: Failed to open %s.\n", outfile);


  // Determine how many clauses are in the reduced theory.  Go through and
  // count the number of binary and nary clauses.  Also, mark all literals
  // found in theory in order to check for active literals that have been
  // removed from the theory without being assigned a value or an
  // equivalent literal.  This could happen if all instances of the literal
  // were in clauses that we found to be true by other means.

  // Set elements of array of literals found to false initially.
  vars_found = new bool[NLITS/2];

  for(i = 0; i < NLITS/2; i++)
    vars_found[i] = false;

  // Go through the binary clauses, counting the number of remaining clauses and marking
  // all variables still in the theory.
  for(i = 0; i < NLITS; i++) {
    if(active(i)) {
      for(j = 0; j < getNumBcls(i); j++) {
	if(i < getLitBclsElem(i, j)) {
	  NEW_NUMBCLS++;
	  vars_found[variable_of(i)] = true;
	  vars_found[variable_of(getLitBclsElem(i, j))] = true;
	}
      }
    }
  }

  // Go through the nary clauses, counting the number of active clauses and marking all
  // variables still in the theory.
  for(i = 0; i < NUMNCLS; i++) {
    if(getActive(i)) {
      NEW_NUMNCLS++;
      for(j = 0; j < getCurLen(i); j++)
	vars_found[variable_of(getLitsElem(i, j))] = true;
    }
  }

  NEW_NUMCLS = NEW_NUMBCLS + NEW_NUMNCLS;

  // Go through the var_found mark array and count the number of variables still in
  // the theory.
  for(i = 0; i < NLITS/2; i++)
    if(vars_found[i])
      NEW_NVARS++;

#ifdef _STATS
  // Run checks on the calculated values here.
  if(NEW_NUMBCLS != (NUMBCLS + numAddBcls - numSatBcls))
    printf("ERROR: Problem in counting binary clauses.\n");
  if(NEW_NUMNCLS != (NUMNCLS - (numReducedNary + numSatNaryCls)))
    printf("ERROR: Problem in counting nary clauses.\n");
  if(NEW_NVARS > ((NLITS - numEquivLits - numValuedLits) / 2)) {
    printf("ERROR: Problem in counting number of variables.\n");
    printf("NEW_NVARS=%d; other=%d\n", NEW_NVARS, (NLITS - numEquivLits
						   - numValuedLits) / 2);
  }
#endif // _STATS

  // Check if the theory has been satisfied.  If so, print the vline solution to the
  // cnf file.  Otherwise, print the reduced theory to the cnf file.
  if(NEW_NUMCLS == 0) {
    SATISFIED = true;

    // Add code to do printing here.

    // Initialize VAR_ASSIGN array to hold the truth assignment for each variable in
    // the formula.
    var_assign = new bool[NLITS/2];

    fprintf(fp, "c This cnf file was generated by the preprocessor.  It contains a\n");
    fprintf(fp, "c satisfying truth assignment for the variables of the cnf.\n");
    fprintf(fp, "c formula in the file %s.\n", filename);
    fprintf(fp, "s SATISFIABLE\n");

    // Output the satifying truth assignment to the screen outfile.  For variables
    // which did not need to be assigned a value, set them to true arbitrarily.
    fprintf(fp, "v ");

    // Go through the variables and set all active ones to true.  This can be
    // done arbitrarily since they have no impact on the satisfiability of the
    // formula.  The active variables must be set first so that variables
    // equivalent to them can be set to the same values as their equivalent
    // literals.
    for(i = 1; i < NLITS; i+=2) {
      if(active(i)) {
	var_assign[variable_of(i)] = true;
	setVal(i, T);
	setVal(negate(i), F);
      }
    }

    for(i = 1; i < NLITS; i+=2) {
      if(active(i))
	fprintf(fp, "%d ", orig_varnum[variable_of(i)] + 1);

      else {
	int eqvLit = i;
	bool foundValue = false;
	do {
	  if(getVal(eqvLit) == T) {
	    var_assign[variable_of(i)] = true;
	    fprintf(fp, "%d ", orig_varnum[variable_of(i)] + 1);
	    foundValue = true;
	  }
	  else if(getVal(eqvLit) == F) {
	    var_assign[variable_of(i)] = false;
	    fprintf(fp, "-%d ", orig_varnum[variable_of(i)] + 1);
	    foundValue = true;
	  }
	  else
	    eqvLit = getEquivLit(eqvLit);
	} while(!foundValue && (eqvLit != getEquivLit(eqvLit)));

#ifdef _CHECK
	if(!foundValue && (eqvLit == i))
	  printf("ERROR: eqvLit should not equal i, otherwise i is active!\n");
#endif // _CHECK

	if(!foundValue) {
	  if(getVal(eqvLit) == T) {
	    var_assign[variable_of(i)] = true;
	    fprintf(fp, "%d ", orig_varnum[variable_of(i)] + 1);

	  }
	  else if(getVal(eqvLit) == F) {
	    var_assign[variable_of(i)] = false;
	    fprintf(fp, "-%d ", orig_varnum[variable_of(i)] + 1);
	  }

#ifdef _CHECK
	  else
	    printf("ERROR: eqvLit of %d should be assigned a value!\n", IntLitToExt(i));
#endif // _CHECK
	}
      }
    }
    fprintf(fp, "0\n");
  }
  else {

    // Set up an array for the new numbering of the literals which
    // remove the gaps caused by literals that have been valued,
    // assigned an equivalent literal, or are otherwise no longer
    // in the theory.
    renum_lits = new int[NLITS];
    for(i = 0; i < NLITS; i++) {
      if(active(i) && vars_found[variable_of(i)])
	renum_lits[i] = NEW_NLITS++;
      else
	renum_lits[i] = -1;
    }

#ifdef _CHECK
    if(NEW_NLITS != (NEW_NVARS * 2)) {
      printf("ERROR in variable counting method!\n");
      printf("NEW_NLITS=%d; NEW_VARS=%d\n", NEW_NLITS, NEW_NVARS);
    }
#endif // _CHECK

    // Print out a mapping of the original literals to the literals in the reduced
    // theory.  If a literal or its equivalent literal has be assigned a value,
    // print the value instead.  If a literal has an equivalent literal that is
    // still in the theory after reduction, print the original theory literal that
    // corresponds to the equivalent literal.

    fprintf(fp, "c This cnf file was generated by the preprocessor.  It contains the\n");
    fprintf(fp, "c reduced theory resulting from the simplifications performed by\n");
    fprintf(fp, "c preprocessor.\nc \n");
    fprintf(fp, "c The number of variables in the original and reduced theory is:\n");
    fprintf(fp, "c    ORIGINAL\t\tREDUCED\n");

    fprintf(fp, "c *  %d\t\t%d\n", NLITS/2, NEW_NLITS/2);
    fprintf(fp, "c Here is a mapping between the literals of the original cnf file,\n");
    fprintf(fp, "c %s, and the literals of the new output cnf file,\n", filename);
    fprintf(fp, "c %s.\n", outfile);
    fprintf(fp, "c Orig. Lit\tNew Lit\n");
    fprintf(fp, "c *\n");

    for(i = 0; i < NLITS; i++) {
      fprintf(fp, "c %d\t\t", to_ff(orig_varnum[variable_of(i)], truth_of(i)));
      if(active(i) && vars_found[variable_of(i)])
	fprintf(fp, "%d", IntLitToExt(renum_lits[i]));
      else if(active(i) && !vars_found[variable_of(i)])
	fprintf(fp, "not in reduced theory");
      else {
	int eqvLit = i;
	bool foundValue = false;
	do {
	  if(getVal(eqvLit) == T) {
	    fprintf(fp, "T");
	    foundValue = true;
	  }
	  else if(getVal(eqvLit) == F) {
	    fprintf(fp, "F");
	    foundValue = true;
	  }
	  else
	    eqvLit = getEquivLit(eqvLit);
	} while(!foundValue && (eqvLit != getEquivLit(eqvLit)));

#ifdef _CHECK
	if(!foundValue && (eqvLit == i))
	  printf("ERROR: eqvLit should not equal i, otherwise i is active!\n");
#endif // _CHECK

	if(!foundValue) {
	  if(getVal(eqvLit) == T)
	    fprintf(fp, "T");
	  else if(getVal(eqvLit) == F)
	    fprintf(fp, "F");
	  else
	    fprintf(fp, "equivalent to %d",
		    to_ff(orig_varnum[variable_of(eqvLit)], truth_of(eqvLit)));
	}
      }
      fprintf(fp, "\n");
    }
    fprintf(fp, "c *\n");
    fprintf(fp, "c\n");

    fprintf(fp, "c Here is the reverse mapping.\n");
    fprintf(fp, "c New Lit\tOrig. Lit\n");

    for(i = 0; i < NLITS; i++) {
      if(renum_lits[i] != -1) {
	fprintf(fp, "c %d\t\t%d\n", IntLitToExt(renum_lits[i]),
		to_ff(orig_varnum[variable_of(i)], truth_of(i)));
      }
    }

    fprintf(fp, "c\n");
    fprintf(fp, "c The rest of the file contains the actual output cnf file.\n");
    fprintf(fp, "c\n");

    // Now print out the new cnf file.
    fprintf(fp, "p cnf %d %d\n", NEW_NLITS/2, NEW_NUMCLS);

    // Horst: Print Quantifier Prefix
    printPrefix(fp, renum_lits);
    // End

    for(i = 0; i < NLITS; i++) {
      if(active(i)) {
	for(j = 0; j < getNumBcls(i); j++) {
	  if(i < getLitBclsElem(i, j)) {

#ifdef _CHECK
	    if((renum_lits[negate(i)] == -1) || (renum_lits[getLitBclsElem(i, j)] == -1))
	      printf("ERROR: Found inactive literal in reduced theory!\n");
#endif // _CHECK

	    fprintf(fp, "%d %d 0\n", IntLitToExt(renum_lits[negate(i)]),
		    IntLitToExt(renum_lits[getLitBclsElem(i, j)]));
	  }
	}
      }
    }

    for(i = 0; i < NUMNCLS; i++) {
      if(getActive(i)) {
	for(j = 0; j < getCurLen(i); j++) {

#ifdef _CHECK
	  if(renum_lits[getLitsElem(i, j)]  == -1)
	    printf("ERROR: Found inactive literal in reduced theory!\n");
#endif // _CHECK

	  fprintf(fp, "%d ", IntLitToExt(renum_lits[getLitsElem(i, j)]));
	}
	fprintf(fp, "0\n");
      }
    }
  }
  fclose(fp);
}

