/*

2clsQ. Copyright Horst Samulowitz and Fahiem Bacchus 2006

 A DPLL QBF solver based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to
implied warranties of merchantability and fitness for a particular
purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Fahiem Bacchus },
	year    = { 2006 },
	title   = { {2clsQ} a {DPLL} solver employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/

#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <search.h>
#include "2clsEq.h"
#include "binaryClauses.h"
#include "resolve.h"
#include "undo.h"

//fatal error; print a message taking printf style arguments; then exits(1)
#ifdef WIN32
void __cdecl panic(char *fs, ...) {
#else
void panic(char *fs, ...) {
#endif
  va_list args;
  va_start(args, fs);
  printf("FATAL ERROR: ");
  vprintf(fs, args);
  fflush(stdout);
  printf("\n");
  exit(1);
}

void printLit(Lit *l, FILE* fp) {
  fprintf(fp, "Lit %d[%c]\n", to_ff(l->num),ff_tval(l->val));
  fprintf(fp, "    Equivalent Lit = %d:[%c]\n", to_ff(l->equivlit),
		  ff_tval(l->equivlit->val));
  fprintf(fp, "    Nary Clauses (%d), 3 Clauses (%d):\n    ",l->numNcls,
		  l->num3cls);
  printNClauses(l->nClauses.pnext,fp);
  fprintf(fp, "\n    Binary Clauses (%d):\n    ", l->numBcls);
  printBClauses(&l->twoClauses,fp);
  fprintf(fp, "\n");
  //  if(isActive(l))
  //for(BinLitCls *pb=&(l->twoClauses);pb->pnext;pb=pb->pnext)
  //  if(isValued(pb->otherlit))
  //	panic("Unvalued lit has valued lit on its b-clause list!\n");
}

void printParents(Lit *l, FILE* fp) {
  fprintf(fp, "Parents of Lit %d\n", to_ff(l->num));
  for(BinLitCls *pb=&(l->twoClauses);pb->pnext;pb=pb->pnext)
	if(parent(pb->otherlit))
	  printLit(pb->otherlit,fp);
}



void printNClauses(LitCls *litclslist, FILE* fp) {
  int i=1;
  for( ;litclslist->pnext; litclslist=litclslist->pnext) {
	fprintf(fp, "%d.", i);
	printLitCls(litclslist,fp);
	fprintf(fp, "\n    ");
	i++;
  }
}

#ifdef WIN32
int __cdecl cmp(const void *x, const void *y) {
#else
int  cmp(const void *x, const void *y) {
#endif
  if(*(int *)x > *(int *)y)
	return -1;
  else if(*(int *) x < *(int *)y)
	return 1;
  else
	return 0;
}

int bclauses[50000];

void printBClauses(BinLitCls *litBclslist, FILE* fp) {
  int num=0;
  int i;
  for( ;litBclslist->pnext; litBclslist=litBclslist->pnext)
	bclauses[num++]=to_ff(litBclslist->otherlit->num);
  fprintf(fp, "Number of Bclauses=%d\n", num);
  qsort((void *) bclauses, (size_t) num, sizeof(int), cmp);
  for(i=0; i<num; i++)
  	fprintf(fp, "%d[%c],", bclauses[i],
		ff_tval(intTolit(to_internal(bclauses[i]))->val));
}

void printLitCls(LitCls *lc, FILE* fp) {
  fprintf(fp, "#%d [", lc->pcls->num);
  assert(lc->pcls->dagnode != NULL);
  for(ClsLit *cl=lc->pcls->start.pnext; cl->pnext; cl=cl->pnext)
	fprintf(fp, "%d[%c], ", to_ff(cl->plit->num),ff_tval(cl->plit->val));
  fprintf(fp, "]");
}

void printBinLitCls(BinLitCls *lc, FILE* fp) {
  fprintf(fp, "%d[%c,", to_ff(lc->otherlit->num),ff_tval(lc->otherlit->val));
  if(parent(lc->otherlit))
	fprintf(fp, "P");
  fprintf(fp,"],");
//    fprintf(fp, "%d[%c])", to_ff(lc->otherlinks->otherlit->num),
//  		  ff_tval(lc->otherlinks->otherlit->val));
//    if(!haveBclause(lc->otherlinks->otherlit->num, lc->otherlit->num))
//  	fprintf(fp, "[ERROR]" );
}

void printClause(Clause *c, FILE* fp) {
  fprintf(fp, "Clause %d/%d:\n", c->num,c->active);
  fprintf(fp, "[");
  for(ClsLit *cl=c->start.pnext; cl->pnext; cl=cl->pnext)
	fprintf(fp, "%d[%c], ", to_ff(cl->plit->num),ff_tval(cl->plit->val));
  fprintf(fp, "]\n\n");
}



void printTheory(char* file) {
  FILE* fp;
  int i;
  if(!file)
    fp=stdout;
  else if(!(fp=fopen(file, "w"))) exit(1);

  for(i=0; i<NLITS; i++)
	printLit(THELITS+i,fp);
  for(i=0; i<NCLAUSES; i++)
	printClause(THECLAUSES+i,fp);
}

void printLits(char* file) {
  FILE* fp;
  int i;
  if(!file)
    fp=stdout;
  else if(!(fp=fopen(file, "w"))) exit(1);
  for(i=0; i<NLITS; i++) {
	if(isActive(i)) {
	  printLit(THELITS+i,fp);
	  fprintf(fp,"\n");
	}
  }
}

void printCLAUSELIST(CLAUSELIST *cl, FILE* fp) {
  fprintf(fp, "Len=%d, [",cl->clslen);
  for(int i=0;i<cl->clslen;i++)
  {
    Lit * L = intTolit(cl->cls[i]);
	fprintf(fp, "%d [%d, EQ: %d, E?: %d PL: %d],", cl->cls[i], L->val, eqlit(cl->cls[i]) , isLitExistential(cl->cls[i]), getLitPrefixLevel(cl->cls[i]));
  }
  fprintf(fp, "]\n");
}

void printCLAUSEARRAY(int *cl, int len, FILE* fp) {
  fprintf(fp, "Len=%d, [",len);
  for(int i=0;i<len;i++)
	fprintf(fp, "%d,", to_ff(cl[i]));
  fprintf(fp, "]\n");
}

void checkClauses() {
  int i,j;

  bool *lits = new bool[NLITS];
  if(!lits)
	panic("Memory Allocation Failure #30\n");
  BinLitCls *bcl;
  LitCls *ncl;
  ClsLit *nlc;
  Lit *l;
  Clause *c;
  for(i=0;i<NLITS;i++) {
	if(isInactive(i))
	  continue;
	for(j=0;j<NLITS;j++)
	  lits[j]=false;
	l=THELITS+i;

	for(bcl=&(l->twoClauses);bcl->pnext;bcl=bcl->pnext) {
	  lits[bcl->otherlit->num]=true;
	  if(bcl->otherlinks->otherlit!=l)
		printf("Error, binary clause (%d,%d) is linked incorrectly: %d!",
			   to_ff(l->num), to_ff(bcl->otherlit->num),
			   to_ff(bcl->otherlinks->otherlit->num));
	}

	for(j=0;j<NLITS;j++) {
	  if(isInactive(j))
		continue;
	  //	  if(HvalhaveBclause(l->num,j,RESOLVED)&&!lits[j]
	  if(haveBclause(l->num,j)&&!lits[j]
		 && !(isTrue(l->num) || isTrue(j))) {
		printf("Error, binary clause (%d,%d) in hash table",
			   to_ff(l->num), to_ff(j));
		printf(" but not on lits clause list!\n");
		printLit(l);
		printLit(intTolit(j));
	  }
		  //	  if(!HvalhaveBclause(l->num,j,RESOLVED)&&lits[j]) {
	  if(!haveBclause(l->num,j)&&lits[j]) {
		printf("Error, binary clause (%d,%d) on lits clause list",
			   to_ff(l->num), to_ff(j));
		printf(" but not in hash table!\n");
	  }
	}

	for(ncl=l->nClauses.pnext;ncl->pnext;ncl=ncl->pnext)
	  if(ncl->linkincls->plit!=l)
		printf("Error, nary clause %d of lit %d is linked incorrectly: %d!",
			   ncl->pcls->num, to_ff(l->num), to_ff(ncl->linkincls->plit->num));
  }

  for(i=0;i<NCLAUSES;i++) {
	c=THECLAUSES+i;
	j=0;
	for(nlc=c->start.pnext;nlc->pnext;nlc=nlc->pnext) {
	  j++;
	  if(nlc->linkinlit->pcls!=c)
		printf("Error, nary clause %d has lit %d linked incorrectly: %d!",
			   c->num,to_ff(nlc->plit->num),to_ff(nlc->linkinlit->pcls->num));
	}
	if(j!=c->len)
	  printf("Error, Clause length %d is wrong %d!",
			 c->len, j);
  }
  delete lits;
}

void checkHashTable() {
  int i,j, count, entrycount, multiples, maxmultiples;
  bucket *pb;
  count=0;
  multiples=0;
  maxmultiples=0;
  for(i=0;i<NLITS;i++)
	for(j=0;j<TSIZE;j++) {
	  entrycount=0;
	  for(pb=intTolit(i)->litHtable+j;pb; pb=pb->pnext) {
		if(pb->lit==NOLIT&&pb->pnext)
		  printf("Hash table has empty entry in chain!\n");
		if(pb->lit!=NOLIT)
		  entrycount++;
	  }
	  if(entrycount>1)
		multiples++;
	  if(entrycount>maxmultiples)
		maxmultiples=entrycount;
	  count+=entrycount;
	}
  printf("Hash table has %d entries with %d multiple entry chains and max chain size %d\n\n",
		 count, multiples, maxmultiples);
}

bool member(int l, int* array, int len) {
  //return true if l is in array of size len.
  for(int i=0;i<len;i++)
	if(l==array[i])
	  return true;
  return false;
}

void CheckSolution() {
  //verify that every clause in original problem is satisfied.
  CLAUSELIST *cl;
  int i, j;
  for(i=1;i<CLSGROUPS;i++)
	for(cl=lenNclauses[i];cl;cl=cl->pnext) {
	  //printf("Checking clause:\n");
	  //printCLAUSELIST(cl);
	  bool val=false;
	  for(j=0;j<cl->clslen;j++)
		if(isTrue(eqlit(cl->cls[j])))
		  val=true;
	  if(!val) {
		printCLAUSELIST(cl);
		printf("c FATAL: Clause is NOT SATISFIED in claimed solution.");
	  }
	}
}

int *clslen=NULL;

void printCLAUSELISTANDLEVELS(CLAUSELIST *cl, FILE* fp) {
  fprintf(fp, "Len=%d, [",cl->clslen);
  int i;
  for(i=0;i<cl->clslen;i++)
	fprintf(fp, "%d/%d,", to_ff(cl->cls[i]), to_ff(eqlit(cl->cls[i])));
  fprintf(fp, "]/[");
  for(i=0;i<cl->clslen;i++)
	fprintf(fp, "%d,", assignLevel(eqlit(cl->cls[i])));
  fprintf(fp, "]\n");
}

void printOriginalClause(Clause *pcls, FILE* fp) {
  printCLAUSELISTANDLEVELS(pcls->originalClause,fp);
}


void printfalseClauses() {
  CLAUSELIST *cl;
  int i, j;
//    printf("Falsified Lits:\n");
//    for(i = 0; i < NLITS; i++)
//  	if(isFalse(eqlit(i)))
//  	  printf("%i ",to_ff(i));
//    printf("\n");
  bool units, zeros;
  int lit=0;
  int times=0;
  markundoCheckPoint();
  do {
	units=zeros=false;
	times++;
	printf("Checking %d time\n", times);
	for(i=1;i<CLSGROUPS;i++)
	  for(cl=lenNclauses[i];cl;cl=cl->pnext) {
		//printf("Checking clause:\n");
		//printCLAUSELIST(cl);
		bool val=false;
		int len=0;
		for(j=0;j<cl->clslen;j++) {
		  if(isTrue(eqlit(cl->cls[j])))
			val=true;
		  else if(isUnvalued(eqlit(cl->cls[j]))) {
			lit=cl->cls[j];
			len++;
		  }
		}
		if(!val && len==0) {
		  printf("Clause Falsified: ");
		  printCLAUSELISTANDLEVELS(cl);
		  zeros=true;
		}
		else if(!val && len==1) {
		  printf("Clause is Unit %d/%d: ",to_ff(lit), to_ff(eqlit(lit)));
		  printCLAUSELISTANDLEVELS(cl);
		  units=true;
		  markundoLitAssign(intTolit(eqlit(lit)));
		  setLitTrue(eqlit(lit));
		}
	  }
  } while (units && !zeros);
  undoRestore();
}

void checkClauseLens(char *s,int count) {
  for(int i=0;i<NCLAUSES;i++) {
	if((THECLAUSES+i)->len<2) {
	  printf("CheckClause Lens, In %s/%d: Clause %d has length less than 2 (%d).\n",
			 s,count,i,(THECLAUSES+i)->len);
	  printClause(THECLAUSES+i);
	  printf("\n\n");
	  printTheory();
	}
  }
}


void checkLitClauseNums() {
  int i;
  for(i=0; i<NLITS;i++) {
	Lit *L=intTolit(i);
	if(isActive(L)) {
	  int nb, n3, nn;
	  nb=n3=nn=0;
	  for(BinLitCls *pb=&(L->twoClauses);pb->pnext;pb=pb->pnext)
		nb++;
	  if(nb!=L->numBcls) {
		printf("Lit %d. Incorrect number of Bclauses, numBcls=%d, actual=%d.\n",
			   to_ff(L->num), L->numBcls,nb);
		printLit(L);
	  }
	  for(LitCls *plc=L->nClauses.pnext; plc->pnext; plc=plc->pnext) {
		if(plc->pcls->len==3)
		  n3++;
		nn++;
	  }
	  if(n3!=L->num3cls) {
		printf("Lit %d. Incorrect number of 3clauses, num3cls=%d, actual=%d.\n",
			   to_ff(L->num), L->num3cls, n3);
		printLit(L);
	  }
	  if(nn!=L->numNcls) {
		printf("Lit %d. Incorrect number of nclauses, numncls=%d, actual=%d.\n",
			   to_ff(L->num), L->numNcls, n3);
		printLit(L);
	  }
	}
  }
  for(i=0;i<NCLAUSES;i++) {
	Clause *c=THECLAUSES+i;
	int j=0;
	for(ClsLit *nlc=c->start.pnext;nlc->pnext;nlc=nlc->pnext) {
	  j++;
	  if(nlc->linkinlit->pcls!=c)
		printf("Error, nary clause %d has lit %d linked incorrectly: %d!",
			   c->num,to_ff(nlc->plit->num),to_ff(nlc->linkinlit->pcls->num));
	}
	if(j!=c->len)
	  printf("Error, Clause length %d is wrong %d!",
			 c->len, j);
  }
}

