/*

2clsQ. Copyright Horst Samulowitz and Fahiem Bacchus 2006

 A DPLL QBF solver based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to
implied warranties of merchantability and fitness for a particular
purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Fahiem Bacchus },
	year    = { 2006 },
	title   = { {2clsQ} a {DPLL} solver employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/

#ifndef __undo_H
#define __undo_H
#include "dag.h"

/*******************************************************************
 Undo code.
 ******************************************************************/

//Inline allocator for undo items.

enum undocode {CHECKPOINT, LITASSIGN, NEWBCLS, CLAUSETRUE, BCLSTRUE,
	       CLSLIT, LITCLSMOVE, LITEQ, LITDAG, CLAUSEDAG, LITCLS, EQLITWATCH};
void Makeundorecstore();
void undoRestore();

typedef struct undorec {
  undorec *pnext;
  undocode t;
  int info1;
} undorec;

extern undorec *pundoalloc;
extern undorec *undos;

extern bool initializing;

inline undorec* allocundo() {
  //allocate a new undo record
  if(!pundoalloc)
    Makeundorecstore();
  undorec *pundo = pundoalloc;
  pundoalloc=pundo->pnext;
  return(pundo);
}

inline void pushundo(undorec *pundo) {
  pundo->pnext=undos;
  undos=pundo;
}

inline undorec* popundo() {
  undorec *pundo=undos;
  undos=undos->pnext;
  return(pundo);
}

inline void deallocundo(undorec *pundo) {
  //deallocate it.
  pundo->pnext = pundoalloc;
  pundoalloc = pundo;
}

inline void markundoCheckPoint() {
  undorec *pundo = allocundo();
  pundo->t = CHECKPOINT;
  pundo->info1 = (int) CONTRADICTION.val;
  pushundo(pundo);
  //
  pundo = allocundo();
  pundo->t = CHECKPOINT;
  pundo->info1 = (int) CONTRADICTION.dagnode.one;
  pushundo(pundo);
  //
  pundo = allocundo();
  pundo->t = CHECKPOINT;
  pundo->info1 = (int) CONTRADICTION.dagnode.two;
  pushundo(pundo);
  //
  pundo = allocundo();
  pundo->t = CHECKPOINT;
  pundo->info1 = (int) topDAGStack;
  pushundo(pundo);
}

inline void markundoLitAssign(Lit *l) {
  undorec *pundo = allocundo();
  pundo->t = LITASSIGN;
  pundo->info1 = (int) l;
  pushundo(pundo);
}

inline void markundoNewBCls(PairofBinLitCls *pb) {
  undorec *pundo = allocundo();
  pundo->t = NEWBCLS;
  pundo->info1 = (int) pb;
  pushundo(pundo);
}

inline void markundoClauseTrue(Clause *pc) {
  undorec *pundo = allocundo();
  pundo->t = CLAUSETRUE;
  pundo->info1 = (int) pc;
  pushundo(pundo);
}

inline void markundoBclause(BinLitCls *pb) {
  undorec *pundo = allocundo();
  pundo->t = BCLSTRUE;
  pundo->info1 = (int) pb;
  pushundo(pundo);
}

inline void markundoClsLit(ClsLit  *pcl) {
  undorec *pundo = allocundo();
  pundo->t = CLSLIT;
  pundo->info1 = (int) pcl;
  pushundo(pundo);
}

inline void markundoClsDAG(Clause *pc) {
  undorec *pundo = allocundo();
  pundo->t = CLAUSEDAG;
  pundo->info1 = (int) pc->dagnode;
  pushundo(pundo);
  //
  pundo = allocundo();
  pundo->t = CLAUSEDAG;
  pundo->info1 = (int) pc;
  pushundo(pundo);
}

inline void markundoLitClsmove(LitCls  *plc, Lit* l) {
  //need two spaces to store undo info. So push them one after the other.
  undorec *pundo = allocundo();
  pundo->t = LITCLSMOVE;
  pundo->info1 = (int) plc;
  pushundo(pundo);
  //
  pundo = allocundo();
  pundo->t = LITCLSMOVE;
  pundo->info1 = (int) l;
  pushundo(pundo);
}

inline void markundoEq(Lit* x) {
  //need two spaces to store undo info. So push them one after the other.
  undorec *pundo = allocundo();
  pundo->t = LITEQ;
  pundo->info1 = (int) x->equivlit;
  pushundo(pundo);
  //
  pundo = allocundo();
  pundo->t = LITEQ;
  pundo->info1 = (int) x;
  pushundo(pundo);
}

inline void markundoLitdagnode(Lit* l) {
  undorec *pundo= allocundo();
  pundo->t = LITDAG;
  pundo->info1 = (int) l;
  pushundo(pundo);
}

inline void markundoLitdagnode(int l) {
  markundoLitdagnode(intTolit(l));
}

// Horst
inline void markundoLitCls(LitCls *plc) {
  //printf("\n Mark Undo Lit Cls.");
  undorec *pundo = allocundo();
  pundo->t = LITCLS;
  pundo->info1 = (int) plc;
  pushundo(pundo);
}


inline void markundoEquivalences(stEqInformation * stEqInfo) {
  undorec *pundo = allocundo();
  pundo->t = EQLITWATCH;
  pundo->info1 = (int) stEqInfo;
  pushundo(pundo);
}


#endif /* __undo_H */





