/*

2clsQ. Copyright Horst Samulowitz and Fahiem Bacchus 2006

 A DPLL QBF solver based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to
implied warranties of merchantability and fitness for a particular
purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Fahiem Bacchus },
	year    = { 2006 },
	title   = { {2clsQ} a {DPLL} solver employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/

#include "2clsEq.h"
#include "undo.h"
#include "naryClauses.h"
#include "binaryClauses.h"

/*******************************************************************
 Undo code.
 ******************************************************************/

//1. Undo records

const int UNDOALLOCFACTOR=10;

undorec *pundoalloc=NULL;
undorec *undos=NULL;

void Makeundorecstore() {
  undorec *pundo = new undorec[NLITS*UNDOALLOCFACTOR];
  if(!pundo)
	panic("Memory Allocation Failure #27\n");
  pundoalloc = pundo;
  //now link the new array.
  for(int i=0;i<NLITS*UNDOALLOCFACTOR;i++) {
    pundo->pnext=pundo+1;
    pundo++;
  }
  //fix the last pointer
  (--pundo)->pnext=NULL;
}

void undoLitAssign(Lit *l) {
    setLitUnassigned(l);
}

void undoLitdagnode(Lit *l) {
  l->dagnode=NULL;
}

void undoNewBcls(PairofBinLitCls *pb) {
#ifdef _TRACE
  printf("=>undoNewBcls(%d,%d)\n", to_ff(pb->Lit1.otherlit->num),
		 to_ff(pb->Lit2.otherlit->num));
#endif
  unmarkBclause(pb->Lit1.otherlit->num, pb->Lit2.otherlit->num);
  delinkBclause(&(pb->Lit1));
  delinkBclause(&(pb->Lit2));
  deallocPairofBinLitCls(pb);
}

void inline undoClauseTrue(Clause *pc) {
#ifdef _TRACE
  printf("=>undoClauseTrue(%d)\n", to_ff(pc->num));
#endif _TRACE
  relinkNClause(pc);
}

void inline undoCLSdagnode(Clause *pc, DAG *dagnode) {
  pc->dagnode=dagnode;
}

void inline undoBclause(BinLitCls *pb) {
#ifdef _TRACE
  printf("=>undoBclause(%d,%d)\n", to_ff(pb->otherlit->num),
		 to_ff(pb->otherlinks->otherlit->num));
#endif _TRACE
  relinkBclause(pb);
}

void inline undoClsLit(ClsLit *pcl) {
#ifdef _TRACE
  printf("=>undoClsLit(%d in clause %d)\n",
		 to_ff(pcl->plit->num), pcl->linkinlit->pcls->num);
#endif _TRACE
  relinkClsLit(pcl);
}

void inline undoLitClsMove(LitCls *plc, Lit * l) {
#ifdef _TRACE
  printf("=>undoLitClsMove(from lit %d in clause %d to lit %d)\n",
		 to_ff(plc->linkincls->plit->num),
		 plc->pcls->num, to_ff(l->num));
#endif _TRACE
  //unlink from current lit;
  delinkLitCls(plc);
  //change to l
  plc->linkincls->plit=l;
  //relink to l
  relinkLitCls(plc, l);
}

void inline undoLitCls(LitCls *plc) {
  relinkLitCls(plc, plc->linkincls->plit);
}

void inline undoEquivalences(stEqInformation * stEqInfo) {
	Lit* lLit = stEqInfo->lLit;
	//if(lLit->num == 102)
    //  printf("\n here ");
	//if(lLit->vecEquivalences.size() < stEqInfo->nEquivalences) {
    // printf("\n Here %d %d %d ", lLit->num, lLit->vecEquivalences.size(), stEqInfo->nEquivalences);		
	//}
	assert(lLit->vecEquivalences.size() >= stEqInfo->nEquivalences); 
	//printf("\n Here %d %d %d ", lLit->num, lLit->vecEquivalences.size(), stEqInfo->nEquivalences);
	for(int c=0; c < stEqInfo->nEquivalences; c++){
	 lLit->vecEquivalences.pop_back();
	 //printf("\n C: %d ", c);
	}
	//printf(" \n -> Size %d %d ", lLit->vecEquivalences.size(), stEqInfo->nEquivalences);
	delete stEqInfo;
}


void undoRestore() {
  //restore to previous checkpoint;
  undorec *pundo, *second;
  for(pundo=popundo();pundo->t!=CHECKPOINT;pundo=popundo())
	switch(pundo->t) {
	case LITASSIGN:
 	  undoLitAssign((Lit *) pundo->info1);
	  deallocundo(pundo);
	  break;
	case NEWBCLS:
	  undoNewBcls((PairofBinLitCls *) pundo->info1);
	  deallocundo(pundo);
	  break;
	case CLAUSETRUE:
	  undoClauseTrue((Clause *) pundo->info1);
	  deallocundo(pundo);
	  break;
	case BCLSTRUE:
	  undoBclause((BinLitCls *) pundo->info1);
	  deallocundo(pundo);
	  break;
	case CLSLIT:
	  undoClsLit((ClsLit *) pundo->info1);
	  deallocundo(pundo);
	  break;
	case LITCLSMOVE:
	  //these undo records have to items on stack.
	  second = popundo();
#ifdef _PARANOID
	  if(second->t!=LITCLSMOVE)
		printf("LITCLSMOVE didn't come in a pair on undo stack!\n");
#endif _PARANOID
	  undoLitClsMove((LitCls *) second->info1, (Lit *) pundo->info1);
	  deallocundo(pundo);
	  deallocundo(second);
	  break;
	case LITEQ:
	  //these undo records have to items on stack.
	  second = popundo();
#ifdef _PARANOID
	  if(second->t!=LITEQ)
		printf("LITEQ didn't come in a pair on undo stack!\n");
#endif _PARANOID
	  ((Lit *) pundo->info1)->equivlit = (Lit *) second->info1;
	  ((Lit *) pundo->info1)->dagEqnode = &dagTrue;
	  deallocundo(pundo);
	  deallocundo(second);
	  break;
	case LITDAG:
	  undoLitdagnode((Lit *) pundo->info1);
	  deallocundo(pundo);
	  break;
	case CLAUSEDAG:
	  second = popundo();
	  undoCLSdagnode((Clause *) pundo->info1, (DAG *) second->info1);
	  deallocundo(pundo);
	  deallocundo(second);
	  break;
      // HORST
    case LITCLS:
      undoLitCls((LitCls *) pundo->info1);
      deallocundo(pundo);
      break;
	case EQLITWATCH:
	  undoEquivalences((stEqInformation *) pundo->info1);
	  deallocundo(pundo);
      break;
	default:
	  panic("undoRestore. Illegal type on undo stack.\n");
	}
  topDAGStack=(DAG *)pundo->info1;
  deallocundo(pundo);
  pundo=popundo();
  CONTRADICTION.dagnode.two = (DAG *)pundo->info1;
  deallocundo(pundo);
  pundo=popundo();
  CONTRADICTION.dagnode.one = (DAG *)pundo->info1;
  deallocundo(pundo);
  pundo=popundo();
  if(pundo->info1)
	CONTRADICTION.val = true;
  else
	CONTRADICTION.val = false;
  deallocundo(pundo);
}
