/*

2clsQ. Copyright Horst Samulowitz and Fahiem Bacchus 2006

 A DPLL QBF solver based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to
implied warranties of merchantability and fitness for a particular
purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Fahiem Bacchus },
	year    = { 2006 },
	title   = { {2clsQ} a {DPLL} solver employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/


#include "2clsEq.h"
#include <time.h>
#include <stdio.h>
#include "solutions.h"
#include "nogoodDB.h"

#ifdef WIN32
//#include <windows.h>
#else /* WIN32 */
#include <sys/times.h>					// Linux, Solaris, HPUX, etc.
#include <unistd.h>						// Linux, Solaris
//#include <sys/time.h>					// BSD
//#include <sys/resource.h>				// BSD
//#include <sys/param.h>				// BSD
//#include <sys/sysctl.h>				// BSD
#endif /* WIN32 */

bool bNT;								/* this is Windows NT */

#ifdef WIN32
//static double GetWinRunTime(void);
#endif /* WIN32 */

/* GetInternalRunTime

   Description:
   Get the time in seconds since an OS specific epoch.
   If possible, we provide accounted time.
   Notes:
   On non-Windows systems, the default time calculation assumes a Linux, Solaris
   or HPUX system.  Commented out code is also provided for BSD, and if all
   else fails, there is a call to the ANSI clock routine.
*/

double GetInternalRunTime(void)
{
  double df = 0;
#ifndef WIN32
  // Linux, Solaris, HPUX, etc.
  struct tms usage;
  // BSD
  //struct rusage usage;
#endif /* win32 */
#ifdef WIN32
  //df=GetWinRunTime();
  //return(clock()/(CLOCKS_PER_SEC*1.0));
#else /* WIN32 */

  // times() returns accounted time on Linux, Solaris, HPUX etc.
  // on most systems, CLK_TCK is defined as 100, meaning that
  // the time wraps in either 250 or 500 days on a 32 bit processor.

  times(&usage);
  df=((double)usage.tms_utime+(double)usage.tms_stime)/100;//CLK_TCK;

  //	// getrusage() returns accounted time (among other things) on BSD
  //
  //	getrusage(RUSAGE_SELF,&usage);
  //	df=(double)usage.ru_utime.tv_sec+usage.ru_utime.tv_usec/1000000.0+
  //		(double)usage.ru_stime.tv_sec+usage.ru_stime.tv_usec/1000000.0;
  //
  //	// the ANSI clock() routine causes trouble on many systems since
  //	// CLOCKS_PER_SEC may be defined as 1000000, causing the time to wrap
  //	// in either 35 or 70 minutes on a 32 bit processor.
  //
  //	df=(double)clock()/CLOCKS_PER_SEC;
#endif /* WIN32 */
  return df;
}

#ifdef WIN32
/* GetWinRunTime

   Description:
   Get the current system time in seconds, as a double precision number.
   For Windows 95/98, this routine reports the elapsed time, using
   QueryPerformanceCounter and QueryPerformanceFrequency to attain a
   precision of better than 1 microsecond.
   For Windows NT, this routine reports the accounted CPU time using
   GetProcessTimes.
   Notes:
   Windows 95/98 reports a clock frequency of 1193180 Hz on a PC.  The actual
   frequency is more likely 1193046.471111 Hz, which causes a 32 bit counter
   to overflow exactly once an hour... but we take their word for it anyways.
   We assume that the clock frequency is under 4294967296 Hz, so we can
   ignore the upper longword of the frequency.
*/

static double GetWinRunTime(void)
{
  /*double dfTime;
  
  if(bNT)
	{
	  FILETIME ftTemp;
	  FILETIME ftKernal;
	  FILETIME ftUser;

	  GetProcessTimes(GetCurrentProcess(),&ftTemp,&ftTemp,&ftKernal,&ftUser);
	  dfTime=(*(__int64 *)&ftKernal+*(__int64 *)&ftUser)/10000000.0;
	}
  else								
	{
	  unsigned int n[2];
	  static double k0,k1;

	  if(!k0)
		{
		  if(!QueryPerformanceFrequency((LARGE_INTEGER *)n))
			return 0.0;
		  k0=n[0];
		  k1=4294967296.0/k0;
		}
	  QueryPerformanceCounter((LARGE_INTEGER *)n);
	  dfTime=n[1]*k1+n[0]/k0;
	}
	*/
  return 0;
}
#endif /* WIN32 */


/***********************************************************************
                           STATISTICS
***********************************************************************/
//keep track of the time spent on any one problem;

double start_cpu_time = 0;
double init_cpu_time = 0;
double end_cpu_time = 0;
double temp_time = 0;
long this_num_solutions = 0;
long this_num_DPL_leaves = 0;
long this_num_DPL = 0;
long timed_out = 0;
long eqsfound = 0;

long DPL_branches_saved=0;

long pureReductions=0;
long subsumes=0;

long bclsResolved=0;
long bclsAdded=0;

long nClausesChecked=0;
long nClausesHits=0;
long clauseHitsFound=0;
long clauseHitsChecked=0;
long litHitsFound=0;
long litHitsChecked=0;
//long parentHitsChecked=0;
//long parentHitsFound=0;

long *ties;
long *choices;
int deepestlevel;

void initProblemStats() {
#ifdef WIN32
    /* Detect platform */
	/*{
		OSVERSIONINFO osvi;
		osvi.dwOSVersionInfoSize=sizeof(OSVERSIONINFO);
		GetVersionEx(&osvi);
		if(osvi.dwPlatformId==VER_PLATFORM_WIN32_NT)
			bNT=true;
		else
			bNT=false;
	}*/
#endif /* WIN32 */
  this_num_solutions = 0;
  this_num_DPL = 0;
  this_num_DPL_leaves = 0;
  timed_out = 0;

  pureReductions=0;
  subsumes=0;
  start_cpu_time = GetInternalRunTime();
  temp_time= start_cpu_time;

  bclsResolved=0;
  bclsAdded=0;
  clauseHitsFound=0;
  clauseHitsChecked=0;
  nClausesChecked=0;
  nClausesHits=0;
  litHitsFound=0;
  litHitsChecked=0;

  ties = new long[NLITS/2];
  choices = new long[NLITS/2];

  if(!ties || !choices)
	panic("Memory Allocation Failure #26\n");


  for(int i=0;i<NLITS/2;i++) {
    ties[i]=0;
    choices[i]=0;
  }

  deepestlevel=0;
  //parentHitsChecked=0;
  //parentHitsFound=0;

  //printf("bNT=%d, Start CPU time=%.3fs\n",bNT, start_cpu_time);
}

//When we have finished with a problem, this routine
//prints a short summary.

extern int forcedlits;
extern int forcedbcls;
extern int forcedlitsAdded;
extern int forcedbclsAdded;

//extern int *orig_varnum;

void printProblemStats(char *input_file) {
  end_cpu_time = GetInternalRunTime();
  //printf("end CPU time=%.3fs\n",end_cpu_time);
  //Now print a quick summary of this problems results.
  
  printf("c %s:", input_file);
  if (timed_out)
    printf("c \nc Timed out after %6.3fs\n",
		   (end_cpu_time - start_cpu_time + 0.0));
  else if (this_num_solutions > 0)
    printf("c SATISFIABLE: %ld solution(s) found.\n",this_num_solutions);
  else
    printf("c NOT SATISFIABLE\n");

  printf("c (%.3fs cpu sec (%.3f init, %.3f) used, DPL called %ld times, leaves %ld\nc \n",
		 (end_cpu_time - start_cpu_time + 0.0), (init_cpu_time-start_cpu_time+0.0),
		 (end_cpu_time-init_cpu_time+0.0),
		 this_num_DPL,this_num_DPL_leaves);

  printf("c Backjump branches saved %ld\n", DPL_branches_saved);

 
  printf("c Pures %ld, eqs %ld \n",pureReductions, eqsfound);
  printf("c Nogoods stored: %ld, Nogoods triggered: %ld \n", getNumberOfNoGoods(), getTriggeredNoGoods());
  printf("c Cubes stored: %ld, Cubes triggered: %ld \n", getNumberOfTotalCubes(), getNrCubesTriggered()); 
  printf("c Bclauses Resolved = %ld, Bclauses Added=%ld\n", bclsResolved, bclsAdded);
  printf("c Lits checked %ld, times hit %ld (%0.2f%%). Clauses checked %ld, hits found %ld (%0.2f%%), Ave hits per hit lit %5.2f\n",
	 litHitsChecked, litHitsFound, (litHitsChecked>0 ? (litHitsFound*100.0)/litHitsChecked:0), clauseHitsChecked, clauseHitsFound,
	 (clauseHitsChecked>0?(clauseHitsFound*100.0)/clauseHitsChecked:0), (litHitsFound>0 ? (clauseHitsFound*1.0)/litHitsFound:0));

  printf("c Additional lits forced = %d (%d added %0.2f%%)\nc Additional bcls forced = %d (%d added %0.2f%%)\n",
		 forcedlits, forcedlitsAdded,
		 (forcedlitsAdded>0 ? (forcedlits*100.0)/forcedlitsAdded : 0),
		 forcedbcls, forcedbclsAdded,
		 (forcedbclsAdded>0 ? (forcedbcls*100.0)/forcedbclsAdded : 0));

//    printf("Parent Lits checked %ld, percentage parents %0.2f%%, times hit %d (%0.2f%%)\n",
//  	 parentHitsChecked, parentHitsChecked*100.0/litHitsChecked, parentHitsFound,
//           (parentHitsChecked > 0 ? (parentHitsFound*100.0)/parentHitsChecked:0));

  printf("c Nary Clauses checked %ld, hits %ld (%0.2f%%)\n", nClausesChecked, nClausesHits, (nClausesChecked>0 ? (nClausesHits*100.0)/nClausesChecked: 0));


  printf("c\n");
  if (timed_out)
    printf("s UNKNOWN\n");
  else if(this_num_solutions<=0)
    printf("s UNSATISFIABLE\n");

  //  for(int i=0;i<=deepestlevel;i++)
  //  printf("Choices[%d]=%d, Ties[%d]=%d\n", i, choices[i], i, ties[i]);

  //and print to an "excel" data file (excel can read comma delimited files).
  FILE *f;
  if (!(f = fopen("timetable.dat","a")))
    panic("Error: could not open file for appending.");
  fprintf(f,"%s,",input_file);
  if (timed_out)
    fprintf(f,"-1,");
  else if (this_num_solutions > 0)
    fprintf(f,"1,");
  else
    fprintf(f,"0,");
  fprintf(f,"%.3f,%.3f,%ld,%ld,%0.6f,%ld,%ld,%ld,%ld,%ld\n",
		  (end_cpu_time - start_cpu_time + 0.0),
		  (init_cpu_time - start_cpu_time + 0.0),
		  this_num_DPL,this_num_DPL_leaves,clauseHitsFound*1.0/clauseHitsChecked,clauseHitsFound,clauseHitsChecked,pureReductions,eqsfound,subsumes);
  fclose(f);
  //outputLearnedClauses();
}


void recordInitTime() {
  init_cpu_time = GetInternalRunTime();
  printf("c Init time: %.3f cpu sec.\n", init_cpu_time - start_cpu_time+0.0);
}

void recordTime(char *s) {
  double t = 0;//GetInternalRunTime();
  printf("%s: %.3f cpu sec.\n",s, t - temp_time+0.0);
  temp_time=t;
}
