/*

2clsQ. Copyright Horst Samulowitz and Fahiem Bacchus 2006

 A DPLL QBF solver based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to
implied warranties of merchantability and fitness for a particular
purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Fahiem Bacchus },
	year    = { 2006 },
	title   = { {2clsQ} a {DPLL} solver employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/
//---------------------------------------------------------------------------
// Solutions
//---------------------------------------------------------------------------
#if !defined(Solutions_H)
  #define Solutions_H
#endif // Solutions_H


#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <search.h>
#include "2clsEq.h"
#include "binaryClauses.h"
#include "resolve.h"
#include "undo.h"





struct stCubeInformation {
	Lit * lMaxUniversalLit;
	vector<int> * vecCube;
};

struct stCubeInfo {
	long lCube1;
	long lCube2;
};



inline stCubeInformation * getCube();

void initCubeStructure();

void emptyCubeInfo(int);

void setCubeInfo(int, long);

inline long getCubeInfo1(int);

inline long getCubeInfo2(int);

void outputVectorCube(vector<int>*);

inline vector<int> * cutTailingExistentialsFromVector(vector<int> *, int);

inline long addCubeToDB(vector<int>*, int);

inline void swapLiteralsinCube(int, int);

int computeGood(NoGood * ngGood);

void updateBitLevels(vector<int> *, NoGood *);

void addLiteralinCube(int, int);

inline void addLiteralCubeScoreIncremental(int);

float getLiteralCubeScore(int);

inline void setLiteralCubeScore(int, float);

//vector<int> resolveCubes(vector<int> vecCube, int nUniversalAtMaxPrefixLevel);

bool isCubeTrue(int);

inline vector<int> * getLiteralInCubeWatches(int);

void setLiteralInCubeWatches(int, vector<int>*);

inline int updateWatchInCubes(int);

inline int updateWatchInCube(int, int, vector<int>*);

inline int getLiteralInCube(int);

inline void addLiteralWatchCube(int, int);

int checkCubesOfLiteral(int nLiteral);

NoGood* convertCubeToNoGood(long, int , int*);

void outputCube(int nCubeOffset);

void incNrCubesTriggered();

long getNrCubesTriggered();

void addCubeFromNogood(NoGood *, int, int *);

int computeCube();

int resolveCubes(long, long);

int resolveCubesAtLevel(int);

inline stCubeInformation * resolveCubesWithOffset(long, long);
inline stCubeInformation * resolveCubesWithVector(long, vector<int> *);
int resolveCubes(int nLevel);
int computeCubeAndResolve();

inline int getDecayLiteralScoreInterval();

inline int getDecayLiteralCubeInterval();

inline void setDecayLiteralCubeInterval(int);

inline void decayLiteralCubeVarScore();

int getNumberOfCubes(); 

void setNumberOfCubesPlusOne();

void removeLearnedCubes();

int getNumberOfTotalCubes();

long getSizeOfCubes();

  
