/*

2clsQ. Copyright Horst Samulowitz and Fahiem Bacchus 2006

 A DPLL QBF solver based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to
implied warranties of merchantability and fitness for a particular
purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Fahiem Bacchus },
	year    = { 2006 },
	title   = { {2clsQ} a {DPLL} solver employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/


//---------------------------------------------------------------------------
// Solutions.cpp
//---------------------------------------------------------------------------
#include "solutions.h"

// Store the learned Cubes
vector<int> _vecCubes;
vector<vector<int>*> _vecLiteralsInCubes;
vector<vector<int>*> _vecLiteralCubeWatches;
float*               _arrLiteralCubeCount;
bool*                _arrLiteralAlreadyAddedToCube;
bool*                _arrLiteralInverseAlreadyAddedToCube;

bool*                _bArrAddedToCube;

long        _nNumberOfCubes;
long        _nNumberOfTotalCubes;
long        _nNumberOfResetCubes;
int         _nNumberOfUniversalsInActualCube;
long        _nNumberOfCubesTriggered;

int			_decayLiteralCubeInterval;



stCubeInfo** stCubeOffsets;
// ********************************************


using namespace std;


inline stCubeInformation * getCube() {


  int nActualLiteral;
  int nMaxLiteral              = getMaxLiteral();
  int nMaxUniversalPrefixLevel = -1;
  int nPrefixLevel;

  vector<int> * vecCube = new vector<int>;
 
  stCubeInformation * stCube = new stCubeInformation;

 // bool*_bArrAddedToCube = new bool[nMaxLiteral + 1];
  
  for(int c = 0; c < nMaxLiteral; c++)
  {
   _bArrAddedToCube[c] = false;
  }

  CLAUSELIST *cl;
  int i, j;
  int nCubeLiteral;
  Lit * lCubeLiteral;
  Lit * lCurrentDeepestLiteral = NULL;
  // First get all the NECCESSARY literals in the cube
  // Don't need to take care of the units, do we?
  for(i=1;i<CLSGROUPS;i++)
        for(cl=lenNclauses[i];cl;cl=cl->pnext) {
          //printf("Checking clause:\n");
          //printCLAUSELIST(cl);
          bool val                   = false;
          int  nNumberOfTrueLiterals = 0;
          for(j=0;j<cl->clslen;j++)
          {
                if(isTrue(eqlit(cl->cls[j])))
                {
                  val=true;                  
                  nNumberOfTrueLiterals++;  
				  if(isTrue(cl->cls[j]) && isLitExistential(cl->cls[j]))
				  {
                   nCubeLiteral = cl->cls[j];				  
				  }
                  else
				  {
				    nCubeLiteral = cl->cls[j];				  
				  }
                } 
             if(nNumberOfTrueLiterals > 1)
              break;
          }
		  /*if(nNumberOfTrueLiterals == 0)
		  {
           for(j=0;j<cl->clslen;j++)
           {
             int nLit = eqlit(cl->cls[j]);
			   printf(" %d (E?: %d T: %d F: %d) ", nLit, isLitExistential(nLit), isTrue(nLit), isFalse(nLit));
             if(!isFalse(eqlit(cl->cls[j])) && isLitExistential(eqlit(cl->cls[j])))
              nCubeLiteral = eqlit(cl->cls[j]); 
		   } 
		   assert(false);
           nNumberOfTrueLiterals = 1;
		  }*/
          assert(nNumberOfTrueLiterals > 0);
		  // If there is only one true literal in a clause we have to add it to the cube
          if(nNumberOfTrueLiterals == 1) {
              if(!_bArrAddedToCube[nCubeLiteral])
              {
                vecCube->push_back(nCubeLiteral);
               _bArrAddedToCube[nCubeLiteral] = true;
                if(!isLitExistential(nCubeLiteral))
                {
                 /* if((getLitPrefixLevel(nCubeLiteral) > nMaxUniversalPrefixLevel))
					 nMaxUniversalPrefixLevel = getLitPrefixLevel(nCubeLiteral);
				  lCubeLiteral = intTolit(nCubeLiteral);
				  if(lCurrentDeepestLiteral != NULL)
					 {
					  if(lCubeLiteral->assignLevel > lCurrentDeepestLiteral->assignLevel)
					   lCurrentDeepestLiteral = lCubeLiteral;
					  }
					 else
					  lCurrentDeepestLiteral = lCubeLiteral;*/
				  if((getLitPrefixLevel(nCubeLiteral) > nMaxUniversalPrefixLevel))
				  {
					nMaxUniversalPrefixLevel = getLitPrefixLevel(nCubeLiteral);
                    lCubeLiteral = intTolit(nCubeLiteral);
		 		    assert(lCubeLiteral != NULL);
					if(lCurrentDeepestLiteral != NULL)
					 {
					  if(lCubeLiteral->assignLevel > lCurrentDeepestLiteral->assignLevel)
					   lCurrentDeepestLiteral = lCubeLiteral;
					  }
					 else
					  lCurrentDeepestLiteral = lCubeLiteral;
				  } 
				  else if(getLitPrefixLevel(nCubeLiteral) == nMaxUniversalPrefixLevel)
				  {
                    lCubeLiteral = intTolit(nCubeLiteral);  
					if(lCubeLiteral->assignLevel > lCurrentDeepestLiteral->assignLevel)
					  lCurrentDeepestLiteral = lCubeLiteral;
				  }				
				}
			  }
          }
        }
      // Try to satisfy the remaining clauses by maximising the number of used existentials
      for(i=1;i<CLSGROUPS;i++)
            for(cl=lenNclauses[i];cl;cl=cl->pnext) {
              //printf("Checking clause:\n");
              //printCLAUSELIST(cl);
              bool val                   = false;
              int  nNumberOfTrueLiterals = 0;
              bool bAlreadyTrue          = false;
              nCubeLiteral = -1;
			  int nCurrentLiteral;
              for(j=0;j<cl->clslen;j++)
              {
				    if(isTrue(cl->cls[j]))
					{
						if(isTrue(eqlit(cl->cls[j])))
						{
                          if(isLitExistential(cl->cls[j]) && !isLitExistential(eqlit(cl->cls[j])))
							nCurrentLiteral = cl->cls[j];
						  else
							nCurrentLiteral = cl->cls[j];
						}
						else
                         nCurrentLiteral = cl->cls[j];
					}
					else
					 nCurrentLiteral = cl->cls[j];

                    if((_bArrAddedToCube[eqlit(cl->cls[j])]) || (_bArrAddedToCube[cl->cls[j]])){
                     bAlreadyTrue = true;
                     break;
                    }
                    else 
					if(isTrue(nCurrentLiteral)){
                      if(nCubeLiteral != -1)
                      {
                        if(isLitExistential(nCurrentLiteral))
                        {
                          if(!isLitExistential(nCubeLiteral))
                           nCubeLiteral = nCurrentLiteral;
                          else
                          {
                            // If prefix level bigger than of the old variable then substitute too
                            if(getLitPrefixLevel(nCubeLiteral) > getLitPrefixLevel(nCurrentLiteral))
                              nCubeLiteral = nCurrentLiteral;
                          }
						}
                        else
						{
                          // If prefix level smaller than of the old variable then substitute too
                            if((getLiteralCubeScore(nCubeLiteral) > getLiteralCubeScore(nCurrentLiteral)) || (getLitPrefixLevel(nCubeLiteral) < getLitPrefixLevel(nCurrentLiteral)))// || (getLiteralCubeScore(nCurrentLiteral) > getLiteralCubeScore(nCubeLiteral)))
                              nCubeLiteral = nCurrentLiteral;
                        }
					  }
                      else
                       nCubeLiteral = nCurrentLiteral;
                    }
              }
              // If the clause is not yet true by another literal
              if(!bAlreadyTrue) {
                  //assert(nCubeLiteral != -1);
                  //assert(!_bArrAddedToCube[nCubeLiteral]);
                  vecCube->push_back(nCubeLiteral);
				  lCubeLiteral = intTolit(nCubeLiteral);
                 _bArrAddedToCube[nCubeLiteral] = true;
				  /*if(!isLitExistential(nCubeLiteral)) {
                   if((getLitPrefixLevel(nCubeLiteral) > nMaxUniversalPrefixLevel))
  			 		  nMaxUniversalPrefixLevel = getLitPrefixLevel(nCubeLiteral);
				   
				   if(lCurrentDeepestLiteral != NULL)
					 {
					  if(lCubeLiteral->assignLevel > lCurrentDeepestLiteral->assignLevel)
					   lCurrentDeepestLiteral = lCubeLiteral;
					  }
					 else
					  lCurrentDeepestLiteral = lCubeLiteral;
				  }*/
				  
				  if(!isLitExistential(nCubeLiteral) && (getLitPrefixLevel(nCubeLiteral) >= nMaxUniversalPrefixLevel))
                  {
                    nMaxUniversalPrefixLevel = getLitPrefixLevel(nCubeLiteral);
                    if(lCurrentDeepestLiteral != NULL)
                    {
                     if(lCubeLiteral->assignLevel > lCurrentDeepestLiteral->assignLevel)
                      lCurrentDeepestLiteral = lCubeLiteral;
                    }
                    else
                     lCurrentDeepestLiteral = lCubeLiteral;
                  }
              }
            }
    //delete_bArrAddedToCube;
    if(lCurrentDeepestLiteral == NULL)
	{		
		vecCube->clear();
		stCube->vecCube = vecCube;		
		stCube->lMaxUniversalLit = 0;
	    return stCube;
	}
	else
	{
     //outputVectorCube(vecCube);
	 //printf("\n Cut tailing existentials ");	
     vecCube = cutTailingExistentialsFromVector(vecCube,nMaxUniversalPrefixLevel);
	 
     //printf("\n Max Universal Prefix Level: %d ", nMaxUniversalPrefixLevel);	 
	 //printf("\n Universal %d EQ: %d DL: %d ", lCurrentDeepestLiteral->num, eqlit(lCurrentDeepestLiteral->num), lCurrentDeepestLiteral->assignLevel);
	 stCube->vecCube = vecCube;
	 assert(!isLitExistential(lCurrentDeepestLiteral));
	 stCube->lMaxUniversalLit = lCurrentDeepestLiteral;
	 return stCube;
	}
}


void updateBitLevels(vector<int> * vecCube, NoGood* ngGood)
{
 // Go through the cube
 vector<int>::iterator iterCube;
 for(iterCube = vecCube->begin(); iterCube != vecCube->end(); ++iterCube)
 {
	 // Get the literal
     Lit * lLit = intTolit(*iterCube);
	 // Set the assignlevel of the current literal
	 /*if(lLit->assignLevel == 14)
	 {
	  printf(" SSS Setting Literal %d at Level %d. Other Literals at Level: ", *iterCube, lLit->assignLevel);
	  for(int n=0; n<NLITS; n++)
	  {
        Lit * lLit1 = intTolit(n);
		if(lLit1->assignLevel == 14)
			printf(" %d (E?: %d, PL: %d)", lLit1->num, isLitExistential(lLit1->num),getLitPrefixLevel(lLit1->num)); 
	  }
	 }*/
	 ngGood->setbit(lLit->assignLevel);
 }
}


int computeGood(NoGood * ngGood)
{
 stCubeInformation * stCube;
 // Get a cube from the current Solution
 stCube = getCube();
 //outputVectorCube(stCube->vecCube);
 if(stCube->vecCube->size() == 0)
 { 
    //printf("\n Return 0 ");
	return 0;
 }
 else
 {
  // Update BitLevels based on the computed NoGood
  updateBitLevels(stCube->vecCube, ngGood);
  // Add cube to DB
  int nMaxPrefixLevel = getLitPrefixLevel(stCube->lMaxUniversalLit);
  addCubeToDB(stCube->vecCube, nMaxPrefixLevel);
  // Clean up
  delete stCube->vecCube;
  //printf("\n Deepest universal: %d (E?: %d)", stCube->lMaxUniversalLit->num, isLitExistential(stCube->lMaxUniversalLit));
  // Then return the level of the deepest universal
  return stCube->lMaxUniversalLit->assignLevel;
 }
}

int computeCube()
{
 stCubeInformation * stCube;
 // Get a cube from the current Solution
 stCube = getCube();
 outputVectorCube(stCube->vecCube);
 if(stCube->vecCube->size() == 0)
 { 
    //printf("\n Return 0 ");
	return -1;
 }
 else
 {  
  // Add cube to DB
  int nMaxPrefixLevel = getLitPrefixLevel(stCube->lMaxUniversalLit);
  long nCubeOffset = addCubeToDB(stCube->vecCube, nMaxPrefixLevel);
  //printf("\n Level: %d of Literal %d \n", stCube->lMaxUniversalLit->assignLevel, stCube->lMaxUniversalLit->num);  
  setCubeInfo(stCube->lMaxUniversalLit->assignLevel,nCubeOffset); 
  
  // Clean up
  delete stCube->vecCube;
  //printf("\n Deepest universal: %d (E?: %d)", stCube->lMaxUniversalLit->num, isLitExistential(stCube->lMaxUniversalLit)); 
  return stCube->lMaxUniversalLit->num;
 }
}



void outputVectorCube(vector<int> * vecUInts)
{
  vector<int>::iterator iterVec;
  printf("\n Output Cube Vector: ");
  if (vecUInts->size() == 0)
   printf(" Empty (outputVector) ");
  for(iterVec = vecUInts->begin(); iterVec != vecUInts->end(); iterVec++)
   {
     Lit * lCurrentLiteral = intTolit(*iterVec);
	 printf(" %d (Internal: %d E?: %d PL: %d, DL: %d) ", to_ff(*iterVec), *iterVec, isLitExistential(lCurrentLiteral), getLitPrefixLevel(lCurrentLiteral), lCurrentLiteral->assignLevel);
	 //printf(" %d ", to_ff(*iterVec));
   }
  printf("\n");
}


inline vector<int> * cutTailingExistentialsFromVector(vector<int> * vecUInts, int nMaxUniversalPL)
{
  vector<int>::iterator iterVec;
  vector<int> * vecCutTailingLiterals = new vector<int>;
  int nCountUniversalAtMaxLevel = 0;
  for(iterVec = vecUInts->begin(); iterVec != vecUInts->end(); iterVec++)
   {
     if(nMaxUniversalPL >= getLitPrefixLevel(*iterVec))
      vecCutTailingLiterals->push_back(*iterVec);
	 if(!isLitExistential(*iterVec))
      nCountUniversalAtMaxLevel++;
   }  
  //printf("\n Number of Universals in Cube: [%d] ", nCountUniversalAtMaxLevel);
  delete vecUInts;
  return vecCutTailingLiterals;
}




inline long addCubeToDB(vector<int> * vecCube, int nUniversalAtMaxPrefixLevel)
{
 //cout << "\n Start With: ";
 //outputVector(vecCube);
 long nCubeOffset = _vecCubes.size();
 int nFirstLiteralPos = 0;
 int nSecondLiteralPos = 0;
 int nFirstMaxDL = 0;
 int nSecondMaxDL = 0;
 int nActualDL;
 int nActualPosition = _vecCubes.size() - 1;
 int nFirstPosition  = _vecCubes.size();
 bool bTest = false;

 _nNumberOfUniversalsInActualCube = 0;

 //cout << "\n nFirstPos: " << nFirstPosition << " ";
 //vector<int> vecCutCube;
 if(!vecCube->empty())
 {
  // Now add Cube to Clause Database (cut tailing exitentials)
  vector<int>::iterator iterVecCube;
  for(iterVecCube = vecCube->begin(); iterVecCube != vecCube->end(); ++iterVecCube)
  {
    #ifdef SECURE
   assert(isLiteral(*iterVecCube));
    #endif
   if(isLitExistential(*iterVecCube))
   {
     // Only add Existentials that have a smaller PrefixLevel than the maximal universal Prefix Level
     if(getLitPrefixLevel(*iterVecCube) < nUniversalAtMaxPrefixLevel)
     {
       _vecCubes.push_back(*iterVecCube);
       ++nActualPosition;
       
       //vecCutCube.push_back(*iterVecCube);
       nActualDL = getReasonDecisionLevel(*iterVecCube);
       if(nActualDL > nFirstMaxDL)
       {
         nSecondLiteralPos = nFirstLiteralPos;
         nFirstLiteralPos = nActualPosition;
         nSecondMaxDL = nFirstMaxDL;
         nFirstMaxDL = nActualDL;
         //cout << "\n nFirstMaxDL: " << nActualDL << " ";
       }
       else
       {
        if(nActualDL > nSecondMaxDL)
        {
         nSecondLiteralPos = nActualPosition;
         nSecondMaxDL = nActualDL;
        }
       }
     }
   }
   else // universal
   {
     #ifdef SECURE
     assert(isLiteral(*iterVecCube));
     #endif
      _vecCubes.push_back(*iterVecCube);
      ++nActualPosition;
      //vecTCube.push_back(*iterVecCube);
      ++_nNumberOfUniversalsInActualCube;
      // Update Cube Score for Literal
      addLiteralCubeScoreIncremental(*iterVecCube);
      nActualDL = getReasonDecisionLevel(*iterVecCube);
      if(nActualDL > nFirstMaxDL)
      {
        nSecondLiteralPos = nFirstLiteralPos;
        nFirstLiteralPos = nActualPosition;
        nSecondMaxDL = nFirstMaxDL;
        nFirstMaxDL = nActualDL;
        //cout << "\n nFirstMaxDL: " << nActualDL << " ";
      }
      else
      {
       if(nActualDL > nSecondMaxDL)
       {
        nSecondLiteralPos = nActualPosition;
        nSecondMaxDL = nActualDL;
        //cout << "\n nSecondMaxDL: " << nActualDL << " ";
       }
      }
     // Add Cube Offset to Literal
     addLiteralinCube(*iterVecCube, nCubeOffset);     
   }
  }
  assert(nCubeOffset <= _vecCubes.size());
  // Put Deepest Literals to the Front
  if((nFirstLiteralPos != nFirstPosition) && (nFirstLiteralPos != 0))
  {
   swapLiteralsinCube(nFirstLiteralPos, nFirstPosition);
   //cout << "\n Add First Watch: " << _vecCubes[nFirstPosition] << " ";
  }

  if(nFirstLiteralPos != 0)
   addLiteralWatchCube(_vecCubes[nFirstPosition], nCubeOffset);

  if((nSecondLiteralPos != nFirstPosition + 1) && (nSecondLiteralPos != 0))
  {
   swapLiteralsinCube(nSecondLiteralPos, nFirstPosition + 1);
   //cout << " Add Second Watch: " << _vecCubes[nFirstPosition+1] << " ";
  }
  if(nSecondLiteralPos != 0)
   addLiteralWatchCube(_vecCubes[nFirstPosition+1], nCubeOffset);
  //else
  // bTest = true;

 }
 // Add tailing -1
 _vecCubes.push_back(-1);
 //if(bTest)
 // outputCube(nCubeOffset);
 // Increase Number of Cubes
 ++_nNumberOfCubes;

 ++_nNumberOfResetCubes;

 ++_nNumberOfTotalCubes;

 // ****************************
 if(_nNumberOfCubes % getDecayLiteralCubeInterval() == 0)
 {
  ///printf("\n DECAY \n" );
  decayLiteralCubeVarScore();
 }
 // ****************************
 //cout << " \n Literal Value -371: " << getLiteralValue(743) << " Score: " << getLiteralScore(743) << " " << getLiteralScore(745) << " ";
 //cout << " nMaxPrefixLevel: " << nUniversalAtMaxPrefixLevel << " ";
 //outputVector(vecCutCube);
 //  if(getNumberOfCubes() > 0)
 //  assert(false);
 //assert(isCubeTrue(nCubeOffset));
 //printf("\n Number of Universal in actual Cube: %d ", _nNumberOfUniversalsInActualCube);
 return nCubeOffset;
}


inline void swapLiteralsinCube(int nFirstPosition, int nSecondPosition)
{
    #ifdef SECURE
   assert(nFirstPosition < _vecCubes.size());
   assert(nSecondPosition < _vecCubes.size());
    #endif
   //cout << " Swap FirstPosition " << nFirstPosition << " with " << nSecondPosition << " ";
   int nTempLiteral =  _vecCubes[nFirstPosition];
   #ifdef SECURE
   assert(isLiteral(nTempLiteral));
   #endif
   _vecCubes[nFirstPosition] = _vecCubes[nSecondPosition];
   #ifdef SECURE
   assert(isLiteral(_vecCubes[nFirstPosition]));
   #endif
   _vecCubes[nSecondPosition] = nTempLiteral;
}


void incNrCubesTriggered(){
 _nNumberOfCubesTriggered++;
}

long getNrCubesTriggered(){
 return _nNumberOfCubesTriggered;
}

void initCubeStructure()
{
 _arrLiteralCubeCount = new float[NLITS+1];
 _arrLiteralInverseAlreadyAddedToCube = new bool[NLITS+1];
 _arrLiteralAlreadyAddedToCube = new bool[NLITS+1]; 
 
 _vecCubes.push_back(-1);

 _nNumberOfUniversalsInActualCube = 0;
 _nNumberOfResetCubes = 0;
 _nNumberOfCubes = 0;
 _nNumberOfCubesTriggered = 0;
 _nNumberOfTotalCubes = 0; 

 // Set Cube Decay Interval
 _decayLiteralCubeInterval  = 20;
 
 stCubeOffsets = new stCubeInfo*[NVARS+3];

 for(int i=0; i<=NVARS + 3; i++)
 {
   stCubeOffsets[i] = new stCubeInfo; 
   stCubeOffsets[i]->lCube1 = 0;
   stCubeOffsets[i]->lCube2 = 0;
   
 }
 
 for(int i=0; i<NLITS; i++)
 {
  vector<int>* vecEmpty = new vector<int>;
  _vecLiteralsInCubes.push_back(vecEmpty);
  // Init Cube score
  _arrLiteralCubeCount[i] = 0;
  _arrLiteralInverseAlreadyAddedToCube[i] = false;
  _arrLiteralAlreadyAddedToCube[i] = false;

  vector<int> * vecUIntEmptyWatch  = new vector<int>;
  _vecLiteralCubeWatches.push_back(vecUIntEmptyWatch);
 }

 _bArrAddedToCube = new bool[getMaxLiteral() + 1];
 
}

void emptyCubeInfo(int nLevel)
{
 //printf("\n Empty Good @ level %d ", nLevel);
 stCubeOffsets[nLevel]->lCube1 = 0;
 stCubeOffsets[nLevel]->lCube2 = 0;
}

void setCubeInfo(int nLevel, long nCubeOffset)
{ 
 ///printf("\n Set Good @ level %d ", nLevel);
 //if(nCubeOffset == 1967)
	// printf("\ HEREXX 1967 at level: %d ", nLevel);
 if(stCubeOffsets[nLevel]->lCube1 == 0)
 {
  //printf(" Cube 1 ");
  //printf("\n Setting 1. Cube %d at level %d ", nCubeOffset, nLevel);
  stCubeOffsets[nLevel]->lCube1 = nCubeOffset;
 }
 else
 {
  //assert(stCubeOffsets[nLevel]->lCube2 == 0);
  //printf(" Cube 2 ");
  //printf("\n Setting 2. Cube %d at level %d ", nCubeOffset, nLevel);
  stCubeOffsets[nLevel]->lCube2 = nCubeOffset;
 }
}

inline long getCubeInfo1(int nLevel)
{
 assert(nLevel <= NVARS);
 return stCubeOffsets[nLevel]->lCube1;
}

inline long getCubeInfo2(int nLevel)
{
 return stCubeOffsets[nLevel]->lCube2;
}


inline void addLiteralinCube(int nLiteral, int nCubeOffset)
{
 // Add Cube Offset to Literal
 _vecLiteralsInCubes[nLiteral]->push_back(nCubeOffset);
 // Update Cube Score for Literal
 addLiteralCubeScoreIncremental(nLiteral);
}

inline void addLiteralCubeScoreIncremental(int nLiteral)
{
  _arrLiteralCubeCount[nLiteral] = _arrLiteralCubeCount[nLiteral] + 1;
}

float getLiteralCubeScore(int nLiteral)
{
  return _arrLiteralCubeCount[nLiteral];
}

inline void setLiteralCubeScore(int nLiteral, float fValue)
{
  _arrLiteralCubeCount[nLiteral] = fValue;
}

bool isCubeTrue(int nCubeOffset)
{
  int nCurrentOffset = nCubeOffset;
  int nActualValue = _vecCubes[nCurrentOffset];
  int nLiteralValue;
  //cout << "\n Cube (Total #Cubes: " << getNumberOfCubes() << ") : ";
  // While not end of cube
  while(nActualValue != -1)
  {
     #ifdef SECURE
    assert(isLiteral(nActualValue));
     #endif
    
    //cout << " " << nActualValue << ": " << nLiteralValue << " ";
    // If a Literal is False Or Unassigned return false and swap
    if(!isTrue(eqlit(nActualValue)))
    {
     if(nCubeOffset != nCurrentOffset)
       swapLiteralsinCube(nCubeOffset, nCurrentOffset);
     //cout << " nLiteral " << nActualValue << " Existential? " << isExistential(nActualValue) << " Prefix Level: " << getLitPrefixLevel(nActualValue) << " ";
     return false;
    }
    // Move on in Cube
    ++nCurrentOffset;
    nActualValue = _vecCubes[nCurrentOffset];
  }
  // Now all Literals must be true
  return true;
}

inline int updateWatchInCubes(int nLiteral)
{
  vector<int> * vecCubeWatches = getLiteralInCubeWatches(nLiteral);
  //cout << " XXXXXXXXXX nLiteral: " << nLiteral << " " << getLiteralValue(nLiteral) << " "; cout.flush();
  //outputVector(vecCubeWatches);
  vector<int> * vecNewWatches = new vector<int>;
  int nReturnValue = 0;
  vector<int>::iterator iterVec;
  bool bClean = false;
  if(!vecCubeWatches->empty())
  {
    iterVec = vecCubeWatches->begin();
    while((iterVec != vecCubeWatches->end()) && (nReturnValue == 0))
    {
      //cout << "\n C: " << *iterVec << " " <<vecCubeWatches->size() << " ";
      //assert(iterVec != vecCubeWatches->end());
      nReturnValue = updateWatchInCube(nLiteral, *iterVec, vecNewWatches);
      ++iterVec;
    }
    // Copy remaining Cube Offsets to the new vector of watches
    if(nReturnValue != 0)
    {
      while(iterVec != vecCubeWatches->end())
      {
        //assert(*iterVec < _vecCubes.size());
        vecNewWatches->push_back(*iterVec);
        ++iterVec;
      }
    }
    setLiteralInCubeWatches(nLiteral, vecNewWatches);
	bClean = true;
    //outputVector(getLiteralInCubeWatches(nLiteral));
    //assert(false);
  }
  if(!bClean)
   delete vecNewWatches;
  /*if(nReturnValue != 0)
  {
   cout << "\n True Cube: ";
   outputCube(nReturnValue);
  }*/
  return nReturnValue;
}

void setLiteralInCubeWatches(int nLiteral, vector<int>* vecOffsets)
{
  #ifdef SECURE
  assert(isLiteral(nLiteral));
  #endif
  // delete old List of Watches
  delete _vecLiteralCubeWatches[nLiteral];
  _vecLiteralCubeWatches[nLiteral] = vecOffsets;
}

inline vector<int> * getLiteralInCubeWatches(int nLiteral)
{
  #ifdef SECURE
  assert(isLiteral(nLiteral));
  #endif
  return _vecLiteralCubeWatches[nLiteral];
}

inline int updateWatchInCube(int nLiteral, int nCubeOffset, vector<int> * vecNewCubeWatches)
{
  int nActualOffset = nCubeOffset;
  assert(nCubeOffset < _vecCubes.size());
  int nFirstWatch = getLiteralInCube(nActualOffset);
  int nFirstWatchOffset = nActualOffset;
  ++nActualOffset;
  int nSecondWatch = getLiteralInCube(nActualOffset);
  int nSecondWatchOffset = nActualOffset;
  //#ifdef SECURE
  //cout << "\n " << nFirstWatch << " " << nSecondWatch << " CubeOffset: " << nCubeOffset << " ";
  //outputCube(nCubeOffset);
  //cout.flush();
  //assert((isLiteral(nFirstWatch)) && (isLiteral(nSecondWatch)));
  //#endif
  // If one Watch is false then return 0
  //if((getLiteralValue(nFirstWatch) == 0) || (getLiteralValue(nSecondWatch) == 0))
  // return 0;
  if(nSecondWatch == -1)
  {
    assert(nFirstWatch == nLiteral);
	//printf("\n HERE ");
    vecNewCubeWatches->push_back(nCubeOffset);
    return nCubeOffset;
  }
  
  // If nLiteral is not a Watch return 0
  if((nFirstWatch != nLiteral) && (nSecondWatch != nLiteral))
   return 0;

  // Check if Second Watch is NOT true, then we return 0 but keep the Watch
  if(nFirstWatch == nLiteral)
  {
    if(!isTrue(nSecondWatch))
    {
      // Keep Watch on CubeOffset
      vecNewCubeWatches->push_back(nCubeOffset);
      return 0;
    }
  }

 if(nSecondWatch == nLiteral)
  {
    if(!isTrue(nFirstWatch))
    {
      // Keep Watch on CubeOffset
      vecNewCubeWatches->push_back(nCubeOffset);
      return 0;
    }
  }

  // Go through the Cube and find FALSE or UNASSIGNED Literal
  ++nActualOffset;
  int nActualEntry = getLiteralInCube(nActualOffset);
  bool   bNewWatch    = false;
  while((nActualEntry != -1) && (!bNewWatch))
  {
    // False or Unassigned, then swap Literals in Cube
    if(!isTrue(nActualEntry))
    {
      if(nLiteral == nFirstWatch)
      {
       swapLiteralsinCube(nFirstWatchOffset, nActualOffset);
       // Add Watch
       //cout << "\n Add Watch " << nActualEntry << " " << nFirstWatch << " ";
       addLiteralWatchCube(nActualEntry, nCubeOffset);
      }
      else
      {
       swapLiteralsinCube(nSecondWatchOffset, nActualOffset);
       // Add Watch
       //cout << "\n Add Watch " << nActualEntry << " " << nSecondWatch << " ";
       addLiteralWatchCube(nActualEntry, nCubeOffset);
      }
      bNewWatch = true;
    }
    else // proceed in Cube
    {
      ++nActualOffset;
      nActualEntry = getLiteralInCube(nActualOffset);
    }
  }


  if(!bNewWatch)
  {
    // Keep Watch on CubeOffset
    vecNewCubeWatches->push_back(nCubeOffset);
    return nCubeOffset;
  }
  else
   return 0;
}

inline int getLiteralInCube(int nOffset)
{
  #ifdef SECURE
  assert((nOffset > 0) && (nOffset < _vecCubes.size()));
  #endif
  return _vecCubes[nOffset];
}


// Add Literal Cube Watch
inline void addLiteralWatchCube(int nLiteral, int nCubeOffset)
{
   #ifdef SECURE
  assert(isLiteral(nLiteral));
  assert(nCubeOffset > 0);
   #endif
  _vecLiteralCubeWatches[nLiteral]->push_back(nCubeOffset);
}

// If a cube of this literal is true the offset of the cube is returned, o.w. 0
int checkCubesOfLiteral(int nLiteral)
{
  #ifdef SECURE
  assert(!isLitExistential(nLiteral));
  #endif
  return updateWatchInCubes(nLiteral);
}

NoGood* convertCubeToNoGood(long nCubeOffset, int nLevel, int *dplLevelToLit)
{
  int nCurrentOffset = nCubeOffset;
  int nActualValue = _vecCubes[nCurrentOffset];
  NoGood * ngCube = allocNoGood(nLevel);
  //printf("\n nCube MaxIndex %d ", ngCube->maxindex);
  // While not end of cube
  while(nActualValue != -1)
  {    
	//printf("\n %d E?: %d PL: %d DL: %d ",nActualValue, isLitExistential(nActualValue), getLitPrefixLevel(nActualValue), getReasonDecisionLevel(nActualValue));
    ngCube->setbit(getReasonDecisionLevel(nActualValue));
	ngCube->maxindex;
	// Move on in Cube
    ++nCurrentOffset;
    nActualValue = _vecCubes[nCurrentOffset];
  }  
  return ngCube;
}

void outputCube(int nCubeOffset)
{
  int nCurrentOffset = nCubeOffset;
  int nActualValue = _vecCubes[nCurrentOffset];
  
  printf("\n CUBE On Stack: ");
  // While not end of cube
  while(nActualValue != -1)
  {
     #ifdef SECURE
    assert(isLiteral(nActualValue));
     #endif
	//printf(" %d (DL: %d, E?: %d, PL: %d) ",nActualValue, getReasonDecisionLevel(nActualValue), isLitExistential(nActualValue), getLitPrefixLevel(nActualValue));    
    printf(" %d (Internal: %d E?: %d PL: %d, DL: %d) ", to_ff(nActualValue), nActualValue, isLitExistential(nActualValue), getLitPrefixLevel(nActualValue), intTolit(nActualValue)->assignLevel);
	//printf(" %d (E? %d) ",to_ff(nActualValue), isLitExistential(nActualValue));    
	// Move on in Cube
    ++nCurrentOffset;
    nActualValue = _vecCubes[nCurrentOffset];
  }
  printf("\n END ");
  //sort(vecCube.begin(), vecCube.end());
  //outputVector(vecCube);

}

void addCubeFromNogood(NoGood * nogood, int nBacktrackLit, int *dplLevelToLit){
 
 vector<int> * vecCube = new vector<int>;
 vecCube->push_back(nBacktrackLit);
 //printf("\n Literal: %d DL: %d MaxIndex: %d ", nBacktrackLit, getReasonDecisionLevel(nBacktrackLit), nogood->maxindex);
 int nMaxUniversalPrefixLevel = getLitPrefixLevel(nBacktrackLit);
 bool bFirstExistential = true;
 int nLit;
 for(int i=nogood->maxindex;i>0;i--) {
	if(nogood->getbit(i))
	{
     nLit = dplLevelToLit[i];
	 //printf("\n Literal: %d DL: %d E?: %d MaxIndex: %d ", nLit, getReasonDecisionLevel(nLit), isLitExistential(nLit), nogood->maxindex);
     if(isLitExistential(nLit))
	 {           
	    vecCube->push_back(nLit);
	 }
	 else {
      vecCube->push_back(nLit); 
	  if(getLitPrefixLevel(nLit) > nMaxUniversalPrefixLevel)
        nMaxUniversalPrefixLevel = getLitPrefixLevel(nLit);
	  bFirstExistential = false;
	 }
	}
	
  }
 
 
 long nCubeOffset = addCubeToDB(vecCube, nMaxUniversalPrefixLevel);
 //outputCube(nCubeOffset);
 //if(vecCube->size() <3)
 // assert(false);
 //assert(false);
}

int resolveCubes(long nCubeOffset1, long nCubeOffset2)
{
  int nActualLiteral;
  int nMaxLiteral              = getMaxLiteral();
  int nMaxUniversalPrefixLevel = -1;
  int nPrefixLevel;

  vector<int> * vecCube = new vector<int>;
 
  stCubeInformation * stCube = new stCubeInformation;

  //bool*_bArrAddedToCube = new bool[nMaxLiteral + 1];
  
  for(int c = 0; c < nMaxLiteral; c++)
  {
   _bArrAddedToCube[c] = false;
  }
  
  int nCurrentOffset = nCubeOffset1;
  int nActualValue = _vecCubes[nCurrentOffset];
  
  // While not end of cube
  while(nActualValue != -1)
  {	   
	_bArrAddedToCube[nActualValue] = true;
    // Move on in Cube
    ++nCurrentOffset;
    nActualValue = _vecCubes[nCurrentOffset];     
  }
  
  nCurrentOffset = nCubeOffset2;
  nActualValue = _vecCubes[nCurrentOffset];
  // While not end of cube
  while(nActualValue != -1)
  {  
	_bArrAddedToCube[nActualValue] = true;
	// Move on in Cube
    ++nCurrentOffset;
    nActualValue = _vecCubes[nCurrentOffset];     
  }
  Lit * lBacktrackLit = NULL;
  int c = 1;
  while(c<nMaxLiteral+1){
    if(((_bArrAddedToCube[c] && !_bArrAddedToCube[c-1])) || (!_bArrAddedToCube[c] && _bArrAddedToCube[c-1]))
	{
		//printf("\n Push %d, %d %d ", c,_bArrAddedToCube[c],_bArrAddedToCube[c-1]);
		Lit * lCurrentLiteral;  
		if(_bArrAddedToCube[c])
		{
		 vecCube->push_back(c);
		 lCurrentLiteral = intTolit(c);  
		}
		else
		{
         vecCube->push_back(c-1);   
		 lCurrentLiteral = intTolit(c-1);  
		}
		if(!isLitExistential(c))
		{
          if(getLitPrefixLevel(c) > nMaxUniversalPrefixLevel)
			nMaxUniversalPrefixLevel = getLitPrefixLevel(c);
		  if(getLitPrefixLevel(c) == nMaxUniversalPrefixLevel)
				  {
                    
					if((lBacktrackLit == NULL) || (lBacktrackLit->assignLevel < lCurrentLiteral->assignLevel))
					  lBacktrackLit = lCurrentLiteral ;
				  }
		}
	}
	if(_bArrAddedToCube[c] && _bArrAddedToCube[c-1])	 
	{
		printf("\n Wrong: %d ", c);
		assert(!isLitExistential(c));
	}
	c = c+2;
  }  
  vecCube = cutTailingExistentialsFromVector(vecCube, nMaxUniversalPrefixLevel);
  outputVectorCube(vecCube);
  if(vecCube->size() == 0)
	  return 0;
  long nCubeOffset = addCubeToDB(vecCube, nMaxUniversalPrefixLevel);
  setCubeInfo(lBacktrackLit->assignLevel, nCubeOffset); 
  // Clean up
  delete vecCube;
  
  return lBacktrackLit->assignLevel;
}


int resolveCubesAtLevel(int nLevel)
{
  if(nLevel == 0)
	  return 0;
  long nCubeOffset1 = getCubeInfo1(nLevel);
  long nCubeOffset2 = getCubeInfo2(nLevel);
  assert(nCubeOffset1 != 0);
  assert(nCubeOffset2 != 0);
  while(nCubeOffset2 != 0) {
   assert(nCubeOffset1 != 0);	
   //outputCube(nCubeOffset1);
   //outputCube(nCubeOffset2);
   //printf("\n In Loop with Level: %d ", nLevel);
   nLevel = resolveCubes(nCubeOffset1,nCubeOffset2);
   if(nLevel == 0)
	   return 0;
   //printf("\n Backtrack to level: %d ", nLevel);
   nCubeOffset1 = getCubeInfo1(nLevel);
   nCubeOffset2 = getCubeInfo2(nLevel);
  }
  return nLevel;
}


inline stCubeInformation * resolveCubesWithOffset(long nCubeOffset1, long nCubeOffset2)
{
  int nActualLiteral;
  int nMaxLiteral              = getMaxLiteral();
  int nMaxUniversalPrefixLevel = -1;
  int nPrefixLevel;
  int nNumberResoveldUniversals = 0;
  vector<int> * vecCube = new vector<int>;
 
  stCubeInformation * stCube = new stCubeInformation;

  //bool*_bArrAddedToCube = new bool[nMaxLiteral + 1];
  for(int c = 0; c < nMaxLiteral; c++)
  {
   _bArrAddedToCube[c] = false;
  }
  
  int nCurrentOffset = nCubeOffset1;
  int nActualValue = _vecCubes[nCurrentOffset];
  
  // While not end of cube
  while(nActualValue != -1)
  {	   
	_bArrAddedToCube[nActualValue] = true;
    // Move on in Cube
    ++nCurrentOffset;
    nActualValue = _vecCubes[nCurrentOffset];     
  }
  
  nCurrentOffset = nCubeOffset2;
  nActualValue = _vecCubes[nCurrentOffset];
  // While not end of cube
  while(nActualValue != -1)
  {  
	_bArrAddedToCube[nActualValue] = true;
	// Move on in Cube
    ++nCurrentOffset;
    nActualValue = _vecCubes[nCurrentOffset];     
  }
  Lit * lBacktrackLit = NULL;
  int c = 1;
  while(c<nMaxLiteral+1){
    if(((_bArrAddedToCube[c] && !_bArrAddedToCube[c-1])) || (!_bArrAddedToCube[c] && _bArrAddedToCube[c-1]))
	{
		//printf("\n Push %d, %d %d ", c,_bArrAddedToCube[c],_bArrAddedToCube[c-1]);
		Lit * lCurrentLiteral;  
		if(_bArrAddedToCube[c])
		{
		 vecCube->push_back(c);
		 lCurrentLiteral = intTolit(c);  
		}
		else
		{
         vecCube->push_back(c-1);   
		 lCurrentLiteral = intTolit(c-1);  
		}
		if(!isLitExistential(c))
		{
          if(getLitPrefixLevel(c) > nMaxUniversalPrefixLevel)
			nMaxUniversalPrefixLevel = getLitPrefixLevel(c);
		  if(getLitPrefixLevel(c) == nMaxUniversalPrefixLevel)
				  {
                    
					if((lBacktrackLit == NULL) || (lBacktrackLit->assignLevel < lCurrentLiteral->assignLevel))
					  lBacktrackLit = lCurrentLiteral ;
				  }
		}
	}
	if(_bArrAddedToCube[c] && _bArrAddedToCube[c-1])	 
	{
		//printf("\n Wrong: %d ", c);
		assert(!isLitExistential(c));
		if(!isLitExistential(c))
		 nNumberResoveldUniversals++;
	}
	c = c+2;
  }
  assert(nNumberResoveldUniversals <= 1);
  stCube->vecCube = cutTailingExistentialsFromVector(vecCube, nMaxUniversalPrefixLevel);
  stCube->lMaxUniversalLit = lBacktrackLit;
  
  //delete_bArrAddedToCube;
  return stCube;
}


inline stCubeInformation * resolveCubesWithVector(long nCubeOffset1, vector<int> * vecOtherCube)
{
  int nActualLiteral;
  int nMaxLiteral              = getMaxLiteral();
  int nMaxUniversalPrefixLevel = -1;
  int nPrefixLevel;
  int nNumberResoveldUniversals = 0;

  vector<int> * vecCube = new vector<int>;
 
  stCubeInformation * stCube = new stCubeInformation;

  //bool*_bArrAddedToCube = new bool[nMaxLiteral + 1];
  for(int c = 0; c < nMaxLiteral; c++)
  {
   _bArrAddedToCube[c] = false;
  }

  vector<int>::iterator vecIter;
  for(vecIter = vecOtherCube->begin();vecIter != vecOtherCube->end(); vecIter++)
  {
   _bArrAddedToCube[*vecIter] = true;
  }
  
  int nCurrentOffset = nCubeOffset1;
  int nActualValue = _vecCubes[nCurrentOffset];
  
  // While not end of cube
  while(nActualValue != -1)
  {	   
	_bArrAddedToCube[nActualValue] = true;
    // Move on in Cube
    ++nCurrentOffset;
    nActualValue = _vecCubes[nCurrentOffset];     
  }
  
  bool bFail = false;
  Lit * lBacktrackLit = NULL;
  int c = 1;
  while(c<nMaxLiteral+1){
    if(((_bArrAddedToCube[c] && !_bArrAddedToCube[c-1])) || (!_bArrAddedToCube[c] && _bArrAddedToCube[c-1]))
	{
		//printf("\n Push %d, %d %d ", c,_bArrAddedToCube[c],_bArrAddedToCube[c-1]);
		Lit * lCurrentLiteral;  
		if(_bArrAddedToCube[c])
		{
		 vecCube->push_back(c);
		 lCurrentLiteral = intTolit(c);  
		}
		else
		{
         vecCube->push_back(c-1);   
		 lCurrentLiteral = intTolit(c-1);  
		}
		if(!isLitExistential(c))
		{
          if(getLitPrefixLevel(c) > nMaxUniversalPrefixLevel)
			nMaxUniversalPrefixLevel = getLitPrefixLevel(c);
		  if(getLitPrefixLevel(c) == nMaxUniversalPrefixLevel)
				  {
                    
					if((lBacktrackLit == NULL) || (lBacktrackLit->assignLevel < lCurrentLiteral->assignLevel))
					  lBacktrackLit = lCurrentLiteral ;
				  }
		}
	}
	if(_bArrAddedToCube[c] && _bArrAddedToCube[c-1])	 
	{
		//printf("\n Wrong: %d ", c);
		if(isLitExistential(c))
		 bFail = true;//assert(!isLitExistential(c));
		else 
		 nNumberResoveldUniversals++;
	}
	c = c+2;
  }  
  stCube->vecCube = cutTailingExistentialsFromVector(vecCube, nMaxUniversalPrefixLevel);
  stCube->lMaxUniversalLit = lBacktrackLit;
  if(bFail)
  {
   outputCube(nCubeOffset1);
   outputVectorCube(vecOtherCube);
   outputVectorCube(vecCube);
   assert(false);
  }
  assert(nNumberResoveldUniversals <= 1);
  delete vecOtherCube;
  //delete_bArrAddedToCube; 
  return stCube;
}



int resolveCubes(int nLevel)
{
  if(nLevel == 0)
	  return 0;
  long nCubeOffset1 = getCubeInfo1(nLevel);
  long nCubeOffset2 = getCubeInfo2(nLevel);
  //printf("\n Starting with level: %d Cubeoffset1: %d Cubeoffset2: %d ", nLevel, nCubeOffset1, nCubeOffset2); 
  stCubeInformation * stCube = resolveCubesWithOffset(nCubeOffset1,nCubeOffset2);
  if(stCube->vecCube->size() == 0)
	  return 0;
  nLevel = stCube->lMaxUniversalLit->assignLevel;
  nCubeOffset1 = getCubeInfo1(nLevel);
  //outputVectorCube(stCube->vecCube);
  while(getCubeInfo1(nLevel) != 0)
  {
   //printf("\n We are at level: %d with Cube Offset: %d ", nLevel, nCubeOffset1);
   
   assert(getCubeInfo2(nLevel) == 0);
   stCube = resolveCubesWithVector(nCubeOffset1,stCube->vecCube);
   //outputVectorCube(stCube->vecCube);
   //outputCube(nCubeOffset1);   
   if(stCube->vecCube->size() == 0)
	  return 0;
   nLevel = stCube->lMaxUniversalLit->assignLevel;
   if(nLevel == 0)
	   return 0;   
   nCubeOffset1 = getCubeInfo1(nLevel);
   //printf("\n nCubeOffset: %d @ level: %d ", nCubeOffset1, nLevel);
  }
  long nCubeOffset = addCubeToDB(stCube->vecCube, getLitPrefixLevel(stCube->lMaxUniversalLit));
  setCubeInfo(stCube->lMaxUniversalLit->assignLevel, nCubeOffset); 
  delete stCube->vecCube;
  delete stCube;
  return nLevel;
}

int computeCubeAndResolve()
{
 stCubeInformation * stCube;
 // Get a cube from the current Solution
 stCube = getCube();
 //outputVectorCube(stCube->vecCube);
 if(stCube->vecCube->size() == 0)
 { 
    //printf("\n Return 0 ");
	return 0;
 }
 else
 {
  int nLevel = stCube->lMaxUniversalLit->assignLevel;
  long nCubeOffset1 = getCubeInfo1(nLevel);
  while(nCubeOffset1 != 0)
  {
   
   if(getCubeInfo2(nLevel) != 0){
    printf("\n We are @level: %d CubeOffset: %d ", nLevel, nCubeOffset1);
   }
   assert(getCubeInfo2(nLevel) == 0);
   //outputVectorCube(stCube->vecCube);
   //outputCube(nCubeOffset1);   
   stCube = resolveCubesWithVector(nCubeOffset1,stCube->vecCube);   
   if(stCube->vecCube->size() == 0)
	  return 0;
   nLevel = stCube->lMaxUniversalLit->assignLevel;
   if(nLevel == 0)
	   return 0;   
   nCubeOffset1 = getCubeInfo1(nLevel);   
  }
  // Add cube to DB
  int nMaxPrefixLevel = getLitPrefixLevel(stCube->lMaxUniversalLit);
  long nCubeOffset = addCubeToDB(stCube->vecCube, nMaxPrefixLevel);
  setCubeInfo(stCube->lMaxUniversalLit->assignLevel, nCubeOffset); 
  // Clean up
  delete stCube->vecCube;
  //printf("\n Deepest universal: %d (E?: %d)", stCube->lMaxUniversalLit->num, isLitExistential(stCube->lMaxUniversalLit));
  // Then return the level of the deepest universal
  return stCube->lMaxUniversalLit->assignLevel;
 }
}





inline int getDecayLiteralCubeInterval()
{
  return _decayLiteralCubeInterval;
}

inline void setDecayLiteralCubeInterval(int nValue)
{
  _decayLiteralCubeInterval = nValue;
}


inline void decayLiteralCubeVarScore()
{
  float nNewScore = 0;
  float nOldScore;
  for(int nLiteral = 2; nLiteral <= NLITS; ++nLiteral)
  {
    // Divide all Literal Scores by 2
    nOldScore = getLiteralCubeScore(nLiteral);
    if(nOldScore > 0)
    {
      nNewScore = nOldScore / 2;
      if(nNewScore == 0)
       nNewScore = 1;
    }
    setLiteralCubeScore(nLiteral, nNewScore);
  }
  _nNumberOfResetCubes == 0;
}

int getNumberOfCubes() {
	return _nNumberOfCubes;
}

int getNumberOfTotalCubes() {
	return _nNumberOfTotalCubes;
}

long getSizeOfCubes() {
	return (sizeof(int) * _vecCubes.size());
}

void setNumberOfCubesPlusOne() {
 _nNumberOfCubes = _nNumberOfCubes + 1; 
}


void removeLearnedCubes() {

 
 // Clear all the Cubeoffsets stored to a literal	
 for(int i=0; i<NLITS; i++)
 {   
   _vecLiteralsInCubes[i]->clear();   
 }
 
 vector<int> vecCubeOffsetsTemp;
 for(int i=0; i<=NVARS + 2; i++)
 {   
	 //printf("\n Index %d %d %d ", i, stCubeOffsets[i]->lCube1, stCubeOffsets[i]->lCube2);
	 if(stCubeOffsets[i]->lCube1 != 0){
		 vecCubeOffsetsTemp.push_back(stCubeOffsets[i]->lCube1);
	 }
	 if(stCubeOffsets[i]->lCube2 != 0){
		 vecCubeOffsetsTemp.push_back(stCubeOffsets[i]->lCube2);
	 }   
 }
 
 //outputVector(vecCubeOffsetsTemp);
 vector<int> vecCubeOffsets;
 vector<int>::iterator newEnd;
 vector<int>::iterator iterVecOffsets;

 //newEnd = unique(vecCubeOffsetsTemp.begin(), vecCubeOffsetsTemp.end());
 for (iterVecOffsets = vecCubeOffsetsTemp.begin(); iterVecOffsets != vecCubeOffsetsTemp.end(); iterVecOffsets++) {
	 vecCubeOffsets.push_back(*iterVecOffsets);
    }

 
//fflush(stdout);
 vector<int> vecCubesRemaining;
 int vecCubesRemainingOffset;
 vecCubesRemaining.push_back(-1);
 
 //printf("\n DONE ");
 //outputVector(vecCubeOffsets);
 //fflush(stdout);

 vector<int> vecRenamedCubeOffsets;
 for(iterVecOffsets = vecCubeOffsets.begin(); iterVecOffsets != vecCubeOffsets.end(); iterVecOffsets++){
  
  vecCubesRemainingOffset = vecCubesRemaining.size();
  vecRenamedCubeOffsets.push_back(vecCubesRemainingOffset);
  //printf("\n Current Offset %d ", *iterVecOffsets);
  //fflush(stdout);
  int nCurrentOffset = *iterVecOffsets;
  
  int nActualValue = _vecCubes[nCurrentOffset];
  // While not end of cube
  while(nActualValue != -1)
  {     
	vecCubesRemaining.push_back(nActualValue);
	if(!isLitExistential(nActualValue)) {
     // Add Cube Offset to Literal
	 //printf("\n Adding Cube Offset %d to Literal %d ",vecCubesRemainingOffset, nActualValue); 
     addLiteralinCube(nActualValue, vecCubesRemainingOffset); 
	}
	// Move on in Cube
    ++nCurrentOffset;
    nActualValue = _vecCubes[nCurrentOffset];
  }
  vecCubesRemaining.push_back(-1);
 }
 //printf("\n DONE ");
 //assert(false); 

 _vecCubes.clear();
 vector<int>::iterator iterVec;
 vector<int>::iterator iterVecInner;
 for(iterVec = vecCubesRemaining.begin(); iterVec != vecCubesRemaining.end(); iterVec++) {
   _vecCubes.push_back(*iterVec);
 }
 _nNumberOfCubes = vecCubeOffsets.size();
 
 //printf("\n DONE ");
 //assert(false);

 for(int i=0; i<=NVARS + 2; i++)
 {   
	 bool bDone = false;
	 if(stCubeOffsets[i]->lCube1 != 0){
		//set<int>::iterator iterSet1;
		int nCount = 0;
		for(iterVecInner = vecCubeOffsets.begin(); iterVecInner != vecCubeOffsets.end(); iterVecInner++){
			if(*iterVecInner == stCubeOffsets[i]->lCube1) {
				//printf("\n Cube Offset %d (%d) and nCount %d ", *iterSet, stCubeOffsets[i]->lCube1, nCount);
				bDone = true;
				break;
			}
			if(!bDone)
			 nCount++;
		}
		assert(bDone);
		//printf("\n -> Setting Cube %d to %d ", stCubeOffsets[i]->lCube1, vecRenamedCubeOffsets[nCount]);
        stCubeOffsets[i]->lCube1 = vecRenamedCubeOffsets[nCount];
	 }
	 bDone = false;
	 if(stCubeOffsets[i]->lCube2 != 0){
		//set<int>::iterator iterSet1;
		int nCount = 0;
		for(iterVecInner = vecCubeOffsets.begin(); iterVecInner != vecCubeOffsets.end(); iterVecInner++){
			if(*iterVecInner == stCubeOffsets[i]->lCube2) {		
				//printf("\n Cube Offset %d (%d) and nCount %d ", *iterSet, stCubeOffsets[i]->lCube2, nCount);
				bDone = true;
				break;
			}
			if(!bDone)
			 nCount++;
		}
		assert(bDone);
		//printf("\n -> Setting Cube %d to %d ", stCubeOffsets[i]->lCube1, vecRenamedCubeOffsets[nCount]);
        stCubeOffsets[i]->lCube2 = vecRenamedCubeOffsets[nCount];
	 }   
 }
 //printf("\n HERE ");
 //printf("\n DONE ");
 //assert(false);
 // Now adjust the watches...
 for(int i=0; i<NLITS; i++)
 {

  vector<int>* vecCurrentWatches = _vecLiteralCubeWatches[i];
  vector<int>* vecNewWatches = new vector<int>;
  vector<int>::iterator iterVec, iterVecInner;
  
  for(iterVec = vecCurrentWatches->begin(); iterVec != vecCurrentWatches->end(); iterVec++) {
      //iterSet = setCubeOffsets.find(*iterVec);
	  iterVecInner = vecCubeOffsets.begin();
	  bool bFound = false;
	  int  nCount = 0;
	  while(iterVecInner != vecCubeOffsets.end()) {
		  if(*iterVec == *iterVecInner) {
			  bFound = true;
		  }
		  iterVecInner++;
		  if(!bFound)
           nCount++;
	  }
	  if(bFound) {
        vecNewWatches->push_back(vecRenamedCubeOffsets[nCount]);
	  }	  
  }
  
  _vecLiteralCubeWatches[i] = vecNewWatches;
  
  delete vecCurrentWatches;
 }
 //outputVector(_vecLiteralsInCubes[26]);
 
}


