/*

2clsQ. Copyright Horst Samulowitz and Fahiem Bacchus 2006

 A DPLL QBF solver based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to
implied warranties of merchantability and fitness for a particular
purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Fahiem Bacchus },
	year    = { 2006 },
	title   = { {2clsQ} a {DPLL} solver employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/


#include "2clsEq.h"
#include "undo.h"
#include "binaryClauses.h"
#include "naryClauses.h"
#include "resolve.h"

/*******************************************************************
 The resolution and unit prop code.
******************************************************************/
#ifdef _PARANOIA
int upcount=0;
#endif _PARANOIA

//bool TRACE=false;
void UnitProp(int l) {
  //Unit propagate the literal l.
  //Take advantage of the fact that the binary theory is closed.
  //so all consequences of UP are contained in the binary clauses.
  //---No other literals can be forced.
  Lit *L=intTolit(l);
  Lit *NotL=intTolit(negate(l));
  BinLitCls* pb;

  //if(getLitdagnode(L)==NULL)
  //printf("!!");

#ifdef _PARANOIA
  upcount++;
#endif _PARANOIA

#ifdef _TRACE
  printf("=>UP(%d) (E? %d)\n", to_ff(l), isLitExistential(l));
  //printf("=>UP(%d)\n", to_ff(l));
  printLit(L);
  printLit(NotL);
#endif _TRACE
  //Check value of literal.
  if(isTrue(L)) {
#ifdef _TRACE
    printf("<=UP(%d)-Already T.\n",to_ff(l));
#endif _TRACE
    return;
  }
  else if(isFalse(L)) {
#ifdef _TRACE
    printf("<=UP(%d)-CONTRADICTION.\n",to_ff(l));
#endif _TRACE
    setContradiction(getLitdagnode(L),getLitdagnode(negate(L)));
    return;
  }
  // Do we propagate a universal...
  if(!isLitExistential(L))
  {
    DAG *dnode= getLitdagnode(L);
    // ... that is not a decision literal? 
    if((dnode->type!=CHOICE))// && (dnode->type!=PURE) && (dnode->type!=NOGOOD))
    {
     printf("\n XXXTrying to propagate: %d (Dnode: %d)", L->num, dnode->type);
     //printf("\n XXXTrying to propagate: %d ", L->num);
     setContradiction(getLitdagnode(L), getLitdagnode(L));
	 return;
    }
  }
  //if((l==144) || (l==145) || (l==142) || (l==143) || (L->num == 385) || (L->num == 331) || (L->num == 329))
	//  printf("\n=>UP(%d) (E? %d) at level: %d ", l, isLitExistential(l), LEVEL);
  //Set truth values.
  for(pb=&(NotL->twoClauses);pb->pnext;pb=pb->pnext) {
    if(upstack->member(negate(pb->otherlit->num))) {
		//printf("\n Setting literal forced from binary clause: %d (%d)", pb->otherlit->num, to_ff(pb->otherlit));
      setContradiction(allocDAGNODE_NORMAL(getLitdagnode(L),pb->dagnode),
		      getLitdagnode(negate(pb->otherlit)));
      return;
    }
	// Be careful when propagating the 'other' literal since the first literal is always the negation of L
	// Fail if a universal is forced
	if((abs(to_ff(pb->otherlit->num)) != abs(to_ff(L->num))) && (!isLitExistential(pb->otherlit)))
	{
	 //printf("\n (Contradiction) Setting UNIVERSAL literal forced from binary clause: %d (%d) (Forced by: %d)", pb->otherlit->num, to_ff(pb->otherlit), to_ff(L->num));
     //printf("\n XXX Setting literal forced from binary clause: %d (%d)", pb->otherlit->num, to_ff(pb->otherlit));
	 setContradiction(getLitdagnode(L), pb->dagnode);
	 return;
	}
	else
	{
     markundoLitAssign(pb->otherlit);
	 // Set Lit 
	 //if((l==144) || (l==145) || (l==142) || (l==143))
	  //printf("\n Setting literal forced from binary clause: (%d %d (%d)) (%d)", NotL->num, pb->otherlit->num,negate(pb->otherlit->num), to_ff(pb->otherlit));
     setLitTrue(pb->otherlit);
	 markundoLitdagnode(pb->otherlit);
	 setLitdagnode(pb->otherlit,
		      allocDAGNODE_NORMAL(getLitdagnode(L),
					  pb->dagnode));
	}
  }

  //Delink all true clauses.
#ifdef _TRACE
  printf("==UP: delinking True clauses.\n");
#endif _TRACE
  for(pb=&(NotL->twoClauses);pb->pnext;pb=pb->pnext) {
    Lit *plit=pb->otherlit;
    for(LitCls *pNclauses=plit->nClauses.pnext;
	pNclauses->pnext;
	pNclauses=plit->nClauses.pnext) {
      //for each true lit, we delink all of its clauses
      markundoClauseTrue(pNclauses->pcls);
      delinkNClause(pNclauses->pcls);
    }
    for(BinLitCls *pBclauses=plit->twoClauses.pnext;pBclauses->pnext;
	pBclauses=pBclauses->pnext)
      //for each true lit, we delink all of its binary clauses
      //in active lits.
      if(isUnvalued(pBclauses->otherlit)) {
	    markundoBclause(pBclauses->otherlinks);
	    delinkBclause(pBclauses->otherlinks);
      }
  }

  //Delink false literals from all n-ary clauses. For Binary clauses,
  //the other literal has already been forced, so we do not need to
  //do anything.
#ifdef _TRACE
  printf("==UP: delinking false lits.\n");
#endif _TRACE
  // Horst: Add Universal Reduction
  //if((l == 100) || (l == negate(100)))
	//  printf("\n Delinking %d from false Clauses! ", l);
  bool bResult = removeLiteralandApplyUniversalReduction(l);

  /*for(pb=&(NotL->twoClauses);pb->pnext;pb=pb->pnext) {
    //get lit's negation which has become False.
    Lit *plit=negate(pb->otherlit);
    for(LitCls *pNclauses=plit->nClauses.pnext;
	pNclauses->pnext;
	pNclauses=pNclauses->pnext) {
      markundoClsLit(pNclauses->linkincls);
      delinkClsLit(pNclauses->linkincls);

      markundoClsDAG(pNclauses->pcls);
      pNclauses->pcls->dagnode=
	allocDAGNODE_NORMAL(pNclauses->pcls->dagnode,
		     allocDAGNODE_NORMAL(pb->dagnode,getLitdagnode(L)));
      if(pNclauses->pcls->len == 2)
	convertToBinaryClause(pNclauses->pcls);
      else
	if(DOHYP)
	  clsToChk->pushnew(pNclauses->pcls->num);
    }
  }*/

#ifdef _TRACE
  printf("<=UP(%d)\n", to_ff(l));
#endif _TRACE
}

