/*

2clsQ. Copyright Horst Samulowitz and Fahiem Bacchus 2006

 A DPLL QBF solver based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to
implied warranties of merchantability and fitness for a particular
purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Fahiem Bacchus },
	year    = { 2006 },
	title   = { {2clsQ} a {DPLL} solver employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/


#include "2clsEq.h"
#include "binaryClauses.h"
#include "naryClauses.h"
#include "resolve.h"
#include "solutions.h"

/********************************************************
  Resolve binary clauses
********************************************************/


void makeEquivalences(EQS* eqbuf, int nSizeOfBuf);
bool makeeq(Lit* x, Lit* l, DAG* dagnode);
int inline getEquivalentLit(vector<int> *vecLiterals);
EQS* eqbuf;

void resolvebcls(bcls *pbcls) {
  //Resolve a binary clause. Should be called only if upstack is empty.
  //I.e. there are no pending truth assignments.

  bclsResolved++;

  int l1=pbcls->l1;
  int l2=pbcls->l2;
  DAG* dagnode=pbcls->dagnode;
  DAG* dnode1;
  deallocbcls(pbcls);

#ifdef _TRACE
  printf("\n =>R2CL(%d[%c],%d[%c]).",
	 l1, ff_tval((THELITS+l1)->val),
	 l2, ff_tval((THELITS+l2)->val));
#endif

  Lit *NotL1=THELITS+negate(l1);
  Lit *L1=THELITS+l1;
  Lit *NotL2=THELITS+negate(l2);
  //  bucket *pbuc = L1->litHtable;
  //  bucket *notpbuc = NotL1->litHtable;
  //1. check for staleness.
  if(isFalse(l1) && isFalse(l2)) {
    setContradiction(getLitdagnode(NotL1),
		     allocDAGNODE_NORMAL(getLitdagnode(NotL2),dagnode));
    return;
  }
  //  if(isTrue(l1)||isTrue(l2)||HvalhaveBclause(pbuc,l2,RESOLVED)) {
  //  if(isTrue(l1)||isTrue(l2)||haveBclause(pbuc,l2)) {
  if(isTrue(l1)||isTrue(l2)||haveBclause(L1,l2)) {
    return;
  }

  //2. check for predecessors resolutions making this generate
  //   a unitprop
  if(isFalse(l1)) {
	  //printf(" X 16 X ");
    pushupstack(l2,allocDAGNODE_NORMAL(getLitdagnode(NotL1),dagnode));
    return;
  }

  // Horst: Adding universal reduction
  // If literal l1 is not existential and if the prefix level is bigger than the one of l2
  // we can directly propagate l2
  // Also fail if we have two universals only...
  if(!isLitExistential(l2) && (!isLitExistential(l1))) {
	  //printf(" X 19 X ");
      setContradiction(dagnode,dagnode); 
	  //pushupstack(l1,allocDAGNODE_NORMAL(dagnode, dagnode));
	//assert(dagnode->type == 0);
    return;
  }
  else if((!isLitExistential(l1)) && (getLitPrefixLevel(l1) > getLitPrefixLevel(l2))) {
	  //printf(" X 17 X ");
    pushupstack(l2,allocDAGNODE_NORMAL(dagnode, dagnode));
    return;
  }
  else if((!isLitExistential(l2)) && (getLitPrefixLevel(l2) > getLitPrefixLevel(l1))) {
	  //printf(" X 18 X ");
    pushupstack(l1,allocDAGNODE_NORMAL(dagnode, dagnode));
    return;
  }
  
  // END

  //  if(DNodehaveBclause(notpbuc,l2,dnode1)) {
  if(DNodehaveBclause(NotL1,l2,dnode1)) {
	  //printf(" X 20 X ");
    pushupstack(l2,allocDAGNODE_NORMAL(dagnode,dnode1));
    return;
  }
  if(isFalse(l2)) {
	  //printf(" X 21 X ");
    pushupstack(l1,allocDAGNODE_NORMAL(getLitdagnode(NotL2),dagnode));
    return;
  }
  //  if(DNodehaveBclause(pbuc,negate(l2),dnode1)) {
  if(DNodehaveBclause(L1,negate(l2),dnode1)) {
	  //printf(" X 22 X ");
    pushupstack(l1,allocDAGNODE_NORMAL(dagnode,dnode1));
    return;
  }

  //3. create all the new 2-clauses
  BinLitCls* pb1;
  BinLitCls* pb2;

  bool unit;
  //printf("\n Lists of not-L1: %d not-L2: %d ", NotL1->num, NotL2->num);
  
  for(pb1=&(NotL1->twoClauses);pb1->pnext;pb1=pb1->pnext) {
    // pbuc=pb1->otherlit->litHtable;
    //notpbuc=negate(pb1->otherlit)->litHtable;
    for(pb2=&(NotL2->twoClauses);pb2->pnext;pb2=pb2->pnext) {
	  //if(L1->num == 143)
	   //printf("\n oL1: %d oL2: %d ", pb1->otherlit->num, pb2->otherlit->num);
      
	  if(pb1->otherlit==pb2->otherlit) {
		  //printf(" X 0 X ");
	pushupstack(pb1->otherlit->num,
		    allocDAGNODE_NORMAL(dagnode,
					allocDAGNODE_NORMAL(pb1->dagnode,pb2->dagnode)));
	break;
      }
      //      else if(DNodehaveBclause(pbuc,negate(pb2->otherlit->num),dnode1)) {
      else if(DNodehaveBclause(pb1->otherlit,negate(pb2->otherlit->num),dnode1)) {
		  //printf(" X 1 X ");
	pushupstack(pb1->otherlit->num,
		    allocDAGNODE_NORMAL(dagnode,
					allocDAGNODE_NORMAL(pb1->dagnode,
							    allocDAGNODE_NORMAL(pb2->dagnode,dnode1))));
	break;
      }
      //      else if(DNodehaveBclause(notpbuc,pb2->otherlit->num,dnode1))
      else if(DNodehaveBclause(negate(pb1->otherlit),pb2->otherlit->num,dnode1))
	  {
		  //printf(" X 2 X ");
	     pushupstack(pb2->otherlit->num,
		        allocDAGNODE_NORMAL(dagnode,
			  		  allocDAGNODE_NORMAL(pb1->dagnode,
							    allocDAGNODE_NORMAL(pb2->dagnode,dnode1))));
	  }
      //      else if(!HvalhaveBclause(pbuc,pb2->otherlit->num,RESOLVED)) {
      //	  else if(!haveBclause(pbuc,pb2->otherlit->num)) {
    else if(!haveBclause(pb1->otherlit,pb2->otherlit->num)) {
        
		bool bForceInner = false;
		// Horst
		if(!isLitExistential(pb1->otherlit))
		{
		 if(!isLitExistential(pb2->otherlit))
		 {
		  //pushupstack(pb1->otherlit->num,
			//	allocDAGNODE_NORMAL(dagnode,
			//			allocDAGNODE_NORMAL(pb1->dagnode,
			//						allocDAGNODE_NORMAL(pb2->dagnode,dnode1))));
          DAG * dagnode2 = allocDAGNODE_NORMAL(dagnode,allocDAGNODE_NORMAL(pb1->dagnode,allocDAGNODE_NORMAL(pb2->dagnode,dnode1)));
		  //printf("\n 1 Universal Reduction in Resolve BC (L1: %d E: %d PL: %d; L2: %d E: %d PL: %d) ", pb1->otherlit->num, isLitExistential(pb1->otherlit), getLitPrefixLevel((pb1->otherlit)), pb2->otherlit->num, isLitExistential(pb2->otherlit), getLitPrefixLevel((pb2->otherlit)));
		  setContradiction(dagnode2,dagnode2);		  
		 }
		 else if(getLitPrefixLevel((pb1->otherlit)) > getLitPrefixLevel((pb2->otherlit)))
		 {
			  //printf(" X 3 X ");
		  pushupstack(pb2->otherlit->num,
				allocDAGNODE_NORMAL(dagnode,
						allocDAGNODE_NORMAL(pb2->dagnode,
									allocDAGNODE_NORMAL(pb1->dagnode,dnode1))));		  
		  
		  //printf("\n 2 Universal Reduction in Resolve BC (L1: %d E: %d PL: %d; L2: %d E: %d PL: %d) ", pb1->otherlit->num, isLitExistential(pb1->otherlit), getLitPrefixLevel((pb1->otherlit)), pb2->otherlit->num, isLitExistential(pb2->otherlit), getLitPrefixLevel((pb2->otherlit)));
		  bForceInner = true;
		  //break;
		 }
		}
		else if(!isLitExistential(pb2->otherlit))
		{		 
		 if(getLitPrefixLevel((pb2->otherlit)) > getLitPrefixLevel((pb1->otherlit)))
		 {
			 //printf(" X 4 X ");
		  pushupstack(pb1->otherlit->num,
				allocDAGNODE_NORMAL(dagnode,
						allocDAGNODE_NORMAL(pb1->dagnode,
									allocDAGNODE_NORMAL(pb2->dagnode,dnode1))));		  
		  
		  //printf("\n 3 Universal Reduction in Resolve BC (L1: %d E: %d PL: %d; L2: %d E: %d PL: %d) ", pb1->otherlit->num, isLitExistential(pb1->otherlit), getLitPrefixLevel((pb1->otherlit)), pb2->otherlit->num, isLitExistential(pb2->otherlit), getLitPrefixLevel((pb2->otherlit)));		  
		  // !!!!!!!!!!!!!!
		  // CHANGED: 22.1. Instead of 'break' now set bForceInner = true (same case as 2!)
		  // !!!!!!!!!!!!!!
		  bForceInner = true;
		  //break;
		 }
		}			
		if(!bForceInner)
		{
		  dnode1 = allocDAGNODE_NORMAL(dagnode,allocDAGNODE_NORMAL(pb1->dagnode,pb2->dagnode));
			// END HORST
			if((!CONTRADICTION.val))
			{
			 //assert(isLitExistential(pb1->otherlit) || isLitExistential(pb2->otherlit));
			 addBclause(pb1->otherlit,pb2->otherlit,dnode1);
			   //if((((pb1->otherlit->num == 197) && (pb2->otherlit->num == 647))
			   // || ((negate(pb1->otherlit->num) == 197) && (negate(pb2->otherlit->num) == 647)))
			   //|| (((pb1->otherlit->num == 197) && (pb2->otherlit->num == 640))
			   //|| ((negate(pb1->otherlit->num) == 197) && (negate(pb2->otherlit->num) == 640))))
			 //if(((negate(pb1->otherlit->num) == 931) || (pb1->otherlit->num == 931) || (pb2->otherlit->num == 2752) || (negate(pb2->otherlit->num) == 2752)) && (getNumberOfNoGoods() >= 36000)){
			//	 printf("\n Started with %d (FF: %d) %d (FF: %d) ", l1, l2, to_ff(l1), to_ff(l2));
			//	 printf("\n -> NEW Binary Clause [%d (PL: %d) %d (PL: %d)]",pb1->otherlit->num, getLitPrefixLevel(pb1->otherlit->num),pb2->otherlit->num, getLitPrefixLevel(pb2->otherlit->num)); 					
			// }
			 if(DOHYP)
			 { 
			  //printf("\n Lit1 %d (E?: %d PL: %d) Lit2 %d (E?: %d PL: %d) ", pb1->otherlit->num, isLitExistential(pb1->otherlit), getLitPrefixLevel(pb1->otherlit), pb2->otherlit->num, isLitExistential(pb2->otherlit), getLitPrefixLevel(pb2->otherlit));
			  pushclschkstack(pb1->otherlit,pb2->otherlit);
			 }
			}
		}
	}
    if(CONTRADICTION.val)
	 return;
	}
  }

  if (DOEQS) {
    //test for generated equivalence.
    int topeqbuf=0;
    int i;

    //  pbuc = L1->litHtable;
    //  if(isUnvalued(L1) && HvalhaveBclause(negate(l1),negate(l2),RESOLVED)) {
    // Horst
    vector<int> *vecEqLiterals;
    vecEqLiterals = new vector<int>;
    // End: Horst
	if(isUnvalued(L1) && haveBclause(negate(l1),negate(l2))) {
      for(pb1=NotL1->twoClauses.pnext;pb1->pnext;pb1=pb1->pnext) {
	      if(haveBclause(L1,negate(pb1->otherlit->num))) {
          // Horst
		  //printf("\n Lit: %d Other Lit: %d ", L1->num, negate(pb1->otherlit->num));
          vecEqLiterals->push_back(pb1->otherlit->num);		  
          // End: Horst
		  }
	  }

      // Horst
      vecEqLiterals->push_back(L1->num);
      // End: Horst

      //eqbuf[topeqbuf].L=L1;
      //topeqbuf++;
      #ifdef _TRACE
      printf("\n Equivalent Literal: %d (Existential? %d) ", L1->num, isLitExistential(L1->num));
      printf("\n Literal in Buffers (L1: %d) : ", L1->num);
      for(i=0;i<topeqbuf;i++) {
        printf(" %d",eqbuf[i].L->num);
      }
      printf("\n EqLit %d ", getEquivalentLit(vecEqLiterals));
      #endif _TRACE
      int nEqLit      = getEquivalentLit(vecEqLiterals);
      Lit * lEqLit    = intTolit(nEqLit);
      Lit * lEqNotLit = intTolit(negate(nEqLit));

	  if(vecEqLiterals->size() > 1) {
       for(pb1=lEqNotLit->twoClauses.pnext;pb1->pnext;pb1=pb1->pnext) {
         if(DNodehaveBclause(lEqLit,negate(pb1->otherlit->num),dnode1)) {
          eqbuf[topeqbuf].L=pb1->otherlit;
          //bclause negate(pb1->otherlit),L1 is reason pb1->otherlit
          //can be replaced by L1.
          eqbuf[topeqbuf].dagpos=dnode1;
          //bclause NotL1,pb1->otherlit is reason negate(pb1->otherlit)
          //can be replaced by NotL1.
          eqbuf[topeqbuf].dagneg=pb1->dagnode;
          topeqbuf++;
         }
        }
      
		  int nEqualities = 0;
		  for(i=0;i<topeqbuf;i++) {
		   eqsfound++;
		   if(eqbuf[i].L != lEqLit){
			lEqLit->vecEquivalences.push_back(eqbuf[i].L->num); 
			lEqNotLit->vecEquivalences.push_back(negate(eqbuf[i].L)->num);
			nEqualities++;
		   }
		   //if((lEqLit->num == 143) || (lEqLit->num == 142))
			//   printf("\n Make equal: %d %d (Started with: %d (PL: %d, E?: %d))", lEqLit->num, eqbuf[i].L->num, L1->num, getLitPrefixLevel(L1), isLitExistential(L1));
		   bool bReturnValue = makeeq(eqbuf[i].L,lEqLit,eqbuf[i].dagpos);
		   if(bReturnValue)
			bReturnValue = makeeq(negate(eqbuf[i].L),lEqNotLit,eqbuf[i].dagneg);
		   else
			 return;
		   if(!bReturnValue)
	 		 return;  
	        
		  }
		  // ******************************************************
		  // Do this for the Cube-Watches	
		  //printf("\n XXXXXXX Lit: %d NotLit: %d Size: %d #Eq: %d ", lEqLit->num, lEqNotLit->num, lEqLit->vecEquivalences.size(), nEqualities - 1);
		  //outputVector(lEqLit->vecEquivalences);
		  //outputVector(lEqNotLit->vecEquivalences);
		  /*stEqInformation * stEqInfo1 = new stEqInformation;
		  stEqInfo1->lLit = lEqLit;
		  stEqInfo1->nEquivalences = nEqualities;
		  markundoEquivalences(stEqInfo1);
          
		  stEqInformation * stEqInfo2 = new stEqInformation;
		  stEqInfo2->lLit = lEqNotLit;
		  stEqInfo2->nEquivalences = nEqualities;
		  markundoEquivalences(stEqInfo2); */

		  // *******************************************************
	  }
	  
      //assert(false);
    }
  }

#ifdef _TRACE
  printf("<=R2CL(%d[%c],%d[%c]).\n",
	 to_ff(l1), ff_tval((THELITS+l1)->val),
	 to_ff(l2), ff_tval((THELITS+l2)->val));
#endif _TRACE
}

bool makeeq(Lit* x, Lit* l, DAG* dagnode) {
  //rewrite all nary clauses containing x to contain l.
  //Then delink all b-clauses with x.
#ifdef _TRACE
  printf("=>makeeq(%d (E? %d) <=%d (E? %d))\n",to_ff(l->num), isLitExistential(l), to_ff(x->num), isLitExistential(x));
  //printLit(x);
  //printLit(l);
#endif _TRACE
  //return;
  //assert(false);
  // Horst: Case ADDED
  /*if(x == l)
   return;
  if(x == negate(l))
   return; */
  // END
  assert(x != l);
  assert(x != negate(l));

  if(isValued(x) || upstack->member(x->num)||upstack->member(negate(x)->num))
    return true;
  markundoEq(x);

  x->equivlit=l;
  x->dagEqnode=dagnode;
  LitCls *plc;

  for(LitCls *pNclauses=x->nClauses.pnext;pNclauses->pnext;) {
    //must move pointer along inside of loop
    if(inClause(l,pNclauses->pcls)) {
      // Remove x from clause
      markundoClsLit(pNclauses->linkincls);
      delinkClsLit(pNclauses->linkincls);
	  // Add universal Reduction
	  removeLiteralandApplyUniversalReductionOnClauseDuringEquality(pNclauses->pcls);
	  
	  markundoClsDAG(pNclauses->pcls);
      pNclauses->pcls->dagnode=allocDAGNODE_NORMAL(pNclauses->pcls->dagnode,dagnode);
      if(pNclauses->pcls->len == 2)
	    convertToBinaryClause(pNclauses->pcls);
	  if(haveContradiction())
	   return false;	  
	  pNclauses=pNclauses->pnext;
    }
    else if(inClause(negate(l),pNclauses->pcls)) {
      plc=pNclauses;
      pNclauses=pNclauses->pnext;
      markundoClauseTrue(plc->pcls);
      delinkNClause(plc->pcls);
	  // No need for universal reduction since clause is true anyway
    }
    else {
      plc=pNclauses;
      pNclauses=pNclauses->pnext;
      markundoLitClsmove(plc,x);
      //delink from x.
      delinkLitCls(plc);
      //change to l
      plc->linkincls->plit=l;
      //relink to l
      relinkLitCls(plc, l);
	  // After we replaced x by l we apply universal reduction to the new clause
	  removeLiteralandApplyUniversalReductionOnClauseDuringEquality(plc->pcls); 
      markundoClsDAG(plc->pcls);
      plc->pcls->dagnode=allocDAGNODE_NORMAL(plc->pcls->dagnode,dagnode);
	  if(plc->pcls->len == 2)
	    convertToBinaryClause(plc->pcls);
      if(haveContradiction())
	   return false;	   
    }
  }
  //Now unlink all binary clauses containing x.
  for(BinLitCls *pBclauses=x->twoClauses.pnext;pBclauses->pnext;
      pBclauses=pBclauses->pnext)
    //for each true lit, we delink all of its binary clauses
    //in active lits.
    if(isUnvalued(pBclauses->otherlit)) {
      markundoBclause(pBclauses->otherlinks);
      delinkBclause(pBclauses->otherlinks);
    }

   if(haveContradiction())
	   return false;	  
   else return true;

#ifdef _TRACE
  //printLit(x);
  //printLit(l);
  printf("<=makeeq(%d<-%d)\n",to_ff(x->num), to_ff(l->num));
#endif _TRACE
}


int inline getEquivalentLit(vector<int> *vecLiterals)
{
   #ifdef _TRACE
   printf("=> makeEquivalence\n");
   #endif _TRACE
   //assert(false);
   int i;
   int nUniversals = 0;
   int lUniversal;
   int nMaxExistentialNum = -1;
   int lMaxExistential;
   int nMinExistentialPrefixLevel = 1000000;
   int nMinUniversalPrefixLevel   = 1000000;
   int nLiteral;
   vector<int>::iterator iterLits;
   //printf("\n Equivalen Lits: ");
   
   //for(iterLits = vecLiterals->begin(); iterLits != vecLiterals->end(); ++iterLits)
	// {
	//	 printf(" Lit: %d PL: %d E?: %d L: %d ", *iterLits, getLitPrefixLevel(*iterLits), isLitExistential(*iterLits), intTolit(*iterLits)->assignLevel);
	// }
   for(iterLits = vecLiterals->begin(); iterLits != vecLiterals->end(); ++iterLits) {
     nLiteral = *iterLits;

     if((isLitExistential(nLiteral)) && (getLitPrefixLevel(nLiteral) <= nMinExistentialPrefixLevel))
     {
       nMinExistentialPrefixLevel = getLitPrefixLevel(nLiteral);
       if(nLiteral > nMaxExistentialNum)
        lMaxExistential = nLiteral;
     }
     if((!isLitExistential(nLiteral)) && (getLitPrefixLevel(nLiteral) <= nMinUniversalPrefixLevel))
     {
       nMinUniversalPrefixLevel = getLitPrefixLevel(nLiteral);
     }
     if(!isLitExistential(nLiteral))
     {
      nUniversals++;
      lUniversal = nLiteral;
     }
   }
   // If there is more than one universal we have to fail
   if(nUniversals > 1)
   {
     for(iterLits = vecLiterals->begin(); iterLits != vecLiterals->end(); ++iterLits)
	 {
		 printf(" Lit: %d PL: %d E?: %d ", *iterLits, getLitPrefixLevel(*iterLits), isLitExistential(*iterLits));
	 }	 
	 assert(false);
   }
   // If there is one universal and it is tailing we have to fail too
   else if((nUniversals == 1) && (nMinUniversalPrefixLevel > nMinExistentialPrefixLevel)) {
	 printf("\n FAIL here ");
	 for(iterLits = vecLiterals->begin(); iterLits != vecLiterals->end(); ++iterLits)
	 {
		 printf(" Lit: %d (FF: %d) PL: %d E?: %d ", *iterLits, to_ff(*iterLits), getLitPrefixLevel(*iterLits), isLitExistential(*iterLits));
	 }
    assert(false);
   }
   else if(nUniversals == 1) {
      return lUniversal;
   }
   else if(nUniversals == 0){
     return lMaxExistential;
   }
   #ifdef _TRACE
   printf("=>makeEquivalence\n");
   #endif _TRACE
}






