/*

2clsQ. Copyright Horst Samulowitz and Fahiem Bacchus 2006

 A DPLL QBF solver based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to
implied warranties of merchantability and fitness for a particular
purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Fahiem Bacchus },
	year    = { 2006 },
	title   = { {2clsQ} a {DPLL} solver employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/
#include "2clsEq.h"
#include "binaryClauses.h"
#include "naryClauses.h"
#include "resolve.h"

bool DOEQS;
bool DOHYP;
/*******************************************************************
 The resolution
 ******************************************************************/
typedef struct clslst {
  clslst *pnext;
  Clause *c;
} clslst;

UniqueSet *upstack;
//MultiSet *litbuf;
UniqueSet *litbuf;
UniqueSet *clsToChk;

//dynamic stack for binary clauses
bcls *pbclsalloc=NULL;
bcls *pbclstack=NULL;
bcls *pclschkstack=NULL;

int sizebclsstack=0;
int sizeclschkstack=0;
int HIGHESTBTLEVEL;
int DEEPESTLEVEL;
int MRFailedLit; 


//Initialization routine
void initResolver() {
  pbclsalloc=NULL;
  pbclstack=NULL;
  pclschkstack=NULL;
  clsToChk = new UniqueSet(NCLAUSES);
  litbuf = new UniqueSet(NLITS);
  upstack = new UniqueSet(NLITS);
  eqbuf = new EQS[NLITS/2];

  if(!clsToChk || !litbuf || !upstack || !eqbuf)
    panic("Memory Allocation Failure #24\n");

  LEVEL=0;
}

//Some background storage allocation routines.
//Binary clauses
void Makebclstore() {
  bcls *pb = new bcls[NLITS*BCLSALLOCFACTOR];
  if(!pb)
	panic("Memory Allocation Failure #25\n");
  pbclsalloc = pb;
  //now link the new array.
  for(int i=0;i<NLITS*BCLSALLOCFACTOR;i++) {
    pb->pnext=pb+1;
    pb++;
  }
  //fix the last pointer
  (--pb)->pnext=NULL;
}

