/*

2clseq. Copyright Fahiem Bacchus 2000--2002

 A DPLL solver based on performing extensive reasoning with the binary
 clause subtheory. Pronounced "Two" "Clause" "Eq"

Version 2.0.

The software available at this site is copyright (c) 2000-2002 Fahiem
Bacchus. All right are reserved. Use of this software is permitted for
non-commercial research purposes, and it may be copied only for that
use. All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Fahiem Bacchus and the University of Toronto make
no warranties, express or implied, including but not limited to
implied warranties of merchantability and fitness for a particular
purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Bacchus:2clseq,
	author  = { Fahiem Bacchus },
	year    = { 2002 },
	title   = { {2clseq} a {DPLL} solver employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/2clseq.html }
}

*/

#ifndef __resolver_H
#define __resolver_H

//#include <stdlib.h>
//#include <stdio.h>



#include "binaryClauses.h"
#include "naryClauses.h"
#include "uniqueset.h"
#include "stats.h"
#include "dag.h"
#include "nogood.h"
#include "nogoodDB.h"


// Horst: Use assert include
//#include <assert>
// END

#include <vector>
//#include <set>

using namespace std;

extern bool DOEQS;
extern bool DOHYP;
extern bool DOLPB;



void DoPruneBacks(NoGood *ng, int lt, int btlevel);

/*******************************************************************
The resolution
******************************************************************/
typedef struct bcls {
  bcls *pnext;
  int l1,l2;
  DAG *dagnode;
} bcls;

typedef struct EQS {
  Lit* L;
  DAG* dagpos;
  DAG* dagneg;
} EQS;

extern bcls *pbclsalloc;
extern bcls *pbclstack;
extern bcls *pclschkstack;
extern UniqueSet *clsToChk;
extern UniqueSet *upstack;
extern UniqueSet *litstochk;
extern UniqueSet *litbuf;
extern Lit** lits;
extern EQS* eqbuf;

extern int MRFailedLit;
extern int HIGHESTBTLEVEL;
extern int DEEPESTLEVEL;

extern int sizebclsstack;
extern int sizeclschkstack;

extern int *dplLevelToLit;

// Horst: Add universal reduction
bool inline removeLiteralandApplyUniversalReduction(int l);
bool inline removeLiteralandApplyUniversalReductionDuringEquality(int l, DAG* dagnode);
void inline removeLiteralandApplyUniversalReductionOnClauseDuringEquality(Clause * c);

const int BCLSALLOCFACTOR=20;

void Makebclstore();
void findallhits(Clause *c);

inline bcls* allocbcls() {
  //allocate a new bcls record
  if(!pbclsalloc)
    Makebclstore();
  bcls *pbcls = pbclsalloc;
  pbclsalloc=pbcls->pnext;
  return(pbcls);
}

inline void deallocbcls(bcls *pbcls) {
  //deallocate it.
  pbcls->pnext = pbclsalloc;
  pbclsalloc = pbcls;
}

/*We use two stacks a 2-clause stack and a unit prop stack.
  These stacks are used to store pending 2-clauses to be resolved, and
  literals to be unit propagated. Processing of UPs is always done
  prior to 2-clauses. So some 2-clauses	in the stack might become
  redundant prior to being resolved.

  Also a contradition might be discovered at any time. In which case
  entries on both stacks become stale.

  finally, it is possible for a lit to become equivalent to another, so
  pop lits that have been reduced by equivalences.
*/


inline void pushupstack(int l, DAG *dagnode) {
  switch(val(l)) {
  case F:
    setContradiction(dagnode,getLitdagnode(negate(l)));
	//printf("\n  FAILED %d ", l);  
    break;
  case T:
    break;
  case U:
    // Horst: Universal Reduction
    
    if(!isLitExistential(l))
    { 
	 //printf("\n XXXTrying to propagate: %d (PL: %d dtype: %d, Level: %d)", l, getLitPrefixLevel(l), dagnode->type, LEVEL);     
	 if((dagnode->type!=CHOICE))// && (dagnode->type!=PURE) && (dagnode->type!=NOGOOD))
     {
      //printf("\n  FAILED %d ", l);     
      setContradiction(dagnode, dagnode);
	  //assert(CONTRADICTION.val);
	  return;
     }
	 else
	 {
      //printf("\n  We don't fail... %d ", l);     
	 }
	}
	// Horst END
    
    if(upstack->member(negate(l))) {
      setContradiction(dagnode,getLitdagnode(negate(l)));
	  //printf("\n  FAILED HERE %d ", l);     
    }		
    else if(!upstack->member(l)) {
      setLitdagnode(l,dagnode);
      markundoLitdagnode(l);
	  //printf("\n Push on UPstack: %d ", l);
      upstack->pushnew(l);
      if(DOLPB && dagnode->type==NORMAL) { 
		  //printf("\n !!! DOLPB !!! %d (E?: %d)", l, isLitExistential(l));
	   NoGood *ng=allocNoGood(LEVEL+1);
	   ng->unionFromDAG(dagnode);
	   //ng->printLiterals(dplLevelToLit);
	   //ng->cutTailingUniversals(dplLevelToLit);
	   //ng->printLiterals(dplLevelToLit);
	   //assert(isLitExistential(l));
	   //if(isLitExistential(l))
	    //ng->cutTailingUniversals(dplLevelToLit);
	   //else

	   //ng->printLiterals(dplLevelToLit);
	   DoPruneBacks(ng,negate(l),LEVEL);
	   deallocNoGood(ng);
      }	 
    }
  }
}

//inline void pushupstack(int l, DAG *dagnode) {
 // pushupstackInternal(l, dagnode);  
  /*if((l == 320) || (negate(l) == 320))
   printf("\n Testing Nogoods of Literal %d [%d] (Negate: %d, [%d]) ",l, upstack->member(l), negate(l), upstack->member(negate(l))); 
  int nNoGoodOffset = -1;
  if(!haveContradiction()) */
   //bool bResult = 

  /*while((!haveContradiction()) && (nNoGoodOffset !=0))  {
	  // Compute Nogood offsets
	  nNoGoodOffset = checkNoGoodsOfLiteral(negate(l));
	  if(nNoGoodOffset != 0) {
	   stNoGoodInformation * stNoGoodInfo = computeReason(nNoGoodOffset, negate(l));
	   printf("\n Put %d on Stack with NoGood: %d! ", stNoGoodInfo->nForcedLit, nNoGoodOffset);
	   if(!upstack->member(stNoGoodInfo->nForcedLit)) {
		 pushupstack(stNoGoodInfo->nForcedLit, stNoGoodInfo->dagnode); 			 
		 setTriggeredNoGoodsPlusOne();
	    }
	  }
  }*/
//}

inline bool emptyupstack() {
  return(upstack->size==0);
}

inline DAG* computeLitEqdagnode(int lt);

inline int popupstack() {
  int lt=upstack->pop();
  int eqlt=eqlit(lt);
  if(eqlt != lt && !getLitdagnode(eqlt)) {
	
	setLitdagnode(eqlt,allocDAGNODE_NORMAL(getLitdagnode(lt),
					       computeLitEqdagnode(lt)));
	markundoLitdagnode(lt);
  }
  //printf("\n POP stack returns: %d ", eqlt);
  return(eqlt);
}

inline void pushbclsstack(int l1, int l2, DAG *dagnode) {
  //check bcls and push it on the bcls stack to be resolved
  //if appropriate.
  //assert(isLitExistential(l1) || isLitExistential(l2));

#ifdef _TRACE
  printf("=>pushbclsstack(%d[%c],%d[%c]).\n",to_ff(l1),
		 ff_tval(val(l1)), to_ff(l2), ff_tval(val(l2)));
  //  if(HvalhaveBclause(l1,l2,RESOLVED))
	//
  if(haveBclause(l1,l2))
	printf("HaveBclause.\n");
	//  if(HvalhaveBclause(l1,l2,INSTACK))
	//    printf("HaveBclause with INSTACK\n");
#endif
  //bucket *pb = intTolit(l1)->litHtable;
  //bucket *notpb = intTolit(negate(l1))->litHtable;
  DAG *dnode1;

  //  if(haveBclause(pb,l2))
  if(haveBclause(l1,l2))
    return;
  // Horst: Adding universal reduction
  // If literal l1 is not existential and if the prefix level is bigger than the one of l2
  // we can directly propagate l2
  if((!isLitExistential(l1)) && (!isLitExistential(l2))) {
   setContradiction(dagnode, dagnode);
   //assert(false);
   return;
  }
  else if((!isLitExistential(l1)) && (getLitPrefixLevel(l1) > getLitPrefixLevel(l2))) {
   pushupstack(l2, allocDAGNODE_NORMAL(dagnode, dagnode));
   //assert(false);
   return;
  }
  else if((!isLitExistential(l2)) && (getLitPrefixLevel(l2) > getLitPrefixLevel(l1))) {
   pushupstack(l1, allocDAGNODE_NORMAL(dagnode, dagnode));
   //assert(false);
   return;
  }
  // END
  else if(isFalse(l1)) {
    //printf(" X 7 X ");
    pushupstack(l2,allocDAGNODE_NORMAL(dagnode,getLitdagnode(negate(l1))));
  }
  //  else if(DNodehaveBclause(notpb,l2,dnode1)) {
  else if(DNodehaveBclause(negate(l1),l2,dnode1)) {
	  //printf(" X 8 X ");
    pushupstack(l2,allocDAGNODE_NORMAL(dagnode,dnode1));
  }
  else if(isFalse(l2)) {
	  //printf(" X 9 X ");
    pushupstack(l1,allocDAGNODE_NORMAL(dagnode,getLitdagnode(negate(l2))));
  }
  //  else if(DNodehaveBclause(pb,negate(l2),dnode1)) {
  else if(DNodehaveBclause(l1,negate(l2),dnode1)) {
	  //printf(" X 10 X ");
    pushupstack(l1,allocDAGNODE_NORMAL(dagnode,dnode1));
  }
  else {
    //put on to be resolved stack
#ifdef _TRACE
    printf("==pushbclsstack(%d,%d) added to stack.\n",to_ff(l1),to_ff(l2));
#endif
	sizebclsstack++;
	bcls *pbcls=allocbcls();
	pbcls->l1=l1;
	pbcls->l2=l2;
	pbcls->dagnode=dagnode;
	pbcls->pnext=pbclstack;
	pbclstack=pbcls;
	//markBclause(l1,l2,INSTACK,dagnode);
  }
}

inline void pushbclsstack(bcls *pbcls) {
  int l1=pbcls->l1;
  int l2=pbcls->l2;
  //check bcls and push it on the bcls stack to be resolved
  //if appropriate.
#ifdef _TRACE
  printf("=>pushbclsstack(%d[%c],%d[%c]).\n",to_ff(l1),
		 ff_tval(val(l1)), to_ff(l2), ff_tval(val(l2)));
  //  if(HvalhaveBclause(l1,l2,RESOLVED))
  //    printf("HaveBclause with RESOLVED\n");
  if(haveBclause(l1,l2))
	printf("HaveBclause.\n");
  //  if(HvalhaveBclause(l1,l2,INSTACK))
  //    printf("HaveBclause with INSTACK\n");
#endif
  //bucket *pb = intTolit(l1)->litHtable;
  //bucket *notpb = intTolit(negate(l1))->litHtable;
  DAG *dnode1;

  //  if(haveBclause(pb,l2))
  if(haveBclause(l1,l2))
    return;

  else if(isFalse(l1)) {
	  //printf(" X 12 X ");
    pushupstack(l2,allocDAGNODE_NORMAL(pbcls->dagnode,getLitdagnode(negate(l1))));
  }
  //  else if(DNodehaveBclause(notpb,l2,dnode1)) {
  else if(DNodehaveBclause(negate(l1),l2,dnode1)) {
	  //printf(" X 13 X ");
    pushupstack(l2,allocDAGNODE_NORMAL(pbcls->dagnode,dnode1));
  }
  else if(isFalse(l2)) {
	  //printf(" X 14 X ");
    pushupstack(l1,allocDAGNODE_NORMAL(pbcls->dagnode,getLitdagnode(negate(l2))));
  }
  //  else if(DNodehaveBclause(pb,negate(l2),dnode1)) {
  else if(DNodehaveBclause(l1,negate(l2),dnode1)) {
	  //printf(" X 15 X ");
    pushupstack(l1,allocDAGNODE_NORMAL(pbcls->dagnode,dnode1));
  }

  else {
    //put on to be resolved stack
#ifdef _TRACE
    printf("==pushbclsstack(%d,%d) added to stack.\n",to_ff(l1),to_ff(l2));
#endif
	sizebclsstack++;
	pbcls->pnext=pbclstack;
	pbclstack=pbcls;
	//markBclause(l1,l2,INSTACK,pbcls->dagnode);
  }
}

inline bool emptybclstack() {
  return(pbclstack==NULL);
}

inline bcls* popbclsstack() {
  sizebclsstack--;
  bcls* pbcls=pbclstack;
  pbclstack=pbcls->pnext;
  //if(HvalhaveBclause(pbcls->l1,pbcls->l2,INSTACK))
  //unmarkBclause(pbcls->l1,pbcls->l2);
  DAG *dnode=pbcls->dagnode;
  int eql1=eqlit(pbcls->l1);
  if(eql1!=pbcls->l1) {
	//printf("=>popbclsstack reducing eqlit!\n");
	dnode=allocDAGNODE_NORMAL(dnode,
							  computeLitEqdagnode(pbcls->l1));
  }
  int eql2=eqlit(pbcls->l2);
  if(eql1!=pbcls->l2) {
	//printf("=>popbclsstack reducing eqlit!\n");
	dnode=allocDAGNODE_NORMAL(dnode,
							  computeLitEqdagnode(pbcls->l2));
  }
  pbcls->l1=eql1;
  pbcls->l2=eql2;
  pbcls->dagnode=dnode;
  return(pbcls);
}

inline void pushclschkstack(int l1, int l2) {
  //Push a bclause to be check later for clause hits.
#ifdef _TRACE
  printf("=>pushclschkstack(%d[%c],%d[%c]).\n",to_ff(l1),
		 ff_tval(val(l1)), to_ff(l2), ff_tval(val(l2)));
#endif
  sizeclschkstack++;
  bcls *pbcls=allocbcls();
  pbcls->l1=l1;
  pbcls->l2=l2;
  pbcls->pnext=pclschkstack;
  pclschkstack=pbcls;
}

inline void pushclschkstack(Lit* l1, Lit* l2) {
  //Push a bclause to be check later for clause hits.
#ifdef _TRACE
  printf("=>pushclschkstack(%d[%c],%d[%c]).\n",to_ff(l1->num),
		 ff_tval(val(l1)), to_ff(l2->num), ff_tval(val(l2)));
#endif
  assert(isLitExistential(l1) || isLitExistential(l2));
  if(!isLitExistential(l1))
  {
    assert(getLitPrefixLevel(l2) > getLitPrefixLevel(l1));
  }
  if(!isLitExistential(l2))
  {
    assert(getLitPrefixLevel(l1) > getLitPrefixLevel(l2));
  }

  sizeclschkstack++;
  bcls *pbcls=allocbcls();
  pbcls->l1=l1->num;
  pbcls->l2=l2->num;
  pbcls->pnext=pclschkstack;
  pclschkstack=pbcls;
}

inline bool emptyclschkstack() {
  return(pclschkstack==NULL);
}

inline bcls* popclschkstack() {
  sizeclschkstack--;
  bcls* pbcls=pclschkstack;
  pclschkstack=pbcls->pnext;
  return(pbcls);
}

inline void emptystacks() {
  //On contradiction empty both stacks.
  upstack->empty();
  while(!emptybclstack())
    deallocbcls(popbclsstack());
  while(!emptyclschkstack())
    deallocbcls(popclschkstack());
  clsToChk->empty();
}

void UnitProp(int l);
void resolvebcls(bcls *pbcls);
void resolveEqcls(int l1, int l2);
void checkClauseHits(bcls *pbcls);
void checkClauseHits(Lit *l1, Lit *l2);

void inline convertToBinaryClause(Clause* pcls) {
  int l1=pcls->start.pnext->plit->num;
  int l2=pcls->start.pnext->pnext->plit->num;
 // assert(isLitExistential(l1) || isLitExistential(l2));
  pushbclsstack(l1,l2,pcls->dagnode);
  markundoClauseTrue(pcls);
  delinkNClause(pcls);
}

bool inline parent(Lit *pl) {
  //True if pl has a parent. I.e., another lit
  //that pl passes on all of its 2-clauses to
  Lit *l=negate(pl);
  return(l->twoClauses.pnext->pnext==NULL);
}

bool inline parent(int il) {
  //True if l has a parent. I.e., another lit
  //that l passes on all of its 2-clauses to
  Lit *l=THELITS+negate(il);
  return(l->twoClauses.pnext->pnext==NULL);
}

void inline propagateStacks() {
  //do all stacked up unit props and binary clause resolutions.
  while(!CONTRADICTION.val &&
		(!emptyupstack() || !emptybclstack() || !emptyclschkstack()
		 || !clsToChk->isEmpty())) {
	if(!emptyupstack()) {
     int nUnit = popupstack();
	 //printf("\n Propagating %d ", nUnit);
     UnitProp(nUnit);
	 //if((nUnit == 100) || (nUnit==101))
		//printf("\n XXXX Pushing %d (%d F?: %d) on the Stack! ", nUnit, negate(nUnit), isFalse(negate(nUnit)));
	 bool bReturn = updateWatchesInLearnedClauses(negate(nUnit));
	  //if(!bReturn)
		  //printf("\n Updating of Nogood Watch failed with %d ", nUnit);
	}
    else if(!emptybclstack())
      resolvebcls(popbclsstack());
    else if(!emptyclschkstack())
	  checkClauseHits(popclschkstack());
    else if(!clsToChk->isEmpty())
	  findallhits(THECLAUSES+clsToChk->pop());
  }
  if(CONTRADICTION.val)
    emptystacks();
}

/*
bool inline checkforNewbClause(Clause *c, Lit* L, int &missedlit, int &missedcount) {
  //check if l generates a new bclause from clause c
  missedcount=0;
  //bucket *pb = L->litHtable;
  for(ClsLit *cl=c->start.pnext; cl->pnext; cl=cl->pnext) {
	//    if(haveBclause(pb,cl->plit->num)) {
      // If we have this binary clause already there is no need to continue looking for a new one
      if(haveBclause(L,cl->plit->num)) {
       return false;
      }
	//    if(!haveBclause(pb,negate(cl->plit->num))) {
      // If we dont have this clause we miss a clause for hyper-resolution
      if(!haveBclause(L,negate(cl->plit->num))) {
       missedcount++;
      if(missedcount>1)
		return false;
      missedlit=cl->plit->num;
    }
  }
  return true;
} */


/*
bool inline checkforNewbClause(Clause *c, Lit* L, int &missedlit, int &missedcount) {
  //check if l generates a new bclause from clause c
  missedcount=0;

  int nMinUniversalPrefixLevel    = 100000;
  int nMaxExistentialPrefixLevel  = -1;
  int nUniversalsAtMinPrefixLevel = 0;
  int nMissedUniversal            = -1;
  int nMissedExistential          = -1;

  if(isLitExistential(L))
     nMaxExistentialPrefixLevel = getLitPrefixLevel(L);

  vector<int> vecLiterals;
  // Add the Literal L to the vector of literals
  vecLiterals.push_back(L->num);

  //bucket *pb = L->litHtable;
  for(ClsLit *cl=c->start.pnext; cl->pnext; cl=cl->pnext) {
        //    if(haveBclause(pb,cl->plit->num)) {
      // If we have this binary clause already there is no need to continue looking for a new one
      if(haveBclause(L,cl->plit->num)) {
       return false;
      }
      // If we dont have this clause we miss a clause for hyper-resolution
      // Count numbered of missed existentials (we cannot get rid of existentials by universal reduction!
      if(!haveBclause(L,negate(cl->plit->num))) {
        if(isLitExistential(cl->plit->num))
        {
          missedcount++;
          if(missedcount>1)
           return false;
          missedlit=cl->plit->num;
          nMissedExistential = cl->plit->num;
          if(getLitPrefixLevel(cl->plit->num) > nMaxExistentialPrefixLevel)
           nMaxExistentialPrefixLevel = getLitPrefixLevel(cl->plit->num);
        }
        else
        {
          assert(!isLitExistential(cl->plit->num));
          if(getLitPrefixLevel(cl->plit->num) < nMinUniversalPrefixLevel)
          {
            nMinUniversalPrefixLevel = getLitPrefixLevel(cl->plit->num);
            nUniversalsAtMinPrefixLevel = 0;
            nMissedUniversal = cl->plit->num;
          }
          // Count number of universals at Max-Prefix-Level
          if(getLitPrefixLevel(cl->plit->num) == nMinUniversalPrefixLevel)
          {
            nUniversalsAtMinPrefixLevel++;
          }
        }
      }
  }
  // There is no missed universal == we have two existentials
  if(nMissedUniversal == -1)
   return true;

  if(nUniversalsAtMinPrefixLevel > 0)
  {
    // Dont miss any existential
    if(nMissedExistential == -1)
    {
      // If the prefix level of L is equal or smaller to the minUniversalPrefixLevel
      // we can cut all the universals, hence L is the only remaining variable
      // Or L is a universal
      if((!isLitExistential(L)) || (getLitPrefixLevel(L) <= nMinUniversalPrefixLevel))
      {
       missedcount = 0;
       return true;
      }
      else
      {
        // We missed only one upstream universal?
        if(nUniversalsAtMinPrefixLevel == 1)
        {
          missedLit   = nMissedUniversal;
          missedcount = 1;
          return true;
        }
        else // we missed more than one upstream universal
         return false;
      }
    }
    else // we also miss an existential
    {
      // If L is existential
      if(isLitExistential(L))
      {
        // We can forget about the missing universals - they are all tailing
        if(nMaxExistentialPrefixLevel < nMinUniversalPrefixLevel)
        {
          return true;
        }
       else // L is a universal
       {
         if(nMaxExistentialPrefixLevel < nMinUniversalPrefixLevel)
          return true;
         else
         {
           if(
         }
       }
    }
  }
  return false;
}*/

/*
bool inline checkforNewbClause(Clause *c, Lit* L, int &missedlit, int &missedcount) {
  //check if l generates a new bclause from clause c
  missedcount=0;
  //bucket *pb = L->litHtable;
  for(ClsLit *cl=c->start.pnext; cl->pnext; cl=cl->pnext) {
	//    if(haveBclause(pb,cl->plit->num)) {
	if(haveBclause(L,cl->plit->num)) {
      return false;
    }
	//    if(!haveBclause(pb,negate(cl->plit->num))) {
	if(!haveBclause(L,negate(cl->plit->num))) {
      missedcount++;
      if(missedcount>1)
		return false;
      missedlit=cl->plit->num;
    }
  }
  return true;
}
*/

bool inline checkforNewbClause(Clause *c, Lit* L, int &missedlit, int &missedcount) {
  //check if l generates a new bclause from clause c
  missedcount=0;

  int nMaxUniversalPrefixLevel    = -1;
  int nMaxExistentialPrefixLevel  = -1;
  int nUniversalsAtMaxPrefixLevel = 0;
  int nMissedUniversal            = -1;
  int nMissedExistential          = -1;

  if(isLitExistential(L))
     nMaxExistentialPrefixLevel = getLitPrefixLevel(L);
  else
  {
     nMaxUniversalPrefixLevel = getLitPrefixLevel(L);
	 nUniversalsAtMaxPrefixLevel++;
  }

  vector<int> vecLiterals;
  // Add the Literal L to the vector of literals
  vecLiterals.push_back(L->num);
  //printf("\n Current Clause: %d", c->num);
  //assert(c->dagnode != NULL);
  bool bExistential = false;
  int nDMaxExistentialPrefixLevel = -1;
  int nDMaxUniversalPrefixLevel    = -1;
  for(ClsLit *cl=c->start.pnext; cl->pnext; cl=cl->pnext) { 
     if(isLitExistential(cl->plit))
     {
      bExistential = true;
      if(getLitPrefixLevel(cl->plit->num) > nDMaxExistentialPrefixLevel)
            nDMaxExistentialPrefixLevel = getLitPrefixLevel(cl->plit->num);
     }
     else
	 {
      if(getLitPrefixLevel(cl->plit->num) > nDMaxUniversalPrefixLevel)
            nDMaxUniversalPrefixLevel = getLitPrefixLevel(cl->plit->num);
	 }
  }
  //assert(nDMaxUniversalPrefixLevel < nDMaxExistentialPrefixLevel);
  if(nDMaxUniversalPrefixLevel > nDMaxExistentialPrefixLevel)
  {
   printf("\n Current Clause: %d", c->num);
   printf("\n Check Clause with L: %d (%d) =  ", to_ff(L->num), L->num);
   for(ClsLit *cl=c->start.pnext; cl->pnext; cl=cl->pnext) {
     printf(" [%d (E?:%d, PL: %d)] ", cl->plit->num, isLitExistential(cl->plit), getLitPrefixLevel(cl->plit)); 
   }
   assert(false);
  }
  assert(bExistential);
  //bucket *pb = L->litHtable;
  //printf("\n Check Clause with L: %d (%d) =  ", to_ff(L->num), L->num);
  //for(ClsLit *cl=c->start.pnext; cl->pnext; cl=cl->pnext) {
	//  printf(" [%d (E?:%d, PL: %d)] ", cl->plit->num, isLitExistential(cl->plit), getLitPrefixLevel(cl->plit)); 
  //}
  for(ClsLit *cl=c->start.pnext; cl->pnext; cl=cl->pnext) {
        //    if(haveBclause(pb,cl->plit->num)) {
      
      // If we have this binary clause already there is no need to continue looking for a new one
      if(haveBclause(L,cl->plit->num)) {
       return false;
      }
      // If we dont have this clause we miss a clause for hyper-resolution
      // Count numbered of missed existentials (we cannot get rid of existentials by universal reduction!
      if(!haveBclause(L,negate(cl->plit->num))) {
        // Miss an existential?
        if(isLitExistential(cl->plit->num))
		{
          missedcount++;
          if(missedcount>1)
           return false;
          missedlit=cl->plit->num;
		  //printf(" MissedLit: %d ", missedlit);
          nMissedExistential = cl->plit->num;
          if(getLitPrefixLevel(cl->plit->num) > nMaxExistentialPrefixLevel)
            nMaxExistentialPrefixLevel = getLitPrefixLevel(cl->plit->num);
          vecLiterals.push_back(cl->plit->num);
        }
        else // Miss a universal
        {
          assert(!isLitExistential(cl->plit->num));
          vecLiterals.push_back(cl->plit->num);
		  //printf(" Missed Universal: %d ", cl->plit->num);
          if(getLitPrefixLevel(cl->plit->num) > nMaxUniversalPrefixLevel)
          {
            nMaxUniversalPrefixLevel = getLitPrefixLevel(cl->plit->num);
            nUniversalsAtMaxPrefixLevel = 0;
            nMissedUniversal = cl->plit->num;
          }
          // Count number of universals at Max-Prefix-Level
          if(getLitPrefixLevel(cl->plit->num) == nMaxUniversalPrefixLevel)
          {
            nUniversalsAtMaxPrefixLevel++;
          }
        }
	  }
      else
      {
        //printf("\n Literal %d (Existential? %d PL: %d) hits %d (Existential? %d PL: %d)", L->num, isLitExistential(L->num), getLitPrefixLevel(L->num), negate(cl->plit->num), isLitExistential(cl->plit->num), getLitPrefixLevel(cl->plit->num));
        //printf("\n Literal %d (Existential? %d PL: %d) hits %d (Existential? %d PL: %d)", to_ff(L->num), isLitExistential(L->num), getLitPrefixLevel(L->num), to_ff(negate(cl->plit->num)), isLitExistential(cl->plit->num), getLitPrefixLevel(cl->plit->num));
        //assert(isLitExistential(L->num) || isLitExistential(cl->plit->num));
      }

  }
  int k;
  // Apply Universal Reduction
  vector<int> vecRemovedLits;
  vector<int>::iterator iterVec;
  //printf("\n Size VecLiterals %d ", vecLiterals.size());
  for(iterVec = vecLiterals.begin(); iterVec != vecLiterals.end(); iterVec++)
    {    	 
     if(getLitPrefixLevel(*iterVec) <= nMaxExistentialPrefixLevel)
      {
        //printf("\n Remaining Literal %d (E?: %d, PL: %d)", *iterVec, isLitExistential(*iterVec), getLitPrefixLevel(*iterVec));
        vecRemovedLits.push_back(*iterVec);
      }
      else
      {        
		//printf("\n Universal Reduction %d (E?: %d, PL: %d)", *iterVec, isLitExistential(*iterVec), getLitPrefixLevel(*iterVec)); 
		assert(!isLitExistential(*iterVec));
      } 
 
    }
  
  //printf("\n Current Literal %d (E? %d): #MissedExistentials: %d #NumberOfUniversalAtMaxLevel: %d ", L->num, isLitExistential(L), missedcount, nUniversalsAtMaxPrefixLevel);
  // If the remaining clause is empty return true and say that we did not miss a literal
  // - that will cause a propagation of a universal literal and cause a failure
  if(vecRemovedLits.size() == 0)
  {
    missedcount = 0;
    //printf("\n Case 1: Lit1: %d (E?: %d) Lit2: %d (E?: %d)", L->num, isLitExistential(L));	
    assert(!isLitExistential(L));
    return true;
  }
  // Unit Literal
  if(vecRemovedLits.size() == 1)
  {
    missedcount = 0;
    missedlit   = vecRemovedLits[0];
    //printf("\n Case 2: Lit1: %d (E?: %d) Lit2: %d (E?: %d)", L->num, isLitExistential(L), vecRemovedLits[0], isLitExistential(vecRemovedLits[0]));
	// Do we have a subsumption?
    if(L->num != missedlit)
	{      
      return false;
	}
	
    return true;
  }
  // new binary or subsumption
  if(vecRemovedLits.size() == 2)
  {
    // We have a new binary clause that contains L
    if(vecRemovedLits[0] == L->num)
    {
     missedcount = 1;
     missedlit   = vecRemovedLits[1];
	 //printf("\n Case 3: Lit1: %d (E?: %d, PL: %d) Lit2: %d (E?: %d, PL: %d)", L->num, isLitExistential(L), getLitPrefixLevel(L), vecRemovedLits[1], isLitExistential(vecRemovedLits[1]), getLitPrefixLevel(vecRemovedLits[1]));	 
     assert(vecRemovedLits[1] != L->num);
	 return true;
    }
    if(vecRemovedLits[1]== L->num)
    {
     missedcount = 1;
     missedlit   = vecRemovedLits[0];
	 //printf("\n Case 4: Lit1: %d (E?: %d) Lit2: %d (E?: %d)", L->num, isLitExistential(L), vecRemovedLits[0], isLitExistential(vecRemovedLits[0]));
     return true;
    }
    // We have created a subsumption!
    return false;
    assert(false);
  }

  // In all other cases we can return false
  return false;
}



inline void checkClauseHits(bcls *pbcls) {
  Lit* l1=eqlit(intTolit(pbcls->l1));
  Lit* l2=eqlit(intTolit(pbcls->l2));
  deallocbcls(pbcls);
  checkClauseHits(l1, l2);
}

inline DAG* computeDAGnode(Lit *L, Clause *c) {
  //compute a dag for L generating a new binary of unary clause from
  //hitting clause c
  DAG *dnode1, *dnode2;
  dnode1=c->dagnode;
  assert(dnode1 != NULL);

  //bucket *pb = L->litHtable;
  for(ClsLit *cl=c->start.pnext; cl->pnext; cl=cl->pnext)
	//    if(DNodehaveBclause(pb,negate(cl->plit->num),dnode2))
	if(DNodehaveBclause(L,negate(cl->plit->num),dnode2))
        {
           dnode1=allocDAGNODE_NORMAL(dnode2,dnode1);
           //printf("\n ComputeDAGNode: Having %d and %d. Dnode null? %d - My dnode2 null? %d ",L->num, negate(cl->plit->num), ((dnode1 == NULL) ? 1 : 0), ((dnode2 == NULL) ? 1 : 0));
        }
  return dnode1;
}

inline DAG* computeLitEqdagnode(int lt) {
  //compute a dag for lit lt being equivalent to its currently
  //equivalent literal. This follows a chain of equivalences.
  Lit *Lt=intTolit(lt);
  DAG *dnode1=Lt->dagEqnode;
  Lt=Lt->equivlit;
  while(Lt->equivlit!=Lt) {
	//printf("computeLitEqdagnode following chain\n");
	dnode1=allocDAGNODE_NORMAL(Lt->dagEqnode,dnode1);
	Lt=Lt->equivlit;
  }
  return(dnode1);
}

inline void checkClauseHits(Lit *l1, Lit *l2) {
  LitCls *nclauses;
  int missedlit, missedcount;

#ifdef _TRACE
  printf("=>CNCHs(%d,%d)\n", to_ff(l1->num),to_ff(l2->num));
  printLit(l1);
  printLit(negate(l1));
  printLit(l2);
  printLit(negate(l2));
#endif _TRACE

  if(isInactive(l1) || isInactive(l2))
    return;

  bool foundAhit=false;
  if(numBcls(l1) > 1) {
    litHitsChecked++;
    //if(parent(l1)) parentHitsChecked++;
    for(nclauses=(negate(l1))->nClauses.pnext;nclauses->pnext;nclauses=nclauses->pnext) {
      clauseHitsChecked++;
      //if(parent(l1)) clauseHitsChecked++;
      if(checkforNewbClause(nclauses->pcls,l2,missedlit,missedcount)) {
		if(!foundAhit) {
		  //if(parent(l1)) parentHitsFound++;
		  litHitsFound++;
		  foundAhit=true;
		}
		clauseHitsFound++;
		//if(parent(l1)) clauseHitsFound++;
		if(missedcount==0) {
                  //printf("\n Here 1 Literal is %d ", l2->num);
				  //assert(!isLitExistential(l2));
                  //DAG * DAGnode = computeDAGnode(l2,nclauses->pcls);
                  //assert(DAGnode != NULL);
		  pushupstack(l2->num,computeDAGnode(l2,nclauses->pcls));
		  return;
		}
		else
                {
                  //printf("\n 2 Here Literal %d %d ", l2->num, missedlit);
                  //assert(l2->num != missedlit);
		          pushbclsstack(l2->num,missedlit,computeDAGnode(l2,nclauses->pcls));
                }
      }
    }
  }

  if(numBcls(l1) > 1) {
    foundAhit=false;
    litHitsChecked++;
    //if(parent(l2)) parentHitsChecked++;
    for(nclauses=(negate(l2))->nClauses.pnext;nclauses->pnext;
		nclauses=nclauses->pnext) {
      clauseHitsChecked++;
      //if(parent(l2)) clauseHitsChecked++;
      if(checkforNewbClause(nclauses->pcls,l1,missedlit,missedcount)) {
		if(!foundAhit) {
		  //if(parent(l2)) parentHitsFound++;
		  litHitsFound++;
		  foundAhit=true;
		}
		clauseHitsFound++;
		//if(parent(l2)) clauseHitsFound++;
		if(missedcount==0) {
			//printf("\n 1 Here: %d ", l1->num);
			//assert(!isLitExistential(l1));
                  //DAG * DAGnode = computeDAGnode(l1,nclauses->pcls);
                  //assert(DAGnode != NULL);
		  pushupstack(l1->num,computeDAGnode(l1,nclauses->pcls));
		  return;
		}
		else
                {
                  //printf("\n Here 4 ");
                  //printf("\n 2 Here: %d %d", l1->num, missedlit);  
                  //assert(l1->num != missedlit);
		  pushbclsstack(l1->num,missedlit,computeDAGnode(l1,nclauses->pcls));
                }
      }
    }
  }
}

inline void findallhits(Clause *c) {
  //Find all literals hitting clause
  if(!c->active)
    return;

  nClausesChecked++;
  bool foundhit=false;

  int min1=NLITS;
  int min2=NLITS;
  Lit *L1=NULL;
  Lit *L2=NULL;

  //find the two lits in the clause whose negations have min binary clauses.
  for(ClsLit *pcl=c->start.pnext;pcl->pnext;pcl=pcl->pnext) {
    Lit *L=negate(pcl->plit);
    if(numBcls(L)<min1) {
      min2=min1;
      L2=L1;
      min1=numBcls(L);
      L1=L;
    }
    else if(numBcls(L)<min2) {
      min2=numBcls(L);
      L2=L;
    }
  }

  //Now check the union of their bclauses
  int missedlit, missedcount;
  BinLitCls *pb;
  litbuf->empty();
  for(pb=&(L1->twoClauses); pb->pnext; pb=pb->pnext) {
    litbuf->pushnew(pb->otherlit->num);
    if(checkforNewbClause(c, pb->otherlit, missedlit, missedcount)) {
      if(!foundhit) {
		nClausesHits++;
		foundhit=true;
      }
      if(missedcount == 0)
	  {
        //printf("\n 3 Here: %d ", pb->otherlit->num);   
		pushupstack(pb->otherlit->num,computeDAGnode(pb->otherlit,c));
	  }
      else
	  { 
        //printf("\n 4 Here: %d %d ", pb->otherlit->num, missedlit);   
		pushbclsstack(pb->otherlit->num,missedlit,computeDAGnode(pb->otherlit,c));
	  }
    }
  }
  for(pb=&(L2->twoClauses); pb->pnext; pb=pb->pnext) {
    if(!litbuf->member(pb->otherlit->num)
       && checkforNewbClause(c, pb->otherlit, missedlit, missedcount)) {
      if(!foundhit) {
		nClausesHits++;
		foundhit=true;
      }
      if(missedcount == 0)
	  {
        //printf("\n 5 Here: %d ", pb->otherlit->num);   
		pushupstack(pb->otherlit->num,computeDAGnode(pb->otherlit,c));
	  }
      else
	  {
        //printf("\n 6 Here: %d %d ", pb->otherlit->num, missedlit);    
		pushbclsstack(pb->otherlit->num,missedlit,computeDAGnode(pb->otherlit,c));
	  }
	 }
  }
  litbuf->empty();
}

// Horst: apply universal reduction on the clauses of a literal that got falsified
bool inline removeLiteralandApplyUniversalReduction(int l)
{
    Lit *L=intTolit(l);
    Lit *NotL = intTolit(negate(l));
    BinLitCls* pb;
    //LitCls *pNclausesUR, *pNclausesStore;
    Lit * pLiteral;
    ClsLit *cl;
    Clause * c;
    // Horst
    int nMaxExistentialPL, nMaxUniversalPL;
    // END

    for(pb=&(NotL->twoClauses);pb->pnext;pb=pb->pnext) {
    //get lit's negation which has become False.
    Lit *plit=negate(pb->otherlit);
	for(LitCls *pNclauses=plit->nClauses.pnext;pNclauses->pnext;pNclauses=pNclauses->pnext) {
               // Horst: Add Universal Reduction
                nMaxExistentialPL = -1;
                nMaxUniversalPL = -1;
                // Go through actual clause and check prefix level of literal
                c = pNclauses->pcls;

				//if(l==100)
                // printf("\n Go through clause... %d ", c->num);
                assert(c->dagnode != NULL);
                for(cl=c->start.pnext; cl->pnext; cl=cl->pnext)
                  {
                    pLiteral = cl->plit;
					///if(l==100)
                      //printf(" %d", pLiteral->num);
                    // If the current literal is not equal to the literal we want to remove...
                    if(cl->plit != plit)
                    {
                      if(pLiteral->bExistential)
                      {
                       if(pLiteral->nPrefixLevel > nMaxExistentialPL)
                         nMaxExistentialPL = pLiteral->nPrefixLevel;
                      }
                      else
                      {
                       if(pLiteral->nPrefixLevel > nMaxUniversalPL)
                        nMaxUniversalPL = pLiteral->nPrefixLevel;
                      }
                    }
                    else // if it is the literal we want to remove we simply delink it from the clause
                    {
                     // Ignore the false Literal
                    }
                  }
                  // Universal Reduction

       markundoClsLit(pNclauses->linkincls);
       delinkClsLit(pNclauses->linkincls);

       // If there are tailing universals delink them from the current clause
       if(nMaxUniversalPL > nMaxExistentialPL)
        {
          //printf(" \n There are tailing universals: %d %d ", nMaxExistentialPL, nMaxUniversalPL);
          for(cl=c->start.pnext; cl->pnext; cl=cl->pnext)
          {
           pLiteral = cl->plit;
           // If current Literal at 'tailing' universal prefix level...
           if((getLitPrefixLevel(pLiteral) > nMaxExistentialPL) && (c->len > 2))
           {
             LitCls *LitInClause = cl->linkinlit;
             markundoClsLit(LitInClause->linkincls);
             delinkClsLit(LitInClause->linkincls);
             markundoLitCls(LitInClause);
             delinkLitCls(LitInClause);
           }
           // We stop if we reduced the clause to a binary clause
           if(c->len < 3)
            break;
          }
         }

        //printf("\n ### Length: %d ", pNclauses->pcls->len);


      markundoClsDAG(pNclauses->pcls);
      pNclauses->pcls->dagnode=
        allocDAGNODE_NORMAL(pNclauses->pcls->dagnode,
                     allocDAGNODE_NORMAL(pb->dagnode,getLitdagnode(L)));
      assert(pNclauses->pcls->dagnode != NULL);
      if(pNclauses->pcls->len == 2)
        convertToBinaryClause(pNclauses->pcls);
      else
        if(DOHYP)
          clsToChk->pushnew(pNclauses->pcls->num);
    }
    }
    return true;
}


// Horst: apply universal reduction on the clauses of a literal that got falsified
bool inline removeLiteralandApplyUniversalReductionDuringEquality(int l, DAG* dagnode)
{
    Lit *L    = intTolit(l);
    Lit *NotL = intTolit(negate(l));
    BinLitCls* pb;
    //LitCls *pNclausesUR, *pNclausesStore;
    Lit * pLiteral;
    ClsLit *cl;
    Clause * c;
    // Horst
    int nMaxExistentialPL, nMaxUniversalPL;
    // END
    
	for(LitCls *pNclauses=L->nClauses.pnext;pNclauses->pnext;pNclauses=pNclauses->pnext) {
      // Horst: Add Universal Reduction
      nMaxExistentialPL = -1;
      nMaxUniversalPL = -1;
      // Go through actual clause and check prefix level of literal
      c = pNclauses->pcls;
      //printf("\n Go through clause... %d ", c->num);
      assert(c->dagnode != NULL);
      for(cl=c->start.pnext; cl->pnext; cl=cl->pnext)
       {
        pLiteral = cl->plit;      
        if(pLiteral->bExistential)
         {
          if(pLiteral->nPrefixLevel > nMaxExistentialPL)
           nMaxExistentialPL = pLiteral->nPrefixLevel;
         }
         else
         {
          if(pLiteral->nPrefixLevel > nMaxUniversalPL)
           nMaxUniversalPL = pLiteral->nPrefixLevel;
         }                    
	   }
                  
       // We remove l from the clause
       markundoClsLit(pNclauses->linkincls);
       delinkClsLit(pNclauses->linkincls);

       // If there are tailing universals delink them from the current clause
       if(nMaxUniversalPL > nMaxExistentialPL)
        {
          //printf(" \n There are tailing universals: %d %d ", nMaxExistentialPL, nMaxUniversalPL);
          for(cl=c->start.pnext; cl->pnext; cl=cl->pnext)
          {
           pLiteral = cl->plit;
           // If current Literal at 'tailing' universal prefix level...
           if((getLitPrefixLevel(pLiteral) > nMaxExistentialPL) && (c->len > 2))
           {
             LitCls *LitInClause = cl->linkinlit;
             markundoClsLit(LitInClause->linkincls);
             delinkClsLit(LitInClause->linkincls);
             markundoLitCls(LitInClause);
             delinkLitCls(LitInClause);
           }
           // We stop if we reduced the clause to a binary clause
           if(c->len < 3)
            break;
          }
         }

        //printf("\n ### Length: %d ", pNclauses->pcls->len);


      markundoClsDAG(pNclauses->pcls);
      pNclauses->pcls->dagnode = allocDAGNODE_NORMAL(pNclauses->pcls->dagnode,dagnode);
      assert(pNclauses->pcls->dagnode != NULL);
      if(pNclauses->pcls->len == 2)
        convertToBinaryClause(pNclauses->pcls);      
    }

	if(haveContradiction())
	 return false;
	else
     return true;
}

// Horst: apply universal reduction on the clauses of a literal that got falsified
void inline removeLiteralandApplyUniversalReductionOnClauseDuringEquality(Clause * c)
{
      assert(c->dagnode != NULL);
	  int nMaxExistentialPL = -1;
	  int nMaxUniversalPL   = -1;
      Lit* pLiteral;
	  ClsLit *cl;
	  for(cl=c->start.pnext; cl->pnext; cl=cl->pnext)
       {
        pLiteral = cl->plit;      
        if(pLiteral->bExistential)
         {
          if(pLiteral->nPrefixLevel > nMaxExistentialPL)
           nMaxExistentialPL = pLiteral->nPrefixLevel;
         }
         else
         {
          if(pLiteral->nPrefixLevel > nMaxUniversalPL)
           nMaxUniversalPL = pLiteral->nPrefixLevel;
         }                    
	   }
                  
       // If there are tailing universals delink them from the current clause
       if(nMaxUniversalPL > nMaxExistentialPL)
        {
          //printf(" \n There are tailing universals: %d %d ", nMaxExistentialPL, nMaxUniversalPL);
          for(cl=c->start.pnext; cl->pnext; cl=cl->pnext)
          {
           pLiteral = cl->plit;
           // If current Literal at 'tailing' universal prefix level...
           if((getLitPrefixLevel(pLiteral) > nMaxExistentialPL) && (c->len > 2))
           {
             LitCls *LitInClause = cl->linkinlit;
             markundoClsLit(LitInClause->linkincls);
             delinkClsLit(LitInClause->linkincls);
             markundoLitCls(LitInClause);
             delinkLitCls(LitInClause);
           }
           // We stop if we reduced the clause to a binary clause
           if(c->len < 3)
            break;
          }
         }

        //printf("\n ### Length: %d ", pNclauses->pcls->len);


}




#endif /* __resolver_H */
