/*

2clsQ. Copyright Horst Samulowitz and Fahiem Bacchus 2006

 A DPLL QBF solver based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to
implied warranties of merchantability and fitness for a particular
purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Fahiem Bacchus },
	year    = { 2006 },
	title   = { {2clsQ} a {DPLL} solver employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/
//---------------------------------------------------------------------------
// NoGoodDB
//---------------------------------------------------------------------------
#if !defined(NogoodDB_H)
  #define NogoodDB_H
#endif // NogoodDB_H


#include <stdlib.h>
#include <stdio.h>
#include <stdarg.h>
#include <search.h>
#include "2clsEq.h"
#include "binaryClauses.h"

#include "undo.h"
#include "nogood.h"
#include "resolve.h"
#include <vector>
using namespace std;


inline void addNoGoodToDB(vector<int> *);

inline void swapLiteralsinNoGood(int, int);

inline void addLiteralWatchNoGood(int, int);

void initNoGoodStructure();

int checkNoGoodsOfLiteral(int);

inline int updateWatchInNoGoods(int);

inline void setLiteralInNoGoodWatches(int, vector<int>*);

vector<int>* getLiteralInNoGoodWatches(int);

inline int getLiteralInNoGood(int);

inline int updateWatchInNoGood(int, int, vector<int> *);

inline vector<int>* extractNoGood(NoGood *, int*);

void addNoGoodToDB(NoGood *, int*);

void outputVectorNoGood(vector<int> *);

void outputNoGood(int);

bool isForced(int);

stNoGoodInformation * computeReason(int, int);

void setTriggeredNoGoods(int);
void setTriggeredNoGoodsPlusOne();
int  getTriggeredNoGoods();
int  getNumberOfNoGoods();

inline int getLiteralByOffsetInLearnedClause(int);
inline int getTruthValue(int);
inline bool updateWatchInLearnedClause(int, int, vector<int> *);
bool updateWatchesInLearnedClauses(int);
DAG* computeReasonLearnedClause(int, int, int);
void outputLearnedClauses();

// Allow to set a literal score
void setLiteralScore(int, float);
void inline setLiteralScorePlus(int, float);
void initLiteralScore(int);
void setConflictScoreValue();
float getLiteralScore(int);
void  setLiteralWithMaxVarScore(int);
int inline getNewLiteralWithMaxVarScore();
int inline getLiteralWithMaxVarScore();
float inline getConflictScoreValue();
void inline decayLiteralVarScore();
void inline updateNumberOfResetConflicts();
void inline updateNumberOfConflicts();
void setDecayLiteralScoreInterval(int);
int inline getNumberOfResetConflicts();
int inline getDecayLiteralScoreInterval();
void printActiveClauses();
void setNumberBcls(int);
int getNumberBcls();
float getNewMaxVarScore();
