/*

2clsQ. Copyright Horst Samulowitz and Fahiem Bacchus 2006

 A DPLL QBF solver based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to
implied warranties of merchantability and fitness for a particular
purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Fahiem Bacchus },
	year    = { 2006 },
	title   = { {2clsQ} a {DPLL} solver employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/
//---------------------------------------------------------------------------
// NogoodDB.cpp
//---------------------------------------------------------------------------
#include "nogoodDB.h"

extern UniqueSet *upstack;

vector<int> _vecNoGoods;
vector<vector<int>*> _vecLiteralNoGoodWatches;

int         _nNumberOfLearnedClauses;
int         _nTriggeredNogoods;

float*    _arrLiteralsScore;
int       _nLiteralWithMaxVarScore;
int       _nConflictScoreValue;
int       _nNumberOfResetConflicts;
int       _nNumberOfConflicts;
int       _decayLiteralScoreInterval;
int       _nBcls;

using namespace std;




void initNoGoodStructure()
{
 
 _vecNoGoods.push_back(-1);

 _nNumberOfLearnedClauses = 0;
 _nTriggeredNogoods = 0;
 _nNumberOfResetConflicts = 0;
 _nNumberOfConflicts = 0;
 // Set VSIDS Decay Interval
 _decayLiteralScoreInterval = 5;
 
 for(int i=0; i<NLITS; i++)
 {
   vector<int>* vecUIntEmptyWatch  = new vector<int>;
  _vecLiteralNoGoodWatches.push_back(vecUIntEmptyWatch);
 }
 
 
 CLAUSELIST *clsptr;
  // Increase the score for each literal by going through all the clauses
   for(int i=0;i<CLSGROUPS;i++)
    for(clsptr=lenNclauses[i];clsptr;clsptr=clsptr->pnext)
      for(int j=0;j<clsptr->clslen;j++)
      {		               
				setLiteralScorePlus(clsptr->cls[j], 1);
				//printf("\n Lit %d score %f ", clsptr->cls[j],getLiteralScore(clsptr->cls[j]));
      }

  setLiteralWithMaxVarScore(getNewLiteralWithMaxVarScore());
  int nLit = getLiteralWithMaxVarScore();
  setConflictScoreValue();
  //printf(" Lit with max score %d and score %f ", nLit, getLiteralScore(nLit));
  //assert(false);
}


inline void addNoGoodToDB(vector<int> * vecNoGood){
 //cout << "\n Start With: ";
 //outputVector(vecNoGood);
 long nNoGoodOffset = _vecNoGoods.size();
 int nFirstLiteralPos = 0;
 int nSecondLiteralPos = 0;
 int nFirstMaxDL = 0;
 int nSecondMaxDL = 0;
 int nActualDL;
 int nActualPosition = _vecNoGoods.size() - 1;
 int nFirstPosition  = _vecNoGoods.size();
 bool bTest = false;
 //cout << "\n nFirstPos: " << nFirstPosition << " ";
 
 if(vecNoGood->size() > 2){
  // Now add Cube to Clause Database (cut tailing exitentials)
  vector<int>::iterator itervecNoGood;
  for(itervecNoGood = vecNoGood->begin(); itervecNoGood != vecNoGood->end(); ++itervecNoGood){ 
       // Add Literal to nogood : NEGATE Literal when adding to nogoood db
	   _vecNoGoods.push_back(negate(eqlit(*itervecNoGood)));
	   // Move on in vector of Nogoods
       ++nActualPosition; 
       nActualDL = getReasonDecisionLevel(*itervecNoGood);
       if(nActualDL > nFirstMaxDL)
       {
         nSecondLiteralPos = nFirstLiteralPos;
         nFirstLiteralPos = nActualPosition;
         nSecondMaxDL = nFirstMaxDL;
         nFirstMaxDL = nActualDL;
         //cout << "\n nFirstMaxDL: " << nActualDL << " ";
       }
       else
       {
        if(nActualDL > nSecondMaxDL)
        {
         nSecondLiteralPos = nActualPosition;
         nSecondMaxDL = nActualDL;
        }
       }
	 
  }
 
  assert(nNoGoodOffset <= _vecNoGoods.size());
  // Put Deepest Literals to the Front
  if((nFirstLiteralPos != nFirstPosition) && (nFirstLiteralPos != 0))
  {
   swapLiteralsinNoGood(nFirstLiteralPos, nFirstPosition);
   //cout << "\n Add First Watch: " << _vecNoGoods[nFirstPosition] << " ";
  }

  if(nFirstLiteralPos != 0)
   addLiteralWatchNoGood(_vecNoGoods[nFirstPosition], nNoGoodOffset);

  if((nSecondLiteralPos != nFirstPosition + 1) && (nSecondLiteralPos != 0))
  {
   swapLiteralsinNoGood(nSecondLiteralPos, nFirstPosition + 1);
   //cout << " Add Second Watch: " << _vecNoGoods[nFirstPosition+1] << " ";
  }
  if(nSecondLiteralPos != 0)
   addLiteralWatchNoGood(_vecNoGoods[nFirstPosition+1], nNoGoodOffset);
  //else
  // bTest = true;

 // Add tailing -1
 _vecNoGoods.push_back(-1);

 //if(bTest)
 //outputNoGood(nNoGoodOffset);
 // Increase Number of Cubes
 ++_nNumberOfLearnedClauses; 
 //if(_nNumberOfLearnedClauses % 300 == 0) 
//	 printf("\n Number of Learned Clauses: %d ", _nNumberOfLearnedClauses);
 }
 delete vecNoGood;
}


inline void swapLiteralsinNoGood(int nFirstPosition, int nSecondPosition)
{
    #ifdef SECURE
   assert(nFirstPosition < _vecNoGoods.size());
   assert(nSecondPosition < _vecNoGood.size());
    #endif
   //cout << " Swap FirstPosition " << nFirstPosition << " with " << nSecondPosition << " ";
   int nTempLiteral =  _vecNoGoods[nFirstPosition];
   #ifdef SECURE
   assert(isLiteral(nTempLiteral));
   #endif
   _vecNoGoods[nFirstPosition] = _vecNoGoods[nSecondPosition];
   #ifdef SECURE
   assert(isLiteral(_vecNoGoods[nFirstPosition]));
   #endif
   _vecNoGoods[nSecondPosition] = nTempLiteral;
}


// Add Literal Cube Watch
inline void addLiteralWatchNoGood(int nLiteral, int nNoGoodOffset)
{
   #ifdef SECURE
  assert(isLiteral(nLiteral));
  assert(nCubeOffset > 0);
   #endif
  _vecLiteralNoGoodWatches[nLiteral]->push_back(nNoGoodOffset);
}

// If a cube of this literal is true the offset of the cube is returned, o.w. 0
int checkNoGoodsOfLiteral(int nLiteral)
{
  #ifdef SECURE
  assert(!isLitExistential(nLiteral));
  #endif
  return updateWatchInNoGoods(nLiteral);
}


inline int updateWatchInNoGoods(int nLiteral)
{
  vector<int> * vecNoGoodWatches = getLiteralInNoGoodWatches(nLiteral);
  //cout << " XXXXXXXXXX nLiteral: " << nLiteral << " " << getLiteralValue(nLiteral) << " "; cout.flush();
  //outputVector(vecNoGoodWatches);
  vector<int> * vecNewWatches = new vector<int>;
  
  int nReturnValue = 0;
  vector<int>::iterator iterVec;
  if(!vecNoGoodWatches->empty())
  {
    iterVec = vecNoGoodWatches->begin();
    while(iterVec != vecNoGoodWatches->end() && (nReturnValue == 0))
    {
      //cout << "\n C: " << *iterVec << " " <<vecNoGoodWatches->size() << " ";
      //assert(iterVec != vecNoGoodWatches->end());
	  if(*iterVec == 442) {
	   printf("\n Updating NoGood %d of Literal %d. ", *iterVec, nLiteral);
	   outputNoGood(442);
	  }
      nReturnValue = updateWatchInNoGood(nLiteral, *iterVec, vecNewWatches);
	  if(*iterVec == 442) {
	   printf("\n After updating NoGood %d of Literal %d. ", *iterVec, nLiteral);
	   outputNoGood(442);
	  }
      if(nReturnValue != 0)
	  {
		  printf("\n Trigger Nogood: %d (Lit: %d)", nReturnValue,nLiteral);
		  outputNoGood(nReturnValue);
		assert(isForced(nReturnValue));
	  }
	  ++iterVec;
    } 
	// Copy remaining Cube Offsets to the new vector of watches
    if(nReturnValue != 0)
    {
      while(iterVec != vecNoGoodWatches->end())
      {
        //assert(*iterVec < _vecCubes.size());
        vecNewWatches->push_back(*iterVec);
        ++iterVec;
      }
    }    
    setLiteralInNoGoodWatches(nLiteral, vecNewWatches);
    //outputVector(getLiteralInNoGoodWatches(nLiteral));
    //assert(false);
  }

  /*if( vecAllReturnValues->size() > 0)
  {   
	  printf("\n Triggered Nogood: ");
   outputNoGood(vecAllReturnValues->front());
   //assert(false);
  }*/
  
  return nReturnValue;
}


inline void setLiteralInNoGoodWatches(int nLiteral, vector<int>* vecOffsets)
{
  #ifdef SECURE
  assert(isLiteral(nLiteral));
  #endif
  // delete old List of Watches
  delete _vecLiteralNoGoodWatches[nLiteral];
  _vecLiteralNoGoodWatches[nLiteral] = vecOffsets;
}

inline vector<int> * getLiteralInNoGoodWatches(int nLiteral)
{
  #ifdef SECURE
  assert(isLiteral(nLiteral));
  #endif
  return _vecLiteralNoGoodWatches[nLiteral];
}


inline int updateWatchInNoGood(int nLiteral, int nNoGoodOffset, vector<int> * vecNewNoGoodWatches)
{
  int nActualOffset = nNoGoodOffset;
  assert(nNoGoodOffset < _vecNoGoods.size());
  int nFirstWatch = getLiteralInNoGood(nActualOffset);
  int nFirstWatchOffset = nActualOffset;
  ++nActualOffset;
  int nSecondWatch = getLiteralInNoGood(nActualOffset);
  int nSecondWatchOffset = nActualOffset;
  //#ifdef SECURE
  //cout << "\n " << nFirstWatch << " " << nSecondWatch << " NoGoodOffset: " << nNoGoodOffset << " ";
  //outputNoGood(nNoGoodOffset);
  //cout.flush();
  //assert((isLiteral(nFirstWatch)) && (isLiteral(nSecondWatch)));
  //#endif
  // If one Watch is false then return 0
  //if((getLiteralValue(nFirstWatch) == 0) || (getLiteralValue(nSecondWatch) == 0))
  // return 0;
  if(nSecondWatch == -1)
  {
    assert(false);
	assert(nFirstWatch == nLiteral);
	printf("\n HERE ");
    vecNewNoGoodWatches->push_back(nNoGoodOffset);
    return nNoGoodOffset;
  }
  
  // If nLiteral is not a Watch return 0
  if((nFirstWatch != nLiteral) && (nSecondWatch != nLiteral))
   return 0;
 //|| getLitdagnode(nSecondWatch)
  if((nFirstWatch == nLiteral) && (isTrue(nSecondWatch) || upstack->member(nSecondWatch))) {	
    //printf("\n Case 1 ");
	vecNewNoGoodWatches->push_back(nNoGoodOffset);
    return 0;
  }

  if((nSecondWatch == nLiteral) && (isTrue(nFirstWatch) || upstack->member(nFirstWatch))) {
    //printf("\n Case 2 ");    	
	vecNewNoGoodWatches->push_back(nNoGoodOffset);
    return 0;
  } 

  // Go through the NoGood and find FALSE or UNASSIGNED Literal
  ++nActualOffset;
  int nActualEntry = getLiteralInNoGood(nActualOffset);
  bool   bNewWatch    = false;
  while((nActualEntry != -1) && (!bNewWatch))
  {
    // False or Unassigned, then swap Literals in NoGood
    if(!isFalse(nActualEntry) && (!upstack->member(negate(nActualEntry))) || (isTrue(nActualEntry)))
    {
      if(nLiteral == nFirstWatch)
      {
       swapLiteralsinNoGood(nFirstWatchOffset, nActualOffset);
       // Add Watch
	   if(nNoGoodOffset == 442)
        printf("\n Add Watch %d ", nActualEntry);
       addLiteralWatchNoGood(nActualEntry, nNoGoodOffset);
      }
      else
      {
       swapLiteralsinNoGood(nSecondWatchOffset, nActualOffset);
       // Add Watch
       //cout << "\n Add Watch " << nActualEntry << " " << nSecondWatch << " ";
	   if(nNoGoodOffset == 442)
	    printf("\n Add Watch %d ", nActualEntry);
       addLiteralWatchNoGood(nActualEntry, nNoGoodOffset);
      }
      bNewWatch = true;
    }
    else // proceed in NoGood
    {
      ++nActualOffset;
      nActualEntry = getLiteralInNoGood(nActualOffset);
    }
  }


  if(!bNewWatch)
  {
    printf("\n Nogood %d triggered! ", nNoGoodOffset);
    // Keep Watch on NoGoodOffset
    vecNewNoGoodWatches->push_back(nNoGoodOffset);	
    return nNoGoodOffset;
  }
  else
  {
   //assert(!isForced(nNoGoodOffset));
   return 0;
  }
}


inline int getLiteralInNoGood(int nOffset)
{
  #ifdef SECURE
  assert((nOffset > 0) && (nOffset < _vecNoGoods.size()));
  #endif
  return _vecNoGoods[nOffset];
}


void addNoGoodToDB(NoGood *ng, int* dplLevelToLit) {

 
 updateNumberOfConflicts();
 updateNumberOfResetConflicts();
 vector<int>* vecLiterals = extractNoGood(ng, dplLevelToLit);
 addNoGoodToDB(vecLiterals);
 if(getNumberOfResetConflicts() >= getDecayLiteralScoreInterval()){
   decayLiteralVarScore();
 }
 //assert(false);
}

inline vector<int>* extractNoGood(NoGood *ng, int* dplLevelToLit) {

  vector<int>* vecNoGood = new vector<int>;
  bool bHadExistential = false;
  //ng->printLiterals(dplLevelToLit);
  for(int i=ng->maxindex;i>0;i--) {
	if(ng->getbit(i))
	{
	  // Update Literal Score
      setLiteralScorePlus(negate(eqlit(dplLevelToLit[i])), getConflictScoreValue());
      if(isLitExistential(dplLevelToLit[i]))	 
	  {
		vecNoGood->push_back(dplLevelToLit[i]); 
		bHadExistential = true;
	  }
	  else
	  {
         //printf("[%d (PL %d)] ", dplLevelToLit[i], getLitPrefixLevel(dplLevelToLit[i]));	   
		 if(bHadExistential)
		  vecNoGood->push_back(dplLevelToLit[i]); 
	  }
	}
  }
  if(vecNoGood->size() < 15) {
   vector<int>::iterator iterVec;
   for(iterVec = vecNoGood->begin(); iterVec != vecNoGood->end(); iterVec++){
	 // Update Literal Score
     setLiteralScorePlus(negate(eqlit(*iterVec)), getConflictScoreValue());
	 if(vecNoGood->size() < 8) 
	    // Update Literal Score
        setLiteralScorePlus(negate(eqlit(*iterVec)), getConflictScoreValue());
   }
  }
  //outputVectorNoGood(vecNoGood);  
  //assert(false);
  return vecNoGood;
}


void outputVectorNoGood(vector<int> * vecUInts)
{
  vector<int>::iterator iterVec;
  printf("\n");
  if (vecUInts->size() == 0)
   printf(" Empty (outputVector) ");
  for(iterVec = vecUInts->begin(); iterVec != vecUInts->end(); iterVec++)
   {
     Lit * lCurrentLiteral = intTolit(*iterVec);
	 printf(" %d (Internal: %d E?: %d PL: %d, DL: %d) ", to_ff(*iterVec), *iterVec, isLitExistential(lCurrentLiteral), getLitPrefixLevel(lCurrentLiteral), lCurrentLiteral->assignLevel);
	 //printf(" %d ", to_ff(*iterVec));
   }
  printf("\n");
}

void outputNoGood(int nNoGoodOffset)
{
  int nCurrentOffset = nNoGoodOffset;
  int nActualValue = _vecNoGoods[nCurrentOffset];
  
  printf("\n Nogood: ");
  // While not end of cube
  while(nActualValue != -1)
  {
     #ifdef SECURE
    assert(isLiteral(nActualValue));
     #endif
	//printf(" %d (DL: %d, E?: %d, PL: %d) ",nActualValue, getReasonDecisionLevel(nActualValue), isLitExistential(nActualValue), getLitPrefixLevel(nActualValue));    
	printf(" %d (Internal: %d E?: %d PL: %d, DL: %d, Active?: %d ) ", to_ff(nActualValue), nActualValue, isLitExistential(nActualValue), getLitPrefixLevel(nActualValue), intTolit(nActualValue)->assignLevel, isActive(nActualValue));
	if(getLitdagnode(negate(nActualValue)) != NULL)
	{
		printf("\n Literal %d (in NoGood: %d) is on the stack! ", negate(nActualValue), nActualValue);
		if(getLitdagnode(nActualValue))
		 printf(" ... nActual Value has a DAG node too... ");
	}
	//printf(" %d (E? %d) ",to_ff(nActualValue), isLitExistential(nActualValue));    
	// Move on in Cube
    ++nCurrentOffset;
    nActualValue = _vecNoGoods[nCurrentOffset];
  }
  printf("\n END ");
  //sort(vecCube.begin(), vecCube.end());
  //outputVector(vecCube);

}

bool isForced(int nNoGoodOffset) {
 int nCurrentOffset = nNoGoodOffset;
  int nActualValue = _vecNoGoods[nCurrentOffset];
  int nFalseCount = 0;
  printf("\n Forced? %d: ", nNoGoodOffset);
  // While not end of cube
  while(nActualValue != -1)
   {
     #ifdef SECURE
    assert(isLiteral(nActualValue));
     #endif
	printf(" %d (DL: %d, E?: %d, PL: %d, False?: %d, True?: %d) ", nActualValue, getReasonDecisionLevel(nActualValue), isLitExistential(nActualValue), getLitPrefixLevel(nActualValue), isFalse(nActualValue), isTrue(nActualValue));    
	if(!isFalse(nActualValue) && (!upstack->member(negate(nActualValue)))){     
	  nFalseCount++;
	  printf("\n Count! %d %d %d is Upstack Member? %d \n", nActualValue, (getLitdagnode(nActualValue) != NULL), (getLitdagnode(negate(nActualValue)) == NULL), upstack->member(nActualValue));
	}
	if(isTrue(nActualValue))
		printf(" \n True and dagnode true? : %d ", (getLitdagnode(nActualValue) != NULL));
	//printf(" %d (E? %d) ",to_ff(nActualValue), isLitExistential(nActualValue));    
	// Move on in Cube
    ++nCurrentOffset;
    nActualValue = _vecNoGoods[nCurrentOffset];
  }
  printf("\n nFalseCount %d ", nFalseCount);
  return true;
  if(nFalseCount == 1)
	  return true;
  else
	  return false;
}

stNoGoodInformation * computeReason(int nNoGoodOffset, int nFalsifiedLiteral) {
  assert(false);
  stNoGoodInformation * stNoGood = new stNoGoodInformation;
  stNoGood->nForcedLit = -1;
  int nCurrentOffset = nNoGoodOffset;
  int nActualValue = _vecNoGoods[nCurrentOffset];
  
  DAG * dnode1 = getLitdagnode(negate(nFalsifiedLiteral));
  assert(dnode1 != NULL);
  printf(" nFalsifiedLiteral: %d ", nFalsifiedLiteral);
  // While not end of cube
  while(nActualValue != -1)
  {
	printf("\n AV: %d %d %d %d %d %d ", nActualValue, (!isFalse(nActualValue)) ,(!isTrue(nActualValue)) ,(!upstack->member(negate(nActualValue))),(!upstack->member(nActualValue)), (nActualValue != nFalsifiedLiteral));
	if((!isFalse(nActualValue)) && (!isTrue(nActualValue)) && (!upstack->member(negate(nActualValue))) && (!upstack->member(nActualValue)) && (nActualValue != nFalsifiedLiteral)) {               
		stNoGood->nForcedLit = nActualValue;
		printf("\n HERE ! %d ", stNoGood->nForcedLit);
	}
	else {
		if(nActualValue != nFalsifiedLiteral){
			//printf("\n Compute Dagnode for %d (Falsified Literal: %d)! ", nActualValue, nFalsifiedLiteral);
          dnode1 = allocDAGNODE_NORMAL(getLitdagnode(negate(nActualValue)), dnode1);
		  assert(getLitdagnode(negate(nActualValue)) != NULL);
		}
	}
	// Move on in NoGood
    ++nCurrentOffset;
    nActualValue = _vecNoGoods[nCurrentOffset];
  }
  //assert(stNoGood->nForcedLit != -1);
  /*if(stNoGood->nForcedLit == -1){
	  dnode1 = NULL;
	  nCurrentOffset = nNoGoodOffset;
      nActualValue = _vecNoGoods[nCurrentOffset];
	  int nFirstNodeLit;
      while(nActualValue != -1)
      {
		  if(nActualValue != nFalsifiedLiteral){
			  nFirstNodeLit = nActualValue;
			  break;
		  }
       // Move on in NoGood
       ++nCurrentOffset;
       nActualValue = _vecNoGoods[nCurrentOffset];
	  }
      dnode1 = getLitdagnode(negate(nFirstNodeLit));

	  nCurrentOffset = nNoGoodOffset;
      nActualValue = _vecNoGoods[nCurrentOffset];
	  
      while(nActualValue != -1)
      {
		  if((nActualValue != nFalsifiedLiteral) && (nActualValue != nFirstNodeLit)) {
			dnode1 = allocDAGNODE_NORMAL(getLitdagnode(negate(nActualValue)), dnode1);  
		  }
       // Move on in NoGood
       ++nCurrentOffset;
       nActualValue = _vecNoGoods[nCurrentOffset];
	  }
	  stNoGood->nForcedLit = nFalsifiedLiteral;
  }*/
  assert(stNoGood->nForcedLit != -1);
  stNoGood->dagnode = dnode1;
  return stNoGood;
}

void setTriggeredNoGoods(int nNumber) {
  _nTriggeredNogoods = nNumber;
}

void setTriggeredNoGoodsPlusOne() {
  _nTriggeredNogoods = _nTriggeredNogoods + 1;
}

int getTriggeredNoGoods() {
 return _nTriggeredNogoods;
}

int getNumberOfNoGoods() {
	return _nNumberOfLearnedClauses;
}




// Update Watch in a single Clause
inline bool updateWatchInLearnedClause(int nLiteral, int nClauseOffset, vector<int> * vecNewWatchedLiterals)
{
  //int nActualDecisionLevel = getDecisionLevel();
  #ifdef SECUREQBF
  assert(isDecisionLevel(nActualDecisionLevel));
  #endif
  // Get Actual Offset Position of Clause in Theory
  int nActualOffset = nClauseOffset;
  // Store Position of First Watch
  int nOffsetFirstWatch = nActualOffset;
  // Store Position of Second Watch
  int nOffsetSecondWatch = nActualOffset + 1;
  //printf("\n Checking Clauses of %d! ", nLiteral);
  // If nLiteral is first watch then swap with second watch
  if(getLiteralByOffsetInLearnedClause(nClauseOffset) == nLiteral) {
   // Swap First and second Watch
   swapLiteralsinNoGood(nActualOffset, nOffsetSecondWatch);
   //printf(" Swap ");
  }
  //cout << "\n LnClauseOffset: " << nClauseOffset << " First Watch: " << getLiteralByOffsetInLearnedClause(nClauseOffset) << " Second Watch: " << getLiteralByOffsetInLearnedClause(nClauseOffset + 1); //cout.flush();
  // Now go through clause and try to find a new Literal
  bool bNewWatch = false;
  bool bFirstWatchOk = false;
  bool bSecondWatchOk = false;



  // Ignore Lazy Watch !
  if((nLiteral != getLiteralByOffsetInLearnedClause(nClauseOffset)) && (nLiteral != getLiteralByOffsetInLearnedClause(nClauseOffset + 1)))
  {
   //cout << " \n Ignore lazy Watch of Literal: " << nLiteral << " ";
   return true;
  }



  // If First Watch is true now then set bNewWatch to true
  if(getTruthValue(getLiteralByOffsetInLearnedClause(nClauseOffset)) == 1)
  {
    //cout << " First Watch true! \n"; //cout.flush();
    // This literal still watches the clause
    vecNewWatchedLiterals->push_back(nClauseOffset);
    // 'New' Watch has been found
    bNewWatch = true;
  }

  // If First Watch is unassinged then set bFirstWatch to true
  if((isLitExistential(getLiteralByOffsetInLearnedClause(nClauseOffset))) && (getTruthValue(getLiteralByOffsetInLearnedClause(nClauseOffset)) == -1))
  {
   bFirstWatchOk = true;
  }

  // Setting nCount to third variable in the Clause
  int    nCount = nOffsetSecondWatch + 1;
  int    nCurrentLiteral = getLiteralByOffsetInLearnedClause(nCount);
  short int nLiteralTruthValue;

  bool bFreeUniversal = false;
  bool bFreeExistential = false;
  int nOffsetUniversalWithSmallestPrefixLevel;
  int nUniversalWithSmallestPrefixLevel;
  int nSecondFreeExistentialOffset;
  int nSecondFreeExistential;
  int nFirstFreeExistentialOffset;
  int nFirstFreeExistential;
  bool nClauseTrue = false;
  bool bTwoExistentials = false;
  bool bClauseTrue = false;
  bool bForced = false;

  // As long there is no new Watch found and not end of Clause (STOP MARK!) do...
  while((!bNewWatch) && (nCurrentLiteral != -1) && (!bTwoExistentials))
  {
    //cout << " Current Litertal: " << nCurrentLiteral << " Truth Value " << getTruthValue(nCurrentLiteral) << " \n"; //cout.flush();
    #ifdef SECUREQBF
    assert(isLiteral(nCurrentLiteral));
    #endif
    nLiteralTruthValue = getTruthValue(nCurrentLiteral);

    // Literal is true?
    if(nLiteralTruthValue == 1)
    {
     // This literal (nLiteral) still watches the clause
     vecNewWatchedLiterals->push_back(nClauseOffset);

     // New Watch is true since we found a true Literal in the Clause !
     bNewWatch = true;
     bClauseTrue = true;
    }

     // Literal is unassigned?
     if(nLiteralTruthValue == -1)
     {
      // If Existential
      if(isLitExistential(nCurrentLiteral))
      {
        // There exists a free universal
        if(!bFreeExistential)
        {
         bFreeExistential = true;
         nFirstFreeExistentialOffset  = nCount;
         nFirstFreeExistential        = nCurrentLiteral;
        }
        else
        {
          nSecondFreeExistentialOffset  = nCount;
          nSecondFreeExistential        = nCurrentLiteral;
          bTwoExistentials = true;
        }
      }
      else
      {
        // There exists a free universal
        if(!bFreeUniversal)
        {
         bFreeUniversal = true;
         nOffsetUniversalWithSmallestPrefixLevel = nCount;
         nUniversalWithSmallestPrefixLevel = nCurrentLiteral;
        }
        else
        {
          // Check if current found literal is at a smaller prefix level then the previous found
          if(getLitPrefixLevel(nCurrentLiteral) < getLitPrefixLevel(nUniversalWithSmallestPrefixLevel))\
          {
            nOffsetUniversalWithSmallestPrefixLevel = nCount;
            nUniversalWithSmallestPrefixLevel = nCurrentLiteral;
          }
        }
      }
    }
    // Increase Actual Offset
    ++nCount;
    // Get new Literal
    nCurrentLiteral = getLiteralByOffsetInLearnedClause(nCount);
  } // End of while

  if(!bNewWatch)
  {
   /* if(bFreeUniversal)
     cout << "\n Universal with Smallest Prefix Level: " << nOffsetUniversalWithSmallestPrefixLevel << " ";
    else
     cout << "\n No Free Universal ";
    */
    int nFirstWatch = getLiteralByOffsetInLearnedClause(nOffsetFirstWatch);
    //cout << "\n First Watch : " << nFirstWatch << " is there free existential? " <<  bFreeExistential << " ";
    //cout << "\n nLiteral : " << nLiteral << " ";
    // First Case
    if((isLitExistential(nFirstWatch)) && (isLitExistential(nLiteral)))
    {
      // A
      if(bFreeExistential)
      {
        /*if(nClauseOffset == 31761)
        {
          cout << "\n LEARN Case A \n";
        }*/
        //cout << " Swap! " << nCurrentLiteral << " ";
        // Swap second watch
        swapLiteralsinNoGood(nOffsetSecondWatch, nFirstFreeExistentialOffset);
        //cout << "\n Add Literal Watch to " << nCurrentLiteral << " ClsOffset: " << nClauseOffset << " ";
        addLiteralWatchNoGood(nFirstFreeExistential, nClauseOffset);
        bNewWatch = true;
      }
      // B
      if((!bFreeExistential) && (bFreeUniversal) && (!bNewWatch))
      {
        /*if(nClauseOffset == 31761)
        {
         cout << "\n LEARN Case B \n";
        }*/
        // Is free universal upstream?
        if(getLitPrefixLevel(nUniversalWithSmallestPrefixLevel) < getLitPrefixLevel(nFirstWatch))
        {
         // Swap second watch
         swapLiteralsinNoGood(nOffsetSecondWatch, nOffsetUniversalWithSmallestPrefixLevel);
         //cout << "\n Add Literal Watch to " << nCurrentLiteral << " ClsOffset: " << nClauseOffset << " ";
         addLiteralWatchNoGood(nUniversalWithSmallestPrefixLevel, nClauseOffset);
         bNewWatch = true;
        }
      }
      // C
      if(!bNewWatch)
      {
        /*if(nClauseOffset == 31761)
        {
         cout << "\n Learned Case C \n";
        }*/
        nLiteralTruthValue = getTruthValue(nFirstWatch);
        // Fist Watch is unassigned
        if(nLiteralTruthValue == -1)
        {
         // Force First Watch to be true
         //cout << " Force Watch: " << nFirstWatch << " \n";

         

          // This literal still watches the clause
         vecNewWatchedLiterals->push_back(nClauseOffset);
         // Put Information on Stack
		 DAG* dnode = computeReasonLearnedClause(nClauseOffset, nLiteral, nFirstWatch);
         pushupstack(nFirstWatch, dnode);
		 setTriggeredNoGoodsPlusOne();
		 //printf("\n 1 Pushing %d on Stack! ", nFirstWatch);
		 //outputNoGood(nClauseOffset);
		 //putonStack(nFirstWatch);
         //setReason(nFirstWatch, LEARNEDKARY, nClauseOffset, 0, nActualDecisionLevel);
         // Now Watches are ok since one is TRUE
         bNewWatch = true;
         //addClausesOfLiteralToStackAndSetToTrue(nFirstWatch, nActualDecisionLevel);
        }
        else
        {
          bForced = true;
          #ifdef SECUREQBF
          assert(nLiteralTruthValue == 0);
          #endif
          //cout << "\n False Clause - Conflict Var: " << nLiteral << " ";
          //cout << "nFirst Watch " << nFirstWatch << " ";
          // This literal still watches the clause
          vecNewWatchedLiterals->push_back(nClauseOffset);
          // CHANGE TO CONFLICT LITERAL !  1 !
          // Put Information on Stack (CONFLICT!)
		  DAG* dnode = computeReasonLearnedClause(nClauseOffset, nLiteral, nLiteral);
          pushupstack(nLiteral, dnode);
		  setTriggeredNoGoodsPlusOne();
		  //printf("\n 2 Pushing %d on Stack (3 CONFLICT)! ", nFirstWatch);
		  //outputNoGood(nClauseOffset);
		  assert(haveContradiction());
          //putonStack(1);
          //setReason(1, LEARNEDKARY, nClauseOffset, 0, nLiteral);
        }
      }
    } // End: First Case
    // Second Case (1. part)
    if((!isLitExistential(nFirstWatch)) && (isLitExistential(nLiteral)))
    {
      // D2
      if(bTwoExistentials)
      {
        /*if(nClauseOffset == 31761)
        {
         cout << "\n LEARN Case D2 \n";
        }*/
        // Swap first watch
        swapLiteralsinNoGood(nOffsetFirstWatch, nSecondFreeExistentialOffset);
        //cout << "\n Add Literal Watch to " << nCurrentLiteral << " ClsOffset: " << nClauseOffset << " ";
        addLiteralWatchNoGood(nSecondFreeExistential, nClauseOffset);
        // Swap second watch
        swapLiteralsinNoGood(nOffsetSecondWatch, nFirstFreeExistentialOffset);
         //cout << "\n Add Literal Watch to " << nCurrentLiteral << " ClsOffset: " << nClauseOffset << " ";
        addLiteralWatchNoGood(nFirstFreeExistential, nClauseOffset);
        bNewWatch = true;
      }
      // E2
      if((!bTwoExistentials) && (bFreeExistential) && (!bNewWatch))
      {
        /*if(nClauseOffset == 31761)
        {
         cout << "\n LEARN Case E3 \n";
        }*/
        // First Watch Tailing Universal?
        if(getLitPrefixLevel(nFirstFreeExistential) > getLitPrefixLevel(nFirstWatch))
        {
          // Swap second watch
         swapLiteralsinNoGood(nOffsetSecondWatch, nFirstFreeExistentialOffset);
          //cout << "\n Add Literal Watch to " << nCurrentLiteral << " ClsOffset: " << nClauseOffset << " ";
          addLiteralWatchNoGood(nFirstFreeExistential, nClauseOffset);
          bNewWatch = true;
        }
      }
      // E3
      if((!bTwoExistentials) && (bFreeExistential) && (bFreeUniversal) && (!bNewWatch))
      {
        /*if(nClauseOffset == 31761)
        {
         cout << "\n LEARN Case E4 \n";
        }*/
        // Is free universal and free existential a good match?
        if(getLitPrefixLevel(nFirstFreeExistential) > getLitPrefixLevel(nUniversalWithSmallestPrefixLevel))
        {
          // Swap first watch
         swapLiteralsinNoGood(nOffsetFirstWatch, nOffsetUniversalWithSmallestPrefixLevel);
         //cout << "\n Add Literal Watch to " << nCurrentLiteral << " ClsOffset: " << nClauseOffset << " ";
         addLiteralWatchNoGood(nUniversalWithSmallestPrefixLevel, nClauseOffset);
         // Swap second watch
         swapLiteralsinNoGood(nOffsetSecondWatch, nFirstFreeExistentialOffset);
          //cout << "\n Add Literal Watch to " << nCurrentLiteral << " ClsOffset: " << nClauseOffset << " ";
         addLiteralWatchNoGood(nFirstFreeExistential, nClauseOffset);
         bNewWatch = true;
        }
      }
      // F1
      if((!bTwoExistentials) && (bFreeExistential) && (!bNewWatch))
      {
        /*if(nClauseOffset == 31761)
        {
          cout << "\n 2 LEARN Case F1 \n";
        }*/

         nLiteralTruthValue = getTruthValue(nFirstWatch);
         // Fist Watch is unassigned
         if(nLiteralTruthValue == -1)
         {
          // Force First Watch to be true
          //cout << " Force Watch: " << nFirstFreeExistential << " \n";

          //assert(setTruthValueQ(nFirstFreeExistential, 1));

          // This literal still watches the clause
          vecNewWatchedLiterals->push_back(nClauseOffset);
          // Put Information on Stack
		  DAG* dnode = computeReasonLearnedClause(nClauseOffset, nLiteral, nFirstFreeExistential);
          pushupstack(nFirstFreeExistential, dnode);
		  setTriggeredNoGoodsPlusOne();
		  //printf("\n 3 Pushing %d on Stack! ", nFirstFreeExistential);
		  //outputNoGood(nClauseOffset);
          //putonStack(nFirstFreeExistential);
          //setReason(nFirstFreeExistential, LEARNEDKARY, nClauseOffset, 0, nActualDecisionLevel);
          // Now Watches are ok since one is TRUE
          bNewWatch = true;
         // addClausesOfLiteralToStackAndSetToTrue(nFirstFreeExistential, nActualDecisionLevel);
         }
         else
         {
           bForced = true;
           #ifdef SECUREQBF
           assert(nLiteralTruthValue == 0);
           #endif
           //cout << "\n LEARN False Clause - Conflict Var: " << nLiteral << " ";
           // This literal still watches the clause
           vecNewWatchedLiterals->push_back(nClauseOffset);
           // Put Information on Stack (CONFLICT!)
		   DAG* dnode = computeReasonLearnedClause(nClauseOffset, nLiteral, nLiteral);
           pushupstack(nLiteral, dnode);
		   setTriggeredNoGoodsPlusOne();
		   //printf("\n 4 Pushing %d on Stack (2 CONFLICT)! ", nLiteral);
		   //outputNoGood(nClauseOffset);
		   assert(haveContradiction());
           //putonStack(1);
           //setReason(1, LEARNEDKARY, nClauseOffset, 0, nLiteral);
         }
      }
      // G
      if((!bTwoExistentials) && (!bFreeExistential) && (!bNewWatch) && (!bForced))
      {
        /*if(nClauseOffset == 31761)
        {
         cout << "\n G LEARN False Clause - Conflict Var: " << nLiteral << " ";
        }*/
        //outputLearnedClause(nClauseOffset);
        // This literal still watches the clause
        vecNewWatchedLiterals->push_back(nClauseOffset);
        // Put Information on Stack (CONFLICT!)
		DAG* dnode = computeReasonLearnedClause(nClauseOffset, nLiteral, nLiteral);
        pushupstack(nLiteral, dnode);
		setTriggeredNoGoodsPlusOne();
		//printf("\n 5 Pushing %d on Stack (1 CONFLICT)! ", nLiteral);
		//outputNoGood(nClauseOffset);
		assert(haveContradiction());
        //putonStack(1);
        //setReason(1, LEARNEDKARY, nClauseOffset, 0, nLiteral);
      }
    }

    // Second Case (2. part)
    if((isLitExistential(nFirstWatch)) && (!isLitExistential(nLiteral)))
    {
      // D1
      if(bFreeExistential)
      {
        /*if(nClauseOffset == 31761)
        {
         cout << " LEARN Case D1 "; cout.flush();
        }*/
        //outputVector(_vecLiteralLearnedClauseWatches[665]);
        //cout << " Two FreeExists: "<< bTwoExistentials << " Free Univeral " << bFreeUniversal << " ";
       if(bTwoExistentials)
       {
         // Swap second watch
         swapLiteralsinNoGood(nOffsetSecondWatch, nFirstFreeExistentialOffset);
         //cout << "\n (1) Add Literal Watch to " << nFirstFreeExistential << " ClsOffset: " << nClauseOffset << " "; cout.flush();
         addLiteralWatchNoGood(nFirstFreeExistential, nClauseOffset);
         bNewWatch = true;
       }
       if((bFreeUniversal) && (!bNewWatch))
        {
         if(getLitPrefixLevel(nFirstFreeExistential) > getLitPrefixLevel(nUniversalWithSmallestPrefixLevel))
         {
          // Swap second watch
          swapLiteralsinNoGood(nOffsetSecondWatch, nFirstFreeExistentialOffset);
          //cout << "\n (2) Add Literal Watch to " << nFirstFreeExistential << " ClsOffset: " << nClauseOffset << " "; cout.flush();
          addLiteralWatchNoGood(nFirstFreeExistential, nClauseOffset);
          bNewWatch = true;
         }
        }
        if(!bNewWatch)
        {
          if(getTruthValue(nFirstWatch) == -1)
          {
            if((isLitExistential(nFirstWatch)) || (getLitPrefixLevel(nFirstFreeExistential) > getLitPrefixLevel(nFirstWatch)))
            {
             // Swap second watch
             swapLiteralsinNoGood(nOffsetSecondWatch, nFirstFreeExistentialOffset);
            // cout << "\n (3) Add Literal Watch to " << nFirstFreeExistential << " ClsOffset: " << nClauseOffset << " "; cout.flush();

             //_vecLiteralLearnedClauseWatches[665]->push_back(nClauseOffset);
             //outputVector(_vecLiteralLearnedClauseWatches[665]);
             //assert(false);
             addLiteralWatchNoGood(nFirstFreeExistential, nClauseOffset);
             bNewWatch = true;
              //assert(false);
            }
          }
          if(!bNewWatch)
          {
            //outputStack();
            //outputClause(nClauseOffset);
           // cout << " Hallo ";

            //assert(setTruthValueQ(nFirstFreeExistential, 1));

            // This literal still watches the clause
            vecNewWatchedLiterals->push_back(nClauseOffset);
            // Put Information on Stack
			DAG* dnode = computeReasonLearnedClause(nClauseOffset, nLiteral, nFirstFreeExistential);
            pushupstack(nFirstFreeExistential, dnode);
            setTriggeredNoGoodsPlusOne();		
			//printf("\n 6 Pushing %d on Stack! ", nFirstFreeExistential);
		    //outputNoGood(nClauseOffset);
            //putonStack(nFirstFreeExistential);
            //setReason(nFirstFreeExistential, LEARNEDKARY, nClauseOffset, 0, nActualDecisionLevel);
            // Now Watches are ok since one is TRUE
            bNewWatch = true;
            //addClausesOfLiteralToStackAndSetToTrue(nFirstFreeExistential, nActualDecisionLevel);
          }
        }
      }
      // E1
      if((!bFreeExistential) && (bFreeUniversal) && (!bNewWatch))
      {
        /*if(nClauseOffset == 31761)
        {
         cout << "\n LEARN Case E1 \n ";
        }*/
        // is free universal before second watch
        if(getLitPrefixLevel(nFirstWatch) > getLitPrefixLevel(nUniversalWithSmallestPrefixLevel))
        {
          // Swap second watch
          swapLiteralsinNoGood(nOffsetSecondWatch, nOffsetUniversalWithSmallestPrefixLevel);
           //cout << "\n Add Literal Watch to " << nCurrentLiteral << " ClsOffset: " << nClauseOffset << " ";
          addLiteralWatchNoGood(nUniversalWithSmallestPrefixLevel, nClauseOffset);
          bNewWatch = true;
        }
      }
      // F1
      if(!bNewWatch)
      {
         nLiteralTruthValue = getTruthValue(nFirstWatch);
         // Fist Watch is unassigned
         if(nLiteralTruthValue == -1)
         {
           /*if(nClauseOffset == 31761)
           {
            cout << "\n 1 QBF LEARN Case F1 ClauseOffset " << nClauseOffset << " ";
           }*/
          //outputLearnedClause(nClauseOffset);
          // Force First Watch to be true
          //cout << " Force Watch: " << nFirstWatch << " \n";

          

          // This literal still watches the clause
          vecNewWatchedLiterals->push_back(nClauseOffset);
          // Put Information on Stack
		  DAG* dnode = computeReasonLearnedClause(nClauseOffset, nLiteral, nFirstWatch);
          pushupstack(nFirstWatch, dnode);
		  setTriggeredNoGoodsPlusOne();
		  //printf("\n 7 Pushing %d on Stack! ", nFirstWatch);
		  //outputNoGood(nClauseOffset);
          //putonStack(nFirstWatch);
          //setReason(nFirstWatch, LEARNEDKARY, nClauseOffset, 0, nActualDecisionLevel);
          // Now Watches are ok since one is TRUE
          bNewWatch = true;
          //addClausesOfLiteralToStackAndSetToTrue(nFirstWatch, nActualDecisionLevel);
         }
         else
         {
           bForced = true;
           #ifdef SECUREQBF
           assert(nLiteralTruthValue == 0);
           cout << "\n (LEARNED CLAUSE) False Clause - Conflict Var: " << nLiteral << " ";
           #endif

           // This literal still watches the clause
           vecNewWatchedLiterals->push_back(nClauseOffset);
           // Put Information on Stack (CONFLICT!)
		   DAG* dnode = computeReasonLearnedClause(nClauseOffset, nLiteral, nLiteral);
           pushupstack(nLiteral, dnode);
		   setTriggeredNoGoodsPlusOne();
		   //printf("\n 8 Pushing %d on Stack (CONFLICT)! ", nLiteral);
		   assert(haveContradiction());
		   //outputNoGood(nClauseOffset);
           //putonStack(1);
           //setReason(1, LEARNEDKARY, nClauseOffset, 0, nLiteral);
         }
      }
    }
  }
  /*if(nClauseOffset == 183)
  {
   cout << " New First Watch: " << getLiteralByOffsetInLearnedClause(nClauseOffset);// << " Truth Value: " << getTruthValue(getLiteralByOffsetInLearnedClause(nClauseOffset)) << " ";
   cout << " New Second Watch: " << getLiteralByOffsetInLearnedClause(nClauseOffset + 1); // << "Truth Value: " << getTruthValue(getLiteralByOffsetInLearnedClause(nClauseOffset + 1))<<" \n";
   cout.flush();
   outputVector(vecNewWatchedLiterals);
  }*/
  #ifdef SECUREQBF
  assert(isLitExistential(getLiteralByOffsetInLearnedClause(nClauseOffset)) || isLitExistential(getLiteralByOffsetInLearnedClause(nClauseOffset + 1)));
  #endif
  return bNewWatch;
}


bool updateWatchesInLearnedClauses(int nLiteral)
{
  // Get Watches on Kary-Clauses
  vector<int> * vecClauseOffset = getLiteralInNoGoodWatches(nLiteral);
  //cout << "\n Literal " << nLiteral << " watches: "; cout.flush();
  //printf("\n Updating Watches of %d ", nLiteral);
  //_cDataStructure->outputVector(vecClauseOffset);
  // Test if Literal Watches some K-Ary Clauses
  if(vecClauseOffset->size() > 0)
  {
   vector<int>::iterator iterVec = vecClauseOffset->begin();
   vector<int> * vecNewLiteralWatches = new vector<int>;

   // Go through the Clauses this Literal watches...
   while((iterVec != vecClauseOffset->end()) && (updateWatchInLearnedClause(nLiteral,*iterVec, vecNewLiteralWatches)))
    {
     ++iterVec;
    }
   // All Watches updated without Conflict
   if(iterVec == vecClauseOffset->end())
   {
     // Set Literal Wacthes of this Literal
     setLiteralInNoGoodWatches(nLiteral, vecNewLiteralWatches);
     return true;
   }
   else // Conflict
   {
     // Copy remaining Clause Watches (the watch in the conflicting clause is already kept)
     // Therefore, increment iterVec
     ++iterVec;
     vector<int>::iterator iterVecRemaining;
     for(iterVecRemaining = iterVec; iterVecRemaining != vecClauseOffset->end(); ++iterVecRemaining)
     {
      vecNewLiteralWatches->push_back(*iterVecRemaining);
     }
     // Set Literal Wacthes of this Literal
     setLiteralInNoGoodWatches(nLiteral, vecNewLiteralWatches);
     return false;
   }
  }
  return true;
}



inline int getLiteralByOffsetInLearnedClause(int nCount) {
	return _vecNoGoods[nCount];
}

inline int getTruthValue(int nLiteral) {

	assert(nLiteral > -1);
	// We have to take the equivalent literal into account!
	int nCurrentLiteral = eqlit(nLiteral);
	if(!isTrue(nCurrentLiteral) && !isFalse(nCurrentLiteral) && (!upstack->member(nCurrentLiteral)) && (!upstack->member(negate(nCurrentLiteral))))
	 return -1;
	else if(isTrue(nCurrentLiteral) || upstack->member(nCurrentLiteral)) {
     return 1;
	}
	else
	 return 0;
}

DAG* computeReasonLearnedClause(int nNoGoodOffset, int nFalsifiedLiteral, int nForcedLiteral) {
  DAG * dnode1;
  int nCurrentOffset = nNoGoodOffset;
  int nActualValue = _vecNoGoods[nCurrentOffset];
  if(nFalsifiedLiteral == nForcedLiteral)
	   assert(eqlit(nForcedLiteral) == nForcedLiteral); 
  nForcedLiteral = eqlit(nForcedLiteral);
  if(nFalsifiedLiteral != nForcedLiteral) {
   dnode1 = getLitdagnode(negate(nFalsifiedLiteral));
   assert(dnode1 != NULL);
   //outputNoGood(nNoGoodOffset);
   //printf(" nForcedLiteral: %d Eq: %d ", nForcedLiteral, eqlit(nForcedLiteral));
   
   // While not end of cube
   while(nActualValue != -1)
   {
	 //printf("\n AV: %d (E?: %d) %d %d %d %d %d ", nActualValue, isLitExistential(nActualValue), (!isFalse(nActualValue)) ,(!isTrue(nActualValue)) ,(!upstack->member(negate(nActualValue))),(!upstack->member(nActualValue)), (nActualValue != nFalsifiedLiteral));
	nActualValue = eqlit(nActualValue);
	if((nActualValue != nFalsifiedLiteral) && (nActualValue != nForcedLiteral)){
          dnode1 = allocDAGNODE_NORMAL(getLitdagnode(negate(nActualValue)), dnode1);
		  assert((getLitdagnode(negate(nActualValue)) != NULL) || !isLitExistential(nActualValue));
		}
	
	// Move on in NoGood
    ++nCurrentOffset;
    nActualValue = _vecNoGoods[nCurrentOffset];
   }  
  } 
  else { 
   bool bFirst = true;
   //printActiveClauses();
   // While not end of cube
   while(nActualValue != -1)
   {
    nActualValue = eqlit(nActualValue);
	//printf("\n AV: %d %d %d %d %d %d ", nActualValue, (!isFalse(nActualValue)) ,(!isTrue(nActualValue)) ,(!upstack->member(negate(nActualValue))),(!upstack->member(nActualValue)), (nActualValue != nFalsifiedLiteral));
	//if(nActualValue != nFalsifiedLiteral) {
		  if(bFirst) {
			  if(getLitdagnode(negate(nActualValue)) != NULL) {
               dnode1 = getLitdagnode(negate(nActualValue));
			   //printf("\n (1) Dagnode != Null Lit: %d ", nActualValue);
               bFirst = false;
			  }
			  else
			  {
                assert((getLitdagnode(negate(nActualValue)) != NULL) || !isLitExistential(nActualValue));
			  }			
		  } 
		  else {
		   if(getLitdagnode(negate(nActualValue)) != NULL) {
		    dnode1 = allocDAGNODE_NORMAL(getLitdagnode(negate(nActualValue)), dnode1);
			//printf("\n (2) Dagnode != Null Lit: %d ", nActualValue);
		   }
		   else
		    assert((getLitdagnode(negate(nActualValue)) != NULL) || !isLitExistential(nActualValue));
		  }
	//}
	
	// Move on in NoGood
    ++nCurrentOffset;
    nActualValue = _vecNoGoods[nCurrentOffset];
   }
  }
 return dnode1;
}

void outputLearnedClauses() {
 vector<int>::iterator iterVec;
 for(iterVec = _vecNoGoods.begin(); iterVec != _vecNoGoods.end(); iterVec++) {
  if(*iterVec == -1)
	 printf("0\n");
  else
     printf("%d ", to_ff(*iterVec)); 
 }
}



// VSIDS BASED Heuristic


void initLiteralScore(int nNumberofLits)
{
  //printf("\n Number of Lits: %d ", nNumberofLits);
  _arrLiteralsScore     = new float[nNumberofLits + 1];
  int i;
  for(i=0; i < nNumberofLits; i++)
  {
   _arrLiteralsScore[i] = 0;   
  }
}


void  setLiteralScore(int nLiteral, float nScore)
{
   #ifdef SECURE
  assert(isLiteral(nLiteral));
  assert(nScore >= 0);
   #endif
  _arrLiteralsScore[nLiteral] = nScore;
}


float  getLiteralScore(int nLiteral)
{
  return _arrLiteralsScore[nLiteral];
}


void  inline setLiteralScorePlus(int nLiteral, float nAddedScore)
{
   #ifdef SECURE
  assert(isLiteral(nLiteral));
  assert(nAddedScore >= 0);
   #endif   
  _arrLiteralsScore[nLiteral] = _arrLiteralsScore[nLiteral] + nAddedScore;  
}

void setConflictScoreValue()
{
  float nMaxScore = getLiteralScore(getLiteralWithMaxVarScore());
  float nScore = nMaxScore / 10; //5

  if (nScore > 1)
   _nConflictScoreValue = nScore;
  else
   _nConflictScoreValue = 1;
  #ifdef SECURE
  cout << "\n Conflict Score Value: " << _nConflictScoreValue << " Max Literal: " << getMaxLiteral() << " MaxScore: "  << nMaxScore << " ";
  #endif
}

int inline getLiteralWithMaxVarScore()
{
  return _nLiteralWithMaxVarScore;
}

void  setLiteralWithMaxVarScore(int nLiteral)
{
  //cout << "\n Set Literal with Max Var Score: " << nLiteral << " "; //cout.flush();
   #ifdef SECURE
  assert(isLiteral(nLiteral));
   #endif
  _nLiteralWithMaxVarScore = nLiteral;
}


// Identify Literal with maximal score
// Use simple average of positive and negative literal
int inline getNewLiteralWithMaxVarScore()
{
  int nMaxLiteral = getMaxLiteral();
  int nCount = 0;
  float nCurrentMax = 0;
  int nLiteralwithMaxScore = 0;
  while (nCount < nMaxLiteral)
  {
    //printf("\n Score %f of Literal %d ", nCount, _arrLiteralsScore[nCount]);
    //(isActive(nCount)) &&
    if( ((_arrLiteralsScore[nCount] + _arrLiteralsScore[nCount + 1]) > nCurrentMax))
    {
     nCurrentMax = _arrLiteralsScore[nCount] + _arrLiteralsScore[nCount + 1];
     if(_arrLiteralsScore[nCount] > _arrLiteralsScore[nCount + 1])
      nLiteralwithMaxScore = nCount;
     else
      nLiteralwithMaxScore = nCount + 1;
     //cout << "\n New Var Score for: " << nCount << " Value: " << nCurrentMax << "  " ;
    }
    nCount = nCount + 2;
  }
  if(nCurrentMax != 0)
  {
   #ifdef SECURE
   assert(getLiteralValue(nLiteralwithMaxScore) == -1);
   #endif
   setLiteralWithMaxVarScore(nLiteralwithMaxScore);
   return nLiteralwithMaxScore;
  }
  else
   return 0;
}

// Identify Literal with maximal score
// Use simple average of positive and negative literal
float getNewMaxVarScore()
{
  int nMaxLiteral = getMaxLiteral();
  int nCount = 0;
  float nCurrentMax = 0;
  int nLiteralwithMaxScore = 0;
  while (nCount < nMaxLiteral)
  {
    //printf("\n Score %f of Literal %d ", nCount, _arrLiteralsScore[nCount]);
    //(isActive(nCount)) &&
    if( ((_arrLiteralsScore[nCount] + _arrLiteralsScore[nCount + 1]) > nCurrentMax))
    {
     nCurrentMax = _arrLiteralsScore[nCount] + _arrLiteralsScore[nCount + 1];
     //cout << "\n New Var Score for: " << nCount << " Value: " << nCurrentMax << "  " ;
    }
    nCount = nCount + 2;
  }
  if(nCurrentMax > 0)
   return nCurrentMax;
  else
   return 1;
}

void setNumberBcls(int nBcls) {
	_nBcls = nBcls;
}

int getNumberBcls() {
	return _nBcls;
}

/*int getLiteralWithMaxScoreinPL(int *arrSortedLits, int nPrefixLevel) {

  int nCount = 0;
  float nCurrentMax = 0;
  int nLiteralwithMaxScore = 0;
  while((getLitPrefixLevel(arrSortedLits[nCount] == nPrefixLevel) || (nCurrentMax == 0)) {
	  if((!isInactive(arrSortedLits[nCount]) && (getLitPrefixLevel(arrSortedLits[nCount] == nPrefixLevel) && (_arrLiteralsScore[nCount] + _arrLiteralsScore[nCount + 1]) > nCurrentMax)) {
	   nCurrentMax = _arrLiteralsScore[nCount] + _arrLiteralsScore[nCount + 1];
       if(_arrLiteralsScore[nCount] > _arrLiteralsScore[nCount + 1])
        nLiteralwithMaxScore = nCount;
       else
        nLiteralwithMaxScore = nCount + 1;
	  }
   nCount + 2;
  }
  if(nCurrentMax != 0)
  {  
   setLiteralWithMaxVarScore(nLiteralwithMaxScore);
   return nLiteralwithMaxScore;
  }
  else
   return 0;
}*/


float inline getConflictScoreValue()
{
  return _nConflictScoreValue;
}


void inline decayLiteralVarScore()
{
  float nNewScore = 0;
  float nOldScore;
  for(int nLiteral = 0; nLiteral <= NLITS; ++nLiteral)
  {
    #ifdef SECURE
    assert(isLiteral(nLiteral));
    #endif
    // Divide all Literal Scores by 2
    nOldScore = getLiteralScore(nLiteral);
    if(nOldScore > 0)
    {
      nNewScore = nOldScore / 2;
      if(nNewScore == 0)
       nNewScore = 1;
    }
    setLiteralScore(nLiteral, nNewScore);
  }
  // Set Literal with highest Var Score after updating all Literals
  //setLiteralWithMaxVarScore(getNewLiteralWithMaxVarScore());
  //outputLearnedClauses2File();
  //cout << "\n DECAYING VAR SCORE. DL: " << getDecisionLevel() << " ";
  //outputLiteralArray(_arrLiteralsTruthTable);
  // Reset Conflict Count
  _nNumberOfResetConflicts = 0;
}

void  inline updateNumberOfResetConflicts()
{
  ++_nNumberOfResetConflicts;
}

void inline updateNumberOfConflicts()
{
  ++_nNumberOfConflicts;
}

void setDecayLiteralScoreInterval(int nValue)
{
  _decayLiteralScoreInterval = nValue;
}

int inline getNumberOfResetConflicts()
{
  return _nNumberOfResetConflicts;
}

int inline getDecayLiteralScoreInterval()
{
  return _decayLiteralScoreInterval;
}

void printActiveClauses() {

 
  CLAUSELIST *cl;
  int i, j;
  int nCubeLiteral;
 
  // First get all the NECCESSARY literals in the cube
  // Don't need to take care of the units, do we?
  for(i=1;i<CLSGROUPS;i++)
        for(cl=lenNclauses[i];cl;cl=cl->pnext) {
          //printf("Checking clause:\n");
          //printCLAUSELIST(cl);
          bool val                   = false;
          int  nNumberOfTrueLiterals = 0;
          for(j=0;j<cl->clslen;j++)
          {
                if(isTrue(eqlit(cl->cls[j])))
                {
                  val=true;                  
                  nNumberOfTrueLiterals++;  				  
                } 
             if(nNumberOfTrueLiterals > 1)
              break;
		  }
		  if(nNumberOfTrueLiterals == 0){
            printf("\n");
            for(j=0;j<cl->clslen;j++)
            {
              printf(" %d", cl->cls[j]);
			}
		  }
		}
}
