/*

2clsQ. Copyright Horst Samulowitz and Fahiem Bacchus 2006

 A DPLL QBF solver based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to
implied warranties of merchantability and fitness for a particular
purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Fahiem Bacchus },
	year    = { 2006 },
	title   = { {2clsQ} a {DPLL} solver employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/
#ifndef __nogood_H
#define __nogood_H
#include "2clsEq.h"
#include "uniqueset.h"
#include "dag.h"
#include <limits.h>

class NoGood;
extern NoGood** pngsalloc;
void MakeNoGoodstore(int size);

class NoGood {
  //Like an array...probably should write operator overloads for []!
  //same with copy...should write operator overload for =.
  //A nogood of size SIZE can hold size bits indexed from 0 to size-1.
public:
  int maxindex;
  int size;
  bit *vector;
  NoGood *pnext;
  void copyNoGood(NoGood* ng);
  void unionFromNoGood(NoGood* ng);
  void unionFromDAG(DAG* dagnode);
  void unionIntoUniqueSet(UniqueSet *uqset);
  void empty();
  void makeCanonical();
  void setbit(int i);
  void unsetbit(int i);
  bool getbit(int i);
  int max();
  int maxAndUniversal(int * dplLevelToLit);
  int maxAndExistential(int * dplLevelToLit);
  int maxfrom(int i);
  void print();
  void printLiterals(int * dplLevelToLit);
  void cutTailingUniversals(int * dplLevelToLit);
  void init(int sz);
  //vector<int>* getLiterals(int * dplLevelToLit);


  NoGood(int sz) {
	//the nogood can store sz bits, or in terms of indicies
	//0--sz-1.
	maxindex=sz-1;
	size=numberOfInts(sz);
	if(size>0) {
	  vector=new bit[size];
	  if(!vector)
	    panic("Memory Allocation Failure #20\n");
	}
	else
	  vector=NULL;
	for(int i=0;i<size;i++)
	  vector[i]=0;
  };
};

extern NoGood** noGoodAtLevel;

inline void NoGood::setbit(int i) {
  if(i<=maxindex)
	vector[i/bitsperint] |= (1 << (i%bitsperint));
}

inline void NoGood::unsetbit(int i) {
  if(i<=maxindex)
	vector[i/bitsperint] &= ~(1 << (i%bitsperint));
}

inline bool NoGood::getbit(int i) {
  if(i<=maxindex)
	if(vector[i/bitsperint] & (1 << (i%bitsperint)))
	  return(true);
	else
	  return(false);
  return(false);
}

inline int NoGood::max() {
  for(int i=maxindex;i>0;i--) {
	if(getbit(i))
	  return(i);
  }
  return(0);
}

inline int NoGood::maxAndUniversal(int * dplLevelToLit) {
	//printf("\n Skipping Tailing Existentials: ");
	//printf("\n nmaxindex: %d ", maxindex);
	for(int i=maxindex;i>0;i--) {
	if(getbit(i))
	{
		//printf("[%d (PL: %d)] Level: %d ", dplLevelToLit[i], getLitPrefixLevel(dplLevelToLit[i]), i);	  
      if(isLitExistential(dplLevelToLit[i]))	 
	  {
		  //printf("[%d (PL: %d)] ", dplLevelToLit[i], getLitPrefixLevel(dplLevelToLit[i]));	  
		  unsetbit(i);
	  }
	  else
	  {         
		  //printf(" Return [%d (PL: %d)] to Level (%d) ", dplLevelToLit[i], getLitPrefixLevel(dplLevelToLit[i]), i);	  
		  return(i);
	  }
	}
  }
  return(0);
}


inline int NoGood::maxAndExistential(int * dplLevelToLit) {
  //printf("\n Skipping Tailing Universals: ");
  for(int i=maxindex;i>0;i--) {
	if(getbit(i))
	{
      if(isLitExistential(dplLevelToLit[i]))	 
	  {
		  return(i);
	  }
	  else
	  {
         //printf("[%d (PL: %d)] ", dplLevelToLit[i], getLitPrefixLevel(dplLevelToLit[i]));	   
		 unsetbit(i);
	  }
	}
  }
  return(0);
}

/*inline vector<int>* NoGood::getLiterals(int * dplLevelToLit) {
  //printf("\n Skipping Tailing Universals: ");
  vector<int>* vecNoGood = new vector<int>;
  
  for(int i=maxindex;i>0;i--) {
	if(getbit(i))
	{
      if(isLitExistential(dplLevelToLit[i]))	 
	  {
		  
	  }
	  else
	  {
         //printf("[%d (PL: %d)] ", dplLevelToLit[i], getLitPrefixLevel(dplLevelToLit[i]));	   
		 unsetbit(i);
	  }
	}
  }
  return vecNoGood;
}*/


inline int NoGood::maxfrom(int start) {
  for(int i=start-1;i>0;i--) {
	if(getbit(i))
	  return(i);
  }
  return(0);
}

inline void NoGood::init(int sz) {
  maxindex=sz-1;
  for(int i=0;i<size;i++)
	vector[i]=0;
}

inline void NoGood::makeCanonical() {
  int shift = maxindex+1 % bitsperint;
  if(shift != 0)
	vector[size-1] &= (bit) ~0 >> (bitsperint - shift);
}

inline void NoGood::unionFromNoGood(NoGood *ng) {
  for(int i=0;i<size&&i<ng->size;i++) 
	vector[i] |= ng->vector[i];
  makeCanonical();
}

inline void NoGood::unionIntoUniqueSet(UniqueSet *uqset) {
  for(int i=0;i<=maxindex;i++) 
	if(getbit(i))
	  uqset->pushnew(i);
}

inline void NoGood::empty() {
  for(int i=0;i<size;i++)
	vector[i] = (bit) 0;
}

void SearchDAG(DAG *dnode, NoGood *ng);

inline void NoGood::unionFromDAG(DAG *dagnode) {
  SearchDAG(dagnode, this);
}

inline void NoGood::copyNoGood(NoGood* ng) {
  for(int i=0;i<size&&i<ng->size;i++) 
    vector[i] = ng->vector[i];
  makeCanonical();
}

inline NoGood* allocNoGood(int sz) {
  //allocate a new no good that can store levels sz bits inclusive.
  int size=numberOfInts(sz);
  if(!pngsalloc[size])
    MakeNoGoodstore(size);
  NoGood *pNoGood = pngsalloc[size];
  pngsalloc[size]=pNoGood->pnext;
  //Initialize nogood.
  pNoGood->init(sz);
  return(pNoGood);
}

inline void deallocNoGood(NoGood* png) {
  //deallocate it.
  png->pnext = pngsalloc[png->size];
  pngsalloc[png->size] = png;
}

  
#endif __nogood_H
