/*

2clsQ. Copyright Horst Samulowitz and Fahiem Bacchus 2006

 A DPLL QBF solver based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to
implied warranties of merchantability and fitness for a particular
purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Fahiem Bacchus },
	year    = { 2006 },
	title   = { {2clsQ} a {DPLL} solver employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/

#include "nogood.h"
#include "dag.h"
#include <stdio.h>

NoGood** noGoodAtLevel;
NoGood** pngsalloc;

void NoGood::print() {
  printf("[");
  for(int i=0;i<=maxindex;i++) {
	if(getbit(i))
		printf("%d,",i);
  }
  printf("]\n");
}

void NoGood::printLiterals(int * dplLevelToLit) {
  printf("[");
  for(int i=0;i<=maxindex;i++) {
	if(getbit(i))
		printf("%d [Lit: %d E?: %d PL: %d] ",i , dplLevelToLit[i], intTolit(dplLevelToLit[i])->bExistential, getLitPrefixLevel(dplLevelToLit[i]));
  }
  printf("]\n");
}

void NoGood::cutTailingUniversals(int * dplLevelToLit) {  
  int nMaxExistentialPL = -1;
  int nMaxUniversalPL   = -1;
  
  for(int i=0;i<=maxindex;i++) {
	if(getbit(i))
	{
		if(isLitExistential(dplLevelToLit[i]))
		{
			if(getLitPrefixLevel((dplLevelToLit[i])) > nMaxExistentialPL){
			 nMaxExistentialPL = getLitPrefixLevel(dplLevelToLit[i]);
			}
		}
		else if(getLitPrefixLevel((dplLevelToLit[i])) > nMaxUniversalPL){
			 nMaxUniversalPL = getLitPrefixLevel(dplLevelToLit[i]);
		}
	}
  }
  // Do we have tailing universal?
  if(nMaxUniversalPL > nMaxExistentialPL)
  {
   // Then unset all the bits of the tailing universals
   for(int i=0;i<=maxindex;i++) {
	   if(getbit(i))
	   {
		 if(getLitPrefixLevel((dplLevelToLit[i])) > nMaxExistentialPL){
			 unsetbit(i);
		 }
	   }
   }
  }
}

int NOGOODALLOCFACTOR;

void initNoGoods() {
  int i;
  noGoodAtLevel = new (NoGood *[(NACTIVELITS)/2]);
  if(!noGoodAtLevel)
	panic("Memory Allocation Failure #17\n");
  for(i=0;i<(NACTIVELITS)/2;i++)
	noGoodAtLevel[i]=NULL;
  int allocarraysize= (NACTIVELITS)/(2*bitsperint) + 2;
  pngsalloc = new (NoGood *[allocarraysize]);
  if(!pngsalloc)
	panic("Memory Allocation Failure #18\n");
  for(i=0;i<allocarraysize;i++)
	pngsalloc[i]=NULL;
  NOGOODALLOCFACTOR=200;
}
  
void MakeNoGoodstore(int size) {
  int unitsize=(sizeof(NoGood)+sizeof(bit)*size)/sizeof(bit);
  bit *storage=new bit[unitsize*NOGOODALLOCFACTOR];
  if(!storage)
	panic("Memory Allocation Failure #19\n");

  pngsalloc[size]=(NoGood*) storage;
  //now link the new array.
  NoGood *ng=(NoGood *) storage;
  for(int i=0;i<NOGOODALLOCFACTOR;i++) {
	ng->pnext=(NoGood *) (storage+unitsize);
	ng->size=size;
	ng->vector=storage+(sizeof(NoGood)/sizeof(bit));
	storage+=unitsize;
	ng=(NoGood*) storage;
  }
  //fix the last pointer
  storage -= unitsize;
  ng=(NoGood*) storage;
  ng->pnext=NULL;
}
