/*

2clseq. Copyright Fahiem Bacchus 2000--2002

 A DPLL solver based on performing extensive reasoning with the binary
 clause subtheory. Pronounced "Two" "Clause" "Eq"

Version 2.0.

The software available at this site is copyright (c) 2000-2002 Fahiem
Bacchus. All right are reserved. Use of this software is permitted for
non-commercial research purposes, and it may be copied only for that
use. All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Fahiem Bacchus and the University of Toronto make
no warranties, express or implied, including but not limited to
implied warranties of merchantability and fitness for a particular
purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Bacchus:2clseq,
	author  = { Fahiem Bacchus },
	year    = { 2002 },
	title   = { {2clseq} a {DPLL} solver employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/2clseq.html }
}

*/


#ifndef __naryClauses_H
#define __naryClauses_H
#include <stdio.h>
#include "2clsEq.h"
#include "undo.h"
#include "binaryClauses.h"

/* Processing for nary Clauses.*/

inline void delinkLitCls(LitCls *plc) {
   //delink a clause from a literal's list
  plc->pprev->pnext=plc->pnext;
  plc->pnext->pprev=plc->pprev;
  plc->linkincls->plit->numNcls--;
  if(plc->pcls->len==3)
	plc->linkincls->plit->num3cls--;
}

inline void relinkLitCls(LitCls *plc, Lit *plit) {
//relink a clause to a literal's list
  plc->pprev=&(plit->nClauses);
  plc->pnext=plit->nClauses.pnext;
  plc->pprev->pnext=plc;
  plc->pnext->pprev=plc;
  plit->numNcls++;
  if(plc->pcls->len==3)
	  plit->num3cls++;
}


inline void delinkClsLit(ClsLit *pcl) {
  //delink a literal from a clause's list
  pcl->linkinlit->pcls->len -= 1;
  pcl->pprev->pnext=pcl->pnext;
  pcl->pnext->pprev=pcl->pprev;

  if(pcl->linkinlit->pcls->len == 3)
	for(ClsLit *cl=pcl->linkinlit->pcls->start.pnext; cl->pnext; cl=cl->pnext)
	  (cl->plit->num3cls)++;

  else if(pcl->linkinlit->pcls->len == 2)
	for(ClsLit *cl=pcl->linkinlit->pcls->start.pnext; cl->pnext; cl=cl->pnext)
	  (cl->plit->num3cls)--;
}

inline void relinkClsLit(ClsLit *pcl) {
  //relink a literal to a clause's list
  Clause* c=pcl->linkinlit->pcls;
  c->len += 1;
  if(c->len==4)
	for(ClsLit *cl=c->start.pnext; cl->pnext; cl=cl->pnext)
	  (cl->plit->num3cls)--;

  if(c->len==3)
	for(ClsLit *cl=c->start.pnext; cl->pnext; cl=cl->pnext)
	  (cl->plit->num3cls)++;


  pcl->pprev=&(c->start);
  pcl->pnext=c->start.pnext;
  pcl->pprev->pnext=pcl;
  pcl->pnext->pprev=pcl;
}

inline void delinkNClause(Clause *pc) {
  //delink an nary clause
  ClsLit *pcl;
#ifdef _TRACE
  printf("=>delinkNClause(Clause %d)\n",pc->num);
#endif
  pc->active=false;
  for(pcl=pc->start.pnext;pcl->pnext;pcl=pcl->pnext)
    delinkLitCls(pcl->linkinlit);
}

inline void relinkNClause(Clause *pc) {
  //relink an nary clause, except for the literal plink
  ClsLit *pcl;
#ifdef _TRACE
  printf("=>relinkNClause(Clause %d)\n",pc->num);
#endif
  pc->active=true;
  for(pcl=pc->end.pprev;pcl->pprev;pcl=pcl->pprev)
	relinkLitCls(pcl->linkinlit,pcl->plit);
}

void addNaryClause(CLAUSELIST *clsptr, int *lits, int len, int clsnum);

inline bool inClause(Lit *l, Clause *c) {
  //literal is in clause?
  for(ClsLit *cl=c->start.pnext; cl->pnext; cl=cl->pnext)
	if(cl->plit==l)
	  return true;
  return false;
}

inline bool subsumed(Clause *c) {
	//should only be called in intial phase...does not undo.
  for(ClsLit *cl=c->start.pnext;cl->pnext;cl=cl->pnext)
    for(ClsLit *cl1=c->start.pnext;cl1!=cl;cl1=cl1->pnext)
      if(haveBclause(cl->plit->num,cl1->plit->num)) {
	//markundoClauseTrue(c);
	delinkNClause(c);
	return(true);
      }
  return(false);
}


inline void findRemainingTwoLits(Clause *c, Lit *l, Lit * &l1, Lit * &l2) {
  bool first=true;
  for(ClsLit *cl=c->start.pnext;cl->pnext;cl=cl->pnext)
    if(cl->plit!=l)
      if(first) {
        l1=cl->plit;
        first=false;
      }
      else
        l2=cl->plit;
}

#endif /* __naryClauses_H */


