/*

2clsQ. Copyright Horst Samulowitz and Fahiem Bacchus 2006

 A DPLL QBF solver based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to
implied warranties of merchantability and fitness for a particular
purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Fahiem Bacchus },
	year    = { 2006 },
	title   = { {2clsQ} a {DPLL} solver employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/

#include "2clsEq.h"
#include "naryClauses.h"


//Since nary clauses are never created, we should be able to predict
//precisely how many ClsLit and LitCls structures are needed!

ClsLit *pclalloc=NULL;
int numclslits=-1;
int clsnum=0; //Static counter for added clauses.

void MakeClsLitStore() {
  int i;
  numclslits=0;
  CLAUSELIST *clsptr;
  for(i=1;i<CLSGROUPS;i++) 
	for(clsptr=lenNclauses[i]; clsptr; clsptr=clsptr->pnext)
	  numclslits+=clsptr->clslen;
#ifdef _TRACE
  printf("Number of clslit structures = %d\n",numclslits);
#endif
  pclalloc = new ClsLit[numclslits];
  if(!pclalloc)
    panic("Memory Allocation Failure #16\n");
}

//inline allocators;
ClsLit * allocClsLit() {
  if(numclslits<0)
	MakeClsLitStore();
  
  if(numclslits==0)
	panic("Ran out of ClsLit Structures...this shouldn't happen!\n");
  
  ClsLit *pcl=pclalloc;
  pclalloc++;
  numclslits--;
  return(pcl);
}

LitCls *plcalloc=NULL;
int numlitcls=-1;

void MakeLitClsStore() {
  int i;
  numlitcls=0;
  CLAUSELIST *clsptr;
  for(i=1;i<CLSGROUPS;i++) 
	for(clsptr=lenNclauses[i]; clsptr; clsptr=clsptr->pnext)
	  numlitcls+=clsptr->clslen;
#ifdef _TRACE
  printf("Number of litcls structures = %d\n", numlitcls);
#endif
  plcalloc = new LitCls[numlitcls];
}

//inline allocators;
LitCls * allocLitCls() {
  if(numlitcls<0)
	MakeLitClsStore();
  
  if(numlitcls==0)
	panic("Error, ran out of LitCls Structures...this shouldn't happen!\n");
  
  LitCls *plc=plcalloc;
  plcalloc++;
  numlitcls--;
  return(plc);
}

void addNaryClause(CLAUSELIST *clsptr, int *lits, int len, int clsnum) {
  //this routine will typically be used at the inital problem
  //set up phase. As during search we never create a new nary clause.
  //Add the new literals to the clauses in the order passed.
  //but add the new clauses to the literals in the reverse order.
  //(as these are added in clause size order). (We could do an
  //insertion sort).

  LitCls *lc;
  Clause *c=THECLAUSES+clsnum;
  ClsLit *cl;
  c->len=len;
  c->originalClause=clsptr;
  for(int i=0;i<len;i++) {
	Lit *l=THELITS+lits[i];
	
	l->numNcls++;
	if(len==3)
	  l->num3cls++;
	
	cl=allocClsLit();
	lc=allocLitCls();
	cl->linkinlit=lc;
	lc->linkincls=cl;
	cl->plit=l;
	lc->pcls=c;
	
	cl->pnext=&(c->end);
	cl->pprev=c->end.pprev;
	cl->pnext->pprev=cl;
	cl->pprev->pnext=cl;
	
	lc->pprev=&(l->nClauses);
	lc->pnext=l->nClauses.pnext;
	lc->pnext->pprev=lc;
	lc->pprev->pnext=lc;
  }
}
