/*

2clsQ. Copyright Horst Samulowitz and Fahiem Bacchus 2006

 A DPLL QBF solver based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to
implied warranties of merchantability and fitness for a particular
purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Fahiem Bacchus },
	year    = { 2006 },
	title   = { {2clsQ} a {DPLL} solver employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "2clsEq.h"
#include "undo.h"
#include "resolve.h"
#include "parameters.h"
#include "solutions.h"
#include "nogoodDB.h"

char *filename;
void FibSeed(int nValue);

int nLastPrefixLevel;
int nAtLevel;

void usage() {
  printf("Q2clsEq. Developed and written by Horst Samulowitz and Fahiem Bacchus, University of Toronto\n");
  printf("Usage: Q2clseq -t [timeoutvalue] -h [heuristic] (defaults 20000sec,heurstic #4)\n");
  printf("  Additional flags: -d debug main dpl loop\n");
  //printf("                    -p don't print solution\n");
  //printf("                    -r NUMBER set random seed for some heuristics\n");
  printf("                    -e turn off equality processing (except at preprocess)\n");
  printf("                    -hyp turn off hyper resolution (except at preprocess)\n");
  //printf("                    -ppb turn off extra path prune backs\n");
  // printf("                    -lpb turn off extra literal prune backs\n");
  //printf("                    -cpb turn off conflict prune backs\n");
  //printf("                    -pcr NUMBER set pacifier rate (default 0)\n");
  exit(1);
}

#ifdef WIN32
int __cdecl main(int argc, char *argv[]) {
#else
  int main(int argc, char *argv[]) {
#endif
    if(argc == 1)
      usage();
    //set defaults parameters
    FINDNEXTFN=4;
    DPL_debug=false;
    print_solutions=true;
    pcr=0;
    time_out_val=50000; //default time in seconds
    int timeoutval=0;
    int rseed=0;
    // Horst: TURN EQUALILTY REASONING OFF!!!
    DOEQS=true;
    DOHYP=true;
    DOCPB=true;
    DOPPB=true;
    DOLPB=true;

    for(int i=1;i<argc;i++) {
      if(argv[i][0] == '-' && argv[i][1] == 'h' && argv[i][2] == 'y' && argv[i][3] == 'p') {
		DOHYP=false;
      }
      else if(argv[i][0] == '-' && argv[i][1] == 'p' && argv[i][2] == 'p' && argv[i][3] == 'b') {
		DOPPB=false;
      }
      else if(argv[i][0] == '-' && argv[i][1] == 'l' && argv[i][2] == 'p' && argv[i][3] == 'b') {
		DOLPB=false;
      }
      else if(argv[i][0] == '-' && argv[i][1] == 'c' && argv[i][2] == 'p' && argv[i][3] == 'b') {
		DOCPB=false;
      }
      else if(argv[i][0] == '-' && argv[i][1] == 'p' && argv[i][2] == 'c' && argv[i][3] == 'r' ) {
		i++;
		if(sscanf(argv[i],"%d", &pcr) != 1)
		  usage();
      }
      else if(argv[i][0] == '-' && argv[i][1] == 'h') {
		i++;
		if(sscanf(argv[i],"%d", &FINDNEXTFN) != 1)
		  usage();
      }
      else if(argv[i][0] == '-' && argv[i][1] == 't') {
		i++;
		if(sscanf(argv[i],"%d", &timeoutval) != 1)
		  usage();
      }
      else if(argv[i][0] == '-' && argv[i][1] == 'r') {
		i++;
		if(sscanf(argv[i],"%d", &rseed) != 1)
		  usage();
      }
      else if(argv[i][0] == '-' && argv[i][1] == 'd') {
		DPL_debug=true;
      }
      else if(argv[i][0] == '-' && argv[i][1] == 'p') {
		print_solutions=false;
      }
      else if(argv[i][0] == '-' && argv[i][1] == 'e') {
		DOEQS=false;
      }
      else
		filename=argv[i];
    }
    if(timeoutval>0)
      time_out_val=1.0 * timeoutval;

    FibSeed(rseed);
    printf("c Settings: FINDNEXTFN=%d, timeoutval=%.0f\n",FINDNEXTFN, time_out_val);

    CONTRADICTION.val=false;
    if(!readProblem(filename)) {
      printf("c Problem reading CNF file.\n");
      exit(1);
    }
    initProblemStats();
    if(!CONTRADICTION.val) {
      initprob();
      initHeur();
      initDPL();
      initNoGoods();
	  // Horst
	  initCubeStructure();
	  initNoGoodStructure();
      recordInitTime();	  
#ifdef _PARANOID
      checkClauses();
      checkHashTable();
#endif _PARANOID
#ifdef _TRACE
      printTheory("start");
#endif _TRACE
      if(strchr(filename,'/'))
		filename=strrchr(filename, '/')+1;
      else if(strchr(filename,'\\'))
		filename=strrchr(filename, '\\')+1;
      // DEBUG!!
      nLastPrefixLevel = -1 ;
      nAtLevel = 0;

      if(!CONTRADICTION.val) {
		HIGHESTBTLEVEL=NLITS;
		DEEPESTLEVEL=0;
		MRFailedLit=NOLIT;
		markundoCheckPoint();
		DPL(1);
		undoRestore();
      }
    }
    printProblemStats(filename);

#ifdef _TRACE
    printTheory("end");
#endif _TRACE
    if(timed_out)
      exit(0);
	FILE * pFile;
    pFile = fopen ("result3","wt");
    if (pFile!=NULL)
    {       
     fputs("UNSAT",pFile);
    }
    fclose (pFile);
    exit(20);
    return(20);
  }
