/*

2clseq. Copyright Fahiem Bacchus 2000--2002

 A DPLL solver based on performing extensive reasoning with the binary
 clause subtheory. Pronounced "Two" "Clause" "Eq"

Version 2.0.

The software available at this site is copyright (c) 2000-2002 Fahiem
Bacchus. All right are reserved. Use of this software is permitted for
non-commercial research purposes, and it may be copied only for that
use. All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Fahiem Bacchus and the University of Toronto make
no warranties, express or implied, including but not limited to
implied warranties of merchantability and fitness for a particular
purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Bacchus:2clseq,
	author  = { Fahiem Bacchus },
	year    = { 2002 },
	title   = { {2clseq} a {DPLL} solver employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/2clseq.html }
}

*/

#include "2clsEq.h"
#include "binaryClauses.h"
#include "naryClauses.h"
#include "uniqueset.h"
#include "stats.h"
#include "resolve.h"

void inline convertToBinaryClauseNoUndo(Clause* pcls);
void UnitPropNoUndo(int l);
// Horst: apply universal reduction on the clauses of a literal that got falsified
bool inline removeLiteralandApplyUniversalReductionNoUndo(Lit * plit);
void inline makeEquivalencesNoUndo(EQS* eqbuf, int nSizeOfBuf);
// Horst End
void inline addBclauseNoUndo(Lit *l1, Lit *l2);
void resolvebclsNoUndo(bcls *pbcls);
void makeeqNoUndo(Lit* x, Lit* l);
extern EQS* eqbuf;

void pushupstackNoUndo(int l) {
  switch(val(l)) {
  case F:
    setContradiction(&dagTrue,&dagTrue);
    break;
  case T:
    break;
  case U:
    if(upstack->member(negate(l))) {
      setContradiction(&dagTrue,&dagTrue);
    }
    // HORST: Universal Reduction
    // If we propagate a universal - this is a contradiction
    else if(!isLitExistential(l)) {
      //printf(" \n Universal Literal forced: %d ", to_ff(l));
      setContradiction(&dagTrue,&dagTrue);
    }
    // END
    else if(!upstack->member(l)) {
	setLitdagnode(l,&dagTrue);
	upstack->pushnew(l);
	}
  }
}

inline int popupstackNoUndo() {
  int lt=upstack->pop();
  int eqlt=eqlit(lt);
  setLitdagnode(eqlt,&dagTrue);
  return(eqlt);
}

void pushbclsstackNoUndo(int l1, int l2) {
  //check bcls and push it on the bcls stack to be resolved
  //if appropriate.
  if(haveBclause(l1,l2))
    return;
  // Horst: Adding universal reduction
  // If literal l1 is not existential and if the prefix level is bigger than the one of l2
  // we can directly propagate l2 (and vice versa)
  else if(!isLitExistential(l2) && !isLitExistential(l1))
  {
    pushupstackNoUndo(l2);
  }
  else if((!isLitExistential(l1)) && (getLitPrefixLevel(l1) > getLitPrefixLevel(l2))) {
   pushupstackNoUndo(l2);
  }
  else if((!isLitExistential(l2)) && (getLitPrefixLevel(l2) > getLitPrefixLevel(l1))) {
   pushupstackNoUndo(l1);
  }
  // END
  else if(isFalse(l1)) {
    pushupstackNoUndo(l2);
  }
  else if(haveBclause(negate(l1),l2)) {
    pushupstackNoUndo(l2);
  }
  else if(isFalse(l2)) {
    pushupstackNoUndo(l1);
  }
  else if(haveBclause(l1,negate(l2))) {
    pushupstackNoUndo(l1);
  }
  else {
    //put on to be resolved stack
	sizebclsstack++;
	bcls *pbcls=allocbcls();
	pbcls->l1=l1;
	pbcls->l2=l2;
	pbcls->dagnode=&dagTrue;
	pbcls->pnext=pbclstack;
	pbclstack=pbcls;
  }
}

void pushbclsstackNoUndo(bcls *pbcls) {
  int l1=pbcls->l1;
  int l2=pbcls->l2;


  if(haveBclause(l1,l2))
   return;
  // Horst: Adding universal reduction
  // If literal l1 is not existential and if the prefix level is bigger than the one of l2
  // we can directly propagate l2
  else if((!isLitExistential(l1)) && (getLitPrefixLevel(l1) > getLitPrefixLevel(l2))) {
   pushupstackNoUndo(l2);
  }
  else if((!isLitExistential(l2)) && (getLitPrefixLevel(l2) > getLitPrefixLevel(l1))) {
    pushupstackNoUndo(l1);
  }
  // END
  else if(isFalse(l1)) {
    pushupstackNoUndo(l2);
  }
  else if(haveBclause(negate(l1),l2)) {
    pushupstackNoUndo(l2);
  }
  else if(isFalse(l2)) {
    pushupstackNoUndo(l1);
  }
  else if(haveBclause(l1,negate(l2))) {
    pushupstackNoUndo(l1);
  }

  else {
    //put on to be resolved stack
	sizebclsstack++;
	pbcls->pnext=pbclstack;
	pbclstack=pbcls;
  }
}

inline bcls* popbclsstackNoUndo() {
  sizebclsstack--;
  bcls* pbcls=pbclstack;
  pbclstack=pbcls->pnext;
  int eql1=eqlit(pbcls->l1);
  int eql2=eqlit(pbcls->l2);
  pbcls->l1=eql1;
  pbcls->l2=eql2;
  pbcls->dagnode=&dagTrue;
  return(pbcls);
}

inline void checkClauseHitsNoUndo(Lit *l1, Lit *l2);

inline void checkClauseHitsNoUndo(bcls *pbcls) {
  Lit* l1=eqlit(intTolit(pbcls->l1));
  Lit* l2=eqlit(intTolit(pbcls->l2));
  deallocbcls(pbcls);
  checkClauseHitsNoUndo(l1, l2);
}

inline void checkClauseHitsNoUndo(Lit *l1, Lit *l2) {
  LitCls *nclauses;
  int missedlit, missedcount;

  if(isInactive(l1) || isInactive(l2))
    return;

  bool foundAhit=false;
  if(numBcls(l1) > 1) {
    litHitsChecked++;
    for(nclauses=(negate(l1))->nClauses.pnext;nclauses->pnext;nclauses=nclauses->pnext) {
      clauseHitsChecked++;
      if(checkforNewbClause(nclauses->pcls,l2,missedlit,missedcount)) {
		if(!foundAhit) {
		  litHitsFound++;
		  foundAhit=true;
		}
		clauseHitsFound++;
		if(missedcount==0) {
		  pushupstackNoUndo(l2->num);
		  return;
		}
		else
		  pushbclsstackNoUndo(l2->num,missedlit);
      }
    }
  }

  if(numBcls(l1) > 1) {
    foundAhit=false;
    litHitsChecked++;
    for(nclauses=(negate(l2))->nClauses.pnext;nclauses->pnext;
		nclauses=nclauses->pnext) {
      clauseHitsChecked++;
      if(checkforNewbClause(nclauses->pcls,l1,missedlit,missedcount)) {
		if(!foundAhit) {
		  litHitsFound++;
		  foundAhit=true;
		}
		clauseHitsFound++;
		if(missedcount==0) {
		  pushupstackNoUndo(l1->num);
		  return;
		}
		else
		  pushbclsstackNoUndo(l1->num,missedlit);
      }
    }
  }
}

inline void findallhitsNoUndo(Clause *c) {
  //Find all literals hitting clause
  if(!c->active)
    return;

  nClausesChecked++;
  bool foundhit=false;

  int min1=NLITS;
  int min2=NLITS;
  Lit *L1=NULL;
  Lit *L2=NULL;

  //find the two lits in the clause whose negations have min binary clauses.
  for(ClsLit *pcl=c->start.pnext;pcl->pnext;pcl=pcl->pnext) {
    Lit *L=negate(pcl->plit);
    if(numBcls(L)<min1) {
      min2=min1;
      L2=L1;
      min1=numBcls(L);
      L1=L;
    }
    else if(numBcls(L)<min2) {
      min2=numBcls(L);
      L2=L;
    }
  }

  //Now check the union of their bclauses
  int missedlit, missedcount;
  BinLitCls *pb;
  litbuf->empty();
  for(pb=&(L1->twoClauses); pb->pnext; pb=pb->pnext) {
    litbuf->pushnew(pb->otherlit->num);
    if(checkforNewbClause(c, pb->otherlit, missedlit, missedcount)) {
      if(!foundhit) {
		nClausesHits++;
		foundhit=true;
      }
      if(missedcount == 0)
		pushupstackNoUndo(pb->otherlit->num);
      else
		pushbclsstackNoUndo(pb->otherlit->num,missedlit);
    }
  }
  for(pb=&(L2->twoClauses); pb->pnext; pb=pb->pnext) {
    if(!litbuf->member(pb->otherlit->num)
       && checkforNewbClause(c, pb->otherlit, missedlit, missedcount)) {
      if(!foundhit) {
		nClausesHits++;
		foundhit=true;
      }
      if(missedcount == 0)
		pushupstackNoUndo(pb->otherlit->num);
      else
		pushbclsstackNoUndo(pb->otherlit->num,missedlit);
    }
  }
  litbuf->empty();
}


void propagateStacksNoUndo() {
  //do all stacked up unit props and binary clause resolutions.
  while(!CONTRADICTION.val &&
	  (!emptyupstack() || !emptybclstack() )) {// || !emptyclschkstack() || !clsToChk->isEmpty())) {
    if(!emptyupstack())
      UnitPropNoUndo(popupstackNoUndo());
    else if(!emptybclstack())
      resolvebclsNoUndo(popbclsstackNoUndo());
	/*
    else if(!emptyclschkstack())
      if(sizeclschkstack>NCLAUSES) {
		for(int i=0;i<NCLAUSES;i++)
		  if(clsisActive(i))
			clsToChk->pushnew(i);
		while(!emptyclschkstack())
		  deallocbcls(popclschkstack());
      }
      else
		checkClauseHitsNoUndo(popclschkstack());
    else if(!clsToChk->isEmpty())
      while(!clsToChk->isEmpty())
		findallhitsNoUndo(THECLAUSES+clsToChk->pop()); */
  }
  if(haveContradiction())
    emptystacks();
}

void UnitPropNoUndo(int l) {
  //Unit propagate the literal l.
  //Take advantage of the fact that the binary theory is closed.
  //so all consequences of UP are contained in the binary clauses.
  //---No other literals can be forced.
  Lit *L=intTolit(l);
  Lit *NotL=intTolit(negate(l));
  BinLitCls* pb;

  if(isTrue(L)) {
    return;
  }
  else if(isFalse(L)) {
    setContradiction(&dagTrue,&dagTrue);
    return;
  }
  // HORST: Universal Reduction
    // If we propagate a universal - this is a contradiction
  else if(!isLitExistential(L)) {
      printf(" \n Universal Literal forced: %d ", to_ff(L));
      setContradiction(&dagTrue,&dagTrue);
	  return;
  }
  // END


  //Set truth values.
  for(pb=&(NotL->twoClauses);pb->pnext;pb=pb->pnext) {
    if(upstack->member(negate(pb->otherlit->num))) {
      setContradiction(&dagTrue, &dagTrue);
      return;
    }
	if((abs(to_ff(pb->otherlit->num)) != abs(to_ff(L->num))) && (!isLitExistential(pb->otherlit)))
	{
	 printf("\n [PRE] (Contradiction) Setting UNIVERSAL literal forced from binary clause: %d (%d) (Forced by: %d)", pb->otherlit->num, to_ff(pb->otherlit), to_ff(L->num));
     setContradiction(&dagTrue,&dagTrue);
	 return;
	}
	else
	{
     setLitTrue(pb->otherlit);
     setLitdagnode(pb->otherlit,&dagTrue);
	}
  }

  //Delink all true clauses.
  for(pb=&(NotL->twoClauses);pb->pnext;pb=pb->pnext) {
    Lit *plit=pb->otherlit;
    for(LitCls *pNclauses=plit->nClauses.pnext;
		pNclauses->pnext;
		pNclauses=plit->nClauses.pnext) {
      //for each true lit, we delink all of its clauses
      //markundoClauseTrue(pNclauses->pcls);
      delinkNClause(pNclauses->pcls);
    }

    for(BinLitCls *pBclauses=plit->twoClauses.pnext;pBclauses->pnext;
		pBclauses=pBclauses->pnext)
      //for each true lit, we delink all of its binary clauses
      //in active lits.
      if(isUnvalued(pBclauses->otherlit)) {
		//markundoBclause(pBclauses->otherlinks);
		delinkBclause(pBclauses->otherlinks);
      }
  }

  //Delink false literals from all n-ary clauses. For Binary clauses,
  //the other literal has already been forced, so we do not need to
  //do anything.
  for(pb=&(NotL->twoClauses);pb->pnext;pb=pb->pnext) {
    //get lit's negation which has become False.
    Lit *plit=negate(pb->otherlit);
    //int nMaxExistentialPrefixLevel = -1;
    //int nMaxUniversalPrefixLevel = -1;
    bool bRemoveResult = removeLiteralandApplyUniversalReductionNoUndo(plit);
    /*for(LitCls *pNclauses=plit->nClauses.pnext;
		pNclauses->pnext;
		pNclauses=pNclauses->pnext) {
      //markundoClsLit(pNclauses->linkincls);
      delinkClsLit(pNclauses->linkincls);
      //markundoClsDAG(pNclauses->pcls);
      if(pNclauses->pcls->len == 2)
		convertToBinaryClauseNoUndo(pNclauses->pcls);
      else
		clsToChk->pushnew(pNclauses->pcls->num);
    }*/
  }
}

void inline convertToBinaryClauseNoUndo(Clause* pcls) {
  int l1=pcls->start.pnext->plit->num;
  int l2=pcls->start.pnext->pnext->plit->num;
  //assert(isLitExistential(l1) || isLitExistential(l2));
  pushbclsstackNoUndo(l1,l2);
  //markundoClauseTrue(pcls);
  delinkNClause(pcls);
}

void resolvebclsNoUndo(bcls *pbcls) {
  //Resolve a binary clause. Should be called only if upstack is empty.
  //I.e. there are no pending truth assignments.
  bclsResolved++;
  int l1=pbcls->l1;
  int l2=pbcls->l2;
  deallocbcls(pbcls);
  Lit *NotL1=THELITS+negate(l1);
  Lit *L1=THELITS+l1;
  Lit *NotL2=THELITS+negate(l2);

  //1. check for staleness.
  if(isFalse(l1) && isFalse(l2)) {
    setContradiction(&dagTrue,&dagTrue);
    return;
  }
  if(isTrue(l1)||isTrue(l2)||haveBclause(l1,l2)) {
    return;
  }
  //2. check for predecessors resolutions making this generate
  //   a unitprop
  if(isFalse(l1)) {
    pushupstackNoUndo(l2);
    return;
  }
  if(haveBclause(NotL1,l2)) {
    pushupstackNoUndo(l2);
    return;
  }
  if(isFalse(l2)) {
    pushupstackNoUndo(l1);
    return;
  }

  // Horst: Adding universal reduction
  // If literal l1 is not existential and if the prefix level is bigger than the one of l2
  // we can directly propagate l2 (and vice versa)
  if((!isLitExistential(l1)) && (getLitPrefixLevel(l1) > getLitPrefixLevel(l2))) {
   pushupstackNoUndo(l2);
   return;
  }
  else if((!isLitExistential(l2)) && (getLitPrefixLevel(l2) > getLitPrefixLevel(l1))) {
   pushupstackNoUndo(l1);
   return;
  }
  else if((!isLitExistential(l2)) && (!isLitExistential(l1))) {
   pushupstackNoUndo(l1);
   return;
  }
  // END: Adding Universal Reduction

  if(haveBclause(l1,negate(l2))) {
    pushupstackNoUndo(l1);
    return;
  }


  //3. create all the new 2-clauses
  BinLitCls* pb1;
  BinLitCls* pb2;

  for(pb1=&(NotL1->twoClauses);pb1->pnext;pb1=pb1->pnext) {
    for(pb2=&(NotL2->twoClauses);pb2->pnext;pb2=pb2->pnext) {
      if(pb1->otherlit==pb2->otherlit) {
		pushupstackNoUndo(pb1->otherlit->num);
		break;
      }
	  else if(haveBclause(pb1->otherlit,negate(pb2->otherlit->num))) {
		pushupstackNoUndo(pb1->otherlit->num);
		break;
      }
	  else if(haveBclause(negate(pb1->otherlit),pb2->otherlit->num))
		pushupstackNoUndo(pb2->otherlit->num);
	  else if(!haveBclause(pb1->otherlit,pb2->otherlit->num)) {
        // Horst
		if(!isLitExistential(pb1->otherlit))
		{
		 if(!isLitExistential(pb2->otherlit))
		 {
		  setContradiction(&dagTrue,&dagTrue);
		  return;
		 }
		 else if(getLitPrefixLevel((pb1->otherlit)) > getLitPrefixLevel((pb2->otherlit)))
		 {
			  //printf(" X 3 X ");
		  pushupstackNoUndo(pb2->otherlit->num);		  
		  break;
		 }
		}
		else if(!isLitExistential(pb2->otherlit))
		{		 
		 if(getLitPrefixLevel((pb2->otherlit)) > getLitPrefixLevel((pb1->otherlit)))
		 {			 
		  pushupstackNoUndo(pb1->otherlit->num);		  		  
		  //printf("\n 3 Universal Reduction in Resolve BC (L1: %d E: %d PL: %d; L2: %d E: %d PL: %d) ", pb1->otherlit->num, isLitExistential(pb1->otherlit), getLitPrefixLevel((pb1->otherlit)), pb2->otherlit->num, isLitExistential(pb2->otherlit), getLitPrefixLevel((pb2->otherlit)));		  
		  break;
		 }
		}
       
		addBclauseNoUndo(pb1->otherlit,pb2->otherlit);
		//printf("\n Lit1 %d (E?: %d PL: %d) Lit2 %d (E?: %d PL: %d) ", pb1->otherlit->num, isLitExistential(pb1->otherlit), getLitPrefixLevel(pb1->otherlit), pb2->otherlit->num, isLitExistential(pb2->otherlit), getLitPrefixLevel(pb2->otherlit));
		pushclschkstack(pb1->otherlit,pb2->otherlit);
      }
      if(CONTRADICTION.val)
		return;
    }
  }

  if(DOEQS)
  {
	  //test for generated equivalence.
	  int topeqbuf=0;
	  int i;

	  if(isUnvalued(L1) && !upstack->member(l1) && haveBclause(negate(l1),negate(l2))) {
		for(pb1=NotL1->twoClauses.pnext;pb1->pnext;pb1=pb1->pnext) {
		  if(haveBclause(NotL2,negate(pb1->otherlit->num))) {
			eqbuf[topeqbuf].L=pb1->otherlit;
			topeqbuf++;
		  }
		}

		// Horst
		eqbuf[topeqbuf].L=L1;
		topeqbuf++;
		/*printf("\n Literal in Buffers (L1: %d) : ", L1->num);
		for(i=0;i<topeqbuf;i++) {
		  printf(" %d",eqbuf[i].L->num);
		}*/
		makeEquivalencesNoUndo(eqbuf, topeqbuf);
		// End
		/*
		// Horst: REPLACED
		for(i=0;i<topeqbuf;i++) {
		  eqsfound++;
		  makeeqNoUndo(eqbuf[i].L,L1);
		  makeeqNoUndo(negate(eqbuf[i].L),NotL1);
		}*/
		// END
	  }
  }
}

void inline makeEquivalencesNoUndo(EQS* eqbuf, int nSizeOfBuf) {
  #ifdef __TRACE
  printf("=>makeEquivalenceNoUNDO\n");
  #endif __TRACE
  int i;
  int nUniversals = 0;
  Lit * lUniversal;
  int nMaxExistentialNum = -1;
  Lit * lMaxExistential;
  int nMinExistentialPrefixLevel = 1000000;
  int nMinUniversalPrefixLevel   = 1000000;

  for(i=0;i<nSizeOfBuf;i++) {
    Lit * literal = eqbuf[i].L;
    if((isLitExistential(literal)) && (getLitPrefixLevel(literal) < nMinExistentialPrefixLevel))
    {
      nMinExistentialPrefixLevel = getLitPrefixLevel(literal);
      if(literal->num > nMaxExistentialNum)
       lMaxExistential = literal;
    }
    if((!isLitExistential(literal)) && (getLitPrefixLevel(literal) < nMinUniversalPrefixLevel))
    {
      nMinUniversalPrefixLevel = getLitPrefixLevel(literal);
    }
    if(!isLitExistential(literal))
    {
     nUniversals++;
     lUniversal = literal;
    }
  }
  // If there is more than one universal we have to fail
  if(nUniversals > 1)
  {
   setContradiction(&dagTrue,&dagTrue);
   return;
   //assert(false);
  }
  // If there is one universal and it is tailing we have to fail too
  else if((nUniversals == 1) && (nMinUniversalPrefixLevel > nMinExistentialPrefixLevel)) {
	  {       
	   setContradiction(&dagTrue,&dagTrue);
	   return;
       //assert(false);
	  }
  }
  else if(nUniversals == 1) {
    //assert(false);
    for(i=0;i<nSizeOfBuf;i++) {
      eqsfound++;
      //printf("\n Equivalence Literal: %d ", lUniversal->num);
      assert(!isLitExistential(lUniversal));
      if(eqbuf[i].L != lUniversal)
      {
       makeeqNoUndo(eqbuf[i].L,lUniversal);
       makeeqNoUndo(negate(eqbuf[i].L),negate(lUniversal));
      }
    }
  }
  else if(nUniversals == 0)
  {
    for(i=0;i<nSizeOfBuf;i++) {
      eqsfound++;
      //printf("\n Equivalence Literal: %d ", lMaxExistential->num);
      assert(isLitExistential(lMaxExistential));
      if(eqbuf[i].L != lMaxExistential)
      {
       makeeqNoUndo(eqbuf[i].L,lMaxExistential);
       makeeqNoUndo(negate(eqbuf[i].L),negate(lMaxExistential));
      }
    }
  }
  #ifdef __TRACE
  printf("<=makeEquivalenceNoUNDO\n");
  #endif __TRACE
}

void makeeqNoUndo(Lit* x, Lit* l) {
  //rewrite all nary clauses containing x to contain l.
  //Then delink all b-clauses with x.
  if(isValued(x))
    return;

  // Horst: Case ADDED
  //if(x == l)
   //return;
  // END
 //markundoEq(x);
  //assert(isLitExistential(l));
  x->equivlit=l;
  LitCls *plc;

  for(LitCls *pNclauses=x->nClauses.pnext;pNclauses->pnext;) {
    //must move pointer along inside of loop
    if(inClause(l,pNclauses->pcls)) {
      delinkClsLit(pNclauses->linkincls);
      if(pNclauses->pcls->len == 2)
		convertToBinaryClauseNoUndo(pNclauses->pcls);
      pNclauses=pNclauses->pnext;
    }
    else if(inClause(negate(l),pNclauses->pcls)) {
      plc=pNclauses;
      pNclauses=pNclauses->pnext;
      //printf("\n In Makeeqnoundo! ");
      delinkNClause(plc->pcls);
    }
    else {
      plc=pNclauses;
      pNclauses=pNclauses->pnext;
      delinkLitCls(plc);
      plc->linkincls->plit=l;
      relinkLitCls(plc, l);
    }
  }
  //Now unlink all binary clauses containing x.
  for(BinLitCls *pBclauses=x->twoClauses.pnext;pBclauses->pnext;
      pBclauses=pBclauses->pnext)
    if(isUnvalued(pBclauses->otherlit)) {
      delinkBclause(pBclauses->otherlinks);
    }
}

void addBclauseNoUndo(Lit *l1, Lit *l2) {
  //should check that clause is not there prior to calling
  bclsAdded++;

  PairofBinLitCls *pb = allocPairofBinLitCls();
  pb->Lit1.otherlit=l2;
  pb->Lit1.dagnode=&dagTrue;
  pb->Lit2.otherlit=l1;
  pb->Lit2.dagnode=&dagTrue;
  putonLitlist(l1,&(pb->Lit1));
  putonLitlist(l2,&(pb->Lit2));
  markBclause(l1->num,l2->num,&dagTrue);
  //printf("\n NEW Binary Clause [%d (PL: %d) %d (PL: %d)]",l1->num, getLitPrefixLevel(l1->num),l2->num, getLitPrefixLevel(l2->num)); 	
}

// Horst: apply universal reduction on the clauses of a literal that got falsified
bool inline removeLiteralandApplyUniversalReductionNoUndo(Lit * plit)
{
  // Horst: Apply universal reduction
    LitCls *pNclausesUR, *pNclausesStore;
    Lit * pLiteral;
    ClsLit *cl;
    Clause * c;
    int nMaxExistentialPL, nMaxUniversalPL;
    //printf("\n Removing false Literal: %d ", plit->num);
    // Go Through n-ary Clauses of False Literal
    for(LitCls *pNclauses=plit->nClauses.pnext;
        pNclauses->pnext;
        pNclauses=pNclauses->pnext) {

          nMaxExistentialPL = -1;
          nMaxUniversalPL = -1;
          // Go through actual clause and check prefix level of literal
          c = pNclauses->pcls;
          //printf("\n Go through clause... %d ", c->num);
          for(cl=c->start.pnext; cl->pnext; cl=cl->pnext)
            {
              pLiteral = cl->plit;
              // If the current literal is not equal to the literal we want to remove...
              if(cl->plit != plit)
              {
                if(pLiteral->bExistential)
                {
                 if(pLiteral->nPrefixLevel > nMaxExistentialPL)
                   nMaxExistentialPL = pLiteral->nPrefixLevel;
                }
                else
                {
                 if(pLiteral->nPrefixLevel > nMaxUniversalPL)
                  nMaxUniversalPL = pLiteral->nPrefixLevel;
                }
              }
              else // if it is the literal we want to remove we simply delink it from the clause
              {
                // Ignore false literal
                /*cl->pprev->pnext = cl->pnext;
                cl->pnext->pprev = cl->pprev;
                c->len = c->len - 1; */
              }
            }
            // Remove false literal from clause
            delinkClsLit(pNclauses->linkincls);

            // If there are tailing universals delink them from the current clause
            if(nMaxUniversalPL > nMaxExistentialPL)
            {
              //printf(" \n There are tailing universals: %d %d ", nMaxExistentialPL, nMaxUniversalPL);
              for(cl=c->start.pnext; cl->pnext; cl=cl->pnext)
              {
               pLiteral = cl->plit;
               // If current Literal at 'tailing' universal prefix level...
               if((getLitPrefixLevel(pLiteral) > nMaxExistentialPL) && (c->len > 2))
               {
                 //printf("\n * DLink Literal in Clause: %d ", pLiteral->num);
                 LitCls *LitInClause = cl->linkinlit;
                 delinkClsLit(LitInClause->linkincls);
                 delinkLitCls(LitInClause);
                 /*cl->pprev->pnext = cl->pnext;
                 cl->pnext->pprev = cl->pprev;
                 c->len = c->len - 1;
                 printf("\n * DLink Clause from Literal: %d ", pLiteral->num);
                 */
               }
              }
            }
            //printf("\n ### Length: %d ", pNclauses->pcls->len);

          switch(pNclauses->pcls->len)
          {
              case 0 : // Empty Clause
                       assert(false);
                       break;
              case 1 : // Unit Clause
                       assert(false);
                       break;
              case 2 : // New Binary Clause
                       convertToBinaryClauseNoUndo(pNclauses->pcls);
                       //printf("\n Binary Clause ");
                       break;
              default: // All n-ary Clauses
                       clsToChk->pushnew(pNclauses->pcls->num);
                       //printf("\n Still a kary Clause ");
           }
     }
    return true;
    assert(false);
}
