/*

2clseq. Copyright Fahiem Bacchus 2000--2002

 A DPLL solver based on performing extensive reasoning with the binary
 clause subtheory. Pronounced "Two" "Clause" "Eq"

Version 2.0.

The software available at this site is copyright (c) 2000-2002 Fahiem
Bacchus. All right are reserved. Use of this software is permitted for
non-commercial research purposes, and it may be copied only for that
use. All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Fahiem Bacchus and the University of Toronto make
no warranties, express or implied, including but not limited to
implied warranties of merchantability and fitness for a particular
purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Bacchus:2clseq,
	author  = { Fahiem Bacchus },
	year    = { 2002 },
	title   = { {2clseq} a {DPLL} solver employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/2clseq.html }
}

*/

#include "2clsEq.h"
#include "binaryClauses.h"
#include "resolve.h"
#include "uniqueset.h"
#include "stats.h"
#include "solutions.h"
#include "nogoodDB.h"

vector<int> vecLits;


/******************************************************************************
               The heuristic select next variable functions
******************************************************************************/

/* findnext
   0 == static order
   1 == most number of active 2-clauses, break ties by number of active
   3 clauses. (MOM's)
   2 == identical to 1, but tries to always reinstantiate the variable that
   generated the most recent contradiction.
   3 == compute number of new 2 clauses that will be produced and
   return variable with most number of new 2-clauses produced
   4 == check the new 2 clauses more carefully to see if these clauses
   will also generate any new forced literals.
   Compute a weighed score of the number of newly forced literals
   and new 2 clauses.
   5 == identical to 3 except it also maintains a TABU list to
   force changes in the instantiations.

*/


void createLiteralOrderingByPrefixLevel();
int*     _arrLiteralsSortedByPrefixLevel;

int  findNextPL();
int  findNext2ObeyPL(int);
int  findNext3ObeyPL(int);
int  findNext4ObeyPL(int);
int  findNext5ObeyPL(int);
int  findNext6ObeyPL(int);
int  findNext7ObeyPL(int);
int  findNext7ObeyPL(int, bool);
int  propagateExistentialPures();
int  propagateExistentialPuresAsDecisions();
int  propagateUniversalPures();
vector<int>* getSpecialExistentials();
int findNext8ObeyPL(int);
int findNext9ObeyPL(int);
bool bTheoryEmpty();
// End


void FibSeed(int nValue);
int FibRand(void);


int FINDNEXTFN = 1;            //The default find next function to call.

int findNext0(int);
int findNext1(int);
int findNext2(int);
int findNext3(int);
int findNext4(int);
int findNext5(int);
int findNext6(int);

UniqueSet *sclauses;
bcls *bclsmark;
int *LITBUF;

void initHeur() {
  sclauses = new UniqueSet(NCLAUSES);
  bclsmark=NULL;
  LITBUF=new int[NLITS/2];

  if(!LITBUF)
	panic("Memory Allocation Failure #15\n");

  for(int i=0;i<NLITS/2;i++)
    LITBUF[i]=NOLIT;
  
  _arrLiteralsSortedByPrefixLevel = new int[NLITS + 1];
  for(int i=0; i < NLITS; i++)
  {      
   _arrLiteralsSortedByPrefixLevel[i] = 0;
  }
  // Horst: Create Variable Ordering according to Prefix Ordering
  createLiteralOrderingByPrefixLevel();
  /*vecLits.push_back(195);
  vecLits.push_back(-178);
  vecLits.push_back(-177);
  vecLits.push_back(217);
  vecLits.push_back(-76);
  vecLits.push_back(78);
  vecLits.push_back(-181);
  vecLits.push_back(59);
  vecLits.push_back(58);
  vecLits.push_back(-96);
  vecLits.push_back(-90);
  vecLits.push_back(-76);
  vecLits.push_back(78);
  vecLits.push_back(-181); */
  
  //assert(false);
}

bool bTheoryEmpty(){

 int i = 0;
 while(i < NVARS)
 {
  Lit *litf = intTolit(to_literal(i, false));
  Lit *litt = negate(litf);
  int n2 = numBcls(litf);
  int p2 = numBcls(litt);
  int nn = numNcls(litf);
  int pn = numNcls(litt);
  if((litf->val==U) || (litt->val==U)){
   if(!((n2+nn==1) && (p2+pn==1))){
	  return false;
   }
  }
  i++;
 }
 return true;
}

int satisfyRemainingClauses() {
  vector<int> * vecTest = getSpecialExistentials();
  outputVectorCube(vecTest);
  return 0;
}


int findNext(int level) {
  switch(FINDNEXTFN) {
  case 0:
    return(findNext0(level));
  case 1:
    return(findNext1(level));
  case 2:
    return(findNext2(level));
  case 3:
    return(findNext3(level));
  case 4:
    return(findNext4(level));
  
  default:
    panic("findnextfn = %d Illegal value.", FINDNEXTFN);
    return(0);
  }
}

int findNext0(int level) {
  //Simplest. Instantiates in order.
  int choosenlit = NOLIT;
  for(int i = 0; i < NVARS; i++) {
    int l=to_literal(i,false);
    if (isActive(l)) {
      choosenlit = l;
      break;
    }
  }
  return(choosenlit);
}


inline int score(int n2, int p2) {
  //Return  a Freeman like score.
  return(n2+p2+1 + 1024*n2*p2);
}

int findNext1(int level) {
  //computes a Freeman like score based on the number of literals the
  //lit will force.
  //break ties by numeric order of the literals.
  int choosenlit = NOLIT;
  int bestscore = -1;
  int litscore;
  for(int i = 0; i < NVARS; i++) {
    Lit *litf = intTolit(to_literal(i, false));
    if (isInactive(litf))
      continue;
    Lit *litt = negate(litf);
    int n2 = numBcls(litf);
    int p2 = numBcls(litt);
    int nn = numNcls(litf);
    int pn = numNcls(litt);

    //Don't count the l\/-l clause.
    if(n2+nn==1) {
      pureReductions++;
      pushupstack(litt->num,allocDAGNODE_PURE(litt->num));
      continue;
    }

    if(p2+pn==1) {
      pureReductions++;
      pushupstack(litf->num,allocDAGNODE_PURE(litt->num));
      continue;
    }

    litscore = score(n2,p2);
    if (litscore > bestscore
	|| (litscore==bestscore &&
	    score(numNcls(choosenlit), numNcls(negate(choosenlit)))
	    < score(nn,pn))) {
      bestscore = litscore;
      choosenlit = (p2 < n2 ? litt->num: litf->num);
    }
  }
  return(choosenlit);
}

int findNext2(int level) {
  //Identical to fn1. But randomly choosed between the tied variables.

  //   if(MRFailedLit!=NOLIT && isActive(MRFailedLit))
  // 	return(MRFailedLit);

  //int choosenlit = NOLIT;
  int bestscore = -1;
  //int bestsubscore=-1;
  int litscore,i;
  //  int litsubscore;
  int numties=0;

  for(i = 0; i < NVARS; i++) {

    Lit *litf = intTolit(to_literal(i, false));
    if (isInactive(litf))
      continue;

    Lit *litt = negate(litf);
    int n2 = numBcls(litf);
    int p2 = numBcls(litt);
    int nn = numNcls(litf);
    int pn = numNcls(litt);

    //Don't count the l\/-l clause.
    if(n2+nn==1) {
      pureReductions++;
      pushupstack(litt->num,allocDAGNODE_PURE(litt->num));
      continue;
    }

    if(p2+pn==1) {
      pureReductions++;
      pushupstack(litf->num,allocDAGNODE_PURE(litf->num));
      continue;
    }

    litscore = score(n2,p2);
    //litsubscore = score(nn,pn);

    if (litscore > bestscore
	//  || (litscore==bestscore && litsubscore > bestsubscore)) {
	) {
      numties=0;
      bestscore=litscore;
      //bestsubscore=litsubscore;
      LITBUF[numties++]=litf->num;
    }
    else if(litscore==bestscore
	    //&& litsubscore==bestsubscore) {
	    ) {
      LITBUF[numties++]=litf->num;
    }
  }

  if(numties>0) {
    //choices[LEVEL]+=1;
    //if(numties>1)
    //  ties[LEVEL]+=1;
    int litf=LITBUF[FibRand()%numties];
    int litt=negate(litf);
    return(numBcls(litt) < numBcls(litf) ? litt : litf);
  }
  else
    return(NOLIT);

}

int findNext3(int level) {
  //compute number of immediate binary clauses produced.
  int choosenlit = NOLIT;
  int bestscore = -1;
  int litscore;
  Lit *litf, *litt;
  int n,p;
  //  int numties=0;

  for(int i = 0; i < NVARS; i++) {
    litf = intTolit(to_literal(i, false));
    if (isInactive(litf))
      continue;

    litt = negate(litf);
    //Don't count the l\/-l clause.
    if(numBcls(litf)+numNcls(litf)==1) {
      pureReductions++;
      pushupstack(litt->num,allocDAGNODE_PURE(litt->num));
      propagateStacks();
      continue;
    }

    if(numBcls(litt)+numBcls(litt)==1) {
      pureReductions++;
      pushupstack(litf->num,allocDAGNODE_PURE(litt->num));
      propagateStacks();
      continue;
    }

    BinLitCls *pb;
    sclauses->empty();

    n=0;
    if(numBcls(litt)>1) {
      for(pb=&(litt->twoClauses);pb->pnext;pb=pb->pnext) {
	Lit *plit=pb->otherlit;
	for(LitCls *pNclauses=plit->nClauses.pnext;
	    pNclauses->pnext;
	    pNclauses=pNclauses->pnext)
	  sclauses->pushnew(pNclauses->pcls->num);
      }
      for(pb=&(litt->twoClauses);pb->pnext;pb=pb->pnext) {
	Lit *plit=negate(pb->otherlit);
	for(LitCls *pNclauses=plit->nClauses.pnext;
	    pNclauses->pnext;
	    pNclauses=pNclauses->pnext)
	  if(pNclauses->pcls->len==3 &&
	     !sclauses->member(pNclauses->pcls->num))
	    n++;
      }
      sclauses->empty();
    }
    else
      n=num3cls(litt);

    p=0;
    if(numBcls(litf)>1) {
      for(pb=&(litf->twoClauses);pb->pnext;pb=pb->pnext) {
	Lit *plit=pb->otherlit;
	for(LitCls *pNclauses=plit->nClauses.pnext;
	    pNclauses->pnext;
	    pNclauses=pNclauses->pnext)
	  sclauses->pushnew(pNclauses->pcls->num);
      }
      for(pb=&(litf->twoClauses);pb->pnext;pb=pb->pnext) {
	Lit *plit=negate(pb->otherlit);
	for(LitCls *pNclauses=plit->nClauses.pnext;
	    pNclauses->pnext;
	    pNclauses=pNclauses->pnext)
	  if(pNclauses->pcls->len==3 &&
	     !sclauses->member(pNclauses->pcls->num))
	    p++;
      }
      sclauses->empty();
    }
    else
      p=num3cls(litf);

    litscore = score(n,p);
     if (litscore > bestscore
	 || (litscore==bestscore &&
	     score(num3cls(choosenlit), num3cls(negate(choosenlit)))
	     < score(num3cls(litf), num3cls(litt)))) {
       bestscore = litscore;
       choosenlit = (numBcls(litt) < numBcls(litf) ? litt->num: litf->num);
     }

//     litscore = score(n,p);
//     if (litscore > bestscore) {
//       numties=0;
//       bestscore=litscore;
//       LITBUF[numties++]=litf->num;
//     }
//     else if(litscore==bestscore)
//       LITBUF[numties++]=litf->num;
  }

//   if(numties>0) {
//     choices[LEVEL]+=1;
//     if(numties>1)
//       ties[LEVEL]+=1;
//     int litf=LITBUF[FibRand()%numties];
//     int litt=negate(litf);
//     return(numBcls(litt) < numBcls(litf) ? litt : litf);
//   }
//   else
//     return(NOLIT);

  return(choosenlit);
}


inline void pushbclsmark(int l1, int l2) {
  bcls *pbcls=allocbcls();
  pbcls->l1=l1;
  pbcls->l2=l2;
  pbcls->pnext=bclsmark;
  bclsmark=pbcls;
}

inline bool emptybclsmark() {
  return(bclsmark==NULL);
}

inline bcls* popbclsmark() {
  bcls* pbcls=bclsmark;
  bclsmark=pbcls->pnext;
  return(pbcls);
}

int findNext4(int level) {
  //computes the number of new 2-clauses generated, But does more with them
  //than findNext2.
  DAG* dnode1;
  DAG* dnode2;

  //int choosenlit = NOLIT;
  //int bestscore = -1;
  //  int litscore;
  //int numties=0;

  for(int i = 0; i < NVARS; i++) {
    Lit *litf = intTolit(to_literal(i, false));
    if (isInactive(litf))
      continue;
    Lit *litt = negate(litf);

    int n2 = numBcls(litf);
    int p2 = numBcls(litt);
    int nn = numNcls(litf);
    int pn = numNcls(litt);
    int n,p,nf,pf;

    //Don't count the l\/-l clause.
    if(n2+nn==1) {
      pureReductions++;
      pushupstack(litt->num,allocDAGNODE_PURE(litt->num));
      propagateStacks();
      continue;
    }

    if(p2+pn==1) {
      pureReductions++;
      pushupstack(litf->num,allocDAGNODE_PURE(litt->num));
      propagateStacks();
      continue;
    }

    BinLitCls* pb;
    Lit *l1, *l2;

    sclauses->empty();
    n=nf=0;
    for(pb=&(litt->twoClauses);pb->pnext;pb=pb->pnext) {
      Lit *plit=pb->otherlit;
      for(LitCls *pNclauses=plit->nClauses.pnext;
	  pNclauses->pnext;
	  pNclauses=pNclauses->pnext)
	    //mark clause made true
	    sclauses->pushnew(pNclauses->pcls->num);
    }

    for(pb=&(litt->twoClauses);pb->pnext;pb=pb->pnext) {
      //get lit's negation which has become False.
      Lit *plit=negate(pb->otherlit);
      for(LitCls *pNclauses=plit->nClauses.pnext;
	  pNclauses->pnext;
	  pNclauses=pNclauses->pnext)
	if(pNclauses->pcls->len ==3 && !sclauses->member(pNclauses->pcls->num)) {
	  findRemainingTwoLits(pNclauses->pcls, plit, l1, l2);
	  if(!haveBclause(l1, l2->num)) {
	    dnode1=allocDAGNODE_NORMAL(pb->dagnode,pNclauses->pcls->dagnode);
	    //			markBclause(l1->num, l2->num,RESOLVED,dnode1);
	    markBclause(l1->num,l2->num,dnode1);
	    pushbclsmark(l1->num, l2->num);
	    //			if(haveBclause(negate(l1),negate(l2->num)))
	    if(haveBclause(negate(l1->num),negate(l2->num)))
	      nf++;
	    //			else if(DNodehaveBclause(negate(l1),l2->num,dnode2)) {
	    else if(DNodehaveBclause(negate(l1->num),l2->num,dnode2)) {
	      nf++;
	      pushbclsstack(litt->num,l2->num,
			    allocDAGNODE_NORMAL(dnode1,dnode2));
	    }
	    //			else if(DNodehaveBclause(l1,negate(l2->num),dnode2)) {
	    else if(DNodehaveBclause(l1->num,negate(l2->num),dnode2)) {
	      nf++;
	      pushbclsstack(litt->num,l1->num,
			    allocDAGNODE_NORMAL(dnode1,dnode2));
	    }
	    else n++;
	  }
	}
	}

    sclauses->empty();
    while(!emptybclsmark()) {
      unmarkBclause(bclsmark->l1,bclsmark->l2);
      deallocbcls(popbclsmark());
    }
    propagateStacks();

    if(isInactive(litf))
      continue;

    p=pf=0;
    for(pb=&(litf->twoClauses);pb->pnext;pb=pb->pnext) {
      Lit *plit=pb->otherlit;
      for(LitCls *pNclauses=plit->nClauses.pnext;
	  pNclauses->pnext;
	  pNclauses=pNclauses->pnext)
	//mark clause made true
	sclauses->pushnew(pNclauses->pcls->num);
    }
    for(pb=&(litf->twoClauses);pb->pnext;pb=pb->pnext) {
      //get lit's negation which has become False.
      Lit *plit=negate(pb->otherlit);
      for(LitCls *pNclauses=plit->nClauses.pnext;
	  pNclauses->pnext;
	  pNclauses=pNclauses->pnext)
	if(pNclauses->pcls->len ==3 && !sclauses->member(pNclauses->pcls->num)) {
	  findRemainingTwoLits(pNclauses->pcls, plit, l1, l2);
	  if(!haveBclause(l1, l2->num)) {
	    dnode1=allocDAGNODE_NORMAL(pb->dagnode,pNclauses->pcls->dagnode);
	    //			markBclause(l1->num, l2->num,RESOLVED,dnode1);
	    markBclause(l1->num, l2->num,dnode1);
	    pushbclsmark(l1->num, l2->num);
	    if(haveBclause(negate(l1),negate(l2->num)))
	      pf++;
	    else if(DNodehaveBclause(negate(l1),l2->num,dnode2)) {
	      pf++;
	      pushbclsstack(litf->num,l2->num,
			    allocDAGNODE_NORMAL(dnode1,dnode2));
	    }
	    else if(DNodehaveBclause(l1,negate(l2->num),dnode2)) {
	      pf++;
	      pushbclsstack(litf->num,l1->num,
			    allocDAGNODE_NORMAL(dnode1,dnode2));
	    }
	    else p++;
	  }
	}
    }

    sclauses->empty();

    while(!emptybclsmark()) {
      unmarkBclause(bclsmark->l1,bclsmark->l2);
      deallocbcls(popbclsmark());
    }

    propagateStacks();
    if(isInactive(litf))
      continue;

    //    litscore = n*p*2+nf*pf*4+n2+p2;
//     //score(n+4*nf,p+4*pf);
//     if (litscore > bestscore
// 	|| (litscore==bestscore &&
// 	    score(numNcls(choosenlit), numNcls(negate(choosenlit)))
// 	    < score(nn,pn))) {
//       bestscore = litscore;
//       choosenlit = (p2 < n2 ? litt->num: litf->num);
//     }
//     if (litscore > bestscore) {
//       numties=0;
//       bestscore=litscore;
//       LITBUF[numties++]=litf->num;
//     }
//     else if(litscore==bestscore)
//       LITBUF[numties++]=litf->num;

  }
  return(findNext2(level));
//   if(numties>0) {
//     int litf=LITBUF[FibRand()%numties];
//     int litt=negate(litf);
//     return(numBcls(litt) < numBcls(litf) ? litt : litf);
//   }
//   else
//     return(NOLIT);
}





/* Random Number Routines ------------------------------------------------------ */

/* Fibonacci random number generator.

These routines implement a combined fibonacci/congruential generator.
This code is based on code written at NBS.

The original algorithm generated numbers in the range 0.0 to 1.0.
The code was converted to generate integers (with the aid of a linear
congruential generator in Knuth, "Seminumerical Algorithms").

The fibonacci generator is of lags 17 and 5, giving a period of about 2**17 * 2**32.
The conguential generator is of period 2**32.
The total period is then 2**81 or about 10**24.

Usage:

Use FibSeed(nSeed) to seed the generator.
Use FibRand() to generate a new random number.
*/

/*	The default fibonacci array has been loaded by first seeding the array with
	FibSeed(305), and then calling FibRand(100000) times.
	The initial seed of the conguential algorithm is the result of
	the 100000th call to FibRand, starting with a seed of 1. */


/* fibonacci data */

static int iFib=16;						/* fibonacci lag -1 */
static int jFib=4;						/* fibonacci lag -1 */
static unsigned int nFibSeed=0x404DC89E;	/* congruential seed */

static unsigned int anFibCoef[17]=		/* fibonacci coefficients */
  {
    0xC5B191E9,
    0xF2C4A426,
    0xCB46D09C,
    0xB612EADF,
    0x57CE4A07,
    0x3963E451,
    0x47A6C699,
    0x57FA4D15,
    0xBDA044E7,
    0xD0C15F5F,
    0xF37E75A3,
    0x101A61FF,
    0x34A21D1D,
    0xF11874EE,
    0x70FBD4FC,
    0xFE7CA439,
    0xC47087BA
  };


int FibRand(void)
{
  unsigned int nValue;

  /* fibonacci generator */

  anFibCoef[iFib]-=anFibCoef[jFib];
  nValue=(int)anFibCoef[iFib];
  if(--iFib<0)
    iFib=16;
  if(--jFib<0)
    jFib=16;

  /* congruential generator */

  nFibSeed=nFibSeed*1664525+1;

  /* combined generator */

  nValue-=nFibSeed;
  return (int)(nValue&0x7FFFFFFF);	/* reduce to 31 bits */
}

/* FibSeed

Description:
Fill in the fibonacci coefficients.
Each coefficient is filled in as a random sequence of ones and zeros.
*/

void FibSeed
(
 int nValue							/* seed value */
 )
{
  int nSum;
  int i1,j1,k1,l1,m1;
  int i,j;

  nFibSeed=(unsigned int)nValue*1664525+1;

  /* Convert seed to four smallish positive integers. */

  i1=(nFibSeed%177)+1;
  j1=(nFibSeed%167)+1;
  k1=(nFibSeed%157)+1;
  l1=(nFibSeed%147)+1;

  /* Generate random bit pattern in array based on given seed. */

  for(i=0;i<17;i++)
    {
      nSum=0;
      for(j=0;j<32;j++)		/* for each bit */
	{
	  nSum*=2;
	  m1=(((i1*j1)%179)*k1)%179;
	  i1=j1;
	  j1=k1;
	  k1=m1;
	  l1=(53*l1+1)%169;
	  if(((l1*m1)%64)>=32)
	    nSum++;
	}
      anFibCoef[i]=nSum;
    }
  iFib=16;
  jFib=4;
}



void createLiteralOrderingByPrefixLevel()
{
  vector< vector<int> > vecAllLiterals;
  for(int j=0; j< getMaxPrefixLevel(); j++)
  {
    vector<int> vecLiterals;
    vecAllLiterals.push_back(vecLiterals);
  }
  for(int i=0; i<NLITS; i++)
  {
    int nLitPrefixLevel = getLitPrefixLevel(i);
    vecAllLiterals[nLitPrefixLevel].push_back(i);
  }
  int l = 0;
  for(int j=0; j< getMaxPrefixLevel(); j++)
  {
    for(int k = 0; k < vecAllLiterals[j].size(); k++)
    {
      _arrLiteralsSortedByPrefixLevel[l] = vecAllLiterals[j][k];
      l++;
    }
  }
  
  /*for(int i=0; i<NLITS; i++)
  {
    if(to_ff(_arrLiteralsSortedByPrefixLevel[i]) > 0)
     printf("\n Literal %d, PL: %d ", to_ff(_arrLiteralsSortedByPrefixLevel[i]), getLitPrefixLevel(_arrLiteralsSortedByPrefixLevel[i]));

  }
  assert(false); */
  
}

int findNextPL()
{
  int i          = 0;
  bool bFound    = false;
  int nReturnLit = NOLIT;
  int nMinReturnLit = NOLIT;
  float nMaxScore  = -1;
  float nMinScore  = 100000000;
  bool bExistential = true;
  int nCurrentLit;
  int nActivePrefixLevel  = -1;
  while((i < NLITS) && (!bFound))
  {
    nCurrentLit = _arrLiteralsSortedByPrefixLevel[i];
    if((getLitPrefixLevel(nCurrentLit) > nActivePrefixLevel) && (nActivePrefixLevel != -1))
     bFound = true;
    else if(isActive(nCurrentLit) && ((nActivePrefixLevel == -1) || (nActivePrefixLevel == getLitPrefixLevel(nCurrentLit))))
     {
      if(nActivePrefixLevel == -1)
       nActivePrefixLevel = getLitPrefixLevel(nCurrentLit);
	  if(isLitExistential(nCurrentLit))
       bExistential = true;
	  else
       bExistential = false;
      if(getLiteralScore(nCurrentLit) > nMaxScore)
      {
       nReturnLit = nCurrentLit;
       nMaxScore  = getLiteralScore(nCurrentLit);
      }
	  if(getLiteralScore(nCurrentLit) < nMinScore)
      {
       nMinReturnLit = nCurrentLit;
       nMinScore  = getLiteralScore(nCurrentLit);
      }
     }
    ++i;
  }
  //printf("\n XDECISIONX Literal %d, PL: %d %d \n", to_ff(nReturnLit), getLitPrefixLevel(nReturnLit), ((getLitdagnode(nReturnLit) == NULL)? 0:1) );
  if(bExistential)
   return nReturnLit;
  else   
   return nMinReturnLit;
}


int propagateExistentialPures()
{
 vector<int> vecPureExistentials;
 int i = 0;
 while(i < NVARS)
 {
  Lit *litf = intTolit(to_literal(i, false));
  if (isInactive(litf))
  {
	  i++;
      continue;
  }
  if(isLitExistential(litf)) {
	  Lit *litt = negate(litf);
	  int n2 = numBcls(litf);
	  int p2 = numBcls(litt);
	  int nn = numNcls(litf);
	  int pn = numNcls(litt);
	  if((n2+nn==1) && (p2+pn==1))
	  {
        i++;
		continue;
	  }
	  else {
		  if(n2+nn==1) {
			 pureReductions++;	
			 //if((litt->num == 166) || (litt->num==167))
				// printf("\n Existential is pure! %d Other Side Value: %d ",litt->num, p2+pn ); 
			 vecPureExistentials.push_back(litt->num);		 
			 i++;
			 continue;
		  }
		  if(p2+pn==1) {
		   pureReductions++;
		   //if((litf->num== 166) || (litf->num == 167))
				// printf("\n Existential is pure! %d Other Side Value: %d ", litf->num, n2+nn); 
		   vecPureExistentials.push_back(litf->num);		 	   
		   i++;
		   continue;
		  }
	  }
  }
  i++;
 }
  if(vecPureExistentials.size() > 0)
  {
   for(int j = 0; j < vecPureExistentials.size() - 1; j++)
   {
    pushupstack(vecPureExistentials[j],allocDAGNODE_PURE(vecPureExistentials[j]));
   }  
   assert(isLitExistential(vecPureExistentials[vecPureExistentials.size() - 1]));
   return vecPureExistentials[vecPureExistentials.size() - 1];
  }
  return -1;
}

int propagateExistentialPuresAsDecisions()
{
 int i = 0;
 //Lit *litf = intTolit(to_literal(NVARS, false));
 while(i < NVARS)
 {
  Lit * litf = intTolit(to_literal(i, false));
  if (isInactive(litf))
  {
	  i++;
      continue;
  }
  if(isLitExistential(litf)) {
	  Lit *litt = negate(litf);
	  int n2 = numBcls(litf);
	  int p2 = numBcls(litt);
	  int nn = numNcls(litf);
	  int pn = numNcls(litt);
	  if(n2+nn==1) {
  	        pureReductions++;	
			 //if((litt->num == 166) || (litt->num==167))
				// printf("\n Existential is pure! %d Other Side Value: %d ",litt->num, p2+pn ); 
			 return litt->num;		 			 
		  }
		  if(p2+pn==1) {
		   pureReductions++;		   
		   return litf->num;		 			 
		  }
	  }
  i++; 
 }
  return -1;
}

int propagateUniversalPures()
{ 
 int i = 0;
 while(i < NVARS)
 {
      Lit *litf = intTolit(to_literal(i, false));
      if (isInactive(litf))
      {
	   i++;
       continue;
      }
  
	  Lit *litt = negate(litf);
	  int n2 = numBcls(litf);
	  int p2 = numBcls(litt);
	  int nn = numNcls(litf);
	  int pn = numNcls(litt);
	  if(n2+nn==1) {
		 pureReductions++;	  
		 return(litf->num);		 
		 i++;
		 continue;
	  }
	  if(p2+pn==1) {
	   pureReductions++;
	   return(litt->num);
	  }
  
  i++;
 }  
  return -1;
}



int findNext2ObeyPL(int level) {
  //Identical to fn1. But randomly choosed between the tied variables.

  //   if(MRFailedLit!=NOLIT && isActive(MRFailedLit))
  // 	return(MRFailedLit);

  bool bDone    = false;

  int nActivePrefixLevel  = -1;

  //int choosenlit = NOLIT;
  int bestscore = -1;
  //int bestsubscore=-1;
  int litscore,i;
  //  int litsubscore;
  int numties=0;
  // Horst: PURES
  //int nPureLit = propagatePures();
  //if((nPureLit != -1))
  // return nPureLit;  
  //propagateStacks();
  // End
  i = 0;
  while((i < NVARS) && (!bDone)) {
    Lit *litf = intTolit(_arrLiteralsSortedByPrefixLevel[to_literal(i, false)]);	
	Lit *litt = intTolit(_arrLiteralsSortedByPrefixLevel[to_literal(i, true)]);
    if (isInactive(litf))
	{
	  i++;
      continue;
	}
	//printf("\n Active Prefix Level: %d ",nActivePrefixLevel); 
	if((numties == 0) && (getLitPrefixLevel(litf) > nActivePrefixLevel))
	{
	 nActivePrefixLevel = getLitPrefixLevel(litf);	
	}
	if((getLitPrefixLevel(litf) > nActivePrefixLevel) && (nActivePrefixLevel != -1))
	{
	  bDone = true;
	}
	else if((nActivePrefixLevel == -1) || (nActivePrefixLevel == getLitPrefixLevel(litf))){
		nActivePrefixLevel = getLitPrefixLevel(litf);

		Lit *litt = negate(litf);
		int n2 = numBcls(litf);
		int p2 = numBcls(litt);
		int nn = numNcls(litf);
		int pn = numNcls(litt);
        //if(isLitExistential(litf)) 
		//{
		if(n2+nn==1) {
			 pureReductions++;	  
			 if(isLitExistential(litf))  
			 {
			  //printf("\n 1 Pushing Pure: %d ", litt->num);
  			  //pushupstack(litt->num,allocDAGNODE_PURE(litt->num));
              return litt->num;
			 }	 
			 else
			 {
			  return litf->num;
			 }
			 i++;
			 continue;
		  }

		  if(p2+pn==1) {
		   pureReductions++;
		   if(isLitExistential(litf))  
		   {
            //printf("\n 2 Pushing Pure: %d ", litf->num);    
			//pushupstack(litf->num,allocDAGNODE_PURE(litf->num));
			return litf->num;
		   }
		   else
		   {
			return litt->num;
		   }
		   i++;
		   continue;
		  }		 
		//}
        
		litscore = score(n2,p2);
		//litsubscore = score(nn,pn);

		if (litscore > bestscore
		//  || (litscore==bestscore && litsubscore > bestsubscore)) {
		) {
		  numties=0;
		  bestscore=litscore;
		  //bestsubscore=litsubscore;
		  LITBUF[numties++]=litf->num;
		}
		else if(litscore==bestscore
			//&& litsubscore==bestsubscore) {
			) {
		  LITBUF[numties++]=litf->num;
		}
	}
	// Go to next level;
	i++;	
  }

  if(numties>0) {
    //choices[LEVEL]+=1;
    //if(numties>1)
    //  ties[LEVEL]+=1;
    int litf=LITBUF[FibRand()%numties];
    int litt=negate(litf);
	assert(nActivePrefixLevel == getLitPrefixLevel(litf));
    return(numBcls(litt) < numBcls(litf) ? litt : litf);
  }
  else
  {
   /*i = 0;
   while(i < NVARS)
   {
    
    Lit *litf = intTolit(to_literal(i, false));
	Lit *litt = intTolit(to_literal(i, true));
    
	if(litf->val == U || litt->val == U)
	{
		printf("\n Literal %d (PL: %d) is active (? %d %d) !", litf->num, getLitPrefixLevel(litf->num), isActive(litf), isActive(litt));
		//assert(false);
	}
	i++;
   }*/
    //printf("\n Return NOLIT!");
    return(NOLIT);
  }

}


int findNext3ObeyPL(int level) {
  //compute number of immediate binary clauses produced.
  int choosenlit = NOLIT;
  int bestscore;
  int litscore;
  Lit *litf, *litt;
  int n,p;
  //  int numties=0;
 
  // Horst
  bool bDone    = false;
  int nActivePrefixLevel  = -1;
  int nReturnLit = propagateExistentialPures();
  if(nReturnLit != -1)
	  return nReturnLit;
  //nReturnLit = propagateUniversalPures(); 
  //if(nReturnLit != -1)
	//  return nReturnLit;
  bool bFirst = true;
  int i = 0;
  while((i < NVARS) && (!bDone)) {
    Lit *litf = intTolit(_arrLiteralsSortedByPrefixLevel[to_literal(i, false)]);	
  
    if (isInactive(litf))
	{
	  i++;
      continue;
	}
    if((choosenlit == NOLIT) && (getLitPrefixLevel(litf) > nActivePrefixLevel))
	{
	 nActivePrefixLevel = getLitPrefixLevel(litf);	
	 bFirst = true;
	}
	if((getLitPrefixLevel(litf) > nActivePrefixLevel) && (nActivePrefixLevel != -1))
	{
	  bDone = true;
	}
	else if((nActivePrefixLevel == -1) || (nActivePrefixLevel == getLitPrefixLevel(litf)))
    {
	  nActivePrefixLevel = getLitPrefixLevel(litf);
      litt = negate(litf);
	  
      //Don't count the l\/-l clause.
      if(numBcls(litf)+numNcls(litf)==1) {
       pureReductions++;
	  if(isLitExistential(litf))
       return(litt->num);      
	  else
       return(litf->num);      
     }

    if(numBcls(litt)+numBcls(litt)==1) {
      pureReductions++; 
	  if(isLitExistential(litf))
       return(litf->num);      
	  else
       return(litt->num);      
    }

	if(isLitExistential(litf)){
		BinLitCls *pb;
		sclauses->empty();

		n=0;
		if(numBcls(litt)>1) {
		  for(pb=&(litt->twoClauses);pb->pnext;pb=pb->pnext) {
		Lit *plit=pb->otherlit;
		for(LitCls *pNclauses=plit->nClauses.pnext;
			pNclauses->pnext;
			pNclauses=pNclauses->pnext)
		  sclauses->pushnew(pNclauses->pcls->num);
		  }
		  for(pb=&(litt->twoClauses);pb->pnext;pb=pb->pnext) {
		Lit *plit=negate(pb->otherlit);
		for(LitCls *pNclauses=plit->nClauses.pnext;
			pNclauses->pnext;
			pNclauses=pNclauses->pnext)
		  if(pNclauses->pcls->len==3 &&
			 !sclauses->member(pNclauses->pcls->num))
			n++;
		  }
		  sclauses->empty();
		}
		else
		  n=num3cls(litt);

		p=0;
		if(numBcls(litf)>1) {
		  for(pb=&(litf->twoClauses);pb->pnext;pb=pb->pnext) {
		Lit *plit=pb->otherlit;
		for(LitCls *pNclauses=plit->nClauses.pnext;
			pNclauses->pnext;
			pNclauses=pNclauses->pnext)
		  sclauses->pushnew(pNclauses->pcls->num);
		  }
		  for(pb=&(litf->twoClauses);pb->pnext;pb=pb->pnext) {
		Lit *plit=negate(pb->otherlit);
		for(LitCls *pNclauses=plit->nClauses.pnext;
			pNclauses->pnext;
			pNclauses=pNclauses->pnext)
		  if(pNclauses->pcls->len==3 &&
			 !sclauses->member(pNclauses->pcls->num))
			p++;
		  }
		  sclauses->empty();
		}
		else
		  p=num3cls(litf);

		litscore = score(n,p);
		
			if (litscore > bestscore
			 || (litscore==bestscore &&
				 score(num3cls(choosenlit), num3cls(negate(choosenlit)))
				 < score(num3cls(litf), num3cls(litt)))) {
			   bestscore = litscore;
			   choosenlit = (numBcls(litt) < numBcls(litf) ? litt->num: litf->num);
			} 
	 
	}
	else
	{
      litscore = max(getLiteralCubeScore(litf->num), getLiteralCubeScore(litt->num));
	  if (litscore > bestscore
			 || (litscore==bestscore &&
				 score(num3cls(choosenlit), num3cls(negate(choosenlit)))
				 < score(num3cls(litf), num3cls(litt)))) {
			   bestscore = litscore;
			   choosenlit = (numBcls(litt) < numBcls(litf) ? litt->num: litf->num);
	 } 
	}
	}
	i++;
  }
  if(choosenlit == NOLIT)
  {
   /*i = 0;
   while(i < NVARS)
   {
    
    Lit *litf = intTolit(to_literal(i, false));
	Lit *litt = intTolit(to_literal(i, true));
    
	if(litf->val == U || litt->val == U)
	{
		printf("\n Literal %d (PL: %d) is active (? %d) !", litf->num, getLitPrefixLevel(litf->num), isActive(litf));
		//assert(false);
	}
	i++;
   }*/
  }
  return(choosenlit);
}

int findNext5ObeyPL(int level) {
  //compute number of immediate binary clauses produced.
  int choosenlit = NOLIT;
  int bestscore = 1000000;
  int litscore;
  Lit *litf, *litt;
  int n,p;
  //  int numties=0;
 
  // Horst
  bool bDone    = false;
  int nActivePrefixLevel  = -1;
  int nReturnLit = propagateExistentialPures();
  if(nReturnLit != -1)
	  return nReturnLit;
  //nReturnLit = propagateUniversalPures(); 
  //if(nReturnLit != -1)
	//  return nReturnLit;
  bool bFirst = true;
  int i = 0;
  while((i < NVARS) && (!bDone)) {
    Lit *litf = intTolit(_arrLiteralsSortedByPrefixLevel[to_literal(i, false)]);	
  
    if (isInactive(litf))
	{
	  i++;
      continue;
	}
    if((choosenlit == NOLIT) && (getLitPrefixLevel(litf) > nActivePrefixLevel))
	{
	 nActivePrefixLevel = getLitPrefixLevel(litf);	
	 bFirst = true;
	}
	if((getLitPrefixLevel(litf) > nActivePrefixLevel) && (nActivePrefixLevel != -1))
	{
	  bDone = true;
	}
	else if((nActivePrefixLevel == -1) || (nActivePrefixLevel == getLitPrefixLevel(litf)))
    {
	  nActivePrefixLevel = getLitPrefixLevel(litf);
      litt = negate(litf);
	  /*if(bFirst)
	  {
        if(isLitExistential(litf)) 
		  bestscore = 10000000;
		else
          bestscore = -1;
	  } */
	  
		   //Don't count the l\/-l clause.
		  if(numBcls(litf)+numNcls(litf)==1) {
		   pureReductions++;
		  if(isLitExistential(litf))
		   return(litt->num);      
		  else
		   return(litf->num);      
		 }

		if(numBcls(litt)+numBcls(litt)==1) {
		  pureReductions++; 
		  if(isLitExistential(litf))
		   return(litf->num);      
		  else
		   return(litt->num);      
		}
	  
	if(isLitExistential(litf)){
		BinLitCls *pb;
		sclauses->empty();

		n=0;
		if(numBcls(litt)>1) {
		  for(pb=&(litt->twoClauses);pb->pnext;pb=pb->pnext) {
		Lit *plit=pb->otherlit;
		for(LitCls *pNclauses=plit->nClauses.pnext;
			pNclauses->pnext;
			pNclauses=pNclauses->pnext)
		  sclauses->pushnew(pNclauses->pcls->num);
		  }
		  for(pb=&(litt->twoClauses);pb->pnext;pb=pb->pnext) {
		Lit *plit=negate(pb->otherlit);
		for(LitCls *pNclauses=plit->nClauses.pnext;
			pNclauses->pnext;
			pNclauses=pNclauses->pnext)
		  if(pNclauses->pcls->len==3 &&
			 !sclauses->member(pNclauses->pcls->num))
			n++;
		  }
		  sclauses->empty();
		}
		else
		  n=num3cls(litt);

		p=0;
		if(numBcls(litf)>1) {
		  for(pb=&(litf->twoClauses);pb->pnext;pb=pb->pnext) {
		Lit *plit=pb->otherlit;
		for(LitCls *pNclauses=plit->nClauses.pnext;
			pNclauses->pnext;
			pNclauses=pNclauses->pnext)
		  sclauses->pushnew(pNclauses->pcls->num);
		  }
		  for(pb=&(litf->twoClauses);pb->pnext;pb=pb->pnext) {
		Lit *plit=negate(pb->otherlit);
		for(LitCls *pNclauses=plit->nClauses.pnext;
			pNclauses->pnext;
			pNclauses=pNclauses->pnext)
		  if(pNclauses->pcls->len==3 &&
			 !sclauses->member(pNclauses->pcls->num))
			p++;
		  }
		  sclauses->empty();
		}
		else
		  p=num3cls(litf);

		litscore = score(n,p);
		
			if (litscore < bestscore
			 || (litscore==bestscore &&
				 score(num3cls(choosenlit), num3cls(negate(choosenlit)))
				 < score(num3cls(litf), num3cls(litt)))) {
			   bestscore = litscore;
			   choosenlit = (numBcls(litt) < numBcls(litf) ? litt->num: litf->num);
			} 
	 
	}
	else
	{
      litscore = max(getLiteralCubeScore(litf->num), getLiteralCubeScore(litt->num));
	  if (litscore < bestscore
			 || (litscore==bestscore &&
				 score(num3cls(choosenlit), num3cls(negate(choosenlit)))
				 < score(num3cls(litf), num3cls(litt)))) {
			   bestscore = litscore;
			   
			   choosenlit = (numBcls(litt) < numBcls(litf) ? litt->num: litf->num);
			   //printf("\n Set chosen Lit: %d ", choosenlit);
	 } 
	}
	}
	i++;
  }
  if(choosenlit == NOLIT)
  {
   /*i = 0;
   while(i < NVARS)
   {
    
    Lit *litf = intTolit(to_literal(i, false));
	Lit *litt = intTolit(to_literal(i, true));
    
	if(litf->val == U || litt->val == U)
	{
		printf("\n Literal %d (PL: %d) is active (? %d) !", litf->num, getLitPrefixLevel(litf->num), isActive(litf));
		//assert(false);
	}
	i++;
   }*/
  }
  return(choosenlit);
}




int findNext6ObeyPL(int level) {
  //compute number of immediate binary clauses produced.
  int nReturnLit = propagateExistentialPuresAsDecisions();
  if(nReturnLit != -1)
	  return nReturnLit;

  int choosenlit = NOLIT;
  int bestscore = 100000;
  int litscore;
  Lit *litf, *litt;
  int n,p;
  //  int numties=0;
 
  // Horst
  bool bDone    = false;
  int nActivePrefixLevel  = -1;
  //int nReturnLit = propagateExistentialPures();
  //if(nReturnLit != -1)
	//  return nReturnLit;
  /*nReturnLit = propagateUniversalPures();
  if(nReturnLit != -1)
  {
	  printf("\n---> Pure Universal: %d ", nReturnLit);
	  return nReturnLit;
  }*/
  //nReturnLit = propagateUniversalPures(); 
  //if(nReturnLit != -1)
	//  return nReturnLit;
  bool bFirst = true;
  int i = 0;
  while((i < NVARS) && (!bDone)) {
    Lit *litf = intTolit(_arrLiteralsSortedByPrefixLevel[to_literal(i, false)]);	
  
    if (isInactive(litf))
	{
	  i++;
      continue;
	}
    if((choosenlit == NOLIT) && (getLitPrefixLevel(litf) > nActivePrefixLevel))
	{
	 nActivePrefixLevel = getLitPrefixLevel(litf);	
	 bFirst = true;
	}
	if((getLitPrefixLevel(litf) > nActivePrefixLevel) && (nActivePrefixLevel != -1))
	{
	  bDone = true;
	}
	else if((nActivePrefixLevel == -1) || (nActivePrefixLevel == getLitPrefixLevel(litf)))
    {
	  nActivePrefixLevel = getLitPrefixLevel(litf);
      litt = negate(litf);
	  if(bFirst)
	  {
        if(isLitExistential(litf)) 
		  bestscore = -1;
		else
          bestscore = -1;
		bFirst = false;
	  } 
	  
		  //Don't count the l\/-l clause.
		  if(numBcls(litf)+numNcls(litf)==1) {
		   pureReductions++;
		  if(isLitExistential(litf))
		   return(litt->num);      
		  else
		   return(litf->num);      
		 }

		if(numBcls(litt)+numBcls(litt)==1) {
		  pureReductions++; 
		  if(isLitExistential(litf))
		   return(litf->num);      
		  else
		   return(litt->num);      
		}
	  
	if(isLitExistential(litf)){
		BinLitCls *pb;
		sclauses->empty();

		n=0;
		int n1 = 0;
		int n2 = 0;
		if(numBcls(litt)>1) {
		  for(pb=&(litt->twoClauses);pb->pnext;pb=pb->pnext) {
		  Lit *plit=pb->otherlit;
		  for(LitCls *pNclauses=plit->nClauses.pnext;
			pNclauses->pnext;
			pNclauses=pNclauses->pnext)
		    {
		   	 n1++;
		     //sclauses->pushnew(pNclauses->pcls->num);
		    }
		  }
		  /*for(pb=&(litt->twoClauses);pb->pnext;pb=pb->pnext) {
		  Lit *plit=negate(pb->otherlit);
		  for(LitCls *pNclauses=plit->nClauses.pnext;
			pNclauses->pnext;
			pNclauses=pNclauses->pnext)
		  if(!sclauses->member(pNclauses->pcls->num))
			n2++;
		  }*/
		  //sclauses->empty();
		  n = n1;// max(n1, n2);
		}
		else
		  n=num3cls(litt);

		p=0;
        int p1 = 0;
		int p2 = 0;
		if(numBcls(litf)>1) {
		  for(pb=&(litf->twoClauses);pb->pnext;pb=pb->pnext) {
		Lit *plit=pb->otherlit;
		for(LitCls *pNclauses=plit->nClauses.pnext;
			pNclauses->pnext;
			pNclauses=pNclauses->pnext)
		    {
			 p1++;
		     //sclauses->pushnew(pNclauses->pcls->num);
		    }
		  }
		/*for(pb=&(litf->twoClauses);pb->pnext;pb=pb->pnext) {
		Lit *plit=negate(pb->otherlit);
		for(LitCls *pNclauses=plit->nClauses.pnext;
			pNclauses->pnext;
			pNclauses=pNclauses->pnext)
		  if(!sclauses->member(pNclauses->pcls->num))
			p2++;
		  }*/
		  //sclauses->empty();
          p = p1;//max(p1, p2);
		}
		else
		  p=num3cls(litf);

		litscore = max(n,p);//score(n,p);
		
			if (litscore > bestscore
			 || (litscore==bestscore &&
				 score(num3cls(choosenlit), num3cls(negate(choosenlit)))
				 > score(num3cls(litf), num3cls(litt)))) {
			   bestscore = litscore;
			   choosenlit = (numBcls(litt) < numBcls(litf) ? litt->num: litf->num);
			} 
	 
	}
	else
	{
      litscore = max(getLiteralCubeScore(litf->num), getLiteralCubeScore(litt->num));
	  if (litscore > bestscore
			 || (litscore==bestscore &&
				 score(num3cls(choosenlit), num3cls(negate(choosenlit)))
				 < score(num3cls(litf), num3cls(litt)))) {
			   bestscore = litscore;
			   
			   choosenlit = (numBcls(litt) < numBcls(litf) ? litt->num: litf->num);
			   //printf("\n Set chosen Lit: %d ", choosenlit);
	 } 
	}
	}
	i++;
  }
  //if(choosenlit == NOLIT)
  //{
   /*i = 0;
   while(i < NVARS)
   {
    
    Lit *litf = intTolit(to_literal(i, false));
	Lit *litt = intTolit(to_literal(i, true));
    
	if(litf->val == U || litt->val == U)
	{
		printf("\n Literal %d (PL: %d) is active (? %d) !", litf->num, getLitPrefixLevel(litf->num), isActive(litf));
		//assert(false);
	}
	i++;
   }*/
  //}
  return(choosenlit);
}


int findNext4ObeyPL(int level) {
  // Horst: PURES
  //int nPureLit = propagatePures();
  //if((nPureLit != -1) && (!isLitExistential(nPureLit)))
  // return nPureLit;  
  // End
	
  //computes the number of new 2-clauses generated, But does more with them
  //than findNext2.
  DAG* dnode1;
  DAG* dnode2;

  //int choosenlit = NOLIT;
  //int bestscore = -1;
  //  int litscore;
  //int numties=0;

 
  bool bDone    = false;
  int nActivePrefixLevel  = -1;

  int i = 0;
  while((i < NVARS) && (!bDone)) {
    Lit *litf = intTolit(_arrLiteralsSortedByPrefixLevel[to_literal(i, false)]);
    
	if((getLitPrefixLevel(litf) > nActivePrefixLevel) && (nActivePrefixLevel != -1))
      bDone = true;
	else if(isActive(litf) && ((nActivePrefixLevel == -1) || (nActivePrefixLevel == getLitPrefixLevel(litf)))){
		nActivePrefixLevel = getLitPrefixLevel(litf);
		Lit *litt = negate(litf);

		int n2 = numBcls(litf);
		int p2 = numBcls(litt);
		int nn = numNcls(litf);
		int pn = numNcls(litt);
		int n,p,nf,pf;		

        if(n2+nn==1) {
			 pureReductions++;	  
			 if(isLitExistential(litf))  
			 {
  			  //pushupstack(litt->num,allocDAGNODE_PURE(litt->num));
              return litt->num;
			 }	 
			 else
			 {
			  return litf->num;
			 }
			 i++;
			 continue;
		  }

		  if(p2+pn==1) {
		   pureReductions++;
		   if(isLitExistential(litf))  
		   {
			//pushupstack(litf->num,allocDAGNODE_PURE(litf->num));
			return litf->num;
		   }
		   else
		   {
			return litt->num;
		   }
		   i++;
		   continue;
		  }		 

		BinLitCls* pb;
		Lit *l1, *l2;

		sclauses->empty();
		n=nf=0;
		for(pb=&(litt->twoClauses);pb->pnext;pb=pb->pnext) {
		  Lit *plit=pb->otherlit;
		  for(LitCls *pNclauses=plit->nClauses.pnext;
		  pNclauses->pnext;
		  pNclauses=pNclauses->pnext)
			//mark clause made true
			sclauses->pushnew(pNclauses->pcls->num);
		}

		for(pb=&(litt->twoClauses);pb->pnext;pb=pb->pnext) {
		  //get lit's negation which has become False.
		  Lit *plit=negate(pb->otherlit);
		  for(LitCls *pNclauses=plit->nClauses.pnext;
		  pNclauses->pnext;
		  pNclauses=pNclauses->pnext)
		if(pNclauses->pcls->len ==3 && !sclauses->member(pNclauses->pcls->num)) {
		  findRemainingTwoLits(pNclauses->pcls, plit, l1, l2);
		  if(!haveBclause(l1, l2->num)) {
			dnode1=allocDAGNODE_NORMAL(pb->dagnode,pNclauses->pcls->dagnode);
			//			markBclause(l1->num, l2->num,RESOLVED,dnode1);
			markBclause(l1->num,l2->num,dnode1);
			pushbclsmark(l1->num, l2->num);
			//			if(haveBclause(negate(l1),negate(l2->num)))
			if(haveBclause(negate(l1->num),negate(l2->num)))
			  nf++;
			//			else if(DNodehaveBclause(negate(l1),l2->num,dnode2)) {
			else if(DNodehaveBclause(negate(l1->num),l2->num,dnode2)) {
			  nf++;
			  pushbclsstack(litt->num,l2->num,
					allocDAGNODE_NORMAL(dnode1,dnode2));
			}
			//			else if(DNodehaveBclause(l1,negate(l2->num),dnode2)) {
			else if(DNodehaveBclause(l1->num,negate(l2->num),dnode2)) {
			  nf++;
			  pushbclsstack(litt->num,l1->num,
					allocDAGNODE_NORMAL(dnode1,dnode2));
			}
			else n++;
		  }
		}
		}

		sclauses->empty();
		while(!emptybclsmark()) {
		  unmarkBclause(bclsmark->l1,bclsmark->l2);
		  deallocbcls(popbclsmark());
		}
		propagateStacks();

		if(isInactive(litf))
		{
		  i++;
		  continue;
		}

		p=pf=0;
		for(pb=&(litf->twoClauses);pb->pnext;pb=pb->pnext) {
		  Lit *plit=pb->otherlit;
		  for(LitCls *pNclauses=plit->nClauses.pnext;
		  pNclauses->pnext;
		  pNclauses=pNclauses->pnext)
		//mark clause made true
		sclauses->pushnew(pNclauses->pcls->num);
		}
		for(pb=&(litf->twoClauses);pb->pnext;pb=pb->pnext) {
		  //get lit's negation which has become False.
		  Lit *plit=negate(pb->otherlit);
		  for(LitCls *pNclauses=plit->nClauses.pnext;
		  pNclauses->pnext;
		  pNclauses=pNclauses->pnext)
		if(pNclauses->pcls->len ==3 && !sclauses->member(pNclauses->pcls->num)) {
		  findRemainingTwoLits(pNclauses->pcls, plit, l1, l2);
		  if(!haveBclause(l1, l2->num)) {
			dnode1=allocDAGNODE_NORMAL(pb->dagnode,pNclauses->pcls->dagnode);
			//			markBclause(l1->num, l2->num,RESOLVED,dnode1);
			markBclause(l1->num, l2->num,dnode1);
			pushbclsmark(l1->num, l2->num);
			if(haveBclause(negate(l1),negate(l2->num)))
			  pf++;
			else if(DNodehaveBclause(negate(l1),l2->num,dnode2)) {
			  pf++;
			  pushbclsstack(litf->num,l2->num,
					allocDAGNODE_NORMAL(dnode1,dnode2));
			}
			else if(DNodehaveBclause(l1,negate(l2->num),dnode2)) {
			  pf++;
			  pushbclsstack(litf->num,l1->num,
					allocDAGNODE_NORMAL(dnode1,dnode2));
			}
			else p++;
		  }
		}
		}

		sclauses->empty();

		while(!emptybclsmark()) {
		  unmarkBclause(bclsmark->l1,bclsmark->l2);
		  deallocbcls(popbclsmark());
		}

		propagateStacks();
	  }  
   i++;
  }
  return(findNext2ObeyPL(level));
}


int findNext5(int level) {
  //computes the number of new 2-clauses generated
  int choosenlit = NOLIT;
  int bestscore = -1;
  int litscore;
  for(int i = 0; i < NVARS; i++) {
    Lit *litf = intTolit(to_literal(i, false));
    if (isInactive(litf) || LITBUF[level] == i)
      continue;
    Lit *litt = negate(litf);

    int n2 = numBcls(litf);
    int p2 = numBcls(litt);
    int nn = numNcls(litf);
    int pn = numNcls(litt);
    int n,p;

    //Don't count the l\/-l clause.
    if(n2+nn==1) {
      pureReductions++;
      pushupstack(litt->num,allocDAGNODE_PURE(litt->num));
      propagateStacks();
      continue;
    }

    if(p2+pn==1) {
      pureReductions++;
      pushupstack(litf->num,allocDAGNODE_PURE(litt->num));
      propagateStacks();
      continue;
    }

    BinLitCls* pb;
    sclauses->empty();

    n=0;
    for(pb=&(litt->twoClauses);pb->pnext;pb=pb->pnext) {
      Lit *plit=pb->otherlit;
      for(LitCls *pNclauses=plit->nClauses.pnext;
	  pNclauses->pnext;
	  pNclauses=pNclauses->pnext)
	//mark clause made true
	sclauses->pushnew(pNclauses->pcls->num);
    }
    for(pb=&(litt->twoClauses);pb->pnext;pb=pb->pnext) {
      //get lit's negation which has become False.
      Lit *plit=negate(pb->otherlit);
      for(LitCls *pNclauses=plit->nClauses.pnext;
	  pNclauses->pnext;
	  pNclauses=pNclauses->pnext)
	if(pNclauses->pcls->len ==3 && !sclauses->member(pNclauses->pcls->num))
	  n++;
    }
    sclauses->empty();

    p=0;
    for(pb=&(litf->twoClauses);pb->pnext;pb=pb->pnext) {
      Lit *plit=pb->otherlit;
      for(LitCls *pNclauses=plit->nClauses.pnext;
	  pNclauses->pnext;
	  pNclauses=pNclauses->pnext)
	//mark clause made true
	sclauses->pushnew(pNclauses->pcls->num);
    }
    for(pb=&(litf->twoClauses);pb->pnext;pb=pb->pnext) {
      //get lit's negation which has become False.
      Lit *plit=negate(pb->otherlit);
      for(LitCls *pNclauses=plit->nClauses.pnext;
	  pNclauses->pnext;
	  pNclauses=pNclauses->pnext)
	if(pNclauses->pcls->len ==3 && !sclauses->member(pNclauses->pcls->num))
	  p++;
    }
    sclauses->empty();

    litscore = score(n,p);
    if (litscore > bestscore) {
      bestscore = litscore;
      choosenlit = (p2 < n2 ? litt->num: litf->num);
    }
  }
  LITBUF[level]=variable_of(choosenlit);
  return(choosenlit);
}


int findNext7ObeyPL(int level) {
  // Propagate Existential Pures
  int nReturnLit = propagateExistentialPures();
  if(nReturnLit != -1)
	  return nReturnLit;
  //Compute number of immediate binary clauses produced.
  int choosenlit = NOLIT;
  int bestscore = -1;
  int litscore;
  Lit *litf, *litt;
  int n,p;
  //  int numties=0;
  //vector<int> * vecLits = getSpecialExistentials();
  //outputVectorCube(vecLits);
  //assert(false);
  // Horst
  bool bDone    = false;
  int nActivePrefixLevel  = -1;
  
  /*nReturnLit = propagateUniversalPures();
  if(nReturnLit != -1)
  {
	  printf("\n---> Pure Universal: %d ", nReturnLit);
	  return nReturnLit;
  }*/
  //nReturnLit = propagateUniversalPures(); 
  //if(nReturnLit != -1)
	//  return nReturnLit;
  bool bFirst = true;
  int i = 0;
  while((i < NVARS) && (!bDone)) {
    Lit *litf = intTolit(_arrLiteralsSortedByPrefixLevel[to_literal(i, false)]);	
    if (isInactive(litf))
	{
	  i++;
      continue;
	}
    if((choosenlit == NOLIT) && (getLitPrefixLevel(litf) > nActivePrefixLevel))
	{
	 nActivePrefixLevel = getLitPrefixLevel(litf);	
	 bFirst = true;
	}
	if((getLitPrefixLevel(litf) > nActivePrefixLevel) && (nActivePrefixLevel != -1))
	{
	  bDone = true;
	}
	else if((nActivePrefixLevel == -1) || (nActivePrefixLevel == getLitPrefixLevel(litf)))
    {
	  nActivePrefixLevel = getLitPrefixLevel(litf);
	  /*
	  vector<int>::iterator iterVec;
	  for(iterVec = vecLits->begin(); iterVec != vecLits->end(); ++iterVec)
	  {
        if(getLitPrefixLevel(*iterVec) == nActivePrefixLevel)
		{ 
			int nLit = *iterVec;
			delete vecLits;
			return nLit;
		}
	  }*/
	  litt = negate(litf);
	  /*if(isLitExistential(litf)) {
       int n2 = numBcls(litf);
	   int p2 = numBcls(litt);
	   int nn = numNcls(litf);
	   int pn = numNcls(litt);
	   if((n2+nn==1) && (p2+pn==1))
	   {
         i++;
 		 continue;
	   }
	  }*/

	  if(bFirst)
	  {
        if(isLitExistential(litf)) 
		  bestscore = 1000000;
		else
          bestscore = -1;
		bFirst = false;
	  } 
	  if(isLitExistential(litt->num)) {
	   if((getLiteralScore(litt->num) + getLiteralScore(litf->num)) < bestscore) {
		bestscore = getLiteralScore(litt->num) + getLiteralScore(litf->num);
        if(getLiteralScore(litt->num) < getLiteralScore(litf->num))
         choosenlit = litt->num;
		else
         choosenlit = litf->num;
	   }
	 } else // UNIVERSAL 
	  {
       litscore = max(getLiteralCubeScore(litf->num), getLiteralCubeScore(litt->num));
	   if (litscore > bestscore
			 || (litscore==bestscore &&
				 score(num3cls(choosenlit), num3cls(negate(choosenlit)))
				 < score(num3cls(litf), num3cls(litt)))) {
			   bestscore = litscore;
			   
			   choosenlit = (numBcls(litt) < numBcls(litf) ? litt->num: litf->num);
	   }
	  }
	 }
   i++;
  } 
  //delete vecLits;
  return(choosenlit);
}


vector<int>* getSpecialExistentials() {


  int nActualLiteral;
  int nMaxLiteral              = getMaxLiteral();
  int nMaxUniversalPrefixLevel = -1;
  int nPrefixLevel;

  vector<int> * vecSpecialLiterals = new vector<int>;

  bool* bArrAddedToSpecial = new bool[nMaxLiteral + 1];
  for(int c = 0; c < nMaxLiteral; c++)
  {
    bArrAddedToSpecial[c] = false;
  }

  CLAUSELIST *cl;
  int i, j;
  int nCubeLiteral;
  Lit * lCubeLiteral;
  Lit * lCurrentDeepestLiteral = NULL;
  // First get all the NECCESSARY literals in the cube
  // Don't need to take care of the units, do we?
  for(i=1;i<CLSGROUPS;i++)
        for(cl=lenNclauses[i];cl;cl=cl->pnext) {
          //printf("Checking clause:\n");
          //printCLAUSELIST(cl);
		  bool bHasUniversal         = false;
          int  nCurrentLiteral       = NOLIT;
          for(j=0;j<cl->clslen;j++)
          {
			    if(bArrAddedToSpecial[eqlit(cl->cls[j])]){
					bHasUniversal = false;
					break;
				}					
				else if(isTrue(eqlit(cl->cls[j])))
                {
                 if(isLitExistential(cl->cls[j]))
				 {
					 bHasUniversal = false;
					 break;				 
				 }
				 else
				  bHasUniversal = true;
				}
				else if(!isInactive(eqlit(cl->cls[j]))) {
					if(isLitExistential(cl->cls[j])) {
					 if(nCurrentLiteral != NOLIT){
						if(getLitPrefixLevel(nCurrentLiteral) > getLitPrefixLevel(eqlit(cl->cls[j]))) {
                          nCurrentLiteral = eqlit(cl->cls[j]); 
						}
					 }
					 else
                      nCurrentLiteral = eqlit(cl->cls[j]);
					}
					else {
						bHasUniversal = true;
					}
				}
		  }
		  if((!bArrAddedToSpecial[nCurrentLiteral]) && bHasUniversal){
			vecSpecialLiterals->push_back(nCurrentLiteral);
			bArrAddedToSpecial[nCurrentLiteral] = true;
		  }
		}
 return vecSpecialLiterals;
}


int findNext7ObeyPL(int level, bool bFail) {
  // Propagate Existential Pures
  int nReturnLit = propagateExistentialPuresAsDecisions();
  if(nReturnLit != -1)
	  return nReturnLit;
  //Compute number of immediate binary clauses produced.
  int choosenlit = NOLIT;
  float bestscore = -1;
  float litscore;
  int bestlitscore = -1;
  Lit *litf, *litt;
  int n,p;

  float nMaxScore      = getNewMaxVarScore();
  //  int numties=0;
  //vector<int> * vecLits = getSpecialExistentials();
  //outputVectorCube(vecLits);
  //assert(false);
  // Horst
  bool bDone    = false;
  int nActivePrefixLevel  = -1;
  
  /*nReturnLit = propagateUniversalPures();
  if(nReturnLit != -1)
  {
	  printf("\n---> Pure Universal: %d ", nReturnLit);
	  return nReturnLit;
  }*/
  //nReturnLit = propagateUniversalPures(); 
  //if(nReturnLit != -1)
	//  return nReturnLit;
  bool bFirst = true;
  int i = 0;
  while((i < NVARS) && (!bDone)) {
    Lit *litf = intTolit(_arrLiteralsSortedByPrefixLevel[to_literal(i, false)]);	
    if (isInactive(litf))
	{
	  i++;
      continue;
	}
    if((choosenlit == NOLIT) && (getLitPrefixLevel(litf) > nActivePrefixLevel))
	{
	 nActivePrefixLevel = getLitPrefixLevel(litf);	
	 bFirst = true;
	}
	if((getLitPrefixLevel(litf) > nActivePrefixLevel) && (nActivePrefixLevel != -1))
	{
	  bDone = true;
	}
	else if((nActivePrefixLevel == -1) || (nActivePrefixLevel == getLitPrefixLevel(litf)))
    {
	  nActivePrefixLevel = getLitPrefixLevel(litf);
	  /*
	  vector<int>::iterator iterVec;
	  for(iterVec = vecLits->begin(); iterVec != vecLits->end(); ++iterVec)
	  {
        if(getLitPrefixLevel(*iterVec) == nActivePrefixLevel)
		{ 
			int nLit = *iterVec;
			delete vecLits;
			return nLit;
		}
	  }*/
	  litt = negate(litf);
	  /*if(isLitExistential(litf)) {
       int n2 = numBcls(litf);
	   int p2 = numBcls(litt);
	   int nn = numNcls(litf);
	   int pn = numNcls(litt);
	   if((n2+nn==1) && (p2+pn==1))
	   {
         i++;
 		 continue;
	   }
	  }*/
	   //Don't count the l\/-l clause.
		  if(numBcls(litf)+numNcls(litf)==1) {
		   pureReductions++;
		  if(isLitExistential(litf))
		   return(litt->num);      
		  else
		   return(litf->num);      
		 }

		if(numBcls(litt)+numBcls(litt)==1) {
		  pureReductions++; 
		  if(isLitExistential(litf))
		   return(litf->num);      
		  else
		   return(litt->num);      
		} 


      if(bFail)
	  {
	   if(bFirst)
	   {
        if(isLitExistential(litf)) 
		  bestscore = -1;
		else
          bestscore = -1;
		bFirst = false;
	   }
	  } else
	  {
       if(bFirst)
	   {
        if(isLitExistential(litf)) 
		  bestscore = 1000000;
		else
          bestscore = -1;
		bFirst = false;
	   }
	  }
	  if(isLitExistential(litt->num)) {
	  if(bFail) {

		    //************************************************************************** 
			/*BinLitCls* pb;
			sclauses->empty();

			n=0;
			for(pb=&(litt->twoClauses);pb->pnext;pb=pb->pnext) {
			  Lit *plit=pb->otherlit;
			  for(LitCls *pNclauses=plit->nClauses.pnext;
			  pNclauses->pnext;
			  pNclauses=pNclauses->pnext)
			//mark clause made true
			sclauses->pushnew(pNclauses->pcls->num);
			}
			for(pb=&(litt->twoClauses);pb->pnext;pb=pb->pnext) {
			  //get lit's negation which has become False.
			  Lit *plit=negate(pb->otherlit);
			  for(LitCls *pNclauses=plit->nClauses.pnext;
			  pNclauses->pnext;
			  pNclauses=pNclauses->pnext)
			if(pNclauses->pcls->len ==3 && !sclauses->member(pNclauses->pcls->num))
			  n++;
			}
			sclauses->empty();

			p=0;
			for(pb=&(litf->twoClauses);pb->pnext;pb=pb->pnext) {
			  Lit *plit=pb->otherlit;
			  for(LitCls *pNclauses=plit->nClauses.pnext;
			  pNclauses->pnext;
			  pNclauses=pNclauses->pnext)
			//mark clause made true
			sclauses->pushnew(pNclauses->pcls->num);
			}
			for(pb=&(litf->twoClauses);pb->pnext;pb=pb->pnext) {
			  //get lit's negation which has become False.
			  Lit *plit=negate(pb->otherlit);
			  for(LitCls *pNclauses=plit->nClauses.pnext;
			  pNclauses->pnext;
			  pNclauses=pNclauses->pnext)
			if(pNclauses->pcls->len ==3 && !sclauses->member(pNclauses->pcls->num))
			  p++;
			}
			sclauses->empty();

			litscore = max(n,p); */
		    int n2 = numBcls(litf);
	        int p2 = numBcls(litt);
		    //litscore = max(n2,p2);
            //**************************************************************************

            float nBinaryClauses = getNumberBcls() + bclsAdded;
			
            litscore = ((max(n2,p2) / nBinaryClauses) * 100) + ((getLiteralScore(litt->num) + getLiteralScore(litf->num)) / nMaxScore);
	    /*if(getLiteralScore(litt->num) + getLiteralScore(litf->num) == 0)
	      {
               litscore = 0;
	       }*/
	    //printf("\n B: %f BScore %f VScore: %f MaxScore %f", nBinaryClauses, (max(n2,p2) / nBinaryClauses) * 100, ((getLiteralScore(litt->num) + getLiteralScore(litf->num)) / nMaxScore), nMaxScore);
			if(litscore > bestscore) {
              bestscore = litscore;
			  if(getLiteralScore(litt->num) > getLiteralScore(litf->num))
               choosenlit = litt->num;
		      else
               choosenlit = litf->num;
			}
            /*
			if((litscore > bestscore) || ((litscore == bestscore) && 
				(getLiteralScore(litt->num) + getLiteralScore(litf->num)) > (getLiteralScore(choosenlit) + getLiteralScore(choosenlit)))) {
              bestscore = litscore;
			  if(getLiteralScore(litt->num) > getLiteralScore(litf->num))
               choosenlit = litt->num;
		      else
               choosenlit = litf->num;
			}*/
			/* if((getLiteralScore(litt->num) + getLiteralScore(litf->num)) > bestscore) {
		 bestscore = getLiteralScore(litt->num) + getLiteralScore(litf->num);
         if(getLiteralScore(litt->num) > getLiteralScore(litf->num))
          choosenlit = litt->num;
		 else
          choosenlit = litf->num;
	    }*/
        /* int n2 = numBcls(litf);
	        int p2 = numBcls(litt);
		    litscore = max(n2,p2); 
	     if(((getLiteralScore(litt->num) + getLiteralScore(litf->num)) > bestscore) || 
			 (((getLiteralScore(litt->num) + getLiteralScore(litf->num)) == bestscore) &&
			 (litscore > max(numBcls(choosenlit),numBcls(negate(choosenlit)))))) {
		      bestscore = getLiteralScore(litt->num) + getLiteralScore(litf->num);
             if(getLiteralScore(litt->num) > getLiteralScore(litf->num))
              choosenlit = litt->num;
		     else
              choosenlit = litf->num;
			  }*/
	    /*if(((getLiteralScore(litt->num) + getLiteralScore(litf->num)) > bestscore)
			|| ((getLiteralScore(litt->num) + getLiteralScore(litf->num) == bestscore) && (litscore > bestlitscore))) {
		 bestscore = getLiteralScore(litt->num) + getLiteralScore(litf->num);
		 bestlitscore = litscore;
         if(getLiteralScore(litt->num) > getLiteralScore(litf->num))
          choosenlit = litt->num;
		 else
          choosenlit = litf->num;
	    } */
	   }
	  else {
       if(isLitExistential(litt->num)) {
	    if((getLiteralScore(litt->num) + getLiteralScore(litf->num)) < bestscore) {
		 bestscore = getLiteralScore(litt->num) + getLiteralScore(litf->num);
         if(getLiteralScore(litt->num) < getLiteralScore(litf->num))
          choosenlit = litt->num;
		 else
          choosenlit = litf->num;
	     }
	    }
	   }
	  } else // UNIVERSAL 
	  {
       litscore = max(getLiteralCubeScore(litf->num), getLiteralCubeScore(litt->num));
	   if (litscore > bestscore
			 || (litscore==bestscore &&
				 score(num3cls(choosenlit), num3cls(negate(choosenlit)))
				 < score(num3cls(litf), num3cls(litt)))) {
			   bestscore = litscore;
			   
			   choosenlit = (numBcls(litt) < numBcls(litf) ? litt->num: litf->num);
	   }
	  }
	 }
   i++;
  } 
  //delete vecLits;
  return(choosenlit);
}

int findNext8ObeyPL(int level) {
  //compute number of immediate binary clauses produced.
  int nReturnLit = propagateExistentialPuresAsDecisions();
  if(nReturnLit != -1)
	  return nReturnLit;

  int choosenlit = NOLIT;
  int bestscore = 100000;
  int litscore;
  int cubescore = 0;
  int bestcubescore = -1;
  Lit *litf, *litt;
  int n,p;
  //  int numties=0;
 
  // Horst
  bool bDone    = false;
  int nActivePrefixLevel  = -1;
  //int nReturnLit = propagateExistentialPures();
  //if(nReturnLit != -1)
	//  return nReturnLit;
  /*nReturnLit = propagateUniversalPures();
  if(nReturnLit != -1)
  {
	  printf("\n---> Pure Universal: %d ", nReturnLit);
	  return nReturnLit;
  }*/
  //nReturnLit = propagateUniversalPures(); 
  //if(nReturnLit != -1)
	//  return nReturnLit;
  bool bFirst = true;
  int i = 0;
  while((i < NVARS) && (!bDone)) {
    Lit *litf = intTolit(_arrLiteralsSortedByPrefixLevel[to_literal(i, false)]);	
  
    if (isInactive(litf))
	{
	  i++;
      continue;
	}
    if((choosenlit == NOLIT) && (getLitPrefixLevel(litf) > nActivePrefixLevel))
	{
	 nActivePrefixLevel = getLitPrefixLevel(litf);	
	 bFirst = true;
	}
	if((getLitPrefixLevel(litf) > nActivePrefixLevel) && (nActivePrefixLevel != -1))
	{
	  bDone = true;
	}
	else if((nActivePrefixLevel == -1) || (nActivePrefixLevel == getLitPrefixLevel(litf)))
    {
	  nActivePrefixLevel = getLitPrefixLevel(litf);
      litt = negate(litf);
	  if(bFirst)
	  {
        if(isLitExistential(litf)) 
		  bestscore = 10000000;
		else
          bestscore = -1;
		bFirst = false;
	  } 
	  
		  //Don't count the l\/-l clause.
		  if(numBcls(litf)+numNcls(litf)==1) {
		   pureReductions++;
		  if(isLitExistential(litf))
		   return(litt->num);      
		  else
		   return(litf->num);      
		 }

		if(numBcls(litt)+numBcls(litt)==1) {
		  pureReductions++; 
		  if(isLitExistential(litf))
		   return(litf->num);      
		  else
		   return(litt->num);      
		}
	  
	if(isLitExistential(litf)){
		BinLitCls *pb;
		sclauses->empty();

		n=0;
		int n1 = 0;
		int n2 = 0;
		if(numBcls(litt)>1) {
		  for(pb=&(litt->twoClauses);pb->pnext;pb=pb->pnext) {
		  Lit *plit=pb->otherlit;
		  for(LitCls *pNclauses=plit->nClauses.pnext;
			pNclauses->pnext;
			pNclauses=pNclauses->pnext)
		    {
		   	 n1++;
		     sclauses->pushnew(pNclauses->pcls->num);
		    }
		  }
		  for(pb=&(litt->twoClauses);pb->pnext;pb=pb->pnext) {
		  Lit *plit=negate(pb->otherlit);
		  for(LitCls *pNclauses=plit->nClauses.pnext;
			pNclauses->pnext;
			pNclauses=pNclauses->pnext)
		  if(!sclauses->member(pNclauses->pcls->num))
			n2++;
		  }
		  sclauses->empty();
		  n = max(n1, n2);
		}
		else
		  n=num3cls(litt);

		p=0;
        int p1 = 0;
		int p2 = 0;
		if(numBcls(litf)>1) {
		  for(pb=&(litf->twoClauses);pb->pnext;pb=pb->pnext) {
		Lit *plit=pb->otherlit;
		for(LitCls *pNclauses=plit->nClauses.pnext;
			pNclauses->pnext;
			pNclauses=pNclauses->pnext)
		    {
			 p1++;
		     sclauses->pushnew(pNclauses->pcls->num);
		    }
		  }
		for(pb=&(litf->twoClauses);pb->pnext;pb=pb->pnext) {
		Lit *plit=negate(pb->otherlit);
		for(LitCls *pNclauses=plit->nClauses.pnext;
			pNclauses->pnext;
			pNclauses=pNclauses->pnext)
		  if(!sclauses->member(pNclauses->pcls->num))
			p2++;
		  }
		  sclauses->empty();
          p = max(p1, p2);
		}
		else
		  p=num3cls(litf);

		litscore = score(n,p);
		
			if (litscore < bestscore
			 || (litscore==bestscore &&
				 score(num3cls(choosenlit), num3cls(negate(choosenlit)))
				 < score(num3cls(litf), num3cls(litt)))) {
			   bestscore = litscore;
			   choosenlit = (numBcls(litt) < numBcls(litf) ? litt->num: litf->num);
			} 
	 
	}
	else
	{
      cubescore = max(getLiteralCubeScore(litf->num), getLiteralCubeScore(litt->num));
	  if(cubescore >= bestcubescore){
		  if(cubescore > bestcubescore) {
            choosenlit = (getLiteralCubeScore(litt->num) > getLiteralCubeScore(litf->num) ? litt->num: litf->num);			
		  }
		  else {
			  if((numBcls(litt) + numBcls(litf)) > (numBcls(choosenlit) + numBcls(negate(choosenlit)))){
				  choosenlit = (numBcls(litt) > numBcls(litf) ? litt->num: litf->num);				  
			  }
		  }
		bestcubescore = cubescore;
	  }
	  /*
	  if (litscore > bestscore
			 || (litscore==bestscore &&
				 score(num3cls(choosenlit), num3cls(negate(choosenlit)))
				 > score(num3cls(litf), num3cls(litt)))) {
			   bestscore = litscore;			   
			   choosenlit = (numBcls(litt) > numBcls(litf) ? litt->num: litf->num);
			   //printf("\n Set chosen Lit: %d ", choosenlit);
	 } */
	}
	}
	i++;
  }
  //if(choosenlit == NOLIT)
  //{
   /*i = 0;
   while(i < NVARS)
   {
    
    Lit *litf = intTolit(to_literal(i, false));
	Lit *litt = intTolit(to_literal(i, true));
    
	if(litf->val == U || litt->val == U)
	{
		printf("\n Literal %d (PL: %d) is active (? %d) !", litf->num, getLitPrefixLevel(litf->num), isActive(litf));
		//assert(false);
	}
	i++;
   }*/
  //}
  return(choosenlit);
}


int findNext9ObeyPL(int level) {
  //compute number of immediate binary clauses produced.
  int nReturnLit = propagateExistentialPuresAsDecisions();
  if(nReturnLit != -1)
	  return nReturnLit;

  int choosenlit = NOLIT;
  int bestscore = 100000;
  int cubescore = 0;
  int bestcubescore = -1;
  int litscore;
  Lit *litf, *litt;
  int n,p;
  //  int numties=0;
 
  // Horst
  bool bDone    = false;
  int nActivePrefixLevel  = -1;
  //int nReturnLit = propagateExistentialPures();
  //if(nReturnLit != -1)
	//  return nReturnLit;
  /*nReturnLit = propagateUniversalPures();
  if(nReturnLit != -1)
  {
	  printf("\n---> Pure Universal: %d ", nReturnLit);
	  return nReturnLit;
  }*/
  //nReturnLit = propagateUniversalPures(); 
  //if(nReturnLit != -1)
	//  return nReturnLit;
  bool bFirst = true;
  int i = 0;
  while((i < NVARS) && (!bDone)) {
    Lit *litf = intTolit(_arrLiteralsSortedByPrefixLevel[to_literal(i, false)]);	
  
    if (isInactive(litf))
	{
	  i++;
      continue;
	}
    if((choosenlit == NOLIT) && (getLitPrefixLevel(litf) > nActivePrefixLevel))
	{
	 nActivePrefixLevel = getLitPrefixLevel(litf);	
	 bFirst = true;
	}
	if((getLitPrefixLevel(litf) > nActivePrefixLevel) && (nActivePrefixLevel != -1))
	{
	  bDone = true;
	}
	else if((nActivePrefixLevel == -1) || (nActivePrefixLevel == getLitPrefixLevel(litf)))
    {
	  nActivePrefixLevel = getLitPrefixLevel(litf);
      litt = negate(litf);
	  if(bFirst)
	  {
        if(isLitExistential(litf)) 
		  bestscore = -1;
		else
          bestscore = -1;
		bFirst = false;
	  } 
	  
		  //Don't count the l\/-l clause.
		  if(numBcls(litf)+numNcls(litf)==1) {
		   pureReductions++;
		  if(isLitExistential(litf))
		   return(litt->num);      
		  else
		   return(litf->num);      
		 }

		if(numBcls(litt)+numBcls(litt)==1) {
		  pureReductions++; 
		  if(isLitExistential(litf))
		   return(litf->num);      
		  else
		   return(litt->num);      
		}
	  
	if(isLitExistential(litf)){
		BinLitCls *pb;
		sclauses->empty();

		n=0;
		int n1 = 0;
		int n2 = 0;
		if(numBcls(litt)>1) {
		  for(pb=&(litt->twoClauses);pb->pnext;pb=pb->pnext) {
		  Lit *plit=pb->otherlit;
		  for(LitCls *pNclauses=plit->nClauses.pnext;
			pNclauses->pnext;
			pNclauses=pNclauses->pnext)
		    {
		   	 n1++;
		     //sclauses->pushnew(pNclauses->pcls->num);
		    }
		  }
		  /*for(pb=&(litt->twoClauses);pb->pnext;pb=pb->pnext) {
		  Lit *plit=negate(pb->otherlit);
		  for(LitCls *pNclauses=plit->nClauses.pnext;
			pNclauses->pnext;
			pNclauses=pNclauses->pnext)
		  if(!sclauses->member(pNclauses->pcls->num))
			n2++;
		  }*/
		  //sclauses->empty();
		  n = n1;// max(n1, n2);
		}
		else
		  n=num3cls(litt);

		p=0;
        int p1 = 0;
		int p2 = 0;
		if(numBcls(litf)>1) {
		  for(pb=&(litf->twoClauses);pb->pnext;pb=pb->pnext) {
		Lit *plit=pb->otherlit;
		for(LitCls *pNclauses=plit->nClauses.pnext;
			pNclauses->pnext;
			pNclauses=pNclauses->pnext)
		    {
			 p1++;
		     //sclauses->pushnew(pNclauses->pcls->num);
		    }
		  }
		/*for(pb=&(litf->twoClauses);pb->pnext;pb=pb->pnext) {
		Lit *plit=negate(pb->otherlit);
		for(LitCls *pNclauses=plit->nClauses.pnext;
			pNclauses->pnext;
			pNclauses=pNclauses->pnext)
		  if(!sclauses->member(pNclauses->pcls->num))
			p2++;
		  }*/
		  //sclauses->empty();
          p = p1;//max(p1, p2);
		}
		else
		  p=num3cls(litf);

		litscore = max(n,p);
		
			if (litscore > bestscore
			 || (litscore==bestscore &&
				 score(num3cls(choosenlit), num3cls(negate(choosenlit)))
				 > score(num3cls(litf), num3cls(litt)))) {
			   bestscore = litscore;
			   choosenlit = (numBcls(litt) < numBcls(litf) ? litt->num: litf->num);
			} 
	 
	}
	else
	{
      cubescore = max(getLiteralCubeScore(litf->num), getLiteralCubeScore(litt->num));
	  if(cubescore >= bestcubescore){
		  if(cubescore > bestcubescore) {
            choosenlit = (getLiteralCubeScore(litt->num) > getLiteralCubeScore(litf->num) ? litt->num: litf->num);			
		  }
		  else {
			  if((numBcls(litt) + numBcls(litf)) > (numBcls(choosenlit) + numBcls(negate(choosenlit)))){
				  choosenlit = (numBcls(litt) > numBcls(litf) ? litt->num: litf->num);				  
			  }
		  }
		bestcubescore = cubescore;
	  } 
	}
	}
	i++;
  }
  //if(choosenlit == NOLIT)
  //{
   /*i = 0;
   while(i < NVARS)
   {
    
    Lit *litf = intTolit(to_literal(i, false));
	Lit *litt = intTolit(to_literal(i, true));
    
	if(litf->val == U || litt->val == U)
	{
		printf("\n Literal %d (PL: %d) is active (? %d) !", litf->num, getLitPrefixLevel(litf->num), isActive(litf));
		//assert(false);
	}
	i++;
   }*/
  //}
  return(choosenlit);
}
