/*

2clsQ. Copyright Horst Samulowitz and Fahiem Bacchus 2006

 A DPLL QBF solver based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to
implied warranties of merchantability and fitness for a particular
purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Fahiem Bacchus },
	year    = { 2006 },
	title   = { {2clsQ} a {DPLL} solver employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/

#include "2clsEq.h"
#include "undo.h"
#include "resolve.h"
#include "dag.h"
#include "nogood.h"
//#include "binaryClauses.h"
#include "solutions.h"
#include "nogoodDB.h"


/***********************************************************************
                                DPL
***********************************************************************/
/* DPL (Davis Putnam Longham) is the backtracking engine.

DPL calls findNext to choose the variable to value next.

We also configure DPL to count the leaves in the search tree. This
corresponds (I think) to Crawford's notion of branches (and other
notions of branches). Actually it is the only measure of the search
tree size that makes sense, as more than one variable can be valued
at a single node.

In particular, a leaf is a solution node or a node (a literal) that
experienced a direct contradiction and whose sibling (the negatation of
the literal) also experienced a direct contradiction.

*/
extern char* filename;
int LEVEL;
int forcedlits;
int forcedbcls;
int forcedlitsAdded;
int forcedbclsAdded;

int *dplLevelToLit;
bool *dpl2ndBranch;
class ForcedRec;
ForcedRec **dplForcesAtLevel;
ForcedRec **dplOldForcesAtLevel;

double time_out_val;
bool DPL_debug;
bool print_solutions;
int pcr;
bool DOCPB;
bool DOPPB;
bool DOLPB;

extern int *orig_varnum;

extern int nLastPrefixLevel;
extern int nAtLevel;

void inline addFinalForcedLiteral(int lt,int level, NoGood *ng);
void inline addForcedLiteral(int lt,int level, NoGood *ng);
void inline addForcedBcls(int lt,int x, int level, NoGood *ng);
void inline addFinalForcedBcls(int lt,int x, int level, NoGood *ng);
void inline emptyFatL(int level);
void DoPruneBacks(NoGood *ng, int lt, int btlevel);
void DoForces(int level);
void Success(int level);

bool bFail = false;

int DPL(int level) {
  int i;
  LEVEL=level; //give global access to current level.
  DPL_debug = false;
  if (DPL_debug)
    printf("==>Level %d\n",level);
  if (this_num_DPL>0 && (this_num_DPL % 256 == 0)) {
    if((GetInternalRunTime() - start_cpu_time) > (time_out_val)) {
      //Check for time out (more portable than setting up a system
      //interrupt).
      printf("c Timed Out. Fraction of Space explored: ");
      for(i=0;i<level;i++) {
	if(dpl2ndBranch[i])
	  printf("1/2^%d +", i);
      }
      timed_out = 1;
      return(0);
    }
  }
  if(this_num_DPL && pcr && this_num_DPL % pcr == 0) {
    printf("+%d/%d+",HIGHESTBTLEVEL,DEEPESTLEVEL);
    HIGHESTBTLEVEL=level;
    DEEPESTLEVEL=level;
    fflush(stdout);
  }

  //Find next choice point.
  int l;
  int btlevel;
  bool haveChoice=false;
  NoGood *ngfirst=NULL;
  NoGood *ngsecond=NULL;

  //if(getNumberOfNoGoods() % 10 == 0)
	//  bFail = false;
  //if(getNumberOfUniversalInActualCube() > 20)
	 // bFail = true;
  /*if((getNumberOfCubes() > 0) && (getNumberOfCubes() % 2 == 0)) {
	  printf(" XXXXXXXXXXXXXXXX Number of Cubes: %d Size: %d intsize %d ", getNumberOfCubes(), getSizeOfCubes(), sizeof(int));
	  removeLearnedCubes();
  }*/
  if(getSizeOfCubes() > 90000000){
	  printf(" XXXXXXXXXXXXXXXX Number of Cubes: %d Size: %d intsize %d ", getNumberOfCubes(), getSizeOfCubes(), sizeof(int));
	  removeLearnedCubes();
  }

  while(!haveChoice) {

    /*
		  //assert(false);
		CheckSolution(); 
		satisfyRemainingClauses();

		//vector<int> * vecTest = getSpecialExistentials();
		assert(false);
	  }*/
    // Horst: Changed to obey the ordering of the prefix
    if(bFail)
	  l = findNext7ObeyPL(level,bFail);//findNextPL();//(level);	
	else
	  l = findNext6ObeyPL(level);
	//printf(" %d ", bFail);
	//if(l!=NOLIT)
	//if((l == 16) || (l == 3) || (l==2))
	//if(l!=NOLIT)
	 //printf("\n XPropagating %d [%d](E?: %d, PL: %d) at level: %d ", to_ff(l), negate(l), isLitExistential(l), getLitPrefixLevel(l), level);
	 //some findnext functions discover forced literals/bcls. Propagate them.
    propagateStacks();
    //the propagate might force the selected literal.
    //So check if we are finished.
    if(haveContradiction() || l==NOLIT || isActive(l))
      haveChoice=true;
  }

  //Check for contradiction.
  if(haveContradiction()) {
    //assert(false);
	  //printf("\n XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX \n");
	 // printf("\n XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX \n");
	  //printf("\n XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX \n");
    
	//
    bFail = true;
	MRFailedLit=l;
    this_num_DPL_leaves++;
    if(!noGoodAtLevel[level])
      noGoodAtLevel[level]=allocNoGood(level);
	//noGoodAtLevel[level]->printLiterals(dplLevelToLit);
    noGoodAtLevel[level]->empty();
    noGoodAtLevel[level]->unionFromDAG(&CONTRADICTION.dagnode);
	//noGoodAtLevel[level]->printLiterals(dplLevelToLit);
    
	//for(int c=level; c>0; c--)
	//	printf("\n Literal %d (E?: %d, Pl: %d) at Level: %d ", dplLevelToLit[c], isLitExistential(dplLevelToLit[c]), getLitPrefixLevel(dplLevelToLit[c]), c);

	// ADDDED
    addNoGoodToDB(noGoodAtLevel[level],dplLevelToLit); 
	
	noGoodAtLevel[level]->cutTailingUniversals(dplLevelToLit);

    if(DPL_debug) {
      printf(" DPL found contradiction in findnext\n");
      printConflict(contradictionDAG());
      printf("\n");
      printf(" NoGood Computed\n");
      noGoodAtLevel[level]->print();
    }

    btlevel = noGoodAtLevel[level]->max();
    if(btlevel == 0)
    {
	   printf("\n XXXX UN-QSAT XXX \n");	   	   
	   this_num_solutions = 0;
    }

	if(!noGoodAtLevel[btlevel])
      noGoodAtLevel[btlevel]=allocNoGood(btlevel);

	if(!isLitExistential(dplLevelToLit[btlevel])) {
		noGoodAtLevel[level]->printLiterals(dplLevelToLit);
        noGoodAtLevel[btlevel]->printLiterals(dplLevelToLit);
	}
	assert(isLitExistential(dplLevelToLit[btlevel]));

    noGoodAtLevel[btlevel]->unionFromNoGood(noGoodAtLevel[level]);
    noGoodAtLevel[btlevel]->cutTailingUniversals(dplLevelToLit);

	if (DPL_debug) {
      printf("<==Level %d (to %d)\n", level, btlevel);
      printf(" NoGood at %d:            ", level);
      noGoodAtLevel[level]->print();
      printf(" NoGood set at btlevel %d ", btlevel);
	  //noGoodAtLevel[btlevel]->print();
    }
	if((DOCPB) && (isLitExistential(dplLevelToLit[level]))) {
      //DoPruneBacks takes a nogood for a value. Thus
      //we have to remove btlevel from it first
      noGoodAtLevel[level]->unsetbit(btlevel);
      DoPruneBacks(noGoodAtLevel[level],dplLevelToLit[btlevel],btlevel);
    }
    noGoodAtLevel[level]->empty();
    emptyFatL(level);

    emptyCubeInfo(level);

    if(btlevel<HIGHESTBTLEVEL)
      HIGHESTBTLEVEL=btlevel;

    return(btlevel);
  }

  if(l==NOLIT) {
    bFail = false;
    this_num_solutions = 1;
    this_num_DPL_leaves++;
    //CheckSolution();
     //printf("\n (0) SOLUTION BACKTRACKING @level %d ", level);
	 btlevel = computeCubeAndResolve();
     if(btlevel == 0){
       Success(level);	   
     }
     
	 //printf("\n (0) SOLUTION BACKTRACKING: Returning to: %d (Lit: %d EqLit: %d E?: %d) \n", btlevel, dplLevelToLit[btlevel], eqlit(dplLevelToLit[btlevel]), isLitExistential(dplLevelToLit[btlevel]));
	 if(!noGoodAtLevel[btlevel])
	 {	   	  
	   noGoodAtLevel[btlevel]=allocNoGood(btlevel);	   	   
	 }
	 else
	 {		 
		 //noGoodAtLevel[btlevel]->print();
		 //assert(false);
	 }
	 //assert(level < NVARS + 1);
	 // Horst: Added 30.11.
	 if((level < NVARS)){
	  if(noGoodAtLevel[level])
	  {      
	   noGoodAtLevel[level]->empty();	   
	  }
	 }

     if(ngfirst) deallocNoGood(ngfirst);
     if(ngsecond) deallocNoGood(ngsecond);
	 //undoRestore();
     // End
	 if(level < NVARS + 1){
     //emptyFatL(level);    
	  
	 emptyFatL(level);	 
	 }
     
	 // Empty the cube info at this level
	 emptyCubeInfo(level);

	 // Horst 30.11
	 if(level > NVARS + 1)
     {
      for(int i=0; i<level; i++)
       {
		   printf("\n Level: %d Literal %d (FF: %d) ", i,dplLevelToLit[i],to_ff(dplLevelToLit[i]));     
       }
	  assert(false);
     }
	 

     if(btlevel<HIGHESTBTLEVEL)
      HIGHESTBTLEVEL=btlevel;

	 return(btlevel);
   }
  


  if (level>DEEPESTLEVEL) DEEPESTLEVEL=level;

  if (DPL_debug)
	  printf("==>Level %d, lit %d  (E?: %d Pl: %d) [%d,%d/%d,%d].\n",level,l, isLitExistential(l), getLitPrefixLevel(l),
	   intTolit(l)->numBcls,intTolit(l)->numNcls,
	   intTolit(negate(l))->numBcls,intTolit(negate(l))->numNcls);

  this_num_DPL++;
  dpl2ndBranch[level] = false;
  dplLevelToLit[level]=l;
  markundoCheckPoint();
  //if(!isLitExistential(l))
  //if((l== 166) || (l==167))
   //printf("\n 1st Value: propagating: %d at level %d ", l, level);
  //printf(" HERE propagating: %d ", l);
  pushupstack(l,allocDAGNODE_CHOICE(l,level));
  propagateStacks();
  bool firstValueFailed = haveContradiction();

  //Lit* lTemp = intTolit(l);
  //lTemp->assignLevel = level;
  //lTemp->val=T;
  
  // TRIGGER CUBES ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
  long nCubeOffset;
  bool bCubeTriggered = false;
  if(!firstValueFailed) {
     nCubeOffset = checkCubesOfLiteral(l);   
	  if(nCubeOffset != 0){	
       setCubeInfo(level, nCubeOffset);
       bFail = false;
	   //assert(isCubeTrue(nCubeOffset));
	   //assert(getCubeInfo2(level) == 0);
	   //if(btlevel == 12)
	   //printf("\n (1. TRIGGERED CUBE) @level: %d (Lit: %d, E: %d) with Cube Offset: %d \n", level, dplLevelToLit[level], isLitExistential(dplLevelToLit[level]), nCubeOffset); 
	   //outputCube(nCubeOffset); 
	   bCubeTriggered = true;  
	   incNrCubesTriggered();
		//assert(false);
	  } 
  } 
  // Restore Values
  //lTemp->assignLevel = 0;
  //lTemp->val=U;
   
  // **************************************************************
  
  
  if(!bCubeTriggered)
  {   	  
	  if (firstValueFailed) {
		ngfirst=allocNoGood(level);
		ngfirst->unionFromDAG(&CONTRADICTION.dagnode);
		// Horst: Cut tailing universal to prevent backtracking to an universal level!!!
		ngfirst->cutTailingUniversals(dplLevelToLit);
		// Horst:END
		if(DPL_debug) {
		  printf("   1st contradiction at level %d\n",level);
		  ngfirst->print();
		  ngfirst->printLiterals(dplLevelToLit);
		  //assert(false);
		}
	  }
	  else {   //recurse
		if (DPL_debug)
		  printf("   DPL Finished propagating first value.\n");
		btlevel = DPL(level + 1);
		if(btlevel<level) {
		  DPL_branches_saved++;
		  //next two statements should in fact be unnecessary.
	      
		   //printf("\n Empty NoGood at Level %d (Literal : %d)", level, dplLevelToLit[level]);
		   //fflush(stdout);
		  
		  if(level < NVARS){
		  if(noGoodAtLevel[level]) 
		  {
		   //printf("\n Empty NoGood at Level %d (Literal : %d)", level, dplLevelToLit[level]);
		   noGoodAtLevel[level]->empty();
		  }	 
		  
		  //if(level < NVARS + 1)
		   emptyFatL(level);
		  
		  if(DPL_debug)
		   printf("<++Level %d direct to %d (BRANCHES SAVED) [Lit: %d E?: %d ]\n", level, btlevel, dplLevelToLit[level], isLitExistential(dplLevelToLit[level]));
		  //undoRestore();

		  //emptyCubeInfo(level);
		  }
		  // Empty the cube info at this level
	      emptyCubeInfo(level);
		  // BE CAREFUL!!!!
		  if((level < NVARS + 1))
			  undoRestore();
		  return(btlevel);
		}
	   }
  }
  //else
   //assert(!firstValueFailed);
  // Restore the value
 // bCubeTriggered = false;
  //reset global since we are back at level;
  LEVEL=level;
  bool secondValueFailed;
  
  if((firstValueFailed) && (!isLitExistential(l)))
  {
	  secondValueFailed = true;
	  emptyCubeInfo(level);
	  bFail = true;
	  //printf("\n !!! Fail on the second side of the universal because first side faile HERE !!! ");
  }
  else
  {
   //completed recursion now unwind and try second value if necessary.
   undoRestore();
  
	  if (DPL_debug)
		printf("   DPL About to propagate 2nd branch lit %d at level %d (E? %d).\n",
		   negate(l),level, isLitExistential(l));

	  this_num_DPL++;
	  dpl2ndBranch[level] = true;
	  dplLevelToLit[level]=negate(l);

	  markundoCheckPoint(); //Check point
	 // if((l== 166) || (l==167))
      // printf("\n 2nd Value: propagating: %d at level %d ", l, level);
	  pushupstack(negate(l),allocDAGNODE_CHOICE(negate(l),level));
	  //should in fact only have forces to do if we had recursed.
	  //i.e., if ngfirst is empty.
	  DoForces(level);
	  propagateStacks();

	  secondValueFailed = haveContradiction();
	  
      // TRIGGER CUBES ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	   bCubeTriggered = false;
	  if((!secondValueFailed) && (!firstValueFailed)){
          nCubeOffset = checkCubesOfLiteral(negate(l));   
		  if(nCubeOffset != 0){
		   //assert(!isLitExistential(l));
		   //assert(isCubeTrue(nCubeOffset));
		   bFail = false;
		   //assert(getCubeInfo1(level) != 0);
		   setCubeInfo(level, nCubeOffset);
		   //printf("\n TRIGGER CUBE when propagating: %d at level %d (E?: %d) ", negate(l), level, isLitExistential(l));
		   //outputCube(getCubeInfo1(level));
		   //outputCube(getCubeInfo2(level));
		   //assert(getCubeInfo2(level) != 0);
		   //assert(isCubeTrue(nCubeOffset));
		   incNrCubesTriggered();
		   //printf("\n TRIGGER CUBE when propagating: %d at level %d (E?: %d) ", negate(l), level, isLitExistential(l));
		   
		   bCubeTriggered = true;
		   //printf("\n Nogood before at Level %d: ", btlevel);		
		   btlevel = resolveCubes(level);
		   
		   //printf("\n (From triggered Cube) SOLUTION BACKTRACKING: Returning to: %d (Lit: %d, E: %d) Current Level: %d \n", btlevel, dplLevelToLit[btlevel], isLitExistential(dplLevelToLit[btlevel]), level); 
		   
		   if(btlevel == 0)
		   {
		     Success(level);
		   } 
	        
			assert(!isLitExistential(dplLevelToLit[btlevel])); 
			
			//addCubeFromNogood(noGoodAtLevel[btlevel], dplLevelToLit[btlevel], dplLevelToLit);
	        if(level < NVARS) {
				if(noGoodAtLevel[level])
				 noGoodAtLevel[level]->empty();
				if(ngfirst) deallocNoGood(ngfirst);
				if(ngsecond) deallocNoGood(ngsecond);
				emptyFatL(level);
			}
			if(level < (NVARS + 1))
			 undoRestore();

			if(btlevel<HIGHESTBTLEVEL)
			 HIGHESTBTLEVEL=btlevel;
             
			emptyCubeInfo(level);

			return(btlevel);
		  }
	  } 
      // END: TRIGGER CUBES **************************************************************

      assert(!bCubeTriggered);

	   	  
		  if (secondValueFailed) {
			ngsecond=allocNoGood(level);
			ngsecond->unionFromDAG(contradictionDAG());
			//ngsecond->printLiterals(dplLevelToLit);
			// Horst: Cut tailing universal to prevent backtracking to an universal level!!!
			ngsecond->cutTailingUniversals(dplLevelToLit);
			// Horst:END
			if(DPL_debug) {
			  printf("   2nd contradiction at level %d\n",level);
			  ngsecond->print();
			  ngsecond->printLiterals(dplLevelToLit);
			}
			bFail = false;
		  }
		  else { //recurse
			if(DPL_debug)
			  printf("   DPL Finished propagating second value.\n");
			btlevel = DPL(level + 1);
			if(btlevel<level) {
			  DPL_branches_saved++;
			  //printf("<++Level %d direct to %d (BRANCHES SAVED 2) [Lit: %d E?: %d ] \n", level, btlevel, dplLevelToLit[level], isLitExistential(dplLevelToLit[level]));

			  if((DOPPB)) {
	          
			  if(isLitExistential(dplLevelToLit[btlevel]) && isLitExistential(dplLevelToLit[level])) 
			  {
			   /*for(int j=0; j<level; j++)
			   {
				   printf("\n Level: %d Literal: %d (E?: %d) ", j, dplLevelToLit[j], isLitExistential(dplLevelToLit[j]));
			   }
			   printf("\n !!!!! (BTLevel: %d) Here DOPPB at level %d (Literal at BTlevel: %d (E? %d), Literal at Level: %d (E? %d))", btlevel, level, dplLevelToLit[btlevel], isLitExistential(dplLevelToLit[btlevel]), dplLevelToLit[level], isLitExistential(dplLevelToLit[level]));
			     */ 
			   if(!noGoodAtLevel[level])
				noGoodAtLevel[level]=allocNoGood(level);
			   if(ngfirst)
			   {
				noGoodAtLevel[level]->unionFromNoGood(ngfirst);
				//ngfirst->printLiterals(dplLevelToLit);
				//noGoodAtLevel[level]->cutTailingUniversals(dplLevelToLit);
			   }
				//noGoodAtLevel[level]->printLiterals(dplLevelToLit);
				DoPruneBacks(noGoodAtLevel[level],l,btlevel+1);
			   }			 
			 } 
			 if(ngfirst)
			  deallocNoGood(ngfirst);

			 if(level < NVARS) {
			  if(noGoodAtLevel[level])
			   noGoodAtLevel[level]->empty();
			  emptyFatL(level);
			 
			  if(DPL_debug)
			   printf("<==Level %d (to %d)\n", level,btlevel);
			  //emptyCubeInfo(level);
			  
			 }
			 // Empty the cube info at this level
	         emptyCubeInfo(level);
			 if((level < NVARS + 1))
			  undoRestore();
			
			 return(btlevel);
			}
		  }

		  if (firstValueFailed && secondValueFailed) {
			this_num_DPL_leaves++;
			MRFailedLit=l;
		  }	  
  LEVEL=level;
  }
  //if first or second value recursed, and returned to this level.
  //i.e., the recursive call did not backjump above this level.
  //then noGoodAtLevel would have been set. However, we still need
  //to union in ngfirst and ngsecond, if they are non-null.
  //note we did not recurse on either side, noGoodAtLevel[level]
  //will be null.

  if(!noGoodAtLevel[level])
    noGoodAtLevel[level]=allocNoGood(level);
  
 
  // Based on the literal type of the current level, we have to compute different bt levels
  // If it is a universal we can cut tailing existentials and vice versa
  if((isLitExistential(dplLevelToLit[level])) || (secondValueFailed) || (firstValueFailed))
  {
   // We fail !
   bFail = true;
   // Get rid of all cube information at this level
   emptyCubeInfo(level);
   
   // CHANGED!!!!! (was before the if)
   if(ngfirst)
    noGoodAtLevel[level]->unionFromNoGood(ngfirst);
   if(ngsecond)
    noGoodAtLevel[level]->unionFromNoGood(ngsecond);
   // ADDDED
   addNoGoodToDB(noGoodAtLevel[level],dplLevelToLit); 
   //noGoodAtLevel[level]->cutTailingUniversals(dplLevelToLit);
   btlevel = noGoodAtLevel[level]->maxAndExistential(dplLevelToLit);
   //noGoodAtLevel[level]->printLiterals(dplLevelToLit);
   
   if(btlevel != 0)
   {
	//printf("\n (*) CONFLICT BACKTRACKING: Returning to: %d (lit: %d E?: %d) at level %d with Literal %d (E?: %d) \n", btlevel, dplLevelToLit[btlevel], isLitExistential(dplLevelToLit[btlevel]), level, dplLevelToLit[level],isLitExistential(dplLevelToLit[level]));
    assert(isLitExistential(dplLevelToLit[btlevel])); 
	//noGoodAtLevel[level]->printLiterals(dplLevelToLit);
	//printf("\n Literal at Level: %d ", dplLevelToLit[level]);
	
	//assert(false);
   }
   if (DPL_debug) {
      printf("<==Level %d (to %d)\n", level, btlevel);
      printf(" NoGood at %d:            ", level);
      noGoodAtLevel[level]->print();
      printf(" NoGood set at btlevel %d ", btlevel);
      //noGoodAtLevel[btlevel]->print();
    }
   if(btlevel == 0)
   {
	   printf("\n XXXX UN-QSAT XXX \n");	   	   
	   this_num_solutions = 0;
   }
	if(!noGoodAtLevel[btlevel])
	 noGoodAtLevel[btlevel]=allocNoGood(btlevel);
	if(btlevel != 0)
     assert(isLitExistential(dplLevelToLit[btlevel])); 
	noGoodAtLevel[btlevel]->unionFromNoGood(noGoodAtLevel[level]);
	noGoodAtLevel[btlevel]->cutTailingUniversals(dplLevelToLit);
	//now we have three no-goods to work with.

	  if (DPL_debug) {
		printf("<==Level %d (to %d)\n", level, btlevel);
		printf(" NoGood at %d:            ", level);
		noGoodAtLevel[level]->print();
		printf(" NoGood set at btlevel %d ", btlevel);
		//noGoodAtLevel[btlevel]->print();
	  }


	  //1. the new nogood passed back to btlevel.
	  //   use this to prune back the assignment at btlevel.
	  if((DOCPB) && (isLitExistential(dplLevelToLit[level]))) {
		//DoPruneBacks takes a nogood for a value. Thus
		//we have to remove btlevel from it first
		
		noGoodAtLevel[level]->unsetbit(btlevel);
		DoPruneBacks(noGoodAtLevel[level],dplLevelToLit[btlevel],btlevel);
		//
		//2. ngfirst if it exists. It might allow a pruning of l (the lit
		//   on the first branch) to levels above btlevel. Note that
		//   when pruning back the lit at btlevel, we can start by looking
		//   at elements of the nogood less than btlevel, since btlevel
		//   is the max.
		//   However, for ngfirst or ngsecond, the current level is the max.
		//   Hack---we are about to backtrack to btlevel. There is no point
		//   in pruning l or notl to levels between btlevel and level.
		//   so pass doprunebacks btlevel+1 to make it start looking for
		//   a prune back from btlevel and up.

		if(ngfirst)
		  DoPruneBacks(ngfirst,l,btlevel+1);

		//3. similarly with ngsecond
		if(ngsecond)
		  DoPruneBacks(ngsecond,negate(l),btlevel+1);
	  }
  }
  else{
   // We can never get here with solution backtracking since
   // we do cube resolution
   assert(false);
  }
  
  //Note that if either of these do not exist, then the prune back of
  //l or negate l would have been accomplished by some recursive level
  //below for which case 1 corresponds to a prune back of l or negate(l).

  noGoodAtLevel[level]->empty();
  if(ngfirst) deallocNoGood(ngfirst);
  if(ngsecond) deallocNoGood(ngsecond);

  emptyFatL(level);
  undoRestore();

  if(btlevel<HIGHESTBTLEVEL)
    HIGHESTBTLEVEL=btlevel;
  
  emptyCubeInfo(level);

  return(btlevel);
}



void DoPruneBacks(NoGood *ng, int lt, int btlevel) {
  //ng is a value no-good for literal lt. ng is stored as a bit vector
  //in terms levels---the set of assignments at those levels implies
  //that lt cannot hold. We want to compute prunebacks that hold above
  //btlevel
  int i;
  bool pbpossible;
  bool first;
  int notlt=negate(lt);
 

  pbpossible=false;
  int max=ng->max();
   //1. Check if a literal prune back is possible
  //printf("=>DoPruneBacks(,%d [E: %d],%d)\n",lt,isLitExistential(lt), max);
   // printf("  Nogood:\n");
  //ng->print();
  for(i=max+1;i<btlevel;i++)
    if(!dpl2ndBranch[i]) {
      pbpossible=true;
      break;
    }

  if(pbpossible) {
    first=true;
    //1. Create the nogood
    //   note the nogood must store the index max
    //   so it must be of size nextmax+1.
    NoGood *reducedng=allocNoGood(max+1);
    reducedng->copyNoGood(ng);
    //printf(" DoPruneBack: reducedng:\n");
    //reducedng->print();
    //2. put it on the literal force list for every level
    //   that still has another branch to go.
    for(i=max+1;i<btlevel;i++) {
		if((!dpl2ndBranch[i]) && isLitExistential(dplLevelToLit[i])) {
	forcedlitsAdded++;
	//printf("DoPruneBack: forcing lit %d [E: %d] at level %d.\n",
		//   notlt,isLitExistential(notlt), i);
	if(first) {
	  //3. the highest forced literal must deallocate
	  //   the nogood.
	  addFinalForcedLiteral(notlt,i,reducedng);
	  first=false;
	}
	else
	  addForcedLiteral(notlt,i,reducedng);
      }
    }
  }

  //now look for a binary clause prune back.
  pbpossible=false;
  int nextmax=ng->maxfrom(max);
  for(i=nextmax+1;i<max;i++)
    if(!dpl2ndBranch[i]) {
      pbpossible=true;
      break;
    }

  if(pbpossible) {
    first=true;
    NoGood *reducedng=allocNoGood(nextmax+1);
    reducedng->copyNoGood(ng);
    //Find the other lit that forms the binary clause
    int notx=negate(dplLevelToLit[max]);
    for(i=nextmax+1;i<max;i++) {
		if((!dpl2ndBranch[i]) && isLitExistential(dplLevelToLit[i])) {
	forcedbclsAdded++;
	//printf("DoPruneBack: forcing binary clause (%d,%d) at level %d.\n",
	 //    notlt, notx, i);
	if(first) {
	  addFinalForcedBcls(notlt,notx,i,reducedng);
	  first=false;
	}
	else
	  addForcedBcls(notlt,notx,i,reducedng);
      }
    }
  }

}

class ForcedRec {
  //structure to hold the information about a forced lit or forced bcls.
public:
  int lit1;
  int lit2;
  bool deallocNG;
  //built in space for the DagNode. We can't allocate the Dagnode
  //from allocDAGNODE, as these node are automatically reclaimed
  //on backtrack. We are going to store the forced record at a level the
  //current level.
  DAG Dagnode;
  ForcedRec *pnext;
  ForcedRec() {    
    Dagnode.type=NOGOOD;
    Dagnode.pnext=NULL;
    Dagnode.one=NULL;
    Dagnode.two=NULL;
    deallocNG=false;
  };
};

ForcedRec *pFRalloc;
const int FORCEDRECALLOCFACTOR=200;

void MakeForcedRecStore() {
  ForcedRec *pfr = new ForcedRec[FORCEDRECALLOCFACTOR];
  if(!pfr)
	panic("Memory Allocation Failure #13\n");
  pFRalloc = pfr;
  //now link the new array.
  for(int i=0;i<FORCEDRECALLOCFACTOR;i++) {
    pfr->pnext=pfr+1;
    pfr++;
  }
  //fix the last pointer
  (--pfr)->pnext=NULL;
}

inline ForcedRec* allocForcedRec() {
  //allocate a new no good that can store levels sz bits inclusive.
  //allocate a new bcls record
  if(!pFRalloc)
    MakeForcedRecStore();
  ForcedRec *pfr = pFRalloc;
  pFRalloc=pfr->pnext;
  return(pfr);
}

inline void deallocForcedRec(ForcedRec *pfr) {
  //deallocate it.
  pfr->pnext = pFRalloc;
  pFRalloc = pfr;
}

inline bool FatLIsEmpty(int level) {
  return(dplForcesAtLevel[level]==NULL);
}

inline void pushFatL(ForcedRec *fr, int level) {
  fr->pnext=dplForcesAtLevel[level];
  dplForcesAtLevel[level]=fr;
}

inline ForcedRec *popFatL(int level) {
  ForcedRec *fr=dplForcesAtLevel[level];
  dplForcesAtLevel[level]=fr->pnext;
  return(fr);
}

inline bool OldFatLIsEmpty(int level) {
  return(dplOldForcesAtLevel[level]==NULL);
}

inline void pushOldFatL(ForcedRec *fr, int level) {
  fr->pnext=dplOldForcesAtLevel[level];
  dplOldForcesAtLevel[level]=fr;
}

inline ForcedRec *popOldFatL(int level) {
  ForcedRec *fr=dplOldForcesAtLevel[level];
  dplOldForcesAtLevel[level]=fr->pnext;
  return(fr);
}

inline void emptyFatL(int level) {
  while(!FatLIsEmpty(level))
    deallocForcedRec(popFatL(level));
  while(!OldFatLIsEmpty(level)) {
    ForcedRec *fr=popOldFatL(level);
    if(fr->deallocNG)
      deallocNoGood((NoGood *) fr->Dagnode.one);
    deallocForcedRec(fr);
  }
}

inline void addFinalForcedLiteral(int lt,int level, NoGood *ng) {
  //put lt on the force list at level with a special designation that
  //when this lt is forced we should reclaim ng.
  ForcedRec *fr=allocForcedRec();
  fr->Dagnode.one=(DAG *) ng;
  fr->deallocNG=true;
  fr->lit1=lt;
  fr->lit2=NOLIT;
  pushFatL(fr,level);
}

inline void addForcedLiteral(int lt,int level, NoGood *ng) {
  //identical but set deallocNG to false.
  ForcedRec *fr=allocForcedRec();
  fr->Dagnode.one=(DAG *) ng;
  fr->deallocNG=false;
  fr->lit1=lt;
  fr->lit2=NOLIT;
  pushFatL(fr,level);
}

inline void addFinalForcedBcls(int lt, int x, int level, NoGood *ng) {
  //put lt on the force list at level with a special designation that
  //when this lt is forced we should reclaim ng.
  ForcedRec *fr=allocForcedRec();
  fr->Dagnode.one=(DAG *) ng;
  fr->deallocNG=true;
  fr->lit1=lt;
  fr->lit2=x;
  pushFatL(fr,level);
}

inline void addForcedBcls(int lt,int x, int level, NoGood *ng) {
  //identical but set deallocNG to false.
  ForcedRec *fr=allocForcedRec();
  fr->Dagnode.one=(DAG *) ng;
  fr->deallocNG=false;
  fr->lit1=lt;
  fr->lit2=x;
  pushFatL(fr,level);
}

void DoForces(int level) {
  //process all of the forced bcls and lits
  //Note that we cannot deallocate the ForcedRec's once we force them.
  //...they have data that is required by the search below.
  //Instead we must clear the dplForcesAtLevel and move all of the
  //records over dplOldForcesAtLevel.
  //When we backtrack from this level we can deallocate both the
  //old and the unused new ForcedRecs.
	
  while(!FatLIsEmpty(level)) {
    ForcedRec *fr=popFatL(level);
    if(fr->lit2==NOLIT) {
      if(!isTrue(fr->lit1)) {
		forcedlits++;
		//printf("DoForces: At Level %d, forcing lit %d\n", level, to_ff(fr->lit1));
		//printf("Nogood:\n");
		//((NoGood *) fr->Dagnode.one)->print();
		pushupstack(fr->lit1,&(fr->Dagnode));
		//assert(false);
      }
    }
    else {
      if(!haveBclause(fr->lit1,fr->lit2)) {
	pushbclsstack(fr->lit1,fr->lit2,&(fr->Dagnode));
	forcedbcls++;
	//assert(false);
	//printf("DoForces: At Level %d, forcing bcls (%d,%d)\n", level,
	  //   to_ff(fr->lit1), to_ff(fr->lit2));
      }
    }
    pushOldFatL(fr,level);
  }
}

void initDPL() {
  dplLevelToLit = new int[(NACTIVELITS + 2)/2];
  dpl2ndBranch = new bool[(NACTIVELITS + 2)/2];
  dplForcesAtLevel = new (ForcedRec *[(NACTIVELITS + 2)/2]);
  dplOldForcesAtLevel = new (ForcedRec *[(NACTIVELITS + 2)/2]);

  if(!dplLevelToLit || !dpl2ndBranch || !dplForcesAtLevel
	 || !dplOldForcesAtLevel)
	panic("Memory Allocation Failure #14\n");

  for(int i=0;i<(NACTIVELITS + 2)/2;i++) {
    dplLevelToLit[i] = NOLIT;
    dpl2ndBranch[i] = false;
    dplForcesAtLevel[i] = NULL;
    dplOldForcesAtLevel[i] = NULL;
  }
  forcedlits=0;
  forcedbcls=0;
  forcedlitsAdded=0;
  forcedbclsAdded=0;
  pFRalloc=NULL;
}


// Horst:
void Success(int level){

       printf("\n XXXX QSAT XXX \n");	   
	   this_num_solutions = 1;
	   for(int i=0;i<level;i++) {
       if(dpl2ndBranch[i])
		printf("1/2^%d +", i);
       }
		printf("\n");
		printProblemStats(filename);
		printf("s SATISFIABLE\n");

		if (print_solutions) {
		  printf("v ");
		  for(int i = 0; i < NLITS; i++)
		if(isTrue(eqlit(i)))
		  printf("%d ", to_ff(orig_varnum[variable_of(i)], truth_of(i)));

		  printf("0\n");
		  //	printf("Var[%d]=%c (==Var[%d]) at Level %d\n",to_ff(i),
		  //	   ff_tval(val(eqlit(i))),to_ff(eqlit(i)),
		  //	   intTolit(eqlit(i))->assignLevel);
		}
		//return(true); 
        FILE * pFile;
        pFile = fopen ("result3","wt");
        if (pFile!=NULL)
        {       
         fputs("SAT",pFile);
        }
        fclose (pFile);
		exit(10);
}
