/*

2clsQ. Copyright Horst Samulowitz and Fahiem Bacchus 2006

 A DPLL QBF solver based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to
implied warranties of merchantability and fitness for a particular
purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Fahiem Bacchus },
	year    = { 2006 },
	title   = { {2clsQ} a {DPLL} solver employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/

#ifndef __dag_H
#define __dag_H
#include "uniqueset.h"
#include "nogood.h"

enum DAGtype {NORMAL, CHOICE, TRUE, PURE, NOGOOD};

class DAG {
public:
  DAGtype type;
  bool visited;
  //  int number;
  DAG *one;
  DAG *two;
  DAG *pnext;
  DAG() {
	type=NORMAL;
	visited=false;
	one=NULL;
	two=NULL;
	pnext=NULL;
  };
  DAG(DAGtype t) {
	type=t;
	visited=false;
	one=NULL;
	two=NULL;
	pnext=NULL;
  };
};

class Contradiction {
public:
  bool val;
  DAG dagnode;
  Contradiction() {
    val=false;
  };
};

extern Contradiction CONTRADICTION;

inline void setContradiction(DAG* d1, DAG* d2) {
    CONTRADICTION.val=true;
    CONTRADICTION.dagnode.one=d1;
    CONTRADICTION.dagnode.two=d2;
}

inline bool haveContradiction() {
  return(CONTRADICTION.val);
};

inline DAG* contradictionDAG() {
  return(&CONTRADICTION.dagnode);
}

void GrowDAGStack();
extern DAG *topDAGStack;
//extern dagNumber;

inline DAG* getDAGNode() {
  DAG* dnode=topDAGStack;
  if(!topDAGStack->pnext)
	GrowDAGStack();
  topDAGStack=topDAGStack->pnext;
  //  dnode->number=dagNumber;
  //  dagNumber++;
  return(dnode);
}



inline DAG *allocDAGNODE_NORMAL(DAG* d1, DAG* d2) {
  //Allocate a new dag node.
  if(d1==&dagTrue)
	return(d2);
  else if(d2==&dagTrue)
	return(d1);
  else if (d1==d2)
  {
    //printf("they are both equal!");  
	//assert(false);
	return(d1);
  }

  DAG *dnode=getDAGNode();
  dnode->type=NORMAL;
  dnode->visited=false;
  //  dnode->number=dagNumber;
  //  if(d1==NULL || d2==NULL)
  //	panic("DAGNODE_NORMAL called with some null dag nodes.\n");
  dnode->one=d1;
  dnode->two=d2;

  //  if(d1->type==PURE || d2->type==PURE)
  //	printf("Pure node forcing somthing!\n");
  //  if(d1->number>dnode->number || d2->number>dnode->number)
  //	printf("dag node don't always point backwards.\n");

  //  if(d1->type!=dnode->one->type 
  //	 || d2->type != dnode->two->type)
  //	printf("!!");
  return(dnode);
}

inline DAG *allocDAGNODE_CHOICE(int l, int level) {
  DAG *dnode=getDAGNode();
  dnode->type=CHOICE;
  dnode->visited=false;
  //  dnode->number=dagNumber;
  dnode->one= (DAG*) l;
  dnode->two= (DAG*) level;
  return(dnode);
}

inline DAG *allocDAGNODE_PURE(int l) {
  DAG *dnode=getDAGNode();
  dnode->type=PURE;
  dnode->visited=false;
  //  dnode->number=dagNumber;
  dnode->one= (DAG*) l;
  dnode->two= NULL;
  return(dnode);
}

//void SearchDAG(DAG *dnode, NoGood *ng);
void printConflict(DAG *dnode);
#endif /* __dag_H */
