/*

2clsQ. Copyright Horst Samulowitz and Fahiem Bacchus 2006

 A DPLL QBF solver based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to
implied warranties of merchantability and fitness for a particular
purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Fahiem Bacchus },
	year    = { 2006 },
	title   = { {2clsQ} a {DPLL} solver employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/


#include "dag.h"
#include <memory.h>
#include "nogood.h"

//stack of marks for the depth-first search.

Contradiction CONTRADICTION;

int DAGALLOCFACTOR=32;

DAG DAGStack(TRUE);

DAG dagTrue(TRUE);

DAG *topDAGStack=&DAGStack;

//int dagNumber;

void GrowDAGStack() {
  DAG *tmp = new DAG[DAGALLOCFACTOR*NLITS];
  if(!tmp)
    panic("Memory Allocation Failure #7\n");
  DAG *d=tmp;
  for(int i=0;i<DAGALLOCFACTOR*NLITS;i++) {
	d->pnext=d+1;
	d++;
  }
  (--d)->pnext=NULL;
  topDAGStack->pnext=tmp;
  DAGALLOCFACTOR = 2*DAGALLOCFACTOR;
}

DAG **markStack;
int topMarkStack=0;
int markStackSize=0;
int MARKALLOCFACTOR=4;

void GrowMarkStack() {
  if(markStackSize==0) {
	markStackSize=NLITS*MARKALLOCFACTOR;
	markStack=new (DAG * [markStackSize]);
	if(!markStack)
	  panic("Memory Allocation Failure #8\n");
  }
  else {
	DAG **tmp = new (DAG *[markStackSize*2]);
	if(!tmp)
	  panic("Memory Allocation Failure #9\n");
	memcpy(tmp,markStack,markStackSize*sizeof(DAG *));
	delete[] markStack;
	markStack=tmp;
	markStackSize=markStackSize*2;
  }
}

inline void pushMark(DAG *dagnode) {
  if(topMarkStack==markStackSize)
	GrowMarkStack();
  markStack[topMarkStack++]=dagnode;
}

inline DAG* popMark() {
  return markStack[--topMarkStack];
}

inline bool emptyMark() {
  return(topMarkStack==0);
}

DAG **DFSStack;
int topDFSStack=0;
int DFSStackSize=0;
int DFSALLOCFACTOR=4;

void GrowDFSStack() {
  if(DFSStackSize==0) {
	DFSStackSize=NLITS*DFSALLOCFACTOR;
	DFSStack=new (DAG * [DFSStackSize]);
	if(!DFSStack)
	  panic("Memory Allocation Failure #10\n");
  }
  else {
	DAG **tmp = new (DAG *[DFSStackSize*2]);
	if(!tmp)
	  panic("Memory Allocation Failure #11\n");
	memcpy(tmp,DFSStack,DFSStackSize*sizeof(DAG *));
	delete[] DFSStack;
	DFSStack=tmp;
	DFSStackSize=DFSStackSize*2;
  }
}

inline void pushDFS(DAG *dagnode) {
  if(topDFSStack==DFSStackSize)
	GrowDFSStack();
  DFSStack[topDFSStack++]=dagnode;
}

inline DAG* popDFS() {
  return DFSStack[--topDFSStack];
}

inline bool emptyDFS() {
  return(topDFSStack==0);
}


void SearchDAG(DAG* dagnode, UniqueSet *plevels) {
  //  NoGood *ng;
	if(!dagnode)
	return;
  pushDFS(dagnode);
  while(!emptyDFS()) {
	DAG *dnode=popDFS();
	if(dnode->visited)
	  continue;
	
	dnode->visited=true;
	pushMark(dnode);
	switch(dnode->type) {
	case CHOICE:
	  plevels->pushnew((int) dnode->two);
	  break;
	case TRUE:
	  plevels->pushnew(0);
	  break;
	case NORMAL:
	  if(dnode->one)
		pushDFS(dnode->one);
	  if(dnode->two)
		pushDFS(dnode->two);
	  break;
	case PURE:      
	  //printf(" HERE A pure propagation encountered lit %d\n", (int) dnode->one);
	  //printf("Shouldn't be part of a contradiction!\n");
	  //plevels->pushnew((int) dnode->two);  
	
	  break;	  
	case NOGOOD:
	  //	 ng=(NoGood *) dnode->one;
	  //	  ng->unionIntoUniqueSet(plevels);
	  ((NoGood *) dnode->one)->unionIntoUniqueSet(plevels);
	  break;
	default:
	  panic("SearchDAG found illegal type!.\n");
	}
  }
	while(!emptyMark()) 
	  popMark()->visited=false;
}

void SearchDAG(DAG* dagnode, NoGood *ng) {
  if(!dagnode)
	return;
  pushDFS(dagnode);
  while(!emptyDFS()) {
	DAG *dnode=popDFS();
	if(dnode->visited)
	  continue;
	
	dnode->visited=true;
	pushMark(dnode);
	switch(dnode->type) {
	case CHOICE:
	  ng->setbit((int) dnode->two);
	  break;
	case TRUE:
	  ng->setbit(0);
	  break;
	case NORMAL:
	  //		if(dnode->one->type==PURE || dnode->two->type==PURE)
	  //			printf("pure about to be visited\n");
	  if(dnode->one)
		pushDFS(dnode->one);
	  if(dnode->two)
		pushDFS(dnode->two);
	  break;
	case PURE:	  
	  //printf(" HERE2 A pure propagation encountered lit %d\n", (int) dnode->one);
	  //printf("Shouldn't be part of a contradiction!\n");
	  //ng->setbit((int) dnode->two);      		
	  break;
	case NOGOOD:
	  ng->unionFromNoGood((NoGood *) dnode->one);
	  break;
	default:
	  panic("SearchDAG found illegal type!.\n");
	}
  }
	while(!emptyMark()) 
	  popMark()->visited=false;
}

//print utility

UniqueSet *levelbuf=NULL;

void printConflict(DAG *dnode) {
  if(!levelbuf)
	levelbuf=new UniqueSet(NLITS);
  if(!levelbuf)
	panic("Memory Allocation Failure #12\n");
  levelbuf->empty();
  SearchDAG(dnode,levelbuf);
  printf("Conflict levels: ");
  levelbuf->printset();
}
