/*

2clsQ. Copyright Horst Samulowitz and Fahiem Bacchus 2006

 A DPLL QBF solver based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to
implied warranties of merchantability and fitness for a particular
purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Fahiem Bacchus },
	year    = { 2006 },
	title   = { {2clsQ} a {DPLL} solver employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/

#include "2clsEq.h"
#include <stdio.h>
#include "binaryClauses.h"
#include "naryClauses.h"
#include "resolve.h"
#include "nogood.h"

// Horst: Add Prefix Level Information when reading file
extern bool *bArrExistential;
extern int  *nArrPrefixLevel;
// END


/* Read problem builds a sequence of lists of clauses each of size
   2 -- >= 255.

   The code here initializes the problem by building up linked data structures
   to represent the clauses.

   It also performs an incremental binary resolution on the input
   clauses, reports failure if this process finds it, and reduces the
   clauses by applying all equivalences.

*/

void propagateStacksNoUndo();
void pushupstackNoUndo(int l);
void pushbclsstackNoUndo(int l1, int l2);

Lit *THELITS;
Clause *THECLAUSES;

void initprob() {
  CLAUSELIST *clsptr;
  int i,nbcls;
  //1. Print Info about the theory.
  printf("c NLits =%d Table size=%d(%d)\n", NLITS, TSIZE, 1<<TSIZEPWR2);
  clsptr=lenNclauses[2];
  nbcls=0;
  while(clsptr) {
    nbcls++;
    clsptr=clsptr->pnext;
  }
  printf("c The problem has %d binary clauses.\n",nbcls);

  initBitVectorStore(NLITS);

  //2. Set up data structures.
  THELITS = new Lit[NLITS];
  if(!THELITS)
    panic("Memory Allocation Failure #5\n");
  for(i=0;i<NLITS;i++)
  {
    THELITS[i].initLit(i);
    setLitPrefixLevel(i,nArrPrefixLevel[i]);
    if(bArrExistential[i])
     setLitPrefixType(i, true);
    else
     setLitPrefixType(i, false);
  }
  // it was here

  NCLAUSES=NCLAUSES-nbcls;

  THECLAUSES = new Clause[NCLAUSES];
  if(!THECLAUSES)
    panic("Memory Allocation Failure #6\n");
  for(i=0;i<NCLAUSES;i++)
    THECLAUSES[i].initClause(i);

  //initBClsMarkTable();
  for(i=0;i<NLITS;i++)
    if(!haveBclause(i,negate(i)))
	  //markBclause(i,negate(i),RESOLVED,&dagTrue);
	  markBclause(i,negate(i),&dagTrue);

  initResolver();
  int clsnum=0;

  //a. Add in all n-ary clauses
  for(i=3;i<CLSGROUPS;i++)
    for(clsptr=lenNclauses[i]; clsptr; clsptr=clsptr->pnext) {
#ifdef _TRACE
      printf("Adding Clause %d: ", clsnum);
      printCLAUSELIST(clsptr);
#endif
      addNaryClause(clsptr,clsptr->cls,clsptr->clslen,clsnum);
      clsnum++;
    }
  NCLAUSES=clsnum;
  //b. force all unit clauses.
  for(clsptr=lenNclauses[1];clsptr;clsptr=clsptr->pnext) {
    setLitdagnode(clsptr->cls[0],&dagTrue);
    pushupstackNoUndo(clsptr->cls[0]);
  }
  //c. Then process all 2-clauses.
  for(clsptr=lenNclauses[2];clsptr;clsptr=clsptr->pnext)
    pushbclsstackNoUndo(clsptr->cls[0],clsptr->cls[1]);
  propagateStacksNoUndo();
  //propagateStacks();

  int newlitcount=0;
  int newnclscount=0;
  int newbclscount=0;

  for(i=0;i<NLITS;i++)
    if(isActive(i)) {
      newlitcount++;
      newbclscount += numBcls(i);
    }

  for(i=0;i<NCLAUSES;i++)
    if(clsisActive(i))
      if(subsumed(intToclause(i)))
		subsumes++;
      else
		newnclscount++;

  printf("c In reduced theory, %d variables, %d nary clauses, %d binary clauses (%ld nary clauses subsumed)\n",
	 newlitcount/2, newnclscount, newbclscount/2, subsumes);

  NACTIVELITS=newlitcount;



  //printClause(Clause *c)

  //    for(i=0;i<NLITS;i++) {
  //      Lit *l=intTolit(i);
  //      if(isActive(l)) {
  //        printf("Lit %d: ", to_ff(l->num));
  //        printf(" Nary Clauses (%d), 3 Clauses (%d),",l->numNcls,
  //  	     l->num3cls);
  //        printf(" 2 Clauses (%d)\n", l->numBcls);
  //      }
  //    }
}

