/*

2clsQ. Copyright Horst Samulowitz and Fahiem Bacchus 2006

 A DPLL QBF solver based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to
implied warranties of merchantability and fitness for a particular
purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Fahiem Bacchus },
	year    = { 2006 },
	title   = { {2clsQ} a {DPLL} solver employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/

#ifndef __binaryClauses_H
#define __binaryClauses_H
#include <stdio.h>
#include "2clsEq.h"
#include "dag.h"

//1. Hash table items

void Makebucketstore();

//Inline allocator for hash table buckets.
extern bucket *pbktalloc;

inline bucket* allocbucket() {
  //allocate a new bucket
  if(!pbktalloc)
    Makebucketstore();
  bucket *pb = pbktalloc;
  pbktalloc=pb->pnext;
  return(pb);
}

inline void deallocbucket(bucket *pb) {
  //deallocate it.
  pb->pnext = pbktalloc;
  pbktalloc = pb;
}

bool haveBclause(int l1, int l2);

inline void markBclause(int l1, int l2, DAG *dagnode) {
  //Mark the presence of a Binary clauses. If it is already there
  //update its value.
#ifdef _TRACE
  //printf("==markBclause(%d,%d) being marked with %d.\n",to_ff(l1),to_ff(l2),val);
#endif
  bucket *pb;

  if(haveBclause(l1,l2))
	 printf("Marking redundant clause!\n");
  pb = intTolit(l1)->litHtable+(l2/2)%TSIZE;
  if(pb->lit==l2)
	printf("Marking redundant clause!\n");
  else while(pb->pnext) {
	pb=pb->pnext;
	if(pb->lit==l2)
	  printf("Marking redundant clause!\n");
  }

  if(l1<l2)
	setbit(intTolit(l2)->bitvector,l1);
  else
	setbit(intTolit(l1)->bitvector,l2);

  //if(dagnode->type==PURE)
	//printf("Pure forcing binary clause!\n");

  pb = intTolit(l1)->litHtable+(l2/2)%TSIZE;
  if(pb->lit==NOLIT) {
    pb->lit=l2;
    pb->dagnode=dagnode;
  }
  else {
    while(pb->pnext)
      pb=pb->pnext;
	pb->pnext=allocbucket();
	pb->pnext->pnext=NULL;
	pb->pnext->lit=l2;
	pb->pnext->dagnode=dagnode;
  }

  pb = intTolit(l2)->litHtable+(l1/2)%TSIZE;
  if(pb->lit==NOLIT) {
    pb->lit=l1;
    pb->dagnode=dagnode;
  }
  else {
	  while(pb->pnext)
	pb=pb->pnext;
  pb->pnext=allocbucket();
  pb->pnext->pnext=NULL;
  pb->pnext->lit=l1;
  pb->pnext->dagnode=dagnode;
  }
}

inline bool haveBclause(int l1, int l2) {
  if(l1<l2)
	return(getbit(intTolit(l2)->bitvector,l1));
  else
	return(getbit(intTolit(l1)->bitvector,l2));
}

inline bool haveBclause(Lit* L1, int l2) {
  if(L1->num<l2)
	return(getbit(intTolit(l2)->bitvector,L1->num));
  else
	return(getbit(L1->bitvector,l2));
}

inline bool DNodehaveBclause(Lit *L1, int l2, DAG* &dnode) {
  if(haveBclause(L1->num,l2)) {
	bucket *pb=L1->litHtable;
    pb=pb+(l2/2)%TSIZE;
	if(pb->lit==l2) {
	  dnode=pb->dagnode;
	  return true;
	}
	while(pb->pnext) {
	  pb=pb->pnext;
	  if(pb->lit==l2) {
		dnode=pb->dagnode;
		return true;
	  }
	}
	panic("Bclause in bitvector but not in hash table\n");
	return(false);
  }
  else
	return(false);
}

inline bool DNodehaveBclause(int l1, int l2, DAG* &dnode) {
  if(haveBclause(l1,l2)) {
	bucket *pb=intTolit(l1)->litHtable;
    pb=pb+(l2/2)%TSIZE;
	if(pb->lit==l2) {
	  dnode=pb->dagnode;
	  return true;
	}
	while(pb->pnext) {
	  pb=pb->pnext;
	  if(pb->lit==l2) {
		dnode=pb->dagnode;
		return true;
	  }
	}
	panic("Bclause in bitvector but not in hash table\n");
	return(false);
  }
  else
	return(false);
}

inline void unmarkBclause(int l1, int l2) {

// 	if(l1==986 || l2==986)
// 	printf("<==problem lits (%d,%d)", l1,l2);


  if(l1<l2)
	unsetbit(intTolit(l2)->bitvector,l1);
  else
	unsetbit(intTolit(l1)->bitvector,l2);

  bucket *pb = intTolit(l1)->litHtable+(l2/2)%TSIZE;
  if(pb->lit==l2)
    pb->lit=NOLIT;
  else
    for(;pb->pnext;pb=pb->pnext)
      if(pb->pnext->lit==l2) {
		bucket *match=pb->pnext;
		pb->pnext=match->pnext;
		deallocbucket(match);
		break;
      }

  pb = intTolit(l2)->litHtable+(l1/2)%TSIZE;
  if(pb->lit==l1)
    pb->lit=NOLIT;
  else
    for(;pb->pnext;pb=pb->pnext)
      if(pb->pnext->lit==l1) {
		bucket *match=pb->pnext;
		pb->pnext=match->pnext;
		deallocbucket(match);
		break;
      }
}

void addBclause(Lit *l1, Lit *l2, DAG* dnode);
 
//2. Binary clauses
   

extern PairofBinLitCls *ppbclalloc;
//Inline processing of binary clauses

//inline allocators;
inline PairofBinLitCls* allocPairofBinLitCls() {
  if(!ppbclalloc)
    MakePairofBinLitClsStore();
  PairofBinLitCls *pb = ppbclalloc;
  ppbclalloc=(PairofBinLitCls*) pb->Lit1.pnext;
  return(pb);
}

inline void deallocPairofBinLitCls(PairofBinLitCls *pb) {
  pb->Lit1.pnext = (BinLitCls*) ppbclalloc;
  pb->Lit1.pprev = NULL;
  ppbclalloc = pb;
}

inline void putonLitlist(Lit* pl,BinLitCls *pb) {
  //Put binary clause on literal's clause list.
  pb->pprev=&(pl->twoClauses);
  pb->pnext=pl->twoClauses.pnext;
  pb->pnext->pprev=pb;
  pb->pprev->pnext=pb;
  pl->numBcls++;
}

inline void delinkBclause(BinLitCls *pb) {
  //Delink a binary clause from l's two clause list
  pb->pprev->pnext=pb->pnext;
  pb->pnext->pprev=pb->pprev;
  pb->otherlinks->otherlit->numBcls--;
}

inline void relinkBclause(BinLitCls *pb) {
  //Relink a binary clause
  Lit *l=pb->otherlinks->otherlit;
  pb->pprev=&(l->twoClauses);
  pb->pnext=l->twoClauses.pnext;
  pb->pprev->pnext=pb;
  pb->pnext->pprev=pb;
  l->numBcls++;
}

int inline countBClause(Lit *l) {
  int i=1;
  for(BinLitCls *bc=l->twoClauses.pnext;bc->pnext;bc=bc->pnext)
    i++;
  return(i);
}

int inline countBClause(int l) {
  return(countBClause(intTolit(l)));
}

#endif /* __binaryClauses_H */

