/*

2clsQ. Copyright Horst Samulowitz and Fahiem Bacchus 2006

 A DPLL QBF solver based on performing extensive reasoning with the binary
 clause subtheory. 

Version 1.0

The software available at this site is copyright (c) 2006 by Horst Samulowitz 
and Fahiem Bacchus. All right are reserved. 
Use of this software is permitted for non-commercial research purposes, and it may be copied only for that use. 
All copies must include this copyright message. This software and
any documentation and/or information supplied with it is distributed
on an as is basis. Horst Samulowitz and Fahiem Bacchus and the University of Toronto make no warranties, express or implied, including but not limited to
implied warranties of merchantability and fitness for a particular
purpose, regarding the documentation, functions or performance of such
software, documentation and/or information.

@misc{Samulowitz:Bacchus:2clsQ,
	author  = { Horst Samulowitz and Fahiem Bacchus },
	year    = { 2006 },
	title   = { {2clsQ} a {DPLL} solver employing extensive binary clause reasoning },
	note    = { Available from
                    http://www.cs.toronto.edu/\~{}fbacchus/sat.html }
}

*/

#include "2clsEq.h"
#include "binaryClauses.h"
#include "undo.h"
#include "resolve.h"

/* 1. A hash table with buckets is used to store which binary clauses
      exist.
   2. Binary clauses are allocated a pair at a time to link on to
      literal 1 and literal 2's binary clause list.
*/

//*******************************************************
//Hash table


bucket *pbktalloc=NULL;

bit *bitvectorStore;

void  initBitVectorStore(int numlits) {
  int size=0;
  for(int i=0;i<numlits;i++) {
	size += numberOfInts(i+1);
  }
  bitvectorStore=new bit[size];
  if(!bitvectorStore)
      panic("Memory Allocation Failure #2\n");
}

//A supply of for Buckets in the hash table.

const int BKTALLOCFACTOR = 4;

void Makebucketstore() {
  bucket *pb = new bucket[NLITS*BKTALLOCFACTOR];
  if(!pb)
    panic("Memory Allocation Failure #3\n");
  pbktalloc = pb;
  //now link the new array.
  for(int i=0;i<NLITS*BKTALLOCFACTOR;i++) {
    pb->pnext=pb+1;
	pb++;
  }
  //fix the last pointer
  (--pb)->pnext=NULL;
}


//*******************************************************
//A supply of binaryclausepairs. Linked via the next pointers of the
//first binary clause struct.

const int BLITALLOCFACTOR = 32;

PairofBinLitCls *ppbclalloc=NULL;

void MakePairofBinLitClsStore() {
  PairofBinLitCls *pb = new PairofBinLitCls[NLITS*BLITALLOCFACTOR];
  if(!pb)
    panic("Memory Allocation Failure #4\n");
  ppbclalloc = pb;
  //now link the new array.
  for(int i=0;i<NLITS*BLITALLOCFACTOR;i++) {
    pb->Lit1.pnext=(BinLitCls*) (pb+1); //don't cast until addition is done!
	pb++;
  }
  //fix last pointer
  (--pb)->Lit1.pnext=NULL;
}

void addBclause(Lit *l1, Lit *l2, DAG* dagnode) {
  //should check that clause is not there prior to calling
#ifdef _TRACE
  if((l1->num == 931) || (negate(l1->num) == 931) && (getNumberOfNoGoods() >= 36000))
   printf("=>addBclause(%d,%d)\n",to_ff(l1->num),to_ff(l2->num));
#endif _TRACE
  
  assert(isLitExistential(l1) || isLitExistential(l2));
  if(!isLitExistential(l1))
  {
    assert(getLitPrefixLevel(l2) > getLitPrefixLevel(l1));
  }
  if(!isLitExistential(l2))
  {
    assert(getLitPrefixLevel(l1) > getLitPrefixLevel(l2));
  }

  bclsAdded++;

  PairofBinLitCls *pb = allocPairofBinLitCls();
  pb->Lit1.otherlit=l2;
  pb->Lit1.dagnode=dagnode;
  pb->Lit2.otherlit=l1;
  pb->Lit2.dagnode=dagnode;
  putonLitlist(l1,&(pb->Lit1));
  putonLitlist(l2,&(pb->Lit2));
  //  markBclause(l1->num,l2->num,RESOLVED,dagnode);
  markBclause(l1->num,l2->num,dagnode);
  markundoNewBCls(pb);
}

