% Rf = fa_corr(A,S) Correlations between factor scores wrt cov. matrix S
%
% Returns a square, symmetric matric Rf such that rf_ij is the
% correlation between scores of factors (rows of A) i and j:
%
% x = Lf + mu + e (factor analysis model, with mu=E{x} and error e) =>
% f* = Ax (A: factor scores, see fa_scores).
%
% Rf = E{f*(f*)'} = ASA' where S = cov{x} (sample covariance).
%
% For S=I (default) it returns the angles between the row vectors of A.
%
% See also: fa_scores.

% Copyright (c) 1997 by Miguel A. Carreira-Perpinan

function Rf = fa_corr(A,S)

% Argument defaults
if nargin==1 S=eye(length(A')); end;

Sf = A*S*A';
Df = diag(sqrt(1./diag(Sf)));
Rf = Df * Sf * Df;
